package mods.immibis.ccperiphs.rfid;

import java.util.List;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class ItemCardBase extends Item {
	// Colours are stored as item metadata, using wool data values
	
	private String cardType;
	
	private Icon[] icons = new Icon[16];
	
	public ItemCardBase(int id, String type) {
		super(id);
		cardType = type;
		setUnlocalizedName("immibis_peripherals."+type);
		setMaxStackSize(1);
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public void registerIcons(IconRegister reg) {
		for(int k = 0; k < 16; k++)
			icons[k] = reg.registerIcon("immibis_peripherals:"+cardType+k);
	}
	
	@Override
	public boolean getShareTag() {return true;}
	
	@Override
	public Icon getIconFromDamage(int damage) {
		if(damage < 0 || damage > 15)
			return null;
		return icons[damage];
	}
	
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public void addInformation(ItemStack stack, EntityPlayer ply, List list, boolean par4) {
		if(stack.stackTagCompound == null || !stack.stackTagCompound.hasKey("data"))
			return;
		
		String line1 = stack.stackTagCompound.getString("line1");
		//String line2 = stack.stackTagCompound.getString("line2");
		//String line3 = stack.stackTagCompound.getString("line3");
		
		if(!line1.equals("")) list.add(line1);
		//if(!line2.equals("")) list.add(line2);
		//if(!line3.equals("")) list.add(line3);
	}

}
