/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.tconstruct;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import mods.neiplugins.common.LiquidTemplateRecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.library.crafting.CastingRecipe;

public abstract class CastRecipeHandler
extends LiquidTemplateRecipeHandler {
    public static final int xOffset = 30;
    static Rectangle metalTank = new Rectangle(60, 8, 6, 11);

    public abstract String getRecipeName();

    @Override
    public abstract String getRecipeId();

    public abstract ArrayList<CastingRecipe> getCastingRecipes();

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(76, 18, 22, 15), this.getRecipeId(), new Object[0]));
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (CastingRecipe recipe : this.getCastingRecipes()) {
                this.arecipes.add(new CachedCastingRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("liquid") && ingredients.length == 1 && ingredients[0] instanceof FluidStack) {
            FluidStack t = (FluidStack)ingredients[0];
            for (CastingRecipe recipe : this.getCastingRecipes()) {
                if (!LiquidHelper.areSameLiquid(recipe.castingMetal, t)) continue;
                this.arecipes.add(new CachedCastingRecipe(recipe));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingred) {
        FluidStack t = LiquidHelper.getFluidStack(ingred);
        for (CastingRecipe recipe : this.getCastingRecipes()) {
            if (NEIClientUtils.areStacksSameTypeCrafting((ItemStack)recipe.cast, (ItemStack)ingred)) {
                CachedCastingRecipe irecipe = new CachedCastingRecipe(recipe);
                irecipe.setIngredientPermutation(irecipe.resources, ingred);
                this.arecipes.add(irecipe);
                continue;
            }
            if (t == null || !LiquidHelper.areSameLiquid(recipe.castingMetal, t)) continue;
            this.arecipes.add(new CachedCastingRecipe(recipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (CastingRecipe recipe : this.getCastingRecipes()) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)result, (ItemStack)recipe.getResult())) continue;
            this.arecipes.add(new CachedCastingRecipe(recipe));
        }
    }

    public String getGuiTexture() {
        return "neiplugins:gfx/tc_cast.png";
    }

    public class CachedCastingRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        List<PositionedStack> resources;
        LiquidTank metal;
        PositionedStack output;

        public CachedCastingRecipe(CastingRecipe irecipe) {
            super((TemplateRecipeHandler)CastRecipeHandler.this);
            this.output = null;
            this.metal = new LiquidTank(irecipe.castingMetal, irecipe.castingMetal.amount, metalTank);
            this.metal.showMillBuckets = true;
            this.metal.showCapacity = false;
            this.metal.showAmount = true;
            this.resources = new ArrayList<PositionedStack>();
            if (irecipe.cast != null) {
                this.resources.add(new PositionedStack((Object)irecipe.cast, 55, 19));
            }
            this.output = new PositionedStack((Object)irecipe.output, 110, 18);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CastRecipeHandler.this.cycleticks / 20, this.resources);
        }

        @Override
        public ArrayList<LiquidTank> getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.metal);
            return res;
        }
    }
}

