/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forge;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mods.neiplugins.common.Utils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryList
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Ore Dictionary";
    }

    public String getRecipeId() {
        return "forge.oredictionary";
    }

    public String getGuiTexture() {
        return "neiplugins:gfx/Item2Item.png";
    }

    public void drawExtras(int recipe) {
        GuiDraw.drawStringC((String)((CachedOreDictionaryEntry)((Object)this.arecipes.get((int)recipe))).name, (int)85, (int)9, (int)-8355712, (boolean)false);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 25, 16), this.getRecipeId(), new Object[0]));
    }

    protected ArrayList<CachedOreDictionaryEntry> getAllItems() {
        ArrayList<CachedOreDictionaryEntry> result = new ArrayList<CachedOreDictionaryEntry>();
        Object[] oreNames = OreDictionary.getOreNames();
        String[] oreNames2 = new String[oreNames.length - 1];
        boolean hasNull = false;
        int counter = 0;
        for (Object oreName : oreNames) {
            if (oreName == null) {
                hasNull = true;
                continue;
            }
            if (counter + 1 >= oreNames.length) continue;
            oreNames2[counter++] = oreName;
        }
        if (hasNull) {
            oreNames = oreNames2;
        }
        Arrays.sort(oreNames);
        for (Object oreName : oreNames) {
            for (ItemStack ore : OreDictionary.getOres((String)oreName)) {
                result.add(new CachedOreDictionaryEntry(ore, (String)oreName));
            }
        }
        return result;
    }

    protected ArrayList<CachedOreDictionaryEntry> getItemsByID(int id) {
        ArrayList<CachedOreDictionaryEntry> result = new ArrayList<CachedOreDictionaryEntry>();
        for (ItemStack ore : OreDictionary.getOres((Integer)id)) {
            result.add(new CachedOreDictionaryEntry(ore, OreDictionary.getOreName((int)id)));
        }
        return result;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (CachedOreDictionaryEntry recipe : this.getAllItems()) {
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (!Utils.getBooleanSetting("neiplugins.developer.showUsageInOreDictionary")) {
            return;
        }
        for (CachedOreDictionaryEntry recipe : this.getAllItems()) {
            if (!recipe.contains(recipe.content, ingredient)) continue;
            this.arecipes.add(recipe);
        }
    }

    public class CachedOreDictionaryEntry
    extends TemplateRecipeHandler.CachedRecipe {
        public String name;
        public List<PositionedStack> content;

        public CachedOreDictionaryEntry(ItemStack ore, String name) {
            super((TemplateRecipeHandler)OreDictionaryList.this);
            this.name = name;
            this.content = new ArrayList<PositionedStack>();
            this.content.add(new PositionedStack((Object)ore, 51, 24));
            this.content.add(new PositionedStack((Object)OreDictionary.getOres((String)name), 111, 24));
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(OreDictionaryList.this.cycleticks / 20, this.content);
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

