/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedOreRecipe
implements aag {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    private yd output = null;
    private Object[] input = null;
    private int width = 0;
    private int height = 0;
    private boolean mirrored = true;

    public ShapedOreRecipe(aqw result, Object ... recipe) {
        this(new yd(result), recipe);
    }

    public ShapedOreRecipe(yb result, Object ... recipe) {
        this(new yd(result), recipe);
    }

    public ShapedOreRecipe(yd result, Object ... recipe) {
        this.output = result.m();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof yd) {
                itemMap.put(chr, ((yd)in).m());
            } else if (in instanceof yb) {
                itemMap.put(chr, new yd((yb)in));
            } else if (in instanceof aqw) {
                itemMap.put(chr, new yd((aqw)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)in));
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    ShapedOreRecipe(aah recipe, Map<yd, String> replacements) {
        this.output = recipe.b();
        this.width = recipe.b;
        this.height = recipe.c;
        this.input = new Object[recipe.d.length];
        block0: for (int i = 0; i < this.input.length; ++i) {
            yd ingred = recipe.d[i];
            if (ingred == null) continue;
            this.input[i] = recipe.d[i];
            for (Map.Entry<yd, String> replace : replacements.entrySet()) {
                if (!OreDictionary.itemMatches(replace.getKey(), ingred, true)) continue;
                this.input[i] = OreDictionary.getOres(replace.getValue());
                continue block0;
            }
        }
    }

    public yd a(vj var1) {
        return this.output.m();
    }

    public int a() {
        return this.input.length;
    }

    public yd b() {
        return this.output;
    }

    public boolean a(vj inv, abv world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(vj inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                yd slot = inv.b(x, y);
                if (target instanceof yd) {
                    if (this.checkItemEquals((yd)target, slot)) continue;
                    return false;
                }
                if (target instanceof ArrayList) {
                    boolean matched = false;
                    for (yd item : (ArrayList)target) {
                        matched = matched || this.checkItemEquals(item, slot);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkItemEquals(yd target, yd input) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.d == input.d && (target.k() == Short.MAX_VALUE || target.k() == input.k());
    }

    public ShapedOreRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public Object[] getInput() {
        return this.input;
    }
}

