/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class OreDictionary {
    private static boolean hasInit = false;
    private static int maxID = 0;
    private static HashMap<String, Integer> oreIDs = new HashMap();
    private static HashMap<Integer, ArrayList<yd>> oreStacks = new HashMap();
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    public static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new yd(aqw.O, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("plankWood", new yd(aqw.C, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("slabWood", new yd((aqw)aqw.bT, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("stairWood", aqw.ay);
            OreDictionary.registerOre("stairWood", aqw.cc);
            OreDictionary.registerOre("stairWood", aqw.cd);
            OreDictionary.registerOre("stairWood", aqw.cb);
            OreDictionary.registerOre("stickWood", yb.F);
            OreDictionary.registerOre("treeSapling", new yd(aqw.D, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new yd((aqw)aqw.P, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("oreGold", aqw.L);
            OreDictionary.registerOre("oreIron", aqw.M);
            OreDictionary.registerOre("oreLapis", aqw.S);
            OreDictionary.registerOre("oreDiamond", aqw.aB);
            OreDictionary.registerOre("oreRedstone", aqw.aS);
            OreDictionary.registerOre("oreEmerald", aqw.bW);
            OreDictionary.registerOre("oreQuartz", aqw.cu);
        }
        HashMap<yd, String> replacements = new HashMap<yd, String>();
        replacements.put(new yd(aqw.C, 1, Short.MAX_VALUE), "plankWood");
        replacements.put(new yd(yb.F), "stickWood");
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        for (int i = 0; i < 16; ++i) {
            yd dye = new yd(yb.aY, 1, i);
            if (!hasInit) {
                OreDictionary.registerOre(dyes[i], dye);
            }
            replacements.put(dye, dyes[i]);
        }
        hasInit = true;
        yd[] replaceStacks = replacements.keySet().toArray(new yd[replacements.keySet().size()]);
        yd[] exclusions = new yd[]{new yd(aqw.T), new yd(yb.be)};
        List recipes = aae.a().b();
        ArrayList<Object> recipesToRemove = new ArrayList<Object>();
        ArrayList<Object> recipesToAdd = new ArrayList<Object>();
        for (Object obj : recipes) {
            yd output;
            aah recipe;
            if (obj instanceof aah) {
                recipe = (aah)obj;
                output = recipe.b();
                if (output != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.d, replaceStacks)) continue;
                recipesToRemove.add(recipe);
                recipesToAdd.add(new ShapedOreRecipe(recipe, replacements));
                continue;
            }
            if (!(obj instanceof aai) || (output = (recipe = (aai)obj).b()) != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.b.toArray(new yd[recipe.b.size()]), replaceStacks)) continue;
            recipesToRemove.add((aag)obj);
            ShapelessOreRecipe newRecipe = new ShapelessOreRecipe((aai)recipe, replacements);
            recipesToAdd.add(newRecipe);
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
        if (recipesToRemove.size() > 0) {
            System.out.println("Replaced " + recipesToRemove.size() + " ore recipies");
        }
    }

    public static int getOreID(String name) {
        Integer val = oreIDs.get(name);
        if (val == null) {
            val = maxID++;
            oreIDs.put(name, val);
            oreStacks.put(val, new ArrayList());
        }
        return val;
    }

    public static String getOreName(int id) {
        for (Map.Entry<String, Integer> entry : oreIDs.entrySet()) {
            if (id != entry.getValue()) continue;
            return entry.getKey();
        }
        return "Unknown";
    }

    public static int getOreID(yd itemStack) {
        if (itemStack == null) {
            return -1;
        }
        for (Map.Entry<Integer, ArrayList<yd>> ore : oreStacks.entrySet()) {
            for (yd target : ore.getValue()) {
                if (itemStack.d != target.d || target.k() != Short.MAX_VALUE && itemStack.k() != target.k()) continue;
                return ore.getKey();
            }
        }
        return -1;
    }

    public static ArrayList<yd> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static String[] getOreNames() {
        return oreIDs.keySet().toArray(new String[oreIDs.keySet().size()]);
    }

    public static ArrayList<yd> getOres(Integer id) {
        ArrayList<Object> val = oreStacks.get(id);
        if (val == null) {
            val = new ArrayList();
            oreStacks.put(id, val);
        }
        return val;
    }

    private static boolean containsMatch(boolean strict, yd[] inputs, yd ... targets) {
        for (yd input : inputs) {
            for (yd target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(yd target, yd input, boolean strict) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.d == input.d && (target.k() == Short.MAX_VALUE && !strict || target.k() == input.k());
    }

    public static void registerOre(String name, yb ore) {
        OreDictionary.registerOre(name, new yd(ore));
    }

    public static void registerOre(String name, aqw ore) {
        OreDictionary.registerOre(name, new yd(ore));
    }

    public static void registerOre(String name, yd ore) {
        OreDictionary.registerOre(name, OreDictionary.getOreID(name), ore);
    }

    public static void registerOre(int id, yb ore) {
        OreDictionary.registerOre(id, new yd(ore));
    }

    public static void registerOre(int id, aqw ore) {
        OreDictionary.registerOre(id, new yd(ore));
    }

    public static void registerOre(int id, yd ore) {
        OreDictionary.registerOre(OreDictionary.getOreName(id), id, ore);
    }

    private static void registerOre(String name, int id, yd ore) {
        ArrayList<yd> ores = OreDictionary.getOres(id);
        ore = ore.m();
        ores.add(ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    public static class OreRegisterEvent
    extends Event {
        public final String Name;
        public final yd Ore;

        public OreRegisterEvent(String name, yd ore) {
            this.Name = name;
            this.Ore = ore;
        }
    }
}

