/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class FluidContainerRegistry {
    private static Map<List, FluidContainerData> containerFluidMap = new HashMap<List, FluidContainerData>();
    private static Map<List, FluidContainerData> filledContainerMap = new HashMap<List, FluidContainerData>();
    private static Set<List> emptyContainers = new HashSet<List>();
    public static final int BUCKET_VOLUME = 1000;
    public static final yd EMPTY_BUCKET = new yd(yb.ay);
    public static final yd EMPTY_BOTTLE = new yd(yb.bv);

    private FluidContainerRegistry() {
    }

    public static boolean registerFluidContainer(FluidStack stack, yd filledContainer, yd emptyContainer) {
        return FluidContainerRegistry.registerFluidContainer(new FluidContainerData(stack, filledContainer, emptyContainer));
    }

    public static boolean registerFluidContainer(Fluid fluid, yd filledContainer, yd emptyContainer) {
        if (!FluidRegistry.isFluidRegistered(fluid)) {
            FluidRegistry.registerFluid(fluid);
        }
        return FluidContainerRegistry.registerFluidContainer(new FluidStack(fluid, 1000), filledContainer, emptyContainer);
    }

    public static boolean registerFluidContainer(FluidStack stack, yd filledContainer) {
        return FluidContainerRegistry.registerFluidContainer(new FluidContainerData(stack, filledContainer, null, true));
    }

    public static boolean registerFluidContainer(Fluid fluid, yd filledContainer) {
        if (!FluidRegistry.isFluidRegistered(fluid)) {
            FluidRegistry.registerFluid(fluid);
        }
        return FluidContainerRegistry.registerFluidContainer(new FluidStack(fluid, 1000), filledContainer);
    }

    public static boolean registerFluidContainer(FluidContainerData data) {
        if (FluidContainerRegistry.isFilledContainer(data.filledContainer)) {
            return false;
        }
        containerFluidMap.put(Arrays.asList(data.filledContainer.d, data.filledContainer.k()), data);
        if (data.emptyContainer != null) {
            filledContainerMap.put(Arrays.asList(data.emptyContainer.d, data.emptyContainer.k(), data.fluid.fluidID), data);
            emptyContainers.add(Arrays.asList(data.emptyContainer.d, data.emptyContainer.k()));
        }
        MinecraftForge.EVENT_BUS.post(new FluidContainerRegisterEvent(data));
        return true;
    }

    public static FluidStack getFluidForFilledItem(yd container) {
        if (container == null) {
            return null;
        }
        FluidContainerData data = containerFluidMap.get(Arrays.asList(container.d, container.k()));
        return data == null ? null : data.fluid.copy();
    }

    public static yd fillFluidContainer(FluidStack fluid, yd container) {
        if (container == null || fluid == null) {
            return null;
        }
        FluidContainerData data = filledContainerMap.get(Arrays.asList(container.d, container.k(), fluid.fluidID));
        if (data != null && fluid.amount >= data.fluid.amount) {
            return data.filledContainer.m();
        }
        return null;
    }

    public static boolean containsFluid(yd container, FluidStack fluid) {
        if (container == null || fluid == null) {
            return false;
        }
        FluidContainerData data = filledContainerMap.get(Arrays.asList(container.d, container.k(), fluid.fluidID));
        return data == null ? false : data.fluid.isFluidEqual(fluid);
    }

    public static boolean isBucket(yd container) {
        if (container == null) {
            return false;
        }
        if (container.a(EMPTY_BUCKET)) {
            return true;
        }
        FluidContainerData data = containerFluidMap.get(Arrays.asList(container.d, container.k()));
        return data != null && data.emptyContainer.a(EMPTY_BUCKET);
    }

    public static boolean isContainer(yd container) {
        return FluidContainerRegistry.isEmptyContainer(container) || FluidContainerRegistry.isFilledContainer(container);
    }

    public static boolean isEmptyContainer(yd container) {
        return container != null && emptyContainers.contains(Arrays.asList(container.d, container.k()));
    }

    public static boolean isFilledContainer(yd container) {
        return container != null && FluidContainerRegistry.getFluidForFilledItem(container) != null;
    }

    public static FluidContainerData[] getRegisteredFluidContainerData() {
        return containerFluidMap.values().toArray(new FluidContainerData[containerFluidMap.size()]);
    }

    static {
        FluidContainerRegistry.registerFluidContainer(FluidRegistry.WATER, new yd(yb.az), EMPTY_BUCKET);
        FluidContainerRegistry.registerFluidContainer(FluidRegistry.LAVA, new yd(yb.aA), EMPTY_BUCKET);
        FluidContainerRegistry.registerFluidContainer(FluidRegistry.WATER, new yd((yb)yb.bu), EMPTY_BOTTLE);
    }

    public static class FluidContainerRegisterEvent
    extends Event {
        public final FluidContainerData data;

        public FluidContainerRegisterEvent(FluidContainerData data) {
            this.data = data.copy();
        }
    }

    public static class FluidContainerData {
        public final FluidStack fluid;
        public final yd filledContainer;
        public final yd emptyContainer;

        public FluidContainerData(FluidStack stack, yd filledContainer, yd emptyContainer) {
            this(stack, filledContainer, emptyContainer, false);
        }

        public FluidContainerData(FluidStack stack, yd filledContainer, yd emptyContainer, boolean nullEmpty) {
            this.fluid = stack;
            this.filledContainer = filledContainer;
            this.emptyContainer = emptyContainer;
            if (stack == null || filledContainer == null || emptyContainer == null && !nullEmpty) {
                throw new RuntimeException("Invalid FluidContainerData - a parameter was null.");
            }
        }

        public FluidContainerData copy() {
            return new FluidContainerData(this.fluid, this.filledContainer, this.emptyContainer, true);
        }
    }
}

