/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.base.Strings;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.network.FMLNetworkException;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.ITinyPacketHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.InvalidVersionSpecificationException;
import cpw.mods.fml.common.versioning.VersionRange;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.logging.Level;

public class NetworkModHandler {
    private static Object connectionHandlerDefaultValue;
    private static Object packetHandlerDefaultValue;
    private static Object clientHandlerDefaultValue;
    private static Object serverHandlerDefaultValue;
    private static Object tinyPacketHandlerDefaultValue;
    private static int assignedIds;
    private int localId;
    private int networkId;
    private ModContainer container;
    private NetworkMod mod;
    private Method checkHandler;
    private VersionRange acceptableRange;
    private ITinyPacketHandler tinyPacketHandler;

    public NetworkModHandler(ModContainer container, NetworkMod modAnnotation) {
        this.container = container;
        this.mod = modAnnotation;
        this.networkId = this.localId = assignedIds++;
        if (yb.bf.cv == assignedIds) {
            ++assignedIds;
        }
    }

    public NetworkModHandler(ModContainer container, Class<?> networkModClass, ASMDataTable table) {
        this(container, networkModClass.getAnnotation(NetworkMod.class));
        if (this.mod == null) {
            return;
        }
        Set versionCheckHandlers = table.getAnnotationsFor(container).get((Object)NetworkMod.VersionCheckHandler.class.getName());
        String versionCheckHandlerMethod = null;
        for (ASMDataTable.ASMData vch : versionCheckHandlers) {
            if (!vch.getClassName().equals(networkModClass.getName())) continue;
            versionCheckHandlerMethod = vch.getObjectName();
            break;
        }
        if (versionCheckHandlerMethod != null) {
            try {
                Method checkHandlerMethod = networkModClass.getDeclaredMethod(versionCheckHandlerMethod, String.class);
                if (checkHandlerMethod.isAnnotationPresent(NetworkMod.VersionCheckHandler.class)) {
                    this.checkHandler = checkHandlerMethod;
                }
            }
            catch (Exception e) {
                FMLLog.log(Level.WARNING, e, "The declared version check handler method %s on network mod id %s is not accessible", versionCheckHandlerMethod, container.getModId());
            }
        }
        this.configureNetworkMod(container);
    }

    protected void configureNetworkMod(ModContainer container) {
        String versionBounds;
        if (this.checkHandler == null && !Strings.isNullOrEmpty((String)(versionBounds = this.mod.versionBounds()))) {
            try {
                this.acceptableRange = VersionRange.createFromVersionSpec(versionBounds);
            }
            catch (InvalidVersionSpecificationException e) {
                FMLLog.log(Level.WARNING, e, "Invalid bounded range %s specified for network mod id %s", versionBounds, container.getModId());
            }
        }
        FMLLog.finest("Testing mod %s to verify it accepts its own version in a remote connection", container.getModId());
        boolean acceptsSelf = this.acceptVersion(container.getVersion());
        if (!acceptsSelf) {
            FMLLog.severe("The mod %s appears to reject its own version number (%s) in its version handling. This is likely a severe bug in the mod!", container.getModId(), container.getVersion());
        } else {
            FMLLog.finest("The mod %s accepts its own version (%s)", container.getModId(), container.getVersion());
        }
        this.tryCreatingPacketHandler(container, this.mod.packetHandler(), this.mod.channels(), null);
        if (FMLCommonHandler.instance().getSide().isClient() && this.mod.clientPacketHandlerSpec() != this.getClientHandlerSpecDefaultValue()) {
            this.tryCreatingPacketHandler(container, this.mod.clientPacketHandlerSpec().packetHandler(), this.mod.clientPacketHandlerSpec().channels(), Side.CLIENT);
        }
        if (this.mod.serverPacketHandlerSpec() != this.getServerHandlerSpecDefaultValue()) {
            this.tryCreatingPacketHandler(container, this.mod.serverPacketHandlerSpec().packetHandler(), this.mod.serverPacketHandlerSpec().channels(), Side.SERVER);
        }
        if (this.mod.connectionHandler() != this.getConnectionHandlerDefaultValue()) {
            IConnectionHandler instance;
            try {
                instance = this.mod.connectionHandler().newInstance();
            }
            catch (Exception e) {
                FMLLog.log(Level.SEVERE, e, "Unable to create connection handler instance %s", this.mod.connectionHandler().getName());
                throw new FMLNetworkException(e);
            }
            NetworkRegistry.instance().registerConnectionHandler(instance);
        }
        if (this.mod.tinyPacketHandler() != this.getTinyPacketHandlerDefaultValue()) {
            try {
                this.tinyPacketHandler = this.mod.tinyPacketHandler().newInstance();
            }
            catch (Exception e) {
                FMLLog.log(Level.SEVERE, e, "Unable to create tiny packet handler instance %s", this.mod.tinyPacketHandler().getName());
                throw new FMLNetworkException(e);
            }
        }
    }

    private void tryCreatingPacketHandler(ModContainer container, Class<? extends IPacketHandler> clazz, String[] channels, Side side) {
        if (side != null && side.isClient() && !FMLCommonHandler.instance().getSide().isClient()) {
            return;
        }
        if (clazz != this.getPacketHandlerDefaultValue()) {
            if (channels.length == 0) {
                FMLLog.log(Level.WARNING, "The mod id %s attempted to register a packet handler without specifying channels for it", container.getModId());
            } else {
                IPacketHandler instance;
                try {
                    instance = clazz.newInstance();
                }
                catch (Exception e) {
                    FMLLog.log(Level.SEVERE, e, "Unable to create a packet handler instance %s for mod %s", clazz.getName(), container.getModId());
                    throw new FMLNetworkException(e);
                }
                for (String channel : channels) {
                    NetworkRegistry.instance().registerChannel(instance, channel, side);
                }
            }
        } else if (channels.length > 0) {
            FMLLog.warning("The mod id %s attempted to register channels without specifying a packet handler", container.getModId());
        }
    }

    private Object getConnectionHandlerDefaultValue() {
        try {
            if (connectionHandlerDefaultValue == null) {
                connectionHandlerDefaultValue = NetworkMod.class.getMethod("connectionHandler", new Class[0]).getDefaultValue();
            }
            return connectionHandlerDefaultValue;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Derp?", e);
        }
    }

    private Object getPacketHandlerDefaultValue() {
        try {
            if (packetHandlerDefaultValue == null) {
                packetHandlerDefaultValue = NetworkMod.class.getMethod("packetHandler", new Class[0]).getDefaultValue();
            }
            return packetHandlerDefaultValue;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Derp?", e);
        }
    }

    private Object getTinyPacketHandlerDefaultValue() {
        try {
            if (tinyPacketHandlerDefaultValue == null) {
                tinyPacketHandlerDefaultValue = NetworkMod.class.getMethod("tinyPacketHandler", new Class[0]).getDefaultValue();
            }
            return tinyPacketHandlerDefaultValue;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Derp?", e);
        }
    }

    private Object getClientHandlerSpecDefaultValue() {
        try {
            if (clientHandlerDefaultValue == null) {
                clientHandlerDefaultValue = NetworkMod.class.getMethod("clientPacketHandlerSpec", new Class[0]).getDefaultValue();
            }
            return clientHandlerDefaultValue;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Derp?", e);
        }
    }

    private Object getServerHandlerSpecDefaultValue() {
        try {
            if (serverHandlerDefaultValue == null) {
                serverHandlerDefaultValue = NetworkMod.class.getMethod("serverPacketHandlerSpec", new Class[0]).getDefaultValue();
            }
            return serverHandlerDefaultValue;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Derp?", e);
        }
    }

    public boolean requiresClientSide() {
        return this.mod.clientSideRequired();
    }

    public boolean requiresServerSide() {
        return this.mod.serverSideRequired();
    }

    public boolean acceptVersion(String version) {
        if (this.checkHandler != null) {
            try {
                return (Boolean)this.checkHandler.invoke(this.container.getMod(), version);
            }
            catch (Exception e) {
                FMLLog.log(Level.WARNING, e, "There was a problem invoking the checkhandler method %s for network mod id %s", this.checkHandler.getName(), this.container.getModId());
                return false;
            }
        }
        if (this.acceptableRange != null) {
            return this.acceptableRange.containsVersion(new DefaultArtifactVersion(version));
        }
        return this.container.getVersion().equals(version);
    }

    public int getLocalId() {
        return this.localId;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public ModContainer getContainer() {
        return this.container;
    }

    public NetworkMod getMod() {
        return this.mod;
    }

    public boolean isNetworkMod() {
        return this.mod != null;
    }

    public void setNetworkId(int value) {
        this.networkId = value;
    }

    public boolean hasTinyPacketHandler() {
        return this.tinyPacketHandler != null;
    }

    public ITinyPacketHandler getTinyPacketHandler() {
        return this.tinyPacketHandler;
    }

    static {
        assignedIds = 1;
    }
}

