/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.PartMap;
import codechicken.multipart.TFacePart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import mrtjp.projectred.ProjectRedCore;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.BasicWireUtils;
import mrtjp.projectred.core.CommandDebug;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.transmission.EnumWire;
import mrtjp.projectred.transmission.IWirePart;
import mrtjp.projectred.transmission.RenderWire;
import mrtjp.projectred.transmission.WirePropogator;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class WirePart
extends TMultiPart
implements IConnectable,
TFacePart,
JNormalOcclusion,
IWirePart {
    public static Cuboid6[][] selectionBounds = new Cuboid6[3][6];
    public static Cuboid6[][] occlusionBounds = new Cuboid6[3][6];
    public byte side;
    public int connMap;

    public void preparePlacement(int side, int meta) {
        this.side = (byte)(side ^ 1);
    }

    public void save(by tag) {
        super.save(tag);
        tag.a("side", this.side);
        tag.a("connMap", this.connMap);
    }

    public void load(by tag) {
        super.load(tag);
        this.side = tag.c("side");
        this.connMap = tag.e("connMap");
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte((int)this.side);
        packet.writeInt(this.connMap);
    }

    public void readDesc(MCDataInput packet) {
        this.side = packet.readByte();
        this.connMap = packet.readInt();
    }

    public void read(MCDataInput packet) {
        this.read(packet, packet.readUByte());
    }

    public void read(MCDataInput packet, int switch_key) {
        if (switch_key == 0) {
            this.connMap = packet.readInt();
            if (this.useStaticRenderer()) {
                this.tile().markRender();
            }
        }
    }

    public void onPartChanged(TMultiPart part) {
        if (!this.world().I) {
            WirePropogator.logCalculation();
            boolean changed = this.updateInternalConnections();
            if (this.updateOpenConnections()) {
                changed |= this.updateExternalConnections();
            }
            if (changed) {
                this.sendConnUpdate();
                WirePropogator.propogateTo(this, 2);
            } else {
                WirePropogator.propogateTo(this, 0);
            }
        }
    }

    public void onNeighborChanged() {
        if (!this.world().I) {
            if (this.dropIfCantStay()) {
                return;
            }
            WirePropogator.logCalculation();
            if (this.updateExternalConnections()) {
                this.sendConnUpdate();
                WirePropogator.propogateTo(this, 2);
            } else {
                WirePropogator.propogateTo(this, 0);
            }
        }
    }

    public void onAdded() {
        super.onAdded();
        if (!this.world().I) {
            this.updateOpenConnections();
            boolean changed = this.updateInternalConnections();
            if (changed |= this.updateExternalConnections()) {
                this.sendConnUpdate();
            }
            WirePropogator.propogateTo(this, 0);
        }
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.world().I) {
            for (int r = 0; r < 4; ++r) {
                if (!this.maskConnects(r)) continue;
                if ((this.connMap & 1 << r) != 0) {
                    this.notifyCornerChange(r);
                    continue;
                }
                if ((this.connMap & 16 << r) == 0) continue;
                this.notifyStraightChange(r);
            }
        }
    }

    public void onChunkLoad() {
        if ((this.connMap & Integer.MIN_VALUE) != 0) {
            if (this.dropIfCantStay()) {
                return;
            }
            this.connMap = 0;
            this.updateInternalConnections();
            if (this.updateOpenConnections()) {
                this.updateExternalConnections();
            }
            this.tile().markDirty();
        }
    }

    public void sendConnUpdate() {
        this.tile().getWriteStream((TMultiPart)this).writeByte(0).writeInt(this.connMap);
    }

    public boolean canStay() {
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset((int)this.side);
        return BasicWireUtils.canPlaceWireOnSide((abw)this.world(), (int)pos.x, (int)pos.y, (int)pos.z, (ForgeDirection)ForgeDirection.getOrientation((int)(this.side ^ 1)), (boolean)false);
    }

    public boolean dropIfCantStay() {
        if (!this.canStay()) {
            this.drop();
            return true;
        }
        return false;
    }

    public void drop() {
        TileMultipart.dropItem((ye)this.getItem(), (abw)this.world(), (Vector3)Vector3.fromTileEntityCenter((asp)this.tile()));
        this.tile().remPart((TMultiPart)this);
    }

    protected boolean updateExternalConnections() {
        int newConn = 0;
        for (int r = 0; r < 4; ++r) {
            if (!this.maskOpen(r)) continue;
            if (this.connectStraight(r)) {
                newConn |= 16 << r;
                continue;
            }
            int cnrMode = this.connectCorner(r);
            if (cnrMode == 0) continue;
            newConn |= 1 << r;
            if (cnrMode != 2) continue;
            newConn |= 0x100000 << r;
        }
        if (newConn != (this.connMap & 0xF000FF)) {
            int diff = this.connMap ^ newConn;
            this.connMap = this.connMap & 0xFF0FFF00 | newConn;
            for (int r = 0; r < 4; ++r) {
                if ((diff & 1 << r) == 0) continue;
                this.notifyCornerChange(r);
            }
            return true;
        }
        return false;
    }

    protected boolean updateInternalConnections() {
        int newConn = 0;
        for (int r = 0; r < 4; ++r) {
            if (!this.connectInternal(r)) continue;
            newConn |= 256 << r;
        }
        if (this.connectCenter()) {
            newConn |= 0x10000;
        }
        if (newConn != (this.connMap & 0x10F00)) {
            this.connMap = this.connMap & 0xFFFEF0FF | newConn;
            return true;
        }
        return false;
    }

    protected boolean updateOpenConnections() {
        int newConn = 0;
        for (int r = 0; r < 4; ++r) {
            if (!this.connectionOpen(r)) continue;
            newConn |= 4096 << r;
        }
        if (newConn != (this.connMap & 0xF000)) {
            this.connMap = this.connMap & 0xFFFF0FFF | newConn;
            return true;
        }
        return false;
    }

    public boolean connectionOpen(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        TMultiPart facePart = this.tile().partMap(absDir);
        if (!(facePart == null || facePart instanceof WirePart && this.canConnectToType((WirePart)facePart))) {
            return false;
        }
        return this.tile().partMap(PartMap.edgeBetween((int)this.side, (int)absDir)) == null;
    }

    public int connectCorner(int r) {
        boolean b;
        TMultiPart tp;
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((asp)this.tile());
        pos.offset(absDir);
        if (!this.canConnectThroughCorner(pos, absDir ^ 1, this.side)) {
            return 0;
        }
        pos.offset((int)this.side);
        TileMultipart t = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)pos);
        if (t != null && (tp = t.partMap(absDir ^ 1)) instanceof IConnectable && (b = ((IConnectable)tp).connectCorner((IConnectable)this, Rotation.rotationTo((int)(absDir ^ 1), (int)(this.side ^ 1))))) {
            if (tp instanceof WirePart && !this.renderThisCorner((WirePart)tp)) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public boolean canConnectThroughCorner(BlockCoord pos, int side1, int side2) {
        if (this.world().c(pos.x, pos.y, pos.z)) {
            return true;
        }
        TileMultipart t = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)pos);
        if (t != null) {
            return t.partMap(side1) == null && t.partMap(side2) == null && t.partMap(PartMap.edgeBetween((int)side1, (int)side2)) == null;
        }
        return false;
    }

    public boolean connectStraight(int r) {
        TMultiPart tp;
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir);
        TileMultipart t = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)pos);
        if (t != null && (tp = t.partMap((int)this.side)) instanceof IConnectable) {
            return ((IConnectable)tp).connectStraight((IConnectable)this, (r + 2) % 4);
        }
        return this.connectStraightOverride(absDir);
    }

    public boolean connectStraightOverride(int absDir) {
        return false;
    }

    public boolean connectInternal(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        if (this.tile().partMap(PartMap.edgeBetween((int)absDir, (int)this.side)) != null) {
            return false;
        }
        TMultiPart tp = this.tile().partMap(absDir);
        if (tp instanceof IConnectable) {
            return ((IConnectable)tp).connectInternal((IConnectable)this, Rotation.rotationTo((int)absDir, (int)this.side));
        }
        return this.connectInternalOverride(tp, r);
    }

    public boolean connectInternalOverride(TMultiPart p, int r) {
        return false;
    }

    public boolean connectCenter() {
        TMultiPart t = this.tile().partMap(6);
        if (t instanceof IConnectable) {
            return ((IConnectable)t).connectInternal((IConnectable)this, (int)this.side);
        }
        return false;
    }

    public boolean renderThisCorner(IConnectable part) {
        if (!(part instanceof WirePart)) {
            return false;
        }
        WirePart wire = (WirePart)part;
        if (wire.getThickness() == this.getThickness()) {
            return this.side < wire.side;
        }
        return wire.getThickness() > this.getThickness();
    }

    public boolean connectCorner(IConnectable wire, int r) {
        if (this.canConnectToType(wire) && this.maskOpen(r)) {
            int oldConn = this.connMap;
            this.connMap |= 1 << r;
            if (this.renderThisCorner(wire)) {
                this.connMap |= 0x100000 << r;
            }
            if (oldConn != this.connMap) {
                this.sendConnUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean connectStraight(IConnectable wire, int r) {
        if (this.canConnectToType(wire) && this.maskOpen(r)) {
            int oldConn = this.connMap;
            this.connMap |= 16 << r;
            if (oldConn != this.connMap) {
                this.sendConnUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean connectInternal(IConnectable wire, int r) {
        if (this.canConnectToType(wire)) {
            int oldConn = this.connMap;
            this.connMap |= 256 << r;
            if (oldConn != this.connMap) {
                this.sendConnUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean canConnectCorner(int r) {
        return true;
    }

    public abstract boolean canConnectToType(IConnectable var1);

    public void notifyCornerChange(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir).offset((int)this.side);
        this.world().g(pos.x, pos.y, pos.z, this.tile().q().cF);
    }

    public void notifyStraightChange(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir);
        this.world().g(pos.x, pos.y, pos.z, this.tile().q().cF);
    }

    public boolean maskConnects(int r) {
        return (this.connMap & 273 << r) != 0;
    }

    public boolean maskOpen(int r) {
        return (this.connMap & 4096 << r) != 0;
    }

    public void propogate(TMultiPart prev, int mode) {
        if (mode != 3) {
            WirePropogator.addPartChange(this);
        }
        for (int r = 0; r < 4; ++r) {
            if ((this.connMap & 1 << r) != 0) {
                this.propogateCorner(r, prev, mode);
                continue;
            }
            if ((this.connMap & 16 << r) != 0) {
                this.propogateStraight(r, prev, mode);
                continue;
            }
            if ((this.connMap & 256 << r) == 0) continue;
            this.propogateInternal(r, prev, mode);
        }
        if ((this.connMap & 0x10000) != 0) {
            this.propogateCenter(prev, mode);
        }
        this.propogateOther(mode);
    }

    public void propogateCorner(int r, TMultiPart prev, int mode) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir).offset((int)this.side);
        TileMultipart t = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)pos);
        if (t != null) {
            TMultiPart tp = t.partMap(absDir ^ 1);
            if (tp == prev) {
                return;
            }
            if (this.propogateTo(tp, mode)) {
                return;
            }
        }
        WirePropogator.addNeighborChange(pos);
    }

    public void propogateStraight(int r, TMultiPart prev, int mode) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir);
        TileMultipart t = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)pos);
        if (t != null) {
            TMultiPart tp = t.partMap((int)this.side);
            if (tp == prev) {
                return;
            }
            if (this.propogateTo(tp, mode)) {
                return;
            }
        }
        WirePropogator.addNeighborChange(pos);
    }

    public void propogateInternal(int r, TMultiPart prev, int mode) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        TMultiPart tp = this.tile().partMap(absDir);
        if (tp == prev) {
            return;
        }
        this.propogateTo(tp, mode);
    }

    public void propogateCenter(TMultiPart prev, int mode) {
        TMultiPart tp = this.tile().partMap(6);
        if (tp == prev) {
            return;
        }
        this.propogateTo(tp, mode);
    }

    public void propogateOther(int mode) {
    }

    public boolean propogateTo(TMultiPart part, int mode) {
        if (part instanceof IWirePart) {
            WirePropogator.propogateTo((IWirePart)part, this, mode);
            return true;
        }
        return false;
    }

    @Override
    public void onSignalUpdate() {
        this.tile().markDirty();
    }

    @Override
    public boolean isWireSide(int side) {
        return true;
    }

    protected abstract boolean debug(uf var1);

    protected abstract boolean test(uf var1);

    public abstract EnumWire getWireType();

    public int getThickness() {
        return this.getWireType().thickness;
    }

    public float getStrength(ata hit, uf player) {
        return 4.0f;
    }

    public ye getItem() {
        return this.getWireType().getItemStack();
    }

    public Iterable<ye> getDrops() {
        return Arrays.asList(this.getItem());
    }

    public ye pickItem(ata hit) {
        return this.getItem();
    }

    public int getSlotMask() {
        return 1 << this.side;
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        return Arrays.asList(new IndexedCuboid6((Object)0, selectionBounds[this.getThickness()][this.side]));
    }

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(occlusionBounds[this.getThickness()][this.side]);
    }

    public int redstoneConductionMap() {
        return 15;
    }

    public boolean solid(int arg0) {
        return false;
    }

    public boolean activate(uf player, ata hit, ye held) {
        if (CommandDebug.WIRE_READING) {
            return this.debug(player);
        }
        if (held != null && held.d == ProjectRedCore.itemWireDebugger.cv) {
            held.a(1, (of)player);
            player.aV();
            return this.test(player);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ms getIcon() {
        return this.getWireType().wireSprites[0];
    }

    public int getColour() {
        return -1;
    }

    public boolean useStaticRenderer() {
        return Configurator.staticWires;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(Vector3 pos, LazyLightMatrix olm, int pass) {
        if (pass == 0 && this.useStaticRenderer()) {
            CCRenderState.setBrightness((acf)this.world(), (int)this.x(), (int)this.y(), (int)this.z());
            RenderWire.render(this, pos);
            CCRenderState.setColour((int)-1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 0 && !this.useStaticRenderer()) {
            GL11.glDisable((int)2896);
            TextureUtils.bindAtlas((int)0);
            CCRenderState.useModelColours((boolean)true);
            CCRenderState.startDrawing((int)7);
            RenderWire.render(this, pos);
            CCRenderState.draw();
            CCRenderState.setColour((int)-1);
            GL11.glEnable((int)2896);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBreaking(bfr renderBlocks) {
        CCRenderState.reset();
        RenderWire.renderBreakingOverlay(renderBlocks.d, this);
    }

    public boolean doesTick() {
        return false;
    }

    static {
        for (int t = 0; t < 3; ++t) {
            Cuboid6 selection = new Cuboid6(0.0, 0.0, 0.0, 1.0, (double)(t + 2) / 16.0, 1.0).expand(-0.005);
            Cuboid6 occlusion = new Cuboid6(0.25, 0.0, 0.25, 0.75, (double)(t + 2) / 16.0, 0.75);
            for (int s = 0; s < 6; ++s) {
                WirePart.selectionBounds[t][s] = selection.copy().apply(Rotation.sideRotations[s].at(Vector3.center));
                WirePart.occlusionBounds[t][s] = occlusion.copy().apply(Rotation.sideRotations[s].at(Vector3.center));
            }
        }
    }
}

