/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.ColourModifier;
import codechicken.lib.render.ColourMultiplier;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IVertexModifier;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.render.UVTranslation;
import codechicken.lib.render.Vertex5;
import codechicken.lib.vec.AxisCycle;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.IMicroMaterialRender;
import codechicken.microblock.JMicroblockClient;
import codechicken.microblock.MicroMaterialRegistry;
import mrtjp.projectred.transmission.FramedWirePart;
import mrtjp.projectred.transmission.RenderWire;
import org.lwjgl.opengl.GL11;

public class RenderFramedWire {
    public static CCModel[] frameModels = new CCModel[7];
    public static CCModel[] wireModels = new CCModel[192];
    public static JacketedModel[] jacketModels = new JacketedModel[192];
    private static WireModelGenerator gen_inst = new WireModelGenerator();
    private static LazyLightMatrix dynamicLight = new LazyLightMatrix();

    public static void reverseOrder(Vertex5[] verts) {
        for (int k = 0; k < verts.length; k += 4) {
            Vertex5 tmp = verts[k + 1];
            verts[k + 1] = verts[k + 3];
            verts[k + 3] = tmp;
        }
    }

    public static int modelKey(int thickness, int connMap) {
        return connMap | thickness << 6;
    }

    public static int modelKey(FramedWirePart w) {
        return RenderFramedWire.modelKey(w.getThickness(), w.connMap);
    }

    public static CCModel getOrGenerateWireModel(int key) {
        CCModel m = wireModels[key];
        if (m == null) {
            RenderFramedWire.wireModels[key] = m = gen_inst.generateWireModel(key);
        }
        return m;
    }

    public static JacketedModel getOrGenerateJacketedModel(int key) {
        JacketedModel m = jacketModels[key];
        if (m == null) {
            RenderFramedWire.jacketModels[key] = m = gen_inst.generateJacketedModel(key);
        }
        return m;
    }

    public static void render(FramedWirePart w, Vector3 pos) {
        dynamicLight.setPos((acf)w.world(), w.x(), w.y(), w.z());
        RenderFramedWire.render(w, pos, dynamicLight);
    }

    public static void render(FramedWirePart w, Vector3 pos, LazyLightMatrix olm) {
        ColourModifier m;
        int key = RenderFramedWire.modelKey(w);
        IconTransformation uvt = new IconTransformation(w.getIcon());
        Object object = m = w.getColour() == -1 ? ColourModifier.instance : new ColourMultiplier(w.getColour());
        if (w.material == 0) {
            Translation t = new Translation(pos);
            RenderFramedWire.getOrGenerateWireModel(key).render((Transformation)t, (IUVTransformation)uvt, (IVertexModifier)m);
            RenderFramedWire.renderWireFrame(key, (Transformation)t, (IUVTransformation)uvt);
        } else {
            RenderFramedWire.getOrGenerateJacketedModel(key).render(w, pos, olm, (IUVTransformation)uvt, (IVertexModifier)m, w.material);
        }
    }

    private static void renderWireFrame(int key, Transformation t, IUVTransformation uvt) {
        frameModels[6].render(t, uvt);
        for (int s = 0; s < 6; ++s) {
            if ((key & 1 << s) == 0) continue;
            frameModels[s].render(t, uvt);
        }
    }

    public static void renderBreakingOverlay(ms icon, FramedWirePart wire) {
        for (Cuboid6 box : wire.getCollisionBoxes()) {
            RenderUtils.renderBlock((Cuboid6)box, (int)0, (Transformation)new Translation((double)wire.x(), (double)wire.y(), (double)wire.z()), (IUVTransformation)new IconTransformation(icon), null);
        }
    }

    public static void renderInv(int thickness, Transformation t, ms icon) {
        IconTransformation uvt = new IconTransformation(icon);
        RenderFramedWire.getOrGenerateWireModel(RenderFramedWire.modelKey(thickness, 63)).render(t, (IUVTransformation)uvt);
        CCRenderState.setColour((int)-1);
        RenderFramedWire.renderWireFrame(RenderFramedWire.modelKey(thickness, 0), t, (IUVTransformation)uvt);
    }

    public static void renderCoverHighlight(FramedWirePart part, int material) {
        BlockCoord pos = new BlockCoord((asp)part.tile());
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)pos.x + 0.5), (double)((double)pos.y + 0.5), (double)((double)pos.z + 0.5));
        GL11.glScaled((double)1.002, (double)1.002, (double)1.002);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        GL11.glEnable((int)3042);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        CCRenderState.reset();
        TextureUtils.bindAtlas((int)0);
        CCRenderState.useNormals((boolean)true);
        CCRenderState.setBrightness((acf)part.world(), (int)pos.x, (int)pos.y, (int)pos.z);
        CCRenderState.setAlpha((int)127);
        CCRenderState.useModelColours((boolean)true);
        CCRenderState.startDrawing((int)7);
        RenderFramedWire.getOrGenerateJacketedModel(RenderFramedWire.modelKey(part)).renderCovers(part.world(), new BlockCoord(), new Vector3(), null, material);
        CCRenderState.draw();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    static {
        WireFrameModelGenerator.generateModels();
    }

    private static class WireModelGenerator {
        int connMap;
        int tw;
        double w;
        int connCount;
        int i;
        CCModel model;
        private IUVTransformation uvReflect = new RenderWire.UVT(new Scale(-1.0, 1.0, 1.0).at(new Vector3(8.0, 0.0, 16.0)));

        private WireModelGenerator() {
        }

        public static int countConnections(int connMap) {
            int n = 0;
            for (int s = 0; s < 6; ++s) {
                if ((connMap & 1 << s) == 0) continue;
                ++n;
            }
            return n;
        }

        private void setup(int key) {
            this.connMap = key & 0x3F;
            this.connCount = WireModelGenerator.countConnections(this.connMap);
            int thickness = key >> 6;
            this.tw = thickness + 1;
            this.w = (double)this.tw / 16.0 + 0.004;
            this.i = 0;
        }

        public CCModel generateWireModel(int key) {
            this.setup(key);
            this.model = CCModel.quadModel((int)(this.connCount * 16 + 24));
            for (int s = 0; s < 6; ++s) {
                this.generateSide(s);
            }
            return RenderWire.finishModel(this.model);
        }

        private void generateSide(int s) {
            Vertex5[] verts = this.connCount == 0 ? this.generateStub(s) : (this.connCount == 1 ? ((this.connMap & 1 << (s ^ 1)) != 0 ? this.generateStub(s) : this.generateSideFromType(s)) : this.generateSideFromType(s));
            Transformation t = AxisCycle.cycles[s / 2].at(Vector3.center);
            for (Vertex5 vert : verts) {
                vert.apply(t);
            }
            this.i = RenderWire.addVerts(this.model, verts, this.i);
        }

        private Vertex5[] generateSideFromType(int s) {
            if ((this.connMap & 1 << s) != 0) {
                return this.generateStraight(s);
            }
            return this.generateFlat(s);
        }

        private Vertex5[] generateStraight(int s) {
            Vertex5[] verts = new Vertex5[20];
            System.arraycopy(this.faceVerts(s, 0.0), 0, verts, 0, 4);
            if (s % 2 == 0) {
                verts[4] = new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w, (double)(8 - this.tw), 24.0);
                verts[5] = new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w, (double)(8 + this.tw), 24.0);
                verts[6] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 + this.w, (double)(8 + this.tw), (double)(16 + this.tw));
                verts[7] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 + this.w, (double)(8 - this.tw), (double)(16 + this.tw));
            } else {
                verts[4] = new Vertex5(0.5 - this.w, 0.5 + this.w, 0.5 + this.w, (double)(8 - this.tw), (double)(16 - this.tw));
                verts[5] = new Vertex5(0.5 + this.w, 0.5 + this.w, 0.5 + this.w, (double)(8 + this.tw), (double)(16 - this.tw));
                verts[6] = new Vertex5(0.5 + this.w, 1.0, 0.5 + this.w, (double)(8 + this.tw), 8.0);
                verts[7] = new Vertex5(0.5 - this.w, 1.0, 0.5 + this.w, (double)(8 - this.tw), 8.0);
            }
            for (int r = 1; r < 4; ++r) {
                Transformation t = Rotation.quarterRotations[r].at(Vector3.center);
                for (int i = 0; i < 4; ++i) {
                    verts[i + r * 4 + 4] = verts[i + 4].copy().apply(t);
                    if (r < 2) continue;
                    verts[i + r * 4 + 4].apply(this.uvReflect);
                }
            }
            UVTranslation t = new UVTranslation(12.0, 12.0);
            for (int i = 0; i < 4; ++i) {
                verts[i].apply((IUVTransformation)t);
            }
            return verts;
        }

        private Vertex5[] generateFlat(int s) {
            RenderWire.UVT uvt;
            Vertex5[] verts = this.faceVerts(s, 0.5 - this.w);
            int fConnMask = 0;
            for (int i = 0; i < 4; ++i) {
                int absSide = ((s & 6) + i + 2) % 6;
                if ((this.connMap & 1 << absSide) == 0) continue;
                fConnMask |= 1 << i;
            }
            int rot = (fConnMask & 0xC) == 0 ? 0 : ((fConnMask & 3) == 0 ? 1 : 2);
            if (rot == 1) {
                uvt = new RenderWire.UVT(Rotation.quarterRotations[1].at(new Vector3(8.0, 0.0, 16.0)));
            } else if (rot == 2) {
                uvt = new RenderWire.UVT((Transformation)Rotation.quarterRotations[1].at(new Vector3(8.0, 0.0, 16.0)).with((Transformation)new Translation(16.0, 0.0, 0.0)));
            } else {
                return verts;
            }
            for (Vertex5 vert : verts) {
                vert.apply((IUVTransformation)uvt);
            }
            return verts;
        }

        private Vertex5[] generateStub(int s) {
            Vertex5[] verts = this.faceVerts(s, 0.5 - this.w);
            UVTranslation t = new UVTranslation(12.0, 12.0);
            for (Vertex5 vert : verts) {
                vert.apply((IUVTransformation)t);
            }
            return verts;
        }

        private Vertex5[] faceVerts(int s, double d) {
            Vertex5[] verts = new Vertex5[]{new Vertex5(0.5 - this.w, d, 0.5 - this.w, (double)(8 - this.tw), (double)(16 + this.tw)), new Vertex5(0.5 + this.w, d, 0.5 - this.w, (double)(8 + this.tw), (double)(16 + this.tw)), new Vertex5(0.5 + this.w, d, 0.5 + this.w, (double)(8 + this.tw), (double)(16 - this.tw)), new Vertex5(0.5 - this.w, d, 0.5 + this.w, (double)(8 - this.tw), (double)(16 - this.tw))};
            if (s % 2 == 1) {
                Transformation t = new Scale(1.0, -1.0, 1.0).at(Vector3.center);
                for (Vertex5 vert : verts) {
                    vert.apply(t);
                }
                RenderFramedWire.reverseOrder(verts);
            }
            return verts;
        }

        public JacketedModel generateJacketedModel(int key) {
            this.setup(key);
            return new JacketedModel(this.generateJacketedWireModel(), this.generateJacketedBoxes());
        }

        private IndexedCuboid6[] generateJacketedBoxes() {
            if (this.connCount == 0) {
                return new IndexedCuboid6[]{new IndexedCuboid6((Object)0, FramedWirePart.boundingBoxes[6])};
            }
            int n = 0;
            for (int a = 0; a < 3; ++a) {
                if ((this.connMap & 3 << a * 2) == 0) continue;
                ++n;
            }
            IndexedCuboid6[] boxes = new IndexedCuboid6[n];
            this.i = 0;
            boolean first = true;
            for (int a = 0; a < 3; ++a) {
                first = !this.generateAxialJacketBoxes(a, first, boxes);
            }
            return boxes;
        }

        private boolean generateAxialJacketBoxes(int a, boolean first, IndexedCuboid6[] boxes) {
            Cuboid6 box;
            int mask = this.connMap >> a * 2 & 3;
            if (mask == 0) {
                return false;
            }
            if (mask == 1) {
                box = FramedWirePart.boundingBoxes[0].copy();
            } else if (mask == 2) {
                box = FramedWirePart.boundingBoxes[1].copy();
            } else {
                box = FramedWirePart.boundingBoxes[0].copy();
                box.max.y = 1.0;
            }
            box.apply(Rotation.sideRotations[a * 2].at(Vector3.center));
            if (first) {
                box.enclose(FramedWirePart.boundingBoxes[6]);
            }
            int fMask = 0;
            fMask = first || mask == 3 ? 0 : (mask == 1 ? 1 << 2 * a + 1 : 1 << 2 * a);
            boxes[this.i] = new IndexedCuboid6((Object)fMask, box);
            ++this.i;
            return true;
        }

        private CCModel generateJacketedWireModel() {
            int n = this.connCount == 0 ? 6 : (this.connCount == 1 ? 2 : this.connCount);
            this.model = CCModel.quadModel((int)(n * 4));
            for (int s = 0; s < 6; ++s) {
                this.generateJacketedSide(s);
            }
            return RenderWire.finishModel(this.model);
        }

        private void generateJacketedSide(int s) {
            double d;
            if ((this.connMap & 1 << s) != 0) {
                d = 0.0;
            } else if (this.connCount == 0) {
                d = 0.25;
            } else if (this.connCount == 1 && (this.connMap & 1 << (s ^ 1)) != 0) {
                d = 0.25;
            } else {
                return;
            }
            Vertex5[] verts = this.faceVerts(s, d - 0.002);
            Transformation t = AxisCycle.cycles[s / 2].at(Vector3.center);
            UVTranslation uvt = new UVTranslation(12.0, 12.0);
            for (Vertex5 vert : verts) {
                vert.apply(t);
                vert.apply((IUVTransformation)uvt);
            }
            this.i = RenderWire.addVerts(this.model, verts, this.i);
        }
    }

    private static class JacketedModel
    implements IMicroMaterialRender {
        public CCModel wireModel;
        public IndexedCuboid6[] boxes;
        public Cuboid6 bounds;
        private abw world;
        private BlockCoord pos = new BlockCoord();

        public JacketedModel(CCModel model, IndexedCuboid6[] boxes) {
            this.wireModel = model;
            this.boxes = boxes;
            this.bounds = boxes[0].copy();
            for (int i = 1; i < boxes.length; ++i) {
                this.bounds.enclose((Cuboid6)boxes[i]);
            }
        }

        public void render(FramedWirePart w, Vector3 t, LazyLightMatrix olm, IUVTransformation uvt, IVertexModifier m, int mat) {
            this.renderCovers(w.world(), new BlockCoord((asp)w.tile()), t, olm, mat);
            this.wireModel.render((Transformation)new Translation(t), uvt, m);
        }

        public void renderCovers(abw world, BlockCoord pos, Vector3 t, LazyLightMatrix olm, int mat) {
            this.world = world;
            this.pos.set(pos);
            MicroMaterialRegistry.IMicroMaterial material = MicroMaterialRegistry.getMaterial((int)mat);
            for (IndexedCuboid6 box : this.boxes) {
                JMicroblockClient.renderCuboid((Vector3)t, (LazyLightMatrix)olm, (MicroMaterialRegistry.IMicroMaterial)material, (Cuboid6)box, (int)((Integer)box.data), (IMicroMaterialRender)this);
            }
        }

        public Cuboid6 getRenderBounds() {
            return this.bounds;
        }

        public int x() {
            return this.pos.x;
        }

        public int y() {
            return this.pos.y;
        }

        public int z() {
            return this.pos.z;
        }

        public abw world() {
            return this.world;
        }
    }

    private static class WireFrameModelGenerator {
        double w = 0.25;
        double d = 0.0605;

        private WireFrameModelGenerator() {
        }

        public static void generateModels() {
            WireFrameModelGenerator gen_inst = new WireFrameModelGenerator();
            gen_inst.generateCenterModel();
            gen_inst.generateSideModels();
            gen_inst.finishModels();
        }

        public void generateCenterModel() {
            CCModel model = CCModel.quadModel((int)48);
            model.verts[0] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 - this.w, 20.0, 8.0);
            model.verts[1] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 - this.w, 28.0, 8.0);
            model.verts[2] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 + this.w, 28.0, 0.0);
            model.verts[3] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 + this.w, 20.0, 0.0);
            model.verts[4] = new Vertex5(0.5 - this.w, 0.5 - this.w + this.d, 0.5 + this.w, 20.0, 8.0);
            model.verts[5] = new Vertex5(0.5 + this.w, 0.5 - this.w + this.d, 0.5 + this.w, 28.0, 8.0);
            model.verts[6] = new Vertex5(0.5 + this.w, 0.5 - this.w + this.d, 0.5 - this.w, 28.0, 0.0);
            model.verts[7] = new Vertex5(0.5 - this.w, 0.5 - this.w + this.d, 0.5 - this.w, 20.0, 0.0);
            model.generateSidedParts(0, Vector3.center);
            RenderFramedWire.frameModels[6] = model;
        }

        public void generateSideModels() {
            CCModel model = CCModel.quadModel((int)36);
            model.verts[0] = new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w, 16.0, 0.0);
            model.verts[1] = new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w, 16.0, 8.0);
            model.verts[2] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 + this.w, 20.0, 8.0);
            model.verts[3] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 + this.w, 20.0, 0.0);
            model.verts[4] = new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w - this.d, 16.0, 0.0);
            model.verts[5] = new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w - this.d, 16.0, 8.0);
            model.verts[6] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 + this.w - this.d, 20.0, 8.0);
            model.verts[7] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 + this.w - this.d, 20.0, 0.0);
            for (int r = 1; r < 4; ++r) {
                model.apply(Rotation.quarterRotations[r].at(Vector3.center), 0, r * 8, 8);
            }
            model.verts[32] = new Vertex5(0.5 - this.w, 0.0, 0.5 - this.w, 24.0, 32.0);
            model.verts[33] = new Vertex5(0.5 + this.w, 0.0, 0.5 - this.w, 32.0, 32.0);
            model.verts[34] = new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w, 32.0, 24.0);
            model.verts[35] = new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w, 24.0, 24.0);
            RenderFramedWire.frameModels[0] = model;
            for (int s = 1; s < 6; ++s) {
                RenderFramedWire.frameModels[s] = model.copy().apply(Rotation.sideRotations[s].at(Vector3.center));
                if (s % 2 != 1) continue;
                Vertex5[] verts = RenderFramedWire.frameModels[s].verts;
                RenderWire.UVT t = new RenderWire.UVT(Rotation.quarterRotations[2].at(new Vector3(24.0, 0.0, 4.0)));
                for (int i = 0; i < 32; ++i) {
                    verts[i].apply((IUVTransformation)t);
                }
            }
        }

        public void finishModels() {
            for (CCModel m : frameModels) {
                RenderWire.finishModel(m);
            }
        }
    }
}

