/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.TMultiPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.transmission.EnumWire;
import mrtjp.projectred.transmission.IBundledCablePart;
import mrtjp.projectred.transmission.IInsulatedRedwirePart;
import mrtjp.projectred.transmission.RedwirePart;

public class InsulatedRedAlloyPart
extends RedwirePart
implements IInsulatedRedwirePart {
    public byte colour;

    public String getType() {
        return "pr_insulated";
    }

    @Override
    public EnumWire getWireType() {
        return EnumWire.INSULATED_WIRE[this.colour];
    }

    @Override
    public void preparePlacement(int side, int meta) {
        super.preparePlacement(side, meta);
        this.colour = (byte)(meta - EnumWire.INSULATED_0.ordinal());
    }

    @Override
    public void save(by tag) {
        super.save(tag);
        tag.a("colour", this.colour);
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        this.colour = tag.c("colour");
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.colour);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.colour = packet.readByte();
    }

    @Override
    public int getPartSignal(TMultiPart part, int r) {
        if (part instanceof IBundledCablePart) {
            return (((IBundledCablePart)part).getBundledSignal()[this.colour] & 0xFF) - 1;
        }
        return super.getPartSignal(part, r);
    }

    @Override
    public int weakPowerLevel(int side) {
        if (this.side == side || this.side == (side ^ 1) || !this.maskConnects(Rotation.rotationTo((int)this.side, (int)side))) {
            return 0;
        }
        return super.weakPowerLevel(side);
    }

    @Override
    public boolean canConnectToType(IConnectable wire) {
        if (wire instanceof IInsulatedRedwirePart) {
            return ((IInsulatedRedwirePart)wire).getInsulatedColour() == this.colour;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ms getIcon() {
        return this.getWireType().wireSprites[this.signal != 0 ? 1 : 0];
    }

    @Override
    public int getInsulatedColour() {
        return this.colour;
    }
}

