/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.IMaskedRedstonePart;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.CoreSPH;
import mrtjp.projectred.core.Messenger;
import mrtjp.projectred.transmission.FramedWirePart;
import mrtjp.projectred.transmission.IRedwireEmitter;
import mrtjp.projectred.transmission.IRedwirePart;
import mrtjp.projectred.transmission.WirePropogator;

public abstract class FramedRedwirePart
extends FramedWirePart
implements IRedwirePart,
IMaskedRedstonePart {
    public byte signal;

    @Override
    public void save(by tag) {
        super.save(tag);
        tag.a("signal", this.signal);
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        this.signal = tag.c("signal");
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.signal);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.signal = packet.readByte();
    }

    @Override
    public void read(MCDataInput packet, int switch_key) {
        if (switch_key == 10) {
            this.signal = packet.readByte();
            if (this.useStaticRenderer()) {
                this.tile().markRender();
            }
        } else {
            super.read(packet, switch_key);
        }
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public int weakPowerLevel(int side) {
        return this.rsLevel();
    }

    public boolean canConnectRedstone(int side) {
        return true;
    }

    public int rsLevel() {
        if (WirePropogator.redwiresProvidePower) {
            return ((this.signal & 0xFF) + 16) / 17;
        }
        return 0;
    }

    public int getConnectionMask(int side) {
        return 16;
    }

    @Override
    public boolean canConnectToType(IConnectable wire) {
        return wire instanceof IRedwirePart;
    }

    @Override
    public boolean connectStraightOverride(int absDir) {
        WirePropogator.setRedwiresConnectable(false);
        boolean b = (RedstoneInteractions.otherConnectionMask((acf)this.world(), (int)this.x(), (int)this.y(), (int)this.z(), (int)absDir, (boolean)false) & RedstoneInteractions.connectionMask((TMultiPart)this, (int)absDir)) != 0;
        WirePropogator.setRedwiresConnectable(true);
        return b;
    }

    @Override
    public boolean connectInternalOverride(TMultiPart p, int s) {
        if (p instanceof IRedstonePart) {
            IRedstonePart rsPart = (IRedstonePart)p;
            return rsPart.canConnectRedstone(s ^ 1);
        }
        return false;
    }

    @Override
    public void updateAndPropogate(TMultiPart prev, int mode) {
        if (mode == 1 && this.signal == 0) {
            return;
        }
        int newSignal = this.calculateSignal();
        if (newSignal < this.getRedwireSignal()) {
            if (newSignal > 0) {
                WirePropogator.propogateAnalogDrop(this);
            }
            this.signal = 0;
            this.propogate(prev, 1);
        } else if (newSignal > this.getRedwireSignal()) {
            this.signal = (byte)newSignal;
            if (mode == 1) {
                this.propogate(null, 0);
            } else {
                this.propogate(prev, 0);
            }
        } else if (mode == 1) {
            this.propogateTo(prev, 0);
        } else if (mode == 2) {
            this.propogate(prev, 3);
        }
    }

    @Override
    public void onSignalUpdate() {
        super.onSignalUpdate();
        this.tile().getWriteStream((TMultiPart)this).writeByte(10).writeByte((int)this.signal);
    }

    public int calculateSignal() {
        WirePropogator.setWiresProvidePower(false);
        WirePropogator.redwiresProvidePower = false;
        int str = 0;
        for (int s = 0; s < 6; ++s) {
            int i;
            if (!this.maskConnects(s) || (i = (this.connMap & 1 << s) != 0 ? this.calculateStraightSignal(s) : this.calculateInternalSignal(s)) <= str) continue;
            str = i;
        }
        WirePropogator.setWiresProvidePower(true);
        WirePropogator.redwiresProvidePower = true;
        return str;
    }

    public int calculateStraightSignal(int s) {
        TMultiPart tp;
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(s);
        TileMultipart t = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)pos);
        if (t != null && (tp = t.partMap(6)) != null) {
            return this.getPartSignal(tp, s ^ 1);
        }
        return RedstoneInteractions.getPowerTo((TMultiPart)this, (int)s) * 17;
    }

    public int calculateInternalSignal(int s) {
        TMultiPart tp = this.tile().partMap(s);
        int i = this.getPartSignal(tp, -1);
        if (i > 0) {
            return i;
        }
        if (tp instanceof IRedstonePart) {
            IRedstonePart rp = (IRedstonePart)tp;
            return Math.max(rp.strongPowerLevel(s ^ 1), rp.weakPowerLevel(s ^ 1)) << 4;
        }
        return 0;
    }

    public int getPartSignal(TMultiPart part, int r) {
        if (part instanceof IRedwirePart && ((IRedwirePart)part).isWireSide(r)) {
            return ((IRedwirePart)part).getRedwireSignal(r) - 1;
        }
        if (part instanceof IRedwireEmitter) {
            return ((IRedwireEmitter)part).getRedwireSignal(r);
        }
        return 0;
    }

    public int getRedwireSignal() {
        return this.signal & 0xFF;
    }

    @Override
    public int getRedwireSignal(int side) {
        return this.getRedwireSignal();
    }

    @Override
    protected boolean test(uf player, ata hit) {
        if (BasicUtils.isClient((abw)this.world())) {
            Messenger.addMessage((double)(this.x() + 0), (double)((float)this.y() + 0.5f), (double)(this.z() + 0), (String)("/#f/#c[c] = " + this.getRedwireSignal()));
        } else {
            PacketCustom packet = new PacketCustom(CoreSPH.channel, 2);
            packet.writeDouble((double)this.x() + 0.0);
            packet.writeDouble((double)this.y() + 0.5);
            packet.writeDouble((double)this.z() + 0.0);
            packet.writeString("/#c[s] = " + this.getRedwireSignal());
            packet.sendToPlayer(player);
        }
        return true;
    }
}

