/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import java.util.Arrays;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.CoreSPH;
import mrtjp.projectred.transmission.BundledCableCommons;
import mrtjp.projectred.transmission.EnumWire;
import mrtjp.projectred.transmission.IBundledCablePart;
import mrtjp.projectred.transmission.IInsulatedRedwirePart;
import mrtjp.projectred.transmission.WirePart;

public class BundledCablePart
extends WirePart
implements IBundledCablePart {
    public byte[] signal = new byte[16];
    public byte colour;

    public String getType() {
        return "pr_bundled";
    }

    @Override
    public EnumWire getWireType() {
        return EnumWire.BUNDLED_WIRE[this.colour + 1];
    }

    @Override
    public void preparePlacement(int side, int meta) {
        super.preparePlacement(side, meta);
        this.colour = (byte)(meta - EnumWire.BUNDLED_0.ordinal());
    }

    @Override
    public void save(by tag) {
        super.save(tag);
        tag.a("signal", this.signal);
        tag.a("colour", this.colour);
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        this.signal = tag.j("signal");
        this.colour = tag.c("colour");
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.colour);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.colour = packet.readByte();
    }

    @Override
    public boolean canConnectToType(IConnectable wire) {
        if (wire instanceof BundledCablePart) {
            byte ocolour = ((BundledCablePart)wire).colour;
            return ocolour == -1 || this.colour == -1 || ocolour == this.colour;
        }
        return wire instanceof IInsulatedRedwirePart || wire instanceof IBundledEmitter;
    }

    @Override
    public boolean connectStraightOverride(int absDir) {
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir);
        asp t = this.world().r(pos.x, pos.y, pos.z);
        if (t instanceof IBundledTile) {
            return ((IBundledTile)t).canConnectBundled(absDir ^ 1);
        }
        return false;
    }

    @Override
    public void updateAndPropogate(TMultiPart prev, int mode) {
        BundledCableCommons.updateAndPropogate(this, prev, mode);
    }

    @Override
    public boolean propogateTo(TMultiPart part, int mode) {
        if (!BundledCableCommons.shouldPropogate(this, part, mode)) {
            return true;
        }
        return super.propogateTo(part, mode);
    }

    @Override
    public void setSignal(byte[] newSignal) {
        if (newSignal == null) {
            Arrays.fill(this.signal, (byte)0);
        } else {
            System.arraycopy(newSignal, 0, this.signal, 0, 16);
        }
    }

    @Override
    public byte[] calculateSignal() {
        Arrays.fill(BundledCableCommons.tmpSignal, (byte)0);
        for (int r = 0; r < 4; ++r) {
            if (!this.maskConnects(r)) continue;
            if ((this.connMap & 1 << r) != 0) {
                this.calculateCornerSignal(r);
                continue;
            }
            if ((this.connMap & 16 << r) != 0) {
                this.calculateStraightSignal(r);
            }
            this.calculateInternalSignal(r);
        }
        this.calculateCenterSignal();
        return BundledCableCommons.tmpSignal;
    }

    public void calculateCornerSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir).offset((int)this.side);
        TileMultipart t = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)pos);
        if (t != null) {
            BundledCableCommons.calculatePartSignal(t.partMap(absDir ^ 1), Rotation.rotationTo((int)(absDir ^ 1), (int)(this.side ^ 1)));
        }
    }

    public void calculateStraightSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir);
        asp t = this.world().r(pos.x, pos.y, pos.z);
        if (t instanceof IBundledEmitter) {
            BundledCableCommons.calculatePartSignal(t, absDir ^ 1);
        } else if (t instanceof TileMultipart) {
            BundledCableCommons.calculatePartSignal(((TileMultipart)t).partMap((int)this.side), (r + 2) % 4);
        }
    }

    public void calculateInternalSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BundledCableCommons.calculatePartSignal(this.tile().partMap(absDir), (r + 2) % 4);
    }

    public void calculateCenterSignal() {
        BundledCableCommons.calculatePartSignal(this.tile().partMap(6), this.side);
    }

    @Override
    public byte[] getBundledSignal() {
        return this.signal;
    }

    public byte[] getBundledSignal(int side) {
        return this.getBundledSignal();
    }

    @Override
    protected boolean debug(uf ply) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            String s = Integer.toHexString(this.signal[i] & 0xFF).toUpperCase();
            if (s.length() == 1) {
                sb.append('0');
            }
            sb.append(s);
        }
        ply.a(cv.e((String)sb.toString()));
        return true;
    }

    @Override
    protected boolean test(uf player) {
        if (BasicUtils.isServer((abw)this.world())) {
            String s = "";
            for (int i = 0; i < 16; ++i) {
                byte x = this.getBundledSignal()[i];
                if (x == 0) continue;
                s = s + "[" + i + "]";
            }
            if (s == "") {
                s = "off";
            }
            PacketCustom packet = new PacketCustom(CoreSPH.channel, 2);
            packet.writeDouble((double)this.x() + 0.0);
            packet.writeDouble((double)this.y() + 0.5);
            packet.writeDouble((double)this.z() + 0.0);
            packet.writeString("/#f" + s);
            packet.sendToPlayer(player);
        }
        return true;
    }

    @Override
    public boolean useStaticRenderer() {
        return true;
    }
}

