/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import java.util.Random;
import mrtjp.projectred.api.IScrewdriver;
import mrtjp.projectred.integration.GatePart;
import mrtjp.projectred.integration.RedstoneGateLogic;
import mrtjp.projectred.integration.RowGatePart;
import mrtjp.projectred.integration.SimpleGatePart;

public abstract class SimpleGateLogic
extends RedstoneGateLogic<SimpleGatePart> {
    public static int[] advanceDead = new int[]{1, 2, 4, 0, 5, 6, 3};
    public static SimpleGateLogic[] instances = new SimpleGateLogic[]{new OR(), new NOR(), new NOT(), new AND(), new NAND(), new XOR(), new XNOR(), new Buffer(), new Multiplexer(), new Pulse(), new Repeater(), new Randomizer(), null, null, new TransparentLatch(), new LightSensor(), new RainSensor(), null, null, null, null, null, null, null, null, null, null, new ANDCell()};

    public static int countBits(int n) {
        int c = 0;
        while (n != 0) {
            n &= n - 1;
            ++c;
        }
        return c;
    }

    @Override
    public int getOutput(SimpleGatePart gate, int r) {
        return (gate.state & 16 << r) != 0 ? 15 : 0;
    }

    @Override
    public boolean cycleShape(SimpleGatePart gate) {
        int oldShape = gate.shape();
        int newShape = this.cycleShape(oldShape);
        if (newShape != oldShape) {
            gate.setShape(newShape);
            return true;
        }
        return false;
    }

    public int cycleShape(int shape) {
        while (SimpleGateLogic.countBits(shape = advanceDead[shape]) > this.maxDeadSides() && 32 - Integer.numberOfLeadingZeros(shape) <= this.maxDeadSides()) {
        }
        return shape;
    }

    public int deadSides() {
        return 0;
    }

    public int maxDeadSides() {
        return this.deadSides() - 1;
    }

    public int getDelay(int shape) {
        return 2;
    }

    public int feedbackMask(int shape) {
        return 0;
    }

    @Override
    public void onChange(SimpleGatePart gate) {
        int newOutput;
        int inputMask = this.inputMask(gate.shape());
        int outputMask = this.outputMask(gate.shape());
        int oldInput = gate.state & 0xF;
        int feedbackMask = this.feedbackMask(gate.shape());
        int newInput = this.getInput(gate, inputMask | feedbackMask);
        if (oldInput != newInput) {
            gate.setState(gate.state & 0xF0 | newInput);
            gate.onInputChange();
        }
        if ((newOutput = this.calcOutput(gate, gate.state & inputMask) & outputMask) != gate.state() >> 4) {
            gate.scheduleTick(this.getDelay(gate.shape()));
        }
    }

    @Override
    public void scheduledTick(SimpleGatePart gate) {
        int newOutput;
        int inputMask = this.inputMask(gate.shape());
        int outputMask = this.outputMask(gate.shape());
        int oldOutput = gate.state() >> 4;
        if (oldOutput != (newOutput = this.calcOutput(gate, gate.state & inputMask) & outputMask)) {
            gate.setState(gate.state & 0xF | newOutput << 4);
            gate.onOutputChange(outputMask);
        }
        this.onChange(gate);
    }

    @Override
    public void setup(SimpleGatePart gate) {
        int inputMask = this.inputMask(gate.shape());
        int outputMask = this.outputMask(gate.shape());
        int output = this.calcOutput(gate, this.getInput(gate, inputMask)) & outputMask;
        if (output != 0) {
            gate.setState(output << 4);
            gate.onOutputChange(output);
        }
    }

    public static class ANDCell
    extends SimpleGateLogic {
        @Override
        public int calcOutput(int input) {
            return input == 14 ? 1 : 0;
        }

        @Override
        public int getInput(SimpleGatePart gate, int inputMask) {
            int i = super.getInput(gate, 4);
            if (((RowGatePart)gate).signal != 0) {
                i |= 0xA;
            }
            return i;
        }

        @Override
        public boolean canConnect(int shape, int r) {
            return true;
        }
    }

    public static class RainSensor
    extends SimpleGateLogic {
        @Override
        public int inputMask(int shape) {
            return 0;
        }

        @Override
        public int outputMask(int shape) {
            return 4;
        }

        @Override
        public int feedbackMask(int shape) {
            return 4;
        }

        @Override
        public int cycleShape(int shape) {
            return (shape + 1) % 5;
        }

        @Override
        public int calcOutput(SimpleGatePart gate, int input) {
            return gate.shape() >> 4;
        }

        @Override
        public void onTick(SimpleGatePart gate) {
            int oldOutput;
            if (gate.world().I) {
                return;
            }
            int newOutput = gate.world().Q() && gate.world().l(gate.x(), gate.y() + 1, gate.z()) ? 4 : 0;
            if (newOutput != (oldOutput = gate.state() >> 4)) {
                gate.setState(newOutput << 4 | gate.state & 0xF);
                gate.onOutputChange(4);
            }
        }

        @Override
        public int lightLevel() {
            return 0;
        }
    }

    public static class LightSensor
    extends SimpleGateLogic {
        @Override
        public int getOutput(SimpleGatePart gate, int r) {
            return r == 2 ? gate.state() >> 4 : 0;
        }

        @Override
        public int inputMask(int shape) {
            return 0;
        }

        @Override
        public int outputMask(int shape) {
            return 4;
        }

        @Override
        public int feedbackMask(int shape) {
            return 4;
        }

        @Override
        public int cycleShape(int shape) {
            return (shape + 1) % 3;
        }

        @Override
        public void setup(SimpleGatePart gate) {
            this.onTick(gate);
        }

        @Override
        public int calcOutput(SimpleGatePart gate, int input) {
            return gate.shape() >> 4;
        }

        @Override
        public void onTick(SimpleGatePart gate) {
            if (gate.world().I) {
                return;
            }
            int sky = gate.world().b(ach.a, gate.x(), gate.y(), gate.z()) - gate.world().j;
            int block = gate.world().b(ach.b, gate.x(), gate.y(), gate.z());
            int shape = gate.shape();
            int newOutput = shape == 0 ? Math.max(sky, block) : (shape == 1 ? sky : block);
            if (newOutput != gate.state() >> 4) {
                gate.setState(newOutput << 4 | gate.state & 0xF);
                gate.onOutputChange(4);
            }
        }

        @Override
        public void onChange(SimpleGatePart gate) {
            int oldInput = gate.state & 0xF;
            int newInput = this.getInput(gate, 4);
            if (oldInput != newInput) {
                gate.setState(gate.state & 0xF0 | newInput);
                gate.onInputChange();
            }
        }

        @Override
        public int lightLevel() {
            return 0;
        }
    }

    public static class TransparentLatch
    extends SimpleGateLogic {
        @Override
        public int cycleShape(int shape) {
            return (shape + 1) % 2;
        }

        @Override
        public int inputMask(int shape) {
            return shape == 0 ? 12 : 6;
        }

        @Override
        public int outputMask(int shape) {
            return shape == 0 ? 3 : 9;
        }

        @Override
        public int calcOutput(SimpleGatePart gate, int input) {
            if ((input & 4) == 0) {
                return gate.state() >> 4;
            }
            return (input & 0xA) == 0 ? 0 : 15;
        }
    }

    public static class Randomizer
    extends SimpleGateLogic {
        public Random rand = new Random();

        @Override
        public int calcOutput(SimpleGatePart gate, int input) {
            return input == 0 ? gate.state() >> 4 : GatePart.shiftMask(this.rand.nextInt(8), 3);
        }

        @Override
        public int outputMask(int shape) {
            return 11;
        }

        @Override
        public int feedbackMask(int shape) {
            return 11;
        }

        @Override
        public int inputMask(int shape) {
            return 4;
        }

        @Override
        public void onChange(SimpleGatePart gate) {
            super.onChange(gate);
            if ((gate.state() & 4) != 0) {
                gate.scheduleTick(2);
            }
        }
    }

    public static class Repeater
    extends SimpleGateLogic {
        public int[] delays = new int[]{2, 4, 6, 8, 16, 32, 64, 128, 256};

        @Override
        public int calcOutput(int input) {
            return input == 0 ? 0 : 1;
        }

        @Override
        public int inputMask(int shape) {
            return 4;
        }

        @Override
        public void onChange(SimpleGatePart gate) {
            if (gate.schedTime < 0L) {
                super.onChange(gate);
            }
        }

        @Override
        public int getDelay(int shape) {
            return this.delays[shape];
        }

        @Override
        public int cycleShape(int shape) {
            return (shape + 1) % this.delays.length;
        }

        @Override
        public boolean activate(SimpleGatePart part, uf player, ye held) {
            if (held == null || !(held.b() instanceof IScrewdriver)) {
                if (!part.world().I) {
                    part.configure();
                }
                return true;
            }
            return false;
        }
    }

    public static class Pulse
    extends SimpleGateLogic {
        @Override
        public int calcOutput(int input) {
            return 0;
        }

        @Override
        public int inputMask(int shape) {
            return 4;
        }

        @Override
        public void onChange(SimpleGatePart gate) {
            int oldInput = gate.state & 0xF;
            int newInput = this.getInput(gate, 4);
            if (oldInput != newInput) {
                gate.setState(gate.state & 0xF0 | newInput);
                gate.onInputChange();
                if (newInput != 0 && (gate.state & 0xF0) == 0) {
                    gate.setState(gate.state & 0xF | 0x10);
                    gate.scheduleTick(2);
                    gate.onOutputChange(1);
                }
            }
        }
    }

    public static class Multiplexer
    extends SimpleGateLogic {
        @Override
        public int outputMask(int shape) {
            return 1;
        }

        @Override
        public int inputMask(int shape) {
            return 14;
        }

        @Override
        public int calcOutput(int input) {
            boolean inLeft;
            boolean inRight = (input & 2) != 0;
            boolean inFront = (input & 4) != 0;
            boolean bl = inLeft = (input & 8) != 0;
            return inFront ? (inLeft ? 1 : 0) : (inRight ? 1 : 0);
        }
    }

    public static class Buffer
    extends SimpleGateLogic {
        @Override
        public int feedbackMask(int shape) {
            return this.outputMask(shape);
        }

        @Override
        public int outputMask(int shape) {
            int m = 0;
            m |= (shape & 1) << 1;
            m |= (shape & 2) << 2;
            return ~(m |= (shape & 8) << 4) & 0xB;
        }

        @Override
        public int inputMask(int shape) {
            return 4;
        }

        @Override
        public int deadSides() {
            return 2;
        }

        @Override
        public int calcOutput(int input) {
            return input != 0 ? 11 : 0;
        }
    }

    public static class XNOR
    extends SimpleGateLogic {
        @Override
        public int inputMask(int shape) {
            int m = 0;
            m |= 2;
            return m |= 8;
        }

        @Override
        public int calcOutput(SimpleGatePart gate, int input) {
            boolean side1 = (input & 2) != 0;
            boolean side2 = (input & 8) != 0;
            return side1 == side2 ? 1 : 0;
        }
    }

    public static class XOR
    extends SimpleGateLogic {
        @Override
        public int inputMask(int shape) {
            int m = 0;
            m |= 2;
            return m |= 8;
        }

        @Override
        public int calcOutput(SimpleGatePart gate, int input) {
            boolean side1 = (input & 2) != 0;
            boolean side2 = (input & 8) != 0;
            return side1 != side2 ? 1 : 0;
        }
    }

    public static class NAND
    extends SimpleGateLogic {
        @Override
        public int inputMask(int shape) {
            return ~shape << 1 & 0xE;
        }

        @Override
        public int deadSides() {
            return 3;
        }

        @Override
        public int calcOutput(SimpleGatePart gate, int input) {
            return input == this.inputMask(gate.shape()) ? 0 : 1;
        }
    }

    public static class AND
    extends SimpleGateLogic {
        @Override
        public int inputMask(int shape) {
            return ~shape << 1 & 0xE;
        }

        @Override
        public int deadSides() {
            return 3;
        }

        @Override
        public int calcOutput(SimpleGatePart gate, int input) {
            return input == this.inputMask(gate.shape()) ? 1 : 0;
        }
    }

    public static class NOT
    extends SimpleGateLogic {
        @Override
        public int feedbackMask(int shape) {
            return this.outputMask(shape);
        }

        @Override
        public int outputMask(int shape) {
            int m = 0;
            m |= (shape & 1) << 1;
            m |= (shape & 2) >> 1;
            return ~(m |= (shape & 4) << 1) & 0xB;
        }

        @Override
        public int inputMask(int shape) {
            return 4;
        }

        @Override
        public int deadSides() {
            return 3;
        }

        @Override
        public int calcOutput(int input) {
            return input == 0 ? 11 : 0;
        }
    }

    public static class NOR
    extends SimpleGateLogic {
        @Override
        public int feedbackMask(int shape) {
            return 1;
        }

        @Override
        public int inputMask(int shape) {
            return ~shape << 1 & 0xE;
        }

        @Override
        public int deadSides() {
            return 3;
        }

        @Override
        public int calcOutput(int input) {
            return input == 0 ? 1 : 0;
        }
    }

    public static class OR
    extends SimpleGateLogic {
        @Override
        public int inputMask(int shape) {
            return ~shape << 1 & 0xE;
        }

        @Override
        public int deadSides() {
            return 3;
        }

        @Override
        public int calcOutput(int input) {
            return input != 0 ? 1 : 0;
        }
    }
}

