/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.IRandomDisplayTick;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.handler.MultipartProxy;
import java.util.Random;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.integration.GatePart;
import mrtjp.projectred.integration.RedstoneGateLogic;
import mrtjp.projectred.integration.RenderGate;
import mrtjp.projectred.transmission.IRedwireEmitter;

public abstract class RedstoneGatePart
extends GatePart
implements IFaceRedstonePart,
IRandomDisplayTick {
    @Override
    public abstract RedstoneGateLogic getLogic();

    public int strongPowerLevel(int side) {
        if ((side & 6) == (this.side() & 6)) {
            return 0;
        }
        return this.getLogic().getOutput(this, this.relRot(side));
    }

    public int weakPowerLevel(int side) {
        return this.strongPowerLevel(side);
    }

    public boolean canConnectRedstone(int side) {
        if ((side & 6) == (this.side() & 6)) {
            return false;
        }
        return this.getLogic().canConnect(this, this.relRot(side));
    }

    public int getFace() {
        return this.side();
    }

    @Override
    public void notifyNeighbors(int mask) {
        int smask = 0;
        int blockID = MultipartProxy.block().cF;
        BlockCoord pos = new BlockCoord();
        BlockCoord pos2 = new BlockCoord();
        for (int r = 0; r < 4; ++r) {
            if ((mask & 1 << r) == 0) continue;
            int absSide = Rotation.rotateSide((int)this.side(), (int)r);
            pos.set(this.x(), this.y(), this.z()).offset(absSide);
            this.world().g(pos.x, pos.y, pos.z, blockID);
            for (int s = 0; s < 6; ++s) {
                if (s == (absSide ^ 1) || (smask & 1 << s) != 0) continue;
                pos2.set(pos).offset(s);
                this.world().g(pos2.x, pos2.y, pos2.z, blockID);
            }
            smask |= 1 << absSide;
        }
    }

    public int getRedstoneInput(int r) {
        if ((this.connMap & 1 << (r = this.toAbsolute(r))) != 0) {
            return this.calculateCornerSignal(r);
        }
        if ((this.connMap & 16 << r) != 0) {
            return this.calculateStraightSignal(r);
        }
        if ((this.connMap & 256 << r) != 0) {
            return this.calculateInternalSignal(r);
        }
        return this.calculateRedstoneSignal(r);
    }

    public int calculateRedstoneSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        int i = RedstoneInteractions.getPowerTo((TMultiPart)this, (int)absDir) * 17;
        if (i > 0 || this.getLogic().requireStrongInput(r)) {
            return i;
        }
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir);
        if (this.world().u(pos.x, pos.y, pos.z)) {
            return this.world().B(pos.x, pos.y, pos.z) * 17;
        }
        return 0;
    }

    public int calculateCornerSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir).offset(this.side());
        TileMultipart t = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)pos);
        if (t != null) {
            return this.getPartSignal(t.partMap(absDir ^ 1), Rotation.rotationTo((int)(absDir ^ 1), (int)(this.side() ^ 1)));
        }
        return 0;
    }

    public int calculateStraightSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir);
        TileMultipart t = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)pos);
        if (t != null) {
            return this.getPartSignal(t.partMap(this.side()), (r + 2) % 4);
        }
        return 0;
    }

    public int calculateInternalSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        TMultiPart tp = this.tile().partMap(absDir);
        int i = this.getPartSignal(tp, Rotation.rotationTo((int)absDir, (int)this.side()));
        if (i > 0) {
            return i;
        }
        if (tp instanceof IRedstonePart) {
            IRedstonePart rp = (IRedstonePart)tp;
            return Math.max(rp.strongPowerLevel(this.side()), rp.weakPowerLevel(this.side())) << 4;
        }
        return 0;
    }

    public int getPartSignal(TMultiPart part, int r) {
        if (part instanceof IRedwireEmitter) {
            return ((IRedwireEmitter)part).getRedwireSignal(r);
        }
        return 0;
    }

    public void randomDisplayTick(Random rand) {
        RenderGate.spawnParticles(this, rand);
    }
}

