/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.INeighborTileChange;
import codechicken.multipart.handler.MultipartSaveLoad;
import mrtjp.projectred.api.IScrewdriver;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.integration.GateLogic;
import mrtjp.projectred.integration.GatePart;
import mrtjp.projectred.integration.InstancedRsGatePart;
import mrtjp.projectred.integration.IntegrationSPH;
import mrtjp.projectred.integration.RedstoneGateLogic;
import mrtjp.projectred.integration.SimpleGatePart;

public abstract class InstancedRsGateLogic
extends RedstoneGateLogic<InstancedRsGatePart> {
    public InstancedRsGatePart gate;

    public static InstancedRsGateLogic create(InstancedRsGatePart gate, int subID) {
        switch (subID) {
            case 12: {
                return new RSLatch(gate);
            }
            case 13: {
                return new ToggleLatch(gate);
            }
            case 17: {
                return new Timer(gate);
            }
            case 18: {
                return new Sequencer(gate);
            }
            case 19: {
                return new Counter(gate);
            }
            case 20: {
                return new StateCell(gate);
            }
            case 21: {
                return new Synchronizer(gate);
            }
            case 26: {
                return new Comparator(gate);
            }
        }
        throw new IllegalArgumentException("Invalid subID: " + subID);
    }

    public InstancedRsGateLogic(InstancedRsGatePart gate) {
        this.gate = gate;
    }

    @Override
    public int getOutput(InstancedRsGatePart gate, int r) {
        return (gate.state & 16 << r) != 0 ? 15 : 0;
    }

    public void save(by tag) {
    }

    public void load(by tag) {
    }

    public void readDesc(MCDataInput packet) {
    }

    public void writeDesc(MCDataOutput packet) {
    }

    public void read(MCDataInput packet, int switch_key) {
    }

    public void tickSound() {
        if (Configurator.logicGateSounds) {
            this.gate.world().a((double)this.gate.x() + 0.5, (double)this.gate.y() + 0.5, (double)this.gate.z() + 0.5, "random.click", 0.3f, 0.5f);
        }
    }

    public static class Comparator
    extends InstancedRsGateLogic
    implements INeighborTileChange {
        public short state2;

        public Comparator(InstancedRsGatePart gate) {
            super(gate);
        }

        public int state2() {
            return this.state2 & 0xFFFF;
        }

        public void setState2(int i) {
            this.state2 = (short)i;
        }

        @Override
        public void save(by tag) {
            tag.a("state2", this.state2);
        }

        @Override
        public void load(by tag) {
            this.state2 = tag.d("state2");
        }

        @Override
        public boolean cycleShape(InstancedRsGatePart gate) {
            gate.setShape(gate.shape() > 0 ? 0 : 1);
            return true;
        }

        @Override
        public boolean requireStrongInput(int r) {
            return r % 2 == 1;
        }

        @Override
        public boolean canConnect(int shape, int r) {
            return true;
        }

        @Override
        public int getOutput(InstancedRsGatePart gate, int r) {
            if (r == 0) {
                return this.state2 & 0xF;
            }
            return 0;
        }

        public int getAnalogInput(int r) {
            return (this.gate.getRedstoneInput(r) + 16) / 17;
        }

        public int calcInputA() {
            int absDir = Rotation.rotateSide((int)this.gate.side(), (int)this.gate.toAbsolute(2));
            BlockCoord pos = new BlockCoord((asp)this.gate.tile()).offset(absDir);
            aqz block = aqz.s[this.gate.world().a(pos.x, pos.y, pos.z)];
            if (block != null) {
                if (block.q_()) {
                    return block.b_(this.gate.world(), pos.x, pos.y, pos.z, absDir ^ 1);
                }
                if (block.isBlockNormalCube(this.gate.world(), pos.x, pos.y, pos.z)) {
                    pos.offset(absDir);
                    block = aqz.s[this.gate.world().a(pos.x, pos.y, pos.z)];
                    if (block != null && block.q_()) {
                        return block.b_(this.gate.world(), pos.x, pos.y, pos.z, absDir ^ 1);
                    }
                }
            }
            return this.getAnalogInput(2);
        }

        public int calcInput() {
            return this.getAnalogInput(1) << 4 | this.calcInputA() << 8 | this.getAnalogInput(3) << 12;
        }

        public static int digitize(int analog) {
            int digital = 0;
            for (int i = 0; i < 4; ++i) {
                if ((analog >> i * 4 & 0xF) <= 0) continue;
                digital |= 1 << i;
            }
            return digital;
        }

        @Override
        public void onChange(InstancedRsGatePart gate) {
            int oldInput = this.state2 & 0xFFF0;
            int newInput = this.calcInput();
            if (oldInput != newInput) {
                this.setState2(this.state2 & 0xF | newInput);
                gate.setState(Comparator.digitize(newInput | this.calcOutput()) | gate.state & 0xF0);
                gate.onInputChange();
            }
            if ((this.state2 & 0xF) != this.calcOutput()) {
                gate.scheduleTick(2);
            }
        }

        public int calcOutput() {
            if (this.gate.shape() == 0) {
                return this.inputA() >= this.inputB() ? this.inputA() : 0;
            }
            return Math.max(this.inputA() - this.inputB(), 0);
        }

        public int inputA() {
            return this.state2 >> 8 & 0xF;
        }

        public int inputB() {
            return Math.max(this.state2 >> 4 & 0xF, this.state2 >> 12 & 0xF);
        }

        @Override
        public void scheduledTick(InstancedRsGatePart gate) {
            int oldOutput = this.state2 & 0xF;
            int newOutput = this.calcOutput();
            if (oldOutput != newOutput) {
                this.setState2(this.state2 & 0xFFF0 | newOutput);
                gate.setState(gate.state() & 0xF | Comparator.digitize(newOutput) << 4);
                gate.onOutputChange(1);
            }
        }

        public void onNeighborTileChanged(int side, boolean weak) {
            if (side == Rotation.rotateSide((int)this.gate.side(), (int)this.gate.toAbsolute(2))) {
                this.gate.onChange();
            }
        }

        public boolean weakTileChanges() {
            return true;
        }
    }

    public static class Synchronizer
    extends ExtraStateLogic {
        public Synchronizer(InstancedRsGatePart gate) {
            super(gate);
        }

        @Override
        public void onChange(InstancedRsGatePart gate) {
            int oldInput = gate.state() & 0xF;
            int newInput = this.getInput(gate, 14);
            int high = newInput & ~oldInput;
            if (oldInput != newInput) {
                gate.setState(gate.state() & 0xF0 | newInput);
                gate.onInputChange();
                if ((newInput & 4) != 0) {
                    this.off();
                } else {
                    if ((high & 2) != 0) {
                        this.setRight();
                    }
                    if ((high & 8) != 0) {
                        this.setLeft();
                    }
                }
                if (this.right() && this.left()) {
                    gate.scheduleTick(2);
                }
            }
        }

        @Override
        public void scheduledTick(InstancedRsGatePart gate) {
            if (!this.pulsing() && this.right() && this.left()) {
                gate.setState(gate.state() | 0x10);
                gate.onOutputChange(1);
                this.setPulsing();
                gate.scheduleTick(2);
            } else if (this.pulsing()) {
                gate.setState(gate.state() & 0xFFFFFFEF);
                gate.onOutputChange(1);
                this.off();
            }
        }

        public boolean right() {
            return (this.state2() & 1) != 0;
        }

        public boolean left() {
            return (this.state2() & 2) != 0;
        }

        public boolean pulsing() {
            return (this.state2() & 4) != 0;
        }

        public void setPulsing() {
            int oldValue = this.state2();
            this.setState2(this.state2() | 4);
            if (this.state2() != oldValue) {
                this.sendState2Update();
            }
        }

        public void setRight() {
            int oldValue = this.state2();
            this.setState2(this.state2() | 1);
            if (this.state2() != oldValue) {
                this.sendState2Update();
            }
        }

        public void setLeft() {
            int oldValue = this.state2();
            this.setState2(this.state2() | 2);
            if (this.state2() != oldValue) {
                this.sendState2Update();
            }
        }

        public void off() {
            int oldValue = this.state2();
            this.setState2(0);
            if (this.state2() != oldValue) {
                this.sendState2Update();
            }
        }

        @Override
        public int outputMask(int shape) {
            return 1;
        }

        @Override
        public int inputMask(int shape) {
            return 14;
        }
    }

    public static class Counter
    extends InstancedRsGateLogic
    implements GateLogic.ICounterGuiLogic {
        public int value = 0;
        public int max = 10;
        public int incr = 1;
        public int decr = 1;

        public Counter(InstancedRsGatePart gate) {
            super(gate);
        }

        @Override
        public void save(by tag) {
            tag.a("val", this.value);
            tag.a("max", this.max);
            tag.a("inc", this.incr);
            tag.a("dec", this.decr);
        }

        @Override
        public void load(by tag) {
            this.value = tag.e("val");
            this.max = tag.e("max");
            this.incr = tag.e("inc");
            this.decr = tag.e("dec");
        }

        @Override
        public int getCounterValue() {
            return this.value;
        }

        @Override
        public int getCounterMax() {
            return this.max;
        }

        @Override
        public int getCounterIncr() {
            return this.incr;
        }

        @Override
        public int getCounterDecr() {
            return this.decr;
        }

        @Override
        public void setCounterValue(GatePart gate, int i) {
            int oldVal = this.value;
            this.value = Math.min(this.max, Math.max(0, i));
            if (this.value != oldVal) {
                this.tickSound();
                this.sendValueUpdate();
            }
        }

        @Override
        public void setCounterMax(GatePart gate, int i) {
            int oldMax = this.max;
            this.max = Math.min(Short.MAX_VALUE, Math.max(1, i));
            if (this.max != oldMax) {
                this.tickSound();
                this.sendMaxUpdate();
                int oldVal = this.value;
                this.value = Math.min(this.max, Math.max(0, i));
                if (this.value != oldVal) {
                    this.sendValueUpdate();
                    gate.scheduleTick(2);
                }
            }
        }

        @Override
        public void setCounterIncr(GatePart gate, int i) {
            int oldIncr = this.incr;
            this.incr = Math.min(this.max, Math.max(1, i));
            if (this.incr != oldIncr) {
                this.tickSound();
                this.sendIncrUpdate();
            }
        }

        @Override
        public void setCounterDecr(GatePart gate, int i) {
            int oldDecr = this.decr;
            this.decr = Math.min(this.max, Math.max(1, i));
            if (this.decr != oldDecr) {
                this.tickSound();
                this.sendDecrUpdate();
            }
        }

        @Override
        public void read(MCDataInput packet, int switch_key) {
            if (switch_key == 11) {
                this.value = packet.readInt();
            } else if (switch_key == 12) {
                this.max = packet.readInt();
            } else if (switch_key == 13) {
                this.incr = packet.readInt();
            } else if (switch_key == 14) {
                this.decr = packet.readInt();
            }
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            packet.writeInt(this.value).writeInt(this.max).writeInt(this.incr).writeInt(this.decr);
        }

        @Override
        public void readDesc(MCDataInput packet) {
            this.value = packet.readInt();
            this.max = packet.readInt();
            this.incr = packet.readInt();
            this.decr = packet.readInt();
        }

        public void sendValueUpdate() {
            this.gate.getWriteStream(11).writeInt(this.value);
        }

        public void sendMaxUpdate() {
            this.gate.getWriteStream(12).writeInt(this.max);
        }

        public void sendIncrUpdate() {
            this.gate.getWriteStream(13).writeInt(this.incr);
        }

        public void sendDecrUpdate() {
            this.gate.getWriteStream(14).writeInt(this.decr);
        }

        @Override
        public void onChange(InstancedRsGatePart gate) {
            int high;
            int oldInput = gate.state() & 0xF;
            int newInput = this.getInput(gate, 10);
            if (gate.shape() == 1) {
                newInput = GatePart.flipMaskZ(newInput);
            }
            if (((high = newInput & ~oldInput) & 2) != 0) {
                this.setCounterValue(gate, this.value + this.incr);
            }
            if ((high & 8) != 0) {
                this.setCounterValue(gate, this.value - this.decr);
            }
            if (oldInput != newInput) {
                gate.setState(gate.state() & 0xF0 | newInput);
                gate.onInputChange();
                gate.scheduleTick(2);
            }
        }

        @Override
        public boolean cycleShape(InstancedRsGatePart gate) {
            gate.setShape(gate.shape() == 1 ? 0 : 1);
            return true;
        }

        @Override
        public void scheduledTick(InstancedRsGatePart gate) {
            int oldOutput = gate.state();
            int newOutput = 0;
            if (this.value == this.max) {
                newOutput = 1;
            } else if (this.value == 0) {
                newOutput = 4;
            }
            if (newOutput != oldOutput) {
                gate.setState(gate.state() & 0xF | newOutput << 4);
            }
            if (newOutput != oldOutput) {
                gate.onOutputChange(5);
            }
        }

        @Override
        public int outputMask(int shape) {
            return 5;
        }

        @Override
        public int inputMask(int shape) {
            return 10;
        }

        @Override
        public boolean activate(InstancedRsGatePart gate, uf player, ye held) {
            if (held == null || !(held.b() instanceof IScrewdriver)) {
                if (!gate.world().I) {
                    IntegrationSPH.openCounterGui(player, gate);
                }
                return true;
            }
            return false;
        }
    }

    public static class Sequencer
    extends InstancedRsGateLogic
    implements GateLogic.ITimerGuiLogic {
        public int pointer_max = 40;

        public Sequencer(InstancedRsGatePart gate) {
            super(gate);
        }

        @Override
        public void onChange(InstancedRsGatePart gate) {
        }

        @Override
        public void scheduledTick(InstancedRsGatePart gate) {
        }

        @Override
        public int getTimerMax() {
            return this.pointer_max;
        }

        @Override
        public void setTimerMax(GatePart gate, int t) {
            if (t < 4) {
                t = 4;
            }
            if (t != this.pointer_max) {
                this.pointer_max = t;
                this.sendPointerMaxUpdate();
            }
        }

        @Override
        public void save(by tag) {
            tag.a("pmax", this.pointer_max);
        }

        @Override
        public void load(by tag) {
            this.pointer_max = tag.e("pmax");
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            packet.writeInt(this.pointer_max);
        }

        @Override
        public void readDesc(MCDataInput packet) {
            this.pointer_max = packet.readInt();
        }

        @Override
        public void read(MCDataInput packet, int switch_key) {
            if (switch_key == 11) {
                this.pointer_max = packet.readInt();
            }
        }

        public void sendPointerMaxUpdate() {
            this.gate.getWriteStream(11).writeInt(this.pointer_max);
        }

        @Override
        public void onTick(InstancedRsGatePart gate) {
            if (!gate.world().I) {
                int oldOut = gate.state() >> 4;
                int out = 1 << (int)(gate.world().J() % (long)this.pointer_max / (long)(this.pointer_max / 4));
                if (gate.shape() == 1) {
                    out = GatePart.flipMaskZ(out);
                }
                if (oldOut != out) {
                    gate.setState(out << 4);
                    gate.onOutputChange(15);
                    this.tickSound();
                }
            }
        }

        @Override
        public boolean cycleShape(InstancedRsGatePart gate) {
            gate.setShape(gate.shape() == 1 ? 0 : 1);
            return true;
        }

        @Override
        public boolean activate(InstancedRsGatePart gate, uf player, ye held) {
            if (held == null || !(held.b() instanceof IScrewdriver)) {
                if (!gate.world().I) {
                    IntegrationSPH.openTimerGui(player, gate);
                }
                return true;
            }
            return false;
        }

        @Override
        public int outputMask(int shape) {
            return 15;
        }

        @Override
        public int inputMask(int shape) {
            return 0;
        }
    }

    public static class StateCell
    extends TimerGateLogic {
        public byte state2;

        public StateCell(InstancedRsGatePart gate) {
            super(gate);
        }

        public int state2() {
            return this.state2 & 0xFF;
        }

        public void setState2(int i) {
            this.state2 = (byte)i;
        }

        @Override
        public void save(by tag) {
            super.save(tag);
            tag.a("state2", this.state2);
        }

        @Override
        public void load(by tag) {
            super.load(tag);
            this.state2 = tag.c("state2");
        }

        @Override
        public void readDesc(MCDataInput packet) {
            super.readDesc(packet);
            this.state2 = packet.readByte();
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            super.writeDesc(packet);
            packet.writeByte((int)this.state2);
        }

        @Override
        public void read(MCDataInput packet, int switch_key) {
            if (switch_key == 11) {
                this.state2 = packet.readByte();
            } else {
                super.read(packet, switch_key);
            }
        }

        public void sendState2Update() {
            this.gate.getWriteStream(11).writeByte((int)this.state2);
        }

        @Override
        public boolean cycleShape(InstancedRsGatePart gate) {
            gate.setShape((gate.shape() + 1) % 2);
            return true;
        }

        @Override
        public int outputMask(int shape) {
            int output = 9;
            if (shape == 1) {
                output = GatePart.flipMaskZ(output);
            }
            return output;
        }

        @Override
        public int inputMask(int shape) {
            int input = 6;
            if (shape == 1) {
                input = GatePart.flipMaskZ(input);
            }
            return input;
        }

        @Override
        public void onChange(InstancedRsGatePart gate) {
            int newInput;
            int oldInput = gate.state() & 0xF;
            if (oldInput != (newInput = this.getInput(gate, 14))) {
                gate.setState(gate.state() & 0xF0 | newInput);
                gate.onInputChange();
                if (gate.shape() == 1) {
                    newInput = GatePart.flipMaskZ(newInput);
                }
                if ((newInput & 4) != 0 && this.state2 == 0) {
                    this.setState2(1);
                    this.sendState2Update();
                    gate.scheduleTick(2);
                }
                if (this.state2 != 0) {
                    if ((newInput & 6) != 0) {
                        this.resetPointer();
                    } else {
                        this.startPointer();
                    }
                }
            }
        }

        @Override
        public void pointerTick() {
            this.resetPointer();
            if (!this.gate.world().I) {
                this.setState2(0);
                this.sendState2Update();
                this.gate.setState(0x10 | this.gate.state() & 0xF);
                this.gate.onOutputChange(this.outputMask(this.gate.shape()));
                this.gate.scheduleTick(2);
                this.tickSound();
            }
        }

        @Override
        public void scheduledTick(InstancedRsGatePart gate) {
            int output = 0;
            if (this.state2 != 0) {
                output = 8;
            }
            if (gate.shape() == 1) {
                output = GatePart.flipMaskZ(output);
            }
            gate.setState(output << 4 | gate.state() & 0xF);
            gate.onOutputChange(this.outputMask(gate.shape()));
        }
    }

    public static class Timer
    extends TimerGateLogic {
        public Timer(InstancedRsGatePart gate) {
            super(gate);
        }

        @Override
        public int outputMask(int shape) {
            return 11;
        }

        @Override
        public int inputMask(int shape) {
            return 14;
        }

        @Override
        public void setup(InstancedRsGatePart gate) {
            this.startPointer();
        }

        @Override
        public void scheduledTick(InstancedRsGatePart gate) {
            gate.setState(gate.state() & 0xF);
            gate.onOutputChange(11);
            this.onChange(gate);
        }

        @Override
        public void onChange(InstancedRsGatePart gate) {
            int oldInput = gate.state() & 0xF;
            int newInput = this.getInput(gate, 14);
            if (newInput != oldInput) {
                gate.setState(gate.state() & 0xF0 | newInput);
                gate.onInputChange();
            }
            if (gate.schedTime < 0L) {
                if (newInput > 0) {
                    this.resetPointer();
                } else {
                    this.startPointer();
                }
            }
        }

        @Override
        public void pointerTick() {
            this.resetPointer();
            if (!this.gate.world().I) {
                this.gate.scheduleTick(2);
                this.gate.setState(0xB0 | this.gate.state() & 0xF);
                this.gate.onOutputChange(11);
                this.tickSound();
            }
        }
    }

    public static abstract class TimerGateLogic
    extends InstancedRsGateLogic
    implements GateLogic.ITimerGuiLogic {
        public int pointer_max = 38;
        public long pointer_start = -1L;

        public TimerGateLogic(InstancedRsGatePart gate) {
            super(gate);
        }

        @Override
        public void save(by tag) {
            tag.a("pmax", this.pointer_max);
            tag.a("pelapsed", this.pointer_start < 0L ? this.pointer_start : this.gate.world().I() - this.pointer_start);
        }

        @Override
        public void load(by tag) {
            this.pointer_max = tag.e("pmax");
            this.pointer_start = tag.f("pelapsed");
            if (this.pointer_start >= 0L) {
                this.pointer_start = MultipartSaveLoad.loadingWorld().I() - this.pointer_start;
            }
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            packet.writeInt(this.pointer_max);
            packet.writeLong(this.pointer_start);
        }

        @Override
        public void readDesc(MCDataInput packet) {
            this.pointer_max = packet.readInt();
            this.pointer_start = packet.readLong();
        }

        @Override
        public void read(MCDataInput packet, int switch_key) {
            if (switch_key == 12) {
                this.pointer_max = packet.readInt();
            } else if (switch_key == 13) {
                this.pointer_start = packet.readInt();
                if (this.pointer_start >= 0L) {
                    this.pointer_start = this.gate.world().I() - this.pointer_start;
                }
            }
        }

        public int pointerValue() {
            if (this.pointer_start < 0L) {
                return 0;
            }
            return (int)(this.gate.world().I() - this.pointer_start);
        }

        public void sendPointerMaxUpdate() {
            this.gate.getWriteStream(12).writeInt(this.pointer_max);
        }

        public void sendPointerUpdate() {
            this.gate.getWriteStream(13).writeInt(this.pointer_start < 0L ? -1 : this.pointerValue());
        }

        @Override
        public int getTimerMax() {
            return this.pointer_max + 2;
        }

        @Override
        public void setTimerMax(GatePart gate, int t) {
            if (t < 4) {
                t = 4;
            }
            if (t != this.pointer_max) {
                this.pointer_max = t - 2;
                this.sendPointerMaxUpdate();
            }
        }

        @Override
        public void onTick(InstancedRsGatePart gate) {
            if (this.pointer_start >= 0L) {
                if (gate.world().I() >= this.pointer_start + (long)this.pointer_max) {
                    this.pointerTick();
                } else if (this.pointer_start > gate.world().I()) {
                    this.pointer_start = gate.world().I();
                }
            }
        }

        public abstract void pointerTick();

        public void resetPointer() {
            if (this.pointer_start >= 0L) {
                this.pointer_start = -1L;
                this.gate.tile().markDirty();
                if (!this.gate.world().I) {
                    this.sendPointerUpdate();
                }
            }
        }

        public void startPointer() {
            if (this.pointer_start < 0L) {
                this.pointer_start = this.gate.world().I();
                this.gate.tile().markDirty();
                if (!this.gate.world().I) {
                    this.sendPointerUpdate();
                }
            }
        }

        public float interpPointer(float f) {
            if (this.pointer_start < 0L) {
                return 0.0f;
            }
            return ((float)this.pointerValue() + f) / (float)this.pointer_max;
        }

        @Override
        public boolean activate(InstancedRsGatePart gate, uf player, ye held) {
            if (held == null || !(held.b() instanceof IScrewdriver)) {
                if (!gate.world().I) {
                    IntegrationSPH.openTimerGui(player, gate);
                }
                return true;
            }
            return false;
        }
    }

    public static class ToggleLatch
    extends ExtraStateLogic {
        public ToggleLatch(InstancedRsGatePart gate) {
            super(gate);
        }

        @Override
        public int outputMask(int shape) {
            return 5;
        }

        @Override
        public int inputMask(int shape) {
            return 10;
        }

        @Override
        public boolean clientState2() {
            return true;
        }

        @Override
        public void setup(InstancedRsGatePart gate) {
            gate.setState(16);
            gate.sendStateUpdate();
        }

        @Override
        public void onChange(InstancedRsGatePart gate) {
            int oldInput = gate.state() & 0xF;
            int newInput = this.getInput(gate, 10);
            int high = newInput & ~oldInput;
            if (high == 2 || high == 8) {
                this.toggle(gate);
            }
            if (oldInput != newInput) {
                gate.setState(gate.state() & 0xF0 | newInput);
                gate.onInputChange();
            }
        }

        @Override
        public void scheduledTick(InstancedRsGatePart gate) {
            int newOutput;
            int oldOutput = gate.state() >> 4;
            int n = newOutput = this.state2 == 0 ? 1 : 4;
            if (oldOutput != newOutput) {
                gate.setState(newOutput << 4 | gate.state() & 0xF);
                gate.onOutputChange(this.outputMask(5));
            }
            this.onChange(gate);
        }

        @Override
        public boolean activate(InstancedRsGatePart gate, uf player, ye held) {
            if (held == null || !(held.b() instanceof IScrewdriver)) {
                if (!gate.world().I) {
                    this.toggle(gate);
                }
                return true;
            }
            return false;
        }

        private void toggle(InstancedRsGatePart gate) {
            this.setState2(this.state2 ^ 1);
            gate.scheduleTick(2);
            this.tickSound();
        }
    }

    public static class RSLatch
    extends ExtraStateLogic {
        public RSLatch(InstancedRsGatePart gate) {
            super(gate);
        }

        @Override
        public boolean cycleShape(InstancedRsGatePart gate) {
            int newShape = (gate.shape() + 1) % 4;
            gate.setShape(newShape);
            this.setState2(GatePart.flipMaskZ(this.state2()));
            gate.setState(GatePart.flipMaskZ(gate.state()));
            gate.onOutputChange(15);
            gate.scheduleTick(2);
            return true;
        }

        @Override
        public int outputMask(int shape) {
            return shape >> 1 == 0 ? 15 : 5;
        }

        @Override
        public int inputMask(int shape) {
            return 10;
        }

        @Override
        public void setup(InstancedRsGatePart gate) {
            this.setState2(2);
            gate.setState(48);
        }

        @Override
        public void onChange(InstancedRsGatePart gate) {
            int stateInput = this.state2();
            int oldInput = gate.state() & 0xF;
            int newInput = this.getInput(gate, 10);
            int oldOutput = gate.state() >> 4;
            if (newInput != oldInput) {
                if (stateInput != 10 && newInput != 0 && newInput != this.state2()) {
                    gate.setState(newInput);
                    this.setState2(newInput);
                    gate.onOutputChange(oldOutput);
                    gate.scheduleTick(2);
                } else {
                    gate.setState(oldOutput << 4 | newInput);
                    gate.onInputChange();
                }
            }
        }

        @Override
        public void scheduledTick(InstancedRsGatePart gate) {
            int newOutput;
            int oldOutput = gate.state() >> 4;
            if (oldOutput != (newOutput = this.calcOutput(gate))) {
                gate.setState(gate.state() & 0xF | newOutput << 4);
                gate.onOutputChange(this.outputMask(gate.shape()));
            }
            this.onChange(gate);
        }

        public int calcOutput(SimpleGatePart gate) {
            int input = gate.state() & 0xF;
            int stateInput = this.state2();
            if ((gate.shape & 1) != 0) {
                input = GatePart.flipMaskZ(input);
                stateInput = GatePart.flipMaskZ(stateInput);
            }
            if (stateInput == 10) {
                if (input == 10) {
                    gate.scheduleTick(2);
                    return 0;
                }
                stateInput = input == 0 ? (gate.world().s.nextBoolean() ? 2 : 8) : input;
                this.setState2(stateInput);
            }
            int output = GatePart.shiftMask(stateInput, 1);
            if ((gate.shape & 2) == 0) {
                output |= stateInput;
            }
            if ((gate.shape & 1) != 0) {
                output = GatePart.flipMaskZ(output);
            }
            return output;
        }
    }

    public static abstract class ExtraStateLogic
    extends InstancedRsGateLogic {
        public byte state2;

        public ExtraStateLogic(InstancedRsGatePart gate) {
            super(gate);
        }

        public int state2() {
            return this.state2 & 0xFF;
        }

        public void setState2(int i) {
            this.state2 = (byte)i;
        }

        @Override
        public void save(by tag) {
            tag.a("state2", this.state2);
        }

        @Override
        public void load(by tag) {
            this.state2 = tag.c("state2");
        }

        @Override
        public void readDesc(MCDataInput packet) {
            if (this.clientState2()) {
                this.state2 = packet.readByte();
            }
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            if (this.clientState2()) {
                packet.writeByte((int)this.state2);
            }
        }

        @Override
        public void read(MCDataInput packet, int switch_key) {
            if (switch_key == 11) {
                this.state2 = packet.readByte();
            }
        }

        public boolean clientState2() {
            return false;
        }

        public void sendState2Update() {
            this.gate.getWriteStream(11).writeByte((int)this.state2);
        }
    }
}

