/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.integration.BundledGateLogic;
import mrtjp.projectred.integration.SimpleGatePart;

public class BundledGatePart
extends SimpleGatePart
implements IBundledEmitter {
    public BundledGateLogic logic;

    @Override
    public BundledGateLogic getLogic() {
        return this.logic;
    }

    @Override
    public String getType() {
        return "pr_bgate";
    }

    @Override
    public boolean connectStraightOverride(int absDir) {
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir);
        asp t = this.world().r(pos.x, pos.y, pos.z);
        if (t instanceof IBundledTile) {
            return ((IBundledTile)t).canConnectBundled(absDir ^ 1);
        }
        return false;
    }

    public byte[] getBundledInput(int r) {
        if ((this.connMap & 1 << (r = this.toAbsolute(r))) != 0) {
            return this.calculateBundledCornerSignal(r);
        }
        if ((this.connMap & 16 << r) != 0) {
            return this.calculateBundledStraightSignal(r);
        }
        if ((this.connMap & 256 << r) != 0) {
            return this.calculateBundledInternalSignal(r);
        }
        return null;
    }

    public byte[] calculateBundledCornerSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir).offset(this.side());
        TileMultipart t = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)pos);
        if (t != null) {
            return this.getBundledPartSignal(t.partMap(absDir ^ 1), Rotation.rotationTo((int)(absDir ^ 1), (int)(this.side() ^ 1)));
        }
        return null;
    }

    public byte[] calculateBundledStraightSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir);
        asp t = this.world().r(pos.x, pos.y, pos.z);
        if (t instanceof IBundledEmitter) {
            return this.getBundledPartSignal(t, absDir ^ 1);
        }
        if (t instanceof TileMultipart) {
            return this.getBundledPartSignal(((TileMultipart)t).partMap(this.side()), (r + 2) % 4);
        }
        return null;
    }

    public byte[] calculateBundledInternalSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side(), (int)r);
        TMultiPart tp = this.tile().partMap(absDir);
        return this.getBundledPartSignal(tp, Rotation.rotationTo((int)absDir, (int)this.side()));
    }

    public byte[] getBundledPartSignal(Object part, int r) {
        if (part instanceof IBundledEmitter) {
            return ((IBundledEmitter)part).getBundledSignal(r);
        }
        return null;
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        this.logic = BundledGateLogic.create(this, this.subID);
        this.logic.load(tag);
    }

    @Override
    public void save(by tag) {
        super.save(tag);
        this.logic.save(tag);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        this.logic.writeDesc(packet);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        if (this.logic == null) {
            this.logic = BundledGateLogic.create(this, this.subID);
        }
        this.logic.readDesc(packet);
    }

    @Override
    public void read(MCDataInput packet, int switch_key) {
        if (switch_key <= 10) {
            super.read(packet, switch_key);
        } else {
            this.logic.read(packet, switch_key);
        }
    }

    @Override
    public void preparePlacement(uf player, BlockCoord pos, int side, int meta) {
        super.preparePlacement(player, pos, side, meta);
        this.logic = BundledGateLogic.create(this, this.subID);
    }

    public byte[] getBundledSignal(int r) {
        return this.getLogic().getBundledOutput(this, this.toInternal(r));
    }
}

