/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launchwrapper.injector;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.VanillaTweaker;
import org.lwjgl.opengl.Display;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class VanillaTweakInjector
implements IClassTransformer {
    private static String workDirFieldName;

    @Override
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        MethodNode methodNode2;
        if (bytes == null) {
            return null;
        }
        if (!"net.minecraft.client.Minecraft".equals(name)) {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 8);
        MethodNode mainMethod = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!"main".equals(methodNode2.name)) continue;
            mainMethod = methodNode2;
            break;
        }
        if (mainMethod == null) {
            return bytes;
        }
        FieldNode workDirNode = null;
        for (FieldNode fieldNode : classNode.fields) {
            String fileTypeDescriptor = Type.getDescriptor(File.class);
            if (!fileTypeDescriptor.equals(fieldNode.desc) || (fieldNode.access & 8) != 8) continue;
            workDirNode = fieldNode;
            break;
        }
        methodNode2 = new MethodNode();
        Label label = new Label();
        methodNode2.visitLabel(label);
        methodNode2.visitLineNumber(9001, label);
        methodNode2.visitMethodInsn(184, "net/minecraft/launchwrapper/injector/VanillaTweakInjector", "inject", "()Ljava/io/File;");
        methodNode2.visitFieldInsn(179, "net/minecraft/client/Minecraft", workDirNode.name, "Ljava/io/File;");
        for (AbstractInsnNode insn : mainMethod.instructions) {
            if (insn.getOpcode() != 182) continue;
            MethodInsnNode mins = (MethodInsnNode)insn;
            if (!mins.owner.equals("java/awt/Frame") || !mins.name.equals("validate")) continue;
            mainMethod.instructions.insert(insn, methodNode2.instructions);
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static File inject() {
        System.out.println("Turning of ImageIO disk-caching");
        ImageIO.setUseCache(false);
        try {
            File smallIcon = new File(VanillaTweaker.assetsDir, "icons/icon_16x16.png");
            File bigIcon = new File(VanillaTweaker.assetsDir, "icons/icon_32x32.png");
            System.out.println("Loading current icons for window from: " + smallIcon + " and " + bigIcon);
            Display.setIcon((ByteBuffer[])new ByteBuffer[]{VanillaTweakInjector.loadIcon(smallIcon), VanillaTweakInjector.loadIcon(bigIcon)});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Setting gameDir to:" + VanillaTweaker.gameDir);
        return VanillaTweaker.gameDir;
    }

    private static ByteBuffer loadIcon(File iconFile) throws IOException {
        BufferedImage icon = ImageIO.read(iconFile);
        int[] rgb = icon.getRGB(0, 0, icon.getWidth(), icon.getHeight(), null, 0, icon.getWidth());
        ByteBuffer buffer = ByteBuffer.allocate(4 * rgb.length);
        for (int color : rgb) {
            buffer.putInt(color << 8 | color >> 24 & 0xFF);
        }
        buffer.flip();
        return buffer;
    }
}

