/*
 * Decompiled with CFR 0.152.
 */
package factorization.wrath;

import factorization.api.Coord;
import factorization.api.ICoord;
import factorization.common.FzConfig;
import factorization.common.ResourceType;
import factorization.shared.Core;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityWrathFire
extends TileEntity
implements ICoord {
    final int max_generation = 45;
    final int max_age = 35;
    static Random rand = new Random();
    static final List<Integer> deltas = Arrays.asList(-1, 0, 1);
    public static HashMap<BlockMatch, BlockMatch> transforms = new HashMap();
    static BlockMatch air = new BlockMatch(0, -1);
    static BlockMatch fire = new BlockMatch((Block)Block.field_72067_ar);
    static BlockMatch netherBrick = new BlockMatch(Block.field_72033_bA);
    static BlockMatch netherFence = new BlockMatch(Block.field_72098_bB);
    static BlockMatch netherStair = new BlockMatch(Block.field_72100_bC);
    static BlockMatch netherSlab = new BlockMatch((Block)Block.field_72079_ak, 6);
    static BlockMatch netherSlabUp = new BlockMatch((Block)Block.field_72079_ak, 14);
    static BlockMatch netherDoubleSlab = new BlockMatch((Block)Block.field_72085_aj, 6);
    BlockMatch host = null;
    int age = 0;
    int generation = 0;
    int random_time_offset = rand.nextInt();
    public static int updateCount = 0;

    public static void burn(Object key, Object val) {
        if (key instanceof Block) {
            key = new BlockMatch((Block)key);
        }
        if (val instanceof Block) {
            val = new BlockMatch((Block)val);
        }
        transforms.put((BlockMatch)key, (BlockMatch)val);
    }

    public static void burn(Object key) {
        TileEntityWrathFire.burn(key, air);
    }

    public static void setupBurning() {
        for (int i = 0; i < Block.field_71973_m.length; ++i) {
            Material m;
            Block block = Block.field_71973_m[i];
            if (block == null || (m = block.field_72018_cp) != Material.field_76245_d && m != Material.field_76253_m && m != Material.field_76254_j && m != Material.field_76257_i && m != Material.field_76255_k && m != Material.field_76268_x && m != Material.field_76232_D) continue;
            TileEntityWrathFire.burn(block);
        }
        TileEntityWrathFire.burn(Block.field_72036_aT);
        TileEntityWrathFire.burn(Block.field_72033_bA, Block.field_72033_bA);
        TileEntityWrathFire.burn(Block.field_71939_E, Block.field_71946_M);
        TileEntityWrathFire.burn(Block.field_71946_M, Block.field_71939_E);
        TileEntityWrathFire.burn(Block.field_71980_u, Block.field_71979_v);
        TileEntityWrathFire.burn(Block.field_72089_ap, Block.field_71944_C);
        TileEntityWrathFire.burn(Block.field_71978_w, Block.field_71981_t);
        TileEntityWrathFire.burn(Block.field_71981_t, Block.field_71978_w);
        TileEntityWrathFire.burn(new BlockMatch(Block.field_72007_bm, 0), new BlockMatch(Block.field_72007_bm, 2));
        TileEntityWrathFire.burn(new BlockMatch(Block.field_72007_bm, 2), new BlockMatch(Block.field_72007_bm, 0));
        TileEntityWrathFire.burn(new BlockMatch(Block.field_72007_bm, 1), new BlockMatch(Block.field_72007_bm, 0));
        TileEntityWrathFire.burn(Block.field_72087_ao, Block.field_71978_w);
        TileEntityWrathFire.burn(Block.field_72083_ai, new BlockMatch(Core.registry.resource_block, ResourceType.DARKIRONBLOCK.md));
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        if (this.host == null) {
            return;
        }
        tag.func_74768_a("host_id", this.host.id);
        tag.func_74768_a("host_md", this.host.md);
        tag.func_74768_a("age", this.age);
        tag.func_74768_a("generation", this.generation);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.host = new BlockMatch(tag.func_74762_e("host_id"), tag.func_74762_e("host_md"));
        this.age = tag.func_74762_e("age");
        this.generation = tag.func_74762_e("generation");
    }

    static TileEntityWrathFire getFire(World worldObj, int x, int y, int z) {
        TileEntity te = worldObj.func_72796_p(x, y, z);
        if (te instanceof TileEntityWrathFire) {
            return (TileEntityWrathFire)te;
        }
        return null;
    }

    boolean blockSupports(Coord c) {
        return this.host.matches(c);
    }

    boolean isBlockSupported(Coord c) {
        for (Coord n : c.getNeighborsAdjacent()) {
            if (!this.blockSupports(n)) continue;
            return true;
        }
        return false;
    }

    void inherit(TileEntityWrathFire parent) {
        if (parent == null) {
            return;
        }
        this.host = parent.host;
        this.generation = Math.max(this.generation, parent.generation + 1);
    }

    boolean trySpawn(Coord c) {
        if (!FzConfig.spread_wrathfire) {
            return false;
        }
        if (this.generation > 45) {
            return false;
        }
        int id = c.getId();
        if (id != 0 && !c.isAir()) {
            return false;
        }
        if (!this.isBlockSupported(c)) {
            return false;
        }
        if (c.is(Core.registry.lightair_block) && c.getMd() == 1) {
            return false;
        }
        if (rand.nextInt(3) == 0) {
            return true;
        }
        c.setIdMd(Core.registry.lightair_block.field_71990_ca, 1);
        TileEntityWrathFire fire = c.getTE(TileEntityWrathFire.class);
        if (fire != null) {
            fire.inherit(this);
            return true;
        }
        c.setId(0);
        c.rmTE();
        return false;
    }

    @Override
    public Coord getCoord() {
        return new Coord(this);
    }

    void die() {
        this.func_70313_j();
        if ((double)rand.nextFloat() < 0.3333) {
            fire.set(this.getCoord());
        } else {
            this.getCoord().setId(0);
        }
    }

    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            this.doUpdate();
        }
    }

    void doUpdate() {
        if ((this.field_70331_k.func_82737_E() + (long)this.random_time_offset) % 25L != 0L) {
            return;
        }
        if ((double)rand.nextFloat() > 0.95) {
            return;
        }
        if (this.age > 35) {
            this.die();
            return;
        }
        if (updateCount > 100 && rand.nextBoolean()) {
            return;
        }
        ++updateCount;
        BlockMatch burnTo = transforms.get(this.host);
        if (burnTo == null) {
            this.die();
            return;
        }
        Coord here = this.getCoord();
        if (netherBrick.equals(this.host) || netherStair.equals(this.host) || netherFence.equals(this.host) || netherSlab.equals(this.host) || netherSlabUp.equals(this.host) || netherDoubleSlab.equals(this.host)) {
            int furnace_size = 13;
            int src_count = 0;
            for (Coord c : here.getNeighborsDiagonal()) {
                if (!netherBrick.matches(c) && !netherStair.matches(c) && !netherFence.matches(c) && !netherSlab.matches(c) && !netherSlabUp.matches(c) && !netherDoubleSlab.matches(c)) continue;
                ++src_count;
            }
            if (src_count < furnace_size) {
                if (src_count == 0) {
                    this.die();
                    return;
                }
                this.age += furnace_size - src_count;
                return;
            }
            ArrayList<Coord> n = here.getRandomNeighborsAdjacent();
            for (Coord c : n) {
                if (c.is(Block.field_72033_bA)) continue;
                for (BlockMatch match : transforms.keySet()) {
                    BlockMatch burnsTo;
                    if (!match.matches(c) || transforms.containsKey(burnsTo = transforms.get(match))) continue;
                    burnsTo.set(c);
                    ++this.age;
                    return;
                }
            }
            return;
        }
        ++this.age;
        for (Coord c : here.getRandomNeighborsDiagonal()) {
            if (!this.trySpawn(c)) continue;
            return;
        }
        if (this.age < 11) {
            return;
        }
        for (Coord c : here.getRandomNeighborsDiagonal()) {
            if (!this.host.matches(c)) continue;
            burnTo.set(c);
            return;
        }
        this.age += 10;
    }

    boolean tryLoadTarget(int id, int md) {
        for (BlockMatch match : transforms.keySet()) {
            if (!match.isType(id, md)) continue;
            this.host = match;
            return true;
        }
        if (netherBrick.isType(id, md) || netherFence.isType(id, md) || netherStair.isType(id, md) || netherSlab.isType(id, md) || netherSlabUp.isType(id, md) || netherDoubleSlab.isType(id, md)) {
            this.host = netherBrick;
            return true;
        }
        return false;
    }

    void setTarget(int id, int md) {
        if (this.tryLoadTarget(id, md)) {
            return;
        }
    }

    public static void ignite(Coord baseBlock, Coord fireBlock, EntityPlayer player) {
        fireBlock.setIdMd(Core.registry.lightair_block.field_71990_ca, 1);
        TileEntityWrathFire fire = fireBlock.getTE(TileEntityWrathFire.class);
        if (fire == null) {
            return;
        }
        if (!(netherBrick.matches(baseBlock) || netherFence.matches(baseBlock) || netherStair.matches(baseBlock) || netherSlab.matches(baseBlock) || netherSlabUp.matches(baseBlock) || netherDoubleSlab.matches(baseBlock) || fireBlock.w.field_72995_K)) {
            Core.logInfo("Wrath Igniter used at " + fireBlock + " by '" + player.field_71092_bJ + "'", new Object[0]);
        }
        fire.setTarget(baseBlock.getId(), baseBlock.getMd());
    }

    public static class BlockMatch {
        int id;
        int md;

        public BlockMatch(int id, int md) {
            this.id = id;
            this.md = md;
        }

        public BlockMatch(Block block) {
            this(block.field_71990_ca, -1);
        }

        public BlockMatch(Block block, int md) {
            this(block.field_71990_ca, md);
        }

        boolean matches(Coord c) {
            int i = c.getId();
            if (i != this.id) {
                return false;
            }
            if (this.md == -1) {
                return true;
            }
            return this.md == c.getMd();
        }

        boolean isType(int id, int md) {
            if (id != this.id) {
                return false;
            }
            if (this.md == -1) {
                return true;
            }
            return this.md == md;
        }

        void set(Coord c) {
            if (this.md == -1) {
                c.setId(this.id);
            } else {
                c.setIdMd(this.id, this.md);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof BlockMatch) {
                BlockMatch m = (BlockMatch)obj;
                return this.id == m.id && this.md == m.md;
            }
            return false;
        }

        public int hashCode() {
            return this.id << 4 + this.md;
        }

        public String toString() {
            return this.id + ":" + this.md;
        }
    }
}

