/*
 * Decompiled with CFR 0.152.
 */
package factorization.weird;

import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.common.ItemIcons;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.weird.TileEntityDayBarrel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileEntityDayBarrelRenderer
extends TileEntitySpecialRenderer {
    final String[] fontIdx = new String[]{"0123", "4567", "89*+", "i!  "};
    RenderItem renderItem = new RenderItem();

    void doDraw(TileEntityDayBarrel barrel, ItemStack is) {
        double time;
        FzOrientation bo = barrel.orientation;
        ForgeDirection face = bo.facing;
        if (face.offsetX + face.offsetY + face.offsetZ == 1) {
            GL11.glTranslated((double)face.offsetX, (double)face.offsetY, (double)face.offsetZ);
        }
        GL11.glTranslated((double)(0.5 * (double)(1 - Math.abs(face.offsetX))), (double)(0.5 * (double)(1 - Math.abs(face.offsetY))), (double)(0.5 * (double)(1 - Math.abs(face.offsetZ))));
        Quaternion quat = Quaternion.fromOrientation(bo.getSwapped());
        quat.glRotate();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)0.25, (double)0.1875, (double)-0.0078125);
        if (barrel.type == TileEntityDayBarrel.Type.HOPPING && Math.sin((time = (double)barrel.field_70331_k.func_82737_E()) / 20.0) > 0.0) {
            double delta = Math.max(0.0, Math.sin(time / 2.0) / 16.0);
            GL11.glTranslated((double)0.0, (double)delta, (double)0.0);
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2896);
        Core.profileStart("font");
        this.renderItemCount(is, barrel);
        Core.profileEnd();
        Core.profileStart("item");
        this.handleRenderItem(is);
        Core.profileEnd();
        GL11.glEnable((int)2896);
    }

    public void func_76894_a(TileEntity tileentity, double x, double y, double z, float partial) {
        if (!(tileentity instanceof TileEntityDayBarrel)) {
            return;
        }
        TileEntityDayBarrel barrel = (TileEntityDayBarrel)tileentity;
        ItemStack is = barrel.item;
        if (is == null || barrel.getItemCount() == 0) {
            return;
        }
        Core.profileStart("barrel");
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        if (FzConfig.render_barrel_use_displaylists && barrel.type != TileEntityDayBarrel.Type.HOPPING && barrel.should_use_display_list && barrel != FactoryType.DAYBARREL.getRepresentative()) {
            if (barrel.display_list == -1) {
                FzUtil.checkGLError("FZ -- before barrel display list update. Someone left us a mess!");
                if (barrel.display_list == -1) {
                    barrel.display_list = GLAllocation.func_74526_a((int)1);
                }
                GL11.glNewList((int)barrel.display_list, (int)4864);
                this.doDraw(barrel, is);
                GL11.glEndList();
                if (FzUtil.checkGLError("FZ -- after barrel display list; does the item have an advanced renderer?")) {
                    Core.logSevere("The item is: " + is, new Object[0]);
                    Core.logSevere("At: " + new Coord(barrel), new Object[0]);
                    barrel.should_use_display_list = false;
                    this.doDraw(barrel, is);
                } else {
                    GL11.glCallList((int)barrel.display_list);
                }
            } else {
                GL11.glCallList((int)barrel.display_list);
            }
        } else {
            this.doDraw(barrel, is);
        }
        GL11.glPopMatrix();
        Core.profileEnd();
    }

    String getCountLabel(ItemStack item, TileEntityDayBarrel barrel) {
        String t = "";
        int ms = item.func_77976_d();
        int count = barrel.getItemCount();
        if (ms == 1 || count == ms) {
            t = t + count;
        } else {
            int r;
            int q = count / ms;
            if (q > 0) {
                t = t + count / ms + "*" + ms;
            }
            if ((r = count % ms) != 0) {
                if (q > 0) {
                    t = t + "+";
                }
                t = t + r;
            }
        }
        if (barrel.canLose()) {
            t = "!" + t + "!";
        }
        if (barrel.type == TileEntityDayBarrel.Type.CREATIVE) {
            t = "i";
        }
        return t;
    }

    void renderItemCount(ItemStack item, TileEntityDayBarrel barrel) {
        Icon font;
        String t = this.getCountLabel(item, barrel);
        if (t.isEmpty()) {
            return;
        }
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        if (item.func_94608_d() == 1) {
            font = BlockIcons.barrel_font;
            mc.field_71446_o.func_110577_a(Core.blockAtlas);
        } else {
            font = ItemIcons.barrel_font;
            mc.field_71446_o.func_110577_a(Core.itemAtlas);
        }
        int len = t.length();
        double char_width = 0.1;
        double char_height = 0.1;
        Tessellator tess = Tessellator.field_78398_a;
        tess.field_78408_v = -0.1 * (double)len / 2.0 + 0.25;
        tess.field_78407_w = -0.1;
        tess.func_78382_b();
        double du = (font.func_94212_f() - font.func_94209_e()) / 4.0f;
        double dv = (font.func_94210_h() - font.func_94206_g()) / 4.0f;
        double u = font.func_94209_e();
        double v = font.func_94206_g();
        for (int i = 0; i < len; ++i) {
            char c = t.charAt(i);
            int x = 0;
            int y = 0;
            boolean found = false;
            block1: for (y = 0; y < this.fontIdx.length; ++y) {
                String idx = this.fontIdx[y];
                for (x = 0; x < idx.length(); ++x) {
                    if (c != idx.charAt(x)) continue;
                    found = true;
                    break block1;
                }
            }
            if (!found) continue;
            double IX = (double)i * 0.1;
            double dy = 0.99609375;
            tess.func_78374_a(IX + 0.1, 0.0, 0.0, u + (double)(x + 1) * du, v + (double)y * dv);
            tess.func_78374_a(IX, 0.0, 0.0, u + (double)x * du, v + (double)y * dv);
            tess.func_78374_a(IX, 0.1, 0.0, u + (double)x * du, v + ((double)y + 0.99609375) * dv);
            tess.func_78374_a(IX + 0.1, 0.1, 0.0, u + (double)(x + 1) * du, v + ((double)y + 0.99609375) * dv);
        }
        tess.func_78381_a();
        tess.field_78417_x = 0.0;
        tess.field_78407_w = 0.0;
        tess.field_78408_v = 0.0;
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    void old_renderItemCount(ItemStack item, TileEntityDayBarrel barrel) {
        FontRenderer fontRender = this.func_76895_b();
        if (fontRender == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)-0.25, (double)0.125, (double)0.0);
        float scale = 0.01f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        String t = this.getCountLabel(item, barrel);
        int color = 0xBBBBBB;
        fontRender.func_78276_b(t, -fontRender.func_78256_a(t) / 2, 0, color);
        GL11.glPopMatrix();
    }

    public void handleRenderItem(ItemStack is) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float scale = 0.03125f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)-0.02f);
        TextureManager re = Minecraft.func_71410_x().field_71446_o;
        FontRenderer fr = this.func_76895_b();
        if (is.hasEffect(0)) {
            float orig_z = this.renderItem.field_77023_b;
            this.renderItem.field_77023_b = 23.0f;
            this.renderItem.func_82406_b(fr, re, is, 0, 0);
            this.renderItem.field_77023_b = orig_z;
        } else {
            this.renderItem.func_82406_b(fr, re, is, 0, 0);
        }
        GL11.glPopMatrix();
    }
}

