/*
 * Decompiled with CFR 0.152.
 */
package factorization.weird;

import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.notify.Notify;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.TileEntityFactorization;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class TileEntityBarrel
extends TileEntityFactorization {
    public static final int normalBarrelSize = 4096;
    public static final int largeBarrelSize = 65536;
    public static final int maxStackDrop = 64;
    public ItemStack item;
    private ItemStack topStack;
    private int middleCount;
    private ItemStack bottomStack;
    public int upgrade = 0;
    private int lastCount = 0;
    private static final int[] DOWN_s = new int[]{0};
    private static final int[] UP_s = new int[]{1};
    private static final int[] NO_s = new int[0];
    long lastClick = -1000L;
    private static int last_hit_side = -1;
    private static ItemStack emptyItemStack = new ItemStack(0, 0, 0);

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.BARREL;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Barrel;
    }

    @Override
    public Icon getIcon(ForgeDirection dir) {
        return BlockIcons.error;
    }

    public int getItemCount() {
        if (this.item == null) {
            return 0;
        }
        if (this.topStack == null || !this.itemMatch(this.topStack)) {
            this.topStack = this.item.func_77946_l();
            this.topStack.field_77994_a = 0;
        }
        if (this.bottomStack == null || !this.itemMatch(this.bottomStack)) {
            this.bottomStack = this.item.func_77946_l();
            this.bottomStack.field_77994_a = 0;
        }
        return this.topStack.field_77994_a + this.middleCount + this.bottomStack.field_77994_a;
    }

    public int getMaxSize() {
        if (this.upgrade == 0) {
            return 4096;
        }
        return 65536;
    }

    public void updateStacks() {
        if (this.item == null) {
            this.bottomStack = null;
            this.topStack = null;
            this.middleCount = 0;
            return;
        }
        int count = this.getItemCount();
        if (count == 0) {
            this.item = null;
            this.bottomStack = null;
            this.topStack = null;
            this.middleCount = 0;
            return;
        }
        int upperLine = this.getMaxSize() - this.item.func_77976_d();
        if (count > upperLine) {
            this.topStack = this.item.func_77946_l();
            this.topStack.field_77994_a = count - upperLine;
            count -= this.topStack.field_77994_a;
        } else {
            this.topStack.field_77994_a = 0;
        }
        this.bottomStack.field_77994_a = Math.min(this.item.func_77976_d(), count);
        this.middleCount = count -= this.bottomStack.field_77994_a;
    }

    public void changeItemCount(int delta) {
        this.middleCount = this.getItemCount() + delta;
        if (this.middleCount < 0) {
            Core.logSevere("Tried to set the item count to negative value " + this.middleCount + " at " + this.getCoord(), new Object[0]);
            this.middleCount = 0;
            this.item = null;
        }
        if (this.middleCount > this.getMaxSize()) {
            Core.logSevere("Factorization barrel size " + this.middleCount + " is larger than the maximum, " + this.getMaxSize() + " at " + this.getCoord(), new Object[0]);
        }
        this.bottomStack = null;
        this.topStack = null;
        this.updateStacks();
        this.broadcastItemCount();
        this.func_70296_d();
    }

    public void setItemCount(int val) {
        this.bottomStack = null;
        this.topStack = null;
        this.middleCount = val;
        this.changeItemCount(0);
    }

    private ItemStack makeStack(int count) {
        if (this.item == null) {
            return null;
        }
        ItemStack ret = this.item.func_77946_l();
        ret.field_77994_a = count;
        assert (ret.field_77994_a > 0 && ret.field_77994_a <= this.item.func_77976_d());
        return ret;
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        if (this.item == null) {
            this.cleanBarrel();
            return null;
        }
        if (slot == 0) {
            return this.bottomStack;
        }
        if (slot == 1) {
            return this.topStack;
        }
        return null;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack is, int _side) {
        if (this.item == null) {
            return false;
        }
        ForgeDirection side = ForgeDirection.getOrientation((int)_side);
        if (side == ForgeDirection.DOWN) {
            return this.itemMatch(is);
        }
        return false;
    }

    static int sizeOf(ItemStack is) {
        if (is == null) {
            return 0;
        }
        return is.field_77994_a;
    }

    private boolean itemMatch(ItemStack is) {
        if (is == null || this.item == null) {
            return false;
        }
        this.item.field_77994_a = is.field_77994_a;
        boolean b = FzUtil.couldMerge(this.item, is);
        this.item.field_77994_a = 1;
        return b;
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack is = this.func_70301_a(slot);
        if (is == null) {
            return null;
        }
        if (this.getItemCount() - amount < 0) {
            return null;
        }
        ItemStack ret = is.func_77979_a(amount);
        this.func_70296_d();
        return ret;
    }

    public void func_70299_a(int slot, ItemStack is) {
        ItemStack old_item = this.item;
        this.taintBarrel(is);
        if (is != null && !this.itemMatch(is)) {
            new Exception().printStackTrace();
            return;
        }
        switch (slot) {
            case 0: {
                this.bottomStack = is;
                break;
            }
            case 1: {
                this.topStack = is;
            }
        }
        if (old_item != this.item) {
            this.broadcastItem();
        }
        this.broadcastItemCount();
        this.func_70296_d();
    }

    public String func_70303_b() {
        return "Barrel";
    }

    public int[] func_94128_d(int side) {
        switch (ForgeDirection.getOrientation((int)side)) {
            case DOWN: {
                return DOWN_s;
            }
            case UP: {
                return UP_s;
            }
        }
        return NO_s;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (itemstack.func_77951_h()) {
            return false;
        }
        if (this.item == null) {
            return slotIndex == ForgeDirection.UP.ordinal();
        }
        return this.itemMatch(itemstack);
    }

    void info(EntityPlayer entityplayer) {
        if (this.item == null && this.getItemCount() == 0) {
            Notify.send(entityplayer, (Object)this.getCoord(), "Empty", new String[0]);
        } else if (this.getItemCount() >= this.getMaxSize()) {
            Notify.withItem(this.item);
            Notify.send(entityplayer, (Object)this.getCoord(), "Full of {ITEM_NAME}{ITEM_INFOS_NEWLINE}", new String[0]);
        } else {
            Notify.withItem(this.item);
            Notify.send(entityplayer, (Object)this.getCoord(), "%s {ITEM_NAME}{ITEM_INFOS_NEWLINE}", "" + this.getItemCount());
        }
    }

    void taintBarrel(ItemStack is) {
        if (is == null) {
            return;
        }
        if (this.getItemCount() != 0) {
            return;
        }
        if (is.func_77976_d() >= this.getMaxSize()) {
            return;
        }
        this.item = is.func_77946_l();
        this.broadcastItem();
        this.func_70296_d();
    }

    void broadcastItem() {
        if (this.field_70331_k != null && !this.field_70331_k.field_72995_K) {
            Core.network.broadcastMessage(null, this.getCoord(), 41, this.item);
        }
    }

    void broadcastItemCount() {
        if (this.field_70331_k != null && !this.field_70331_k.field_72995_K) {
            this.lastCount = this.getItemCount();
            Core.network.broadcastMessage(null, this.getCoord(), 42, this.lastCount);
        }
    }

    void cleanBarrel() {
        if (this.getItemCount() == 0) {
            this.item = null;
            this.bottomStack = null;
            this.topStack = null;
            this.middleCount = 0;
        } else assert (this.item != null);
    }

    @Override
    public boolean takeUpgrade(ItemStack is) {
        if (is.func_77973_b() == Core.registry.barrel_enlarge && this.upgrade == 0) {
            this.upgrade = 1;
            this.broadcastMessage(null, this.getAuxillaryInfoPacket());
            return true;
        }
        return false;
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        if (entityplayer.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.field_70331_k.func_82737_E() - this.lastClick < 10L && this.item != null) {
            this.addAllItems(entityplayer);
            return true;
        }
        this.lastClick = this.field_70331_k.func_82737_E();
        int handslot = entityplayer.field_71071_by.field_70461_c;
        if (handslot < 0 || handslot > 8) {
            return true;
        }
        ItemStack is = entityplayer.field_71071_by.func_70301_a(handslot);
        if (is == null) {
            this.info(entityplayer);
            return true;
        }
        if (is.func_77951_h()) {
            if (this.getItemCount() == 0) {
                Notify.send(entityplayer, (Object)this.getCoord(), "No storing damaged items", new String[0]);
            } else {
                this.info(entityplayer);
            }
            return true;
        }
        this.taintBarrel(is);
        if (!this.itemMatch(is)) {
            if (Core.getTranslationKey(is.func_77973_b()).equals(Core.getTranslationKey(this.item))) {
                Notify.send(entityplayer, (Object)this.getCoord(), "That item is different", new String[0]);
            } else {
                this.info(entityplayer);
            }
            return true;
        }
        int free = this.getMaxSize() - this.getItemCount();
        if (free <= 0) {
            this.info(entityplayer);
            return true;
        }
        int take = Math.min(free, is.field_77994_a);
        is.field_77994_a -= take;
        this.changeItemCount(take);
        if (is.field_77994_a == 0) {
            entityplayer.field_71071_by.func_70299_a(handslot, null);
        }
        return true;
    }

    @ForgeSubscribe
    public void clickEvent(PlayerInteractEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        last_hit_side = event.face;
    }

    @Override
    public void click(EntityPlayer entityplayer) {
        if (entityplayer.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getItemCount() == 0 || this.item == null) {
            this.info(entityplayer);
            return;
        }
        int to_remove = Math.min(this.item.func_77976_d(), this.getItemCount());
        if (entityplayer.func_70093_af() && to_remove >= 1) {
            to_remove = 1;
        }
        if (to_remove > 1 && to_remove == this.getItemCount()) {
            --to_remove;
        }
        this.ejectItem(this.makeStack(to_remove), false, entityplayer, last_hit_side);
        last_hit_side = -1;
        this.changeItemCount(-to_remove);
        this.cleanBarrel();
        last_hit_side = -1;
    }

    void addAllItems(EntityPlayer entityplayer) {
        int free_space;
        ItemStack hand = entityplayer.field_71071_by.func_70301_a(entityplayer.field_71071_by.field_70461_c);
        if (hand != null) {
            this.taintBarrel(hand);
        }
        if (hand != null && !this.itemMatch(hand)) {
            if (Core.getTranslationKey(hand).equals(Core.getTranslationKey(this.item))) {
                Notify.send(entityplayer, (Object)this.getCoord(), "That item is different", new String[0]);
            } else {
                this.info(entityplayer);
            }
            return;
        }
        InventoryPlayer inv = entityplayer.field_71071_by;
        int total_delta = 0;
        for (int i = 0; i < inv.func_70302_i_() && (free_space = this.getMaxSize() - (this.getItemCount() + total_delta)) > 0; ++i) {
            ItemStack is = inv.func_70301_a(i);
            if (is == null || is.field_77994_a <= 0 || !this.itemMatch(is)) continue;
            int toAdd = Math.min(is.field_77994_a, free_space);
            if (is == hand && toAdd > 1) {
                --toAdd;
            }
            total_delta += toAdd;
            is.field_77994_a -= toAdd;
            if (is.field_77994_a > 0) continue;
            inv.func_70299_a(i, null);
        }
        this.changeItemCount(total_delta);
        if (total_delta > 0) {
            Core.proxy.updatePlayerInventory(entityplayer);
        }
    }

    public boolean canLose() {
        return this.getItemCount() > 64 * this.item.func_77976_d();
    }

    @Override
    public void dropContents() {
        if (this.upgrade > 0) {
            FzUtil.spawnItemStack(this.getCoord(), new ItemStack((Item)Core.registry.barrel_enlarge));
        }
        if (this.item == null || this.getItemCount() <= 0) {
            return;
        }
        int count = this.getItemCount();
        for (int i = 0; i < 64; ++i) {
            int to_drop = Math.min(this.item.func_77976_d(), count);
            this.ejectItem(this.makeStack(to_drop), this.getItemCount() > 1024, null, -1);
            if ((count -= to_drop) <= 0) break;
        }
        this.topStack = null;
        this.middleCount = 0;
        this.bottomStack = null;
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        TileEntityBarrel.saveItem("item_type", tag, this.item);
        tag.func_74768_a("item_count", this.getItemCount());
        tag.func_74768_a("upgrade", this.upgrade);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.item = TileEntityBarrel.readItem("item_type", tag);
        this.upgrade = tag.func_74762_e("upgrade");
        this.setItemCount(tag.func_74762_e("item_count"));
    }

    @Override
    protected void sendFullDescription(EntityPlayer player) {
        super.sendFullDescription(player);
        this.broadcastItem();
        this.changeItemCount(0);
    }

    @Override
    public Packet getAuxillaryInfoPacket() {
        int ic = this.getItemCount();
        if (ic == 0) {
            return this.getDescriptionPacketWith(40, ic, this.upgrade, emptyItemStack);
        }
        return this.getDescriptionPacketWith(40, ic, this.upgrade, this.item);
    }

    @Override
    protected void doLogic() {
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_70316_g() {
        this.updateStacks();
        if (this.lastCount != this.getItemCount()) {
            this.broadcastItemCount();
            this.func_70296_d();
        }
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        switch (messageType) {
            case 42: {
                this.setItemCount(input.readInt());
                break;
            }
            case 40: {
                int i = input.readInt();
                this.upgrade = input.readInt();
                if (i > 0) {
                    this.item = FzUtil.readStack(input);
                }
                this.setItemCount(i);
                break;
            }
            case 41: {
                this.item = FzUtil.readStack(input);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return "Barrel of " + this.getItemCount() + " " + this.item;
    }

    public double func_82115_m() {
        if (FzConfig.render_barrel_close) {
            return 25.0;
        }
        return 1024.0;
    }

    @Override
    public boolean rotate(ForgeDirection axis) {
        if (axis.offsetY != 0) {
            return false;
        }
        this.facing_direction = (byte)axis.ordinal();
        this.getCoord().markBlockForUpdate();
        return true;
    }

    @Override
    public ForgeDirection[] getValidRotations() {
        return flat_rotation_array;
    }

    @Override
    public int getComparatorValue(ForgeDirection side) {
        int count = this.getItemCount();
        if (count == 0) {
            return 0;
        }
        int max = this.getMaxSize();
        if (count == max) {
            return 15;
        }
        float v = (float)count / (float)max;
        return (int)Math.max(1.0f, v * 14.0f);
    }
}

