/*
 * Decompiled with CFR 0.152.
 */
package factorization.sockets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.notify.Notify;
import factorization.servo.ServoMotor;
import factorization.shared.BlockRenderHelper;
import factorization.shared.FzUtil;
import factorization.sockets.ISocketHolder;
import factorization.sockets.TileEntitySocketBase;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.ForgeDirection;

public class SocketRobotHand
extends TileEntitySocketBase {
    boolean wasPowered = false;
    boolean firstTry = false;
    EntityPlayer fakePlayer;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SOCKET_ROBOTHAND;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.wasPowered = data.as(Share.PRIVATE, "pow").putBoolean(this.wasPowered);
        return this;
    }

    @Override
    public void genericUpdate(ISocketHolder socket, Coord coord, boolean powered) {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.wasPowered || !powered) {
            this.wasPowered = powered;
            return;
        }
        this.wasPowered = true;
        IInventory back = this.getBackingInventory(socket);
        if (back == null) {
            return;
        }
        this.firstTry = true;
        FzOrientation orientation = FzOrientation.fromDirection(this.facing).getSwapped();
        this.fakePlayer = null;
        this.rayTrace(socket, coord, orientation, powered, true, false);
        this.fakePlayer = null;
    }

    @Override
    public boolean handleRay(ISocketHolder socket, MovingObjectPosition mop, boolean mopIsThis, boolean powered) {
        if (this.fakePlayer == null) {
            this.fakePlayer = this.getFakePlayer();
        }
        EntityPlayer player = this.fakePlayer;
        FzUtil.FzInv inv = FzUtil.openInventory(this.getBackingInventory(socket), this.facing);
        boolean foundAny = false;
        int anEmpty = -1;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack is = inv.get(i);
            if (is == null || is.field_77994_a <= 0 || !inv.canExtract(i, is)) {
                if (anEmpty == -1) continue;
                anEmpty = i;
                continue;
            }
            player.field_71071_by.field_70462_a[0] = is;
            foundAny = true;
            if (!this.clickWithInventory(i, inv, player, is, mop)) continue;
            return true;
        }
        if (!foundAny && anEmpty != -1) {
            return this.clickWithInventory(anEmpty, inv, player, null, mop);
        }
        return false;
    }

    boolean clickWithInventory(int i, FzUtil.FzInv inv, EntityPlayer player, ItemStack is, MovingObjectPosition mop) {
        ItemStack orig = is == null ? null : is.func_77946_l();
        boolean result = this.clickItem(player, is, mop);
        this.firstTry = false;
        int newSize = FzUtil.getStackSize(is);
        is = player.field_71071_by.field_70462_a[0];
        if (newSize <= 0 || !FzUtil.couldMerge(orig, is)) {
            inv.set(i, null);
            if (newSize > 0 && ((is = inv.pushInto(i, is)) == null || is.field_77994_a <= 0)) {
                player.field_71071_by.field_70462_a[0] = null;
            }
        } else {
            inv.set(i, is);
            player.field_71071_by.field_70462_a[0] = null;
        }
        Coord here = null;
        for (int j = 0; j < player.field_71071_by.func_70302_i_(); ++j) {
            ItemStack toPush = player.field_71071_by.func_70301_a(j);
            ItemStack toDrop = inv.push(toPush);
            if (toDrop != null && toDrop.field_77994_a > 0) {
                if (here == null) {
                    here = this.getCoord();
                }
                here.spawnItem(toDrop);
            }
            player.field_71071_by.func_70299_a(j, null);
        }
        inv.onInvChanged();
        return result;
    }

    boolean clickItem(EntityPlayer player, ItemStack is, MovingObjectPosition mop) {
        if (mop.field_72313_a == EnumMovingObjectType.TILE) {
            return this.mcClick(player, mop, is);
        }
        if (mop.field_72313_a == EnumMovingObjectType.ENTITY) {
            if (mop.field_72308_g.func_130002_c(player)) {
                return true;
            }
            if (mop.field_72308_g instanceof EntityLiving && is.func_111282_a(player, (EntityLivingBase)((EntityLiving)mop.field_72308_g))) {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    boolean mcClick(EntityPlayer player, MovingObjectPosition mop, ItemStack itemstack) {
        world = player.field_70170_p;
        x = mop.field_72311_b;
        y = mop.field_72312_c;
        z = mop.field_72309_d;
        side = mop.field_72310_e;
        hitVec = mop.field_72307_f;
        dx = (float)hitVec.field_72450_a - (float)x;
        dy = (float)hitVec.field_72448_b - (float)y;
        dz = (float)hitVec.field_72449_c - (float)z;
        item = itemstack == null ? null : itemstack.func_77973_b();
        ret = false;
        if (!this.firstTry || itemstack == null) ** GOTO lbl-1000
        orig = itemstack.func_77946_l();
        if (item.onItemUseFirst(itemstack, player, world, x, y, z, side, dx, dy, dz)) {
            ret = true;
        } else if (!FzUtil.identical(itemstack, orig)) {
            ret = true;
        } else lbl-1000:
        // 2 sources

        {
            ret = (player.func_70093_af() == false || itemstack == null || item.shouldPassSneakingClickToBlock(world, x, y, z) != false) && (blockId = world.func_72798_a(x, y, z)) > 0 && Block.field_71973_m[blockId].func_71903_a(world, x, y, z, player, side, dx, dy, dz) != false ? true : (itemstack == null ? false : (item instanceof ItemBlock != false && (itemblock = (ItemBlock)item).func_77884_a(world, x, y, z, side, player, itemstack) == false ? false : itemstack.func_77943_a(player, world, x, y, z, side, dx, dy, dz)));
        }
        origSize = itemstack.field_77994_a;
        mutatedItem = itemstack.func_77957_a(world, player);
        if (!ret && !FzUtil.identical(mutatedItem, itemstack)) {
            ret = true;
        }
        if (mutatedItem == itemstack && (mutatedItem == null || mutatedItem.field_77994_a == origSize)) {
            return ret;
        }
        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = mutatedItem;
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(ServoMotor motor, Tessellator tess) {
        BlockRenderHelper block = BlockRenderHelper.instance;
        float w = 0.375f;
        block.setBlockBoundsOffset(w, 0.0f, w);
        block.useTextures(BlockIcons.socket$hand, null, BlockIcons.socket$arm0, BlockIcons.socket$arm1, BlockIcons.socket$arm2, BlockIcons.socket$arm3);
        block.begin();
        block.rotateCenter(Quaternion.fromOrientation(FzOrientation.fromDirection(this.facing.getOpposite())));
        if (motor != null) {
            block.translate(0.0f, -0.125f, 0.0f);
        }
        block.renderRotated(tess, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        if (this.field_70331_k.field_72995_K) {
            return false;
        }
        if (this.getBackingInventory(this) == null) {
            Notify.send(this, "Missing inventory block", new String[0]);
        }
        return false;
    }
}

