/*
 * Decompiled with CFR 0.152.
 */
package factorization.sockets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.common.FactoryType;
import factorization.shared.Core;
import factorization.shared.ItemFactorization;
import factorization.shared.TileEntityCommon;
import factorization.sockets.SocketEmpty;
import factorization.sockets.TileEntitySocketBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemSocketPart
extends ItemFactorization {
    FactoryType[] socketTypes = null;
    @SideOnly(value=Side.CLIENT)
    Icon[] socketIcons;

    public ItemSocketPart(int itemId, String name2, Core.TabType tabType) {
        super(itemId, name2, tabType);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    static ArrayList<FactoryType> loadSockets() {
        ArrayList<FactoryType> ret = new ArrayList<FactoryType>();
        block0: for (FactoryType ft : FactoryType.values()) {
            if (ft == FactoryType.SOCKET_EMPTY) continue;
            Class<? extends TileEntityCommon> theClass = ft.getFactoryTypeClass();
            while (theClass != null) {
                if ((theClass = theClass.getSuperclass()) != TileEntitySocketBase.class) continue;
                ret.add(ft);
                continue block0;
            }
        }
        return ret;
    }

    FactoryType[] getSockets() {
        if (this.socketTypes == null) {
            ArrayList<FactoryType> aft = ItemSocketPart.loadSockets();
            this.socketTypes = new FactoryType[aft.size()];
            for (int i = 0; i < this.socketTypes.length; ++i) {
                this.socketTypes[i] = aft.get(i);
            }
        }
        return this.socketTypes;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        this.socketIcons = new Icon[FactoryType.MAX_ID];
        ItemStack me = new ItemStack((Item)this);
        for (FactoryType ft : this.getSockets()) {
            me.func_77964_b(ft.md);
            this.socketIcons[ft.md] = register.func_94245_a(this.func_77667_c(me).replace("item.", ""));
        }
    }

    public String func_77667_c(ItemStack is) {
        int md = is.func_77960_j();
        String ret = this.func_77658_a() + (Object)((Object)FactoryType.fromMd(md));
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int itemId, CreativeTabs tab, List list) {
        FactoryType[] ss = this.getSockets();
        for (int i = 0; i < ss.length; ++i) {
            FactoryType ft = ss[i];
            list.add(ft.asSocketItem());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int md) {
        if (md > 0 && md < this.socketIcons.length) {
            return this.socketIcons[md];
        }
        return super.func_77617_a(md);
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        int md = is.func_77960_j();
        Coord here = new Coord(world, x, y, z);
        --is.field_77994_a;
        SocketEmpty se = here.getTE(SocketEmpty.class);
        if (se == null) {
            return super.func_77648_a(is, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        if (md > 0 && md < FactoryType.MAX_ID) {
            try {
                TileEntitySocketBase socket = (TileEntitySocketBase)FactoryType.fromMd(md).getFactoryTypeClass().newInstance();
                here.setTE(socket);
                socket.facing = se.facing;
                here.markBlockForUpdate();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    protected void addExtraInformation(ItemStack is, EntityPlayer player, List list, boolean verbose) {
        list.add("Socket part");
    }
}

