/*
 * Decompiled with CFR 0.152.
 */
package factorization.sockets;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.DataOutPacketClientEdited;
import factorization.api.datahelpers.DataValidator;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.shared.Core;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;

public class GuiDataConfig
extends GuiScreen {
    IDataSerializable ids;
    TileEntity te;
    Entity containingEntity;
    ArrayList<Field> fields = new ArrayList();
    int posLabel;
    int posControl;
    boolean changed;
    boolean fields_initialized = false;
    boolean fields_valid = false;

    public GuiDataConfig(IDataSerializable ids) {
        this.ids = ids;
        this.te = (TileEntity)ids;
    }

    public GuiDataConfig(IDataSerializable ids, Entity container) {
        this.ids = ids;
        this.te = (TileEntity)ids;
        this.containingEntity = container;
    }

    void closeScreen() {
        this.func_73869_a('\u0000', 1);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.fields_initialized) {
            this.fields_initialized = true;
            try {
                this.initFields();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.closeScreen();
            }
            this.fields_valid = true;
        }
        this.posLabel = 40;
        this.posControl = this.posLabel + 20;
        for (Field field : this.fields) {
            this.posControl = Math.max(this.posControl, field.getLabelWidth() + 20);
        }
        for (Field field : this.fields) {
            field.initGui();
        }
    }

    void initFields() throws IOException {
        this.fields.clear();
        this.ids.serialize("", new DataHelper(){
            int count = 0;

            @Override
            protected boolean shouldStore(Share share) {
                return share.is_public && share.client_can_edit;
            }

            @Override
            public <E> E put(E o) throws IOException {
                if (!this.valid) {
                    return o;
                }
                if (o instanceof Enum) {
                    return (E)this.putImplementation(o);
                }
                return super.put(o);
            }

            @Override
            protected <E> Object putImplementation(E o) throws IOException {
                if (!this.valid) {
                    return 0;
                }
                int fieldStart = 100;
                int fieldHeight = 24;
                int posY = this.count * fieldHeight + fieldStart;
                if (o instanceof Boolean) {
                    GuiDataConfig.this.fields.add(new BooleanField(this.name, o, posY));
                } else if (o instanceof Number) {
                    GuiDataConfig.this.fields.add(new NumberField(this.name, o, posY));
                } else if (o instanceof Enum) {
                    GuiDataConfig.this.fields.add(new EnumField(GuiDataConfig.this, this.name, (Enum)o, posY));
                } else {
                    GuiDataConfig.this.fields.add(new Field(this.name, o, posY));
                }
                ++this.count;
                return o;
            }

            @Override
            public boolean isReader() {
                return true;
            }
        });
    }

    boolean validate(ArrayList<Field> fields) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Field f : fields) {
            f.put(data);
        }
        DataValidator dv = new DataValidator(data);
        try {
            this.ids.serialize("", dv);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return dv.isValid();
    }

    public void func_73863_a(int mouseX, int mouseY, float partial) {
        int w;
        int xSize;
        this.func_73873_v_();
        super.func_73863_a(mouseX, mouseY, partial);
        TextureManager tex = Minecraft.func_71410_x().field_71446_o;
        tex.func_110577_a(Core.itemAtlas);
        Icon lmp = Core.registry.logicMatrixProgrammer.func_77617_a(0);
        int ySize = xSize = (w = 256);
        int left = (this.field_73880_f - 6) / 2;
        int top = (this.field_73881_g - ySize) / 2;
        this.func_94065_a(left, top, lmp, xSize, ySize);
        for (Field field : this.fields) {
            field.render(mouseX, mouseY);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        for (Field field : this.fields) {
            field.mouseClick(mouseX, mouseY, button == 1);
        }
        this.valueChanged();
        super.func_73864_a(mouseX, mouseY, button);
    }

    void valueChanged() {
        this.fields_valid = this.validate(this.fields);
        this.fields_initialized = false;
        this.func_73866_w_();
        this.changed = true;
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char chr, int keySym) {
        super.func_73869_a(chr, keySym);
        if (keySym == 1) {
            return;
        }
    }

    public void func_73874_b() {
        super.func_73874_b();
        if (!this.fields_valid || !this.changed) {
            return;
        }
        try {
            this.sendPacket();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    void sendPacket() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        DataOutPacketClientEdited dop = new DataOutPacketClientEdited(dos);
        Coord here = new Coord((TileEntity)this.ids);
        if (this.containingEntity == null) {
            Core.network.prefixTePacket(dos, here, 3);
            this.ids.serialize("", dop);
            Core.network.broadcastPacket((EntityPlayer)this.field_73882_e.field_71439_g, here, Core.network.TEmessagePacket(baos));
        } else {
            Core.network.prefixEntityPacket(dos, this.containingEntity, 3);
            this.ids.serialize("", dop);
            Core.network.broadcastPacket((EntityPlayer)this.field_73882_e.field_71439_g, here, Core.network.entityPacket(baos));
        }
    }

    class EnumField<E extends Enum>
    extends Field {
        E val;
        UsefulButton button;
        final /* synthetic */ GuiDataConfig this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public EnumField(String name2, E object, int posY) {
            this.this$0 = (GuiDataConfig)n;
            super(name2, object, posY);
            this.val = object;
        }

        @Override
        void initGui() {
            super.initGui();
            this.button = this.button(0, Core.tryTranslate(this.getTrans() + "." + this.val, "" + this.val));
        }

        @Override
        void buttonPressed(UsefulButton button, boolean rightClick) {
            int ord = ((Enum)this.val).ordinal();
            Enum[] family = (Enum[])this.val.getClass().getEnumConstants();
            ord = rightClick ? (ord == 0 ? family.length - 1 : ord - 1) : (ord + 1 == family.length ? 0 : ord + 1);
            this.val = family[ord];
            this.object = this.val;
            this.initGui();
        }

        @Override
        void put(Map<String, Object> map) {
            map.put(this.name, ((Enum)this.val).ordinal());
        }
    }

    class NumberField
    extends Field {
        long val;
        int labelPos;

        public NumberField(String name2, Object object, int posY) {
            super(name2, object, posY);
            Number n = (Number)object;
            this.val = n.intValue();
        }

        String transVal() {
            return Core.tryTranslate(this.getTrans() + "." + this.val, "" + this.val);
        }

        @Override
        void initGui() {
            super.initGui();
            this.button(-10, "-10");
            this.button(-1, "-");
            this.labelPos = this.buttonPos;
            this.buttonPos += GuiDataConfig.this.field_73886_k.func_78256_a(this.transVal()) + 5;
            this.button(1, "+");
            this.button(10, "+10");
        }

        @Override
        void renderControl(int mouseX, int mouseY) {
            GuiDataConfig.this.field_73886_k.func_78276_b(this.transVal(), this.labelPos, this.posY, this.color);
        }

        @Override
        void keyTyped(int keysym, char ch) {
            if (keysym == 14) {
                this.val /= 10L;
            } else {
                try {
                    int digit = Integer.parseInt(Character.toString(ch));
                    this.val = this.val * 10L + (long)digit;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.object = this.val;
            this.initGui();
        }

        @Override
        void buttonPressed(UsefulButton button, boolean rightClick) {
            this.val += (long)button.field_73741_f;
            this.object = this.val;
            this.initGui();
        }

        @Override
        void put(Map<String, Object> map) {
            Object obj = this.object;
            if (this.objectType == Long.class) {
                obj = new Long(this.val);
            } else if (this.objectType == Integer.class) {
                obj = new Integer((int)this.val);
            } else if (this.objectType == Short.class) {
                obj = new Short((short)this.val);
            } else if (this.objectType == Byte.class) {
                obj = new Byte((byte)this.val);
            }
            map.put(this.name, obj);
        }
    }

    class BooleanField
    extends Field {
        boolean val;
        UsefulButton button;

        public BooleanField(String name2, Object object, int posY) {
            super(name2, object, posY);
            this.val = (Boolean)object;
        }

        @Override
        void initGui() {
            super.initGui();
            this.button = this.button(0, Core.tryTranslate(this.getTrans() + "." + this.val, "" + this.val));
        }

        @Override
        void buttonPressed(UsefulButton button, boolean rightClick) {
            this.val = !this.val;
            this.object = this.val;
            this.initGui();
        }
    }

    class Field {
        String name;
        Object object;
        Class objectType;
        int posY;
        String label;
        int color = 0xFFFFFF;
        ArrayList<UsefulButton> buttons = new ArrayList();
        int buttonPos = 0;

        public Field(String name2, Object object, int posY) {
            this.name = name2;
            this.object = object;
            this.objectType = object.getClass();
            this.posY = posY;
            this.label = Core.translate(this.getTrans());
            if (this.getClass() == Field.class) {
                this.color = 0xAAAAAA;
            }
        }

        String getTrans() {
            return "data.label." + GuiDataConfig.this.ids.getClass().getSimpleName() + "." + this.name;
        }

        void initGui() {
            this.buttonPos = GuiDataConfig.this.posControl;
            this.buttons.clear();
        }

        UsefulButton button(int delta, String text) {
            UsefulButton button = new UsefulButton(delta, this.buttonPos, this.posY - 2, text);
            this.buttons.add(button);
            this.buttonPos += GuiDataConfig.this.field_73886_k.func_78256_a(button.field_73744_e + 10);
            return button;
        }

        void render(int mouseX, int mouseY) {
            this.renderLabel();
            this.renderControl(mouseX, mouseY);
            for (UsefulButton button : this.buttons) {
                button.func_73737_a(GuiDataConfig.this.field_73882_e, mouseX, mouseY);
            }
        }

        void renderLabel() {
            GuiDataConfig.this.func_73731_b(GuiDataConfig.this.field_73886_k, this.label, GuiDataConfig.this.posLabel, this.posY, this.color);
        }

        void renderControl(int mouseX, int mouseY) {
        }

        int getLabelWidth() {
            return GuiDataConfig.this.field_73886_k.func_78256_a(this.label) + 80;
        }

        void mouseClick(int mouseX, int mouseY, boolean rightClick) {
            for (UsefulButton button : this.buttons) {
                if (!button.isHovered()) continue;
                this.buttonPressed(button, rightClick);
                break;
            }
        }

        void put(Map<String, Object> map) {
            map.put(this.name, this.object);
        }

        void keyTyped(int keysym, char ch) {
        }

        void buttonPressed(UsefulButton button, boolean rightClick) {
        }
    }

    static class UsefulButton
    extends GuiButton {
        static FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;

        public UsefulButton(int id, int xPos, int yPos, String text) {
            super(id, xPos, yPos - 4, fontRenderer.func_78256_a(text) + 8, 20, text);
        }

        public boolean isHovered() {
            return this.field_82253_i;
        }
    }
}

