/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.api.ICoord;
import factorization.api.IFactoryType;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;

public abstract class TileEntityCommon
extends TileEntity
implements ICoord,
IFactoryType {
    protected static Random rand = new Random();
    public String customName = null;
    private long pulseTime = -1000L;
    public static final ForgeDirection[] empty_rotation_array = new ForgeDirection[0];
    public static final ForgeDirection[] flat_rotation_array = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
    public static final ForgeDirection[] full_rotation_array = new ForgeDirection[6];

    public abstract BlockClass getBlockClass();

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ForgeDirection dir) {
        return BlockIcons.error;
    }

    public Packet func_70319_e() {
        return this.getAuxillaryInfoPacket();
    }

    public Packet getAuxillaryInfoPacket() {
        Packet p = Core.network.TEmessagePacket(this.getCoord(), 1, this.getFactoryType().md, this.getExtraInfo(), this.getExtraInfo2());
        p.field_73287_r = true;
        return p;
    }

    protected void onRemove() {
        if (this instanceof IChargeConductor) {
            ((IChargeConductor)((Object)this)).getCharge().remove();
        }
    }

    protected byte getExtraInfo() {
        return 0;
    }

    protected byte getExtraInfo2() {
        return 0;
    }

    protected void useExtraInfo(byte b) {
    }

    protected void useExtraInfo2(byte b) {
    }

    protected void sendFullDescription(EntityPlayer player) {
    }

    public boolean canPlaceAgainst(EntityPlayer player, Coord c, int side) {
        return true;
    }

    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        this.onPlacedBy(player, is, side);
    }

    public void onPlacedBy(EntityPlayer player, ItemStack is, int side) {
        this.loadFromStack(is);
    }

    public void loadFromStack(ItemStack is) {
        this.customName = FzUtil.getCustomItemName(is);
    }

    protected boolean removeBlockByPlayer(EntityPlayer player) {
        return Core.registry.resource_block.removeBlockByPlayer(this.field_70331_k, player, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void neighborChanged() {
    }

    public void pulse() {
        Coord here = this.getCoord();
        if (here.w.field_72995_K) {
            return;
        }
        this.pulseTime = this.field_70331_k.func_82737_E();
        here.notifyNeighbors();
        here.scheduleUpdate(4);
    }

    public boolean power() {
        return this.pulseTime + 4L > this.field_70331_k.func_82737_E();
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        this.setBlockBounds(Core.registry.resource_block);
        AxisAlignedBB ret = Core.registry.resource_block.func_71872_e(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        Core.registry.resource_block.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return ret;
    }

    public boolean addCollisionBoxesToList(Block block, AxisAlignedBB aabb, List list, Entity entity) {
        return false;
    }

    public MovingObjectPosition collisionRayTrace(Vec3 startVec, Vec3 endVec) {
        return Block.field_71981_t.func_71878_a(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, startVec, endVec);
    }

    public void setBlockBounds(Block b) {
        b.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    protected Packet getDescriptionPacketWith(Object ... args) {
        Object[] suffix = new Object[args.length + 3];
        suffix[0] = this.getFactoryType().md;
        suffix[1] = this.getExtraInfo();
        suffix[2] = this.getExtraInfo2();
        for (int i = 0; i < args.length; ++i) {
            suffix[i + 3] = args[i];
        }
        Packet p = Core.network.TEmessagePacket(this.getCoord(), 1, suffix);
        p.field_73287_r = true;
        return p;
    }

    @Override
    public Coord getCoord() {
        return new Coord(this);
    }

    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        FactoryType type = this.getFactoryType();
        if (type.hasGui) {
            if (!entityplayer.field_70170_p.field_72995_K) {
                this.sendFullDescription(entityplayer);
                entityplayer.openGui((Object)Core.instance, type.gui, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
            return true;
        }
        return false;
    }

    public boolean isBlockSolidOnSide(int side) {
        return true;
    }

    public boolean takeUpgrade(ItemStack is) {
        return false;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74778_a("ver", "0.8.29");
        if (this.customName != null) {
            tag.func_74778_a("customName", this.customName);
        }
        if (this.field_70331_k != null && this.power()) {
            tag.func_74772_a("rps", this.pulseTime);
        }
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        if (tag.func_74764_b("customName")) {
            this.customName = tag.func_74779_i("customName");
        }
        if (tag.func_74764_b("rps")) {
            this.pulseTime = tag.func_74763_f("rps");
        }
    }

    protected final void writeBuffer(String bufferName, NBTTagCompound tag, ArrayList<ItemStack> outputBuffer) {
        if (outputBuffer.size() > 0) {
            NBTTagList buffer = new NBTTagList();
            for (ItemStack item : outputBuffer) {
                if (item == null) continue;
                NBTTagCompound btag = new NBTTagCompound();
                item.func_77955_b(btag);
                buffer.func_74742_a((NBTBase)btag);
            }
            tag.func_74782_a(bufferName, (NBTBase)buffer);
        }
    }

    protected final void readBuffer(String bufferName, NBTTagCompound tag, ArrayList<ItemStack> outputBuffer) {
        NBTTagList buffer;
        int bufferSize;
        outputBuffer.clear();
        if (tag.func_74764_b(bufferName) && (bufferSize = (buffer = tag.func_74761_m(bufferName)).func_74745_c()) > 0) {
            for (int i = 0; i < bufferSize; ++i) {
                NBTTagCompound it = (NBTTagCompound)buffer.func_74743_b(i);
                outputBuffer.add(ItemStack.func_77949_a((NBTTagCompound)it));
            }
        }
    }

    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        return false;
    }

    public boolean handleMessageFromClient(int messageType, DataInputStream input) throws IOException {
        return false;
    }

    public void broadcastMessage(EntityPlayer who, int messageType, Object ... msg) {
        Core.network.broadcastMessage(who, this.getCoord(), messageType, msg);
    }

    public void broadcastMessage(EntityPlayer who, Packet toSend) {
        Core.network.broadcastPacket(who, this.getCoord(), toSend);
    }

    public void func_70313_j() {
        if (this instanceof IChargeConductor) {
            IChargeConductor me = (IChargeConductor)((Object)this);
            me.getCharge().invalidate();
        }
        super.func_70313_j();
    }

    public boolean rotate(ForgeDirection axis) {
        return false;
    }

    public ForgeDirection[] getValidRotations() {
        return empty_rotation_array;
    }

    public int getDynamicLight() {
        return 0;
    }

    public int getComparatorValue(ForgeDirection side) {
        if (this instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)this));
        }
        return 0;
    }

    public String toString() {
        return super.toString() + " a " + (Object)((Object)this.getFactoryType()) + " at " + this.getCoord();
    }

    public ItemStack getDroppedBlock() {
        return new ItemStack((Item)Core.registry.item_factorization, 1, this.getFactoryType().md);
    }

    public ItemStack getPickedBlock() {
        return this.getDroppedBlock();
    }

    public void onNeighborTileChanged(int tilex, int tiley, int tilez) {
    }

    public void representYoSelf() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    static {
        for (int i = 0; i < 6; ++i) {
            TileEntityCommon.full_rotation_array[i] = ForgeDirection.getOrientation((int)i);
        }
    }
}

