/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ITinyPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.IEntityMessage;
import factorization.api.Quaternion;
import factorization.api.VectorUV;
import factorization.common.Command;
import factorization.common.FactoryType;
import factorization.notify.NotifyImplementation;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.Sound;
import factorization.shared.TileEntityCommon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet131MapData;
import net.minecraft.server.management.PlayerInstance;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class NetworkFactorization
implements ITinyPacketHandler {
    protected static final short factorizeTEChannel = 0;
    protected static final short factorizeCmdChannel = 2;
    protected static final short factorizeNtfyChannel = 3;
    protected static final short factorizeEntityChannel = 4;
    public static final ItemStack EMPTY_ITEMSTACK = new ItemStack(0, 0, 0);
    int huge_tag_warnings = 0;
    private double maxBroadcastDistSq = 2.0 * Math.pow(64.0, 2.0);
    private static final ThreadLocal<EntityPlayer> currentPlayer = new ThreadLocal();

    public NetworkFactorization() {
        Core.network = this;
    }

    void addPacket(EntityPlayer player, Packet packet) {
        if (player.field_70170_p.field_72995_K) {
            PacketDispatcher.sendPacketToServer((Packet)packet);
        } else {
            PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)player));
        }
    }

    private void writeObjects(ByteArrayOutputStream outputStream, DataOutputStream output, Object ... items) throws IOException {
        for (Object item : items) {
            if (item == null) {
                throw new RuntimeException("Argument is null!");
            }
            if (item instanceof Integer) {
                output.writeInt((Integer)item);
                continue;
            }
            if (item instanceof Byte) {
                output.writeByte(((Byte)item).byteValue());
                continue;
            }
            if (item instanceof Short) {
                output.writeShort(((Short)item).shortValue());
                continue;
            }
            if (item instanceof String) {
                output.writeUTF((String)item);
                continue;
            }
            if (item instanceof Boolean) {
                output.writeBoolean((Boolean)item);
                continue;
            }
            if (item instanceof Float) {
                output.writeFloat(((Float)item).floatValue());
                continue;
            }
            if (item instanceof ItemStack) {
                ItemStack is = (ItemStack)item;
                NBTTagCompound tag = new NBTTagCompound();
                Item is_item = is.func_77973_b();
                NBTTagCompound orig_tag = is.func_77978_p();
                if (FzUtil.isTagBig((NBTBase)tag, 1024) >= 1024) {
                    is.func_77982_d(null);
                    if (this.huge_tag_warnings == 0) {
                        Core.logWarning("FIXME: Need to add in Item.getTagForClient", new Object[0]);
                    }
                    if (this.huge_tag_warnings++ < 10) {
                        Core.logWarning("Item " + is + " has a large NBT tag; it won't be sent over the wire.", new Object[0]);
                        if (this.huge_tag_warnings == 10) {
                            Core.logWarning("(This will no longer be logged)", new Object[0]);
                        }
                    }
                }
                is.func_77955_b(tag);
                NBTBase.func_74731_a((NBTBase)tag, (DataOutput)output);
                is.func_77982_d(orig_tag);
                continue;
            }
            if (item instanceof VectorUV) {
                VectorUV v = (VectorUV)item;
                output.writeFloat((float)v.x);
                output.writeFloat((float)v.y);
                output.writeFloat((float)v.z);
                continue;
            }
            if (item instanceof DeltaCoord) {
                DeltaCoord dc = (DeltaCoord)item;
                dc.write(output);
                continue;
            }
            if (item instanceof Quaternion) {
                Quaternion q = (Quaternion)item;
                q.write(output);
                continue;
            }
            if (item instanceof byte[]) {
                byte[] b = (byte[])item;
                output.write(b, 0, b.length);
                continue;
            }
            throw new RuntimeException("Don't know how to serialize " + item.getClass() + " (" + item + ")");
        }
    }

    public void prefixTePacket(DataOutputStream output, Coord src, int messageType) throws IOException {
        output.writeInt(src.x);
        output.writeInt(src.y);
        output.writeInt(src.z);
        output.writeShort(messageType);
    }

    public Packet TEmessagePacket(ByteArrayOutputStream outputStream) throws IOException {
        outputStream.flush();
        return PacketDispatcher.getTinyPacket((Object)Core.instance, (short)0, (byte[])outputStream.toByteArray());
    }

    public Packet TEmessagePacket(Coord src, int messageType, Object ... items) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            this.prefixTePacket(output, src, messageType);
            this.writeObjects(outputStream, output, items);
            return this.TEmessagePacket(outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Packet notifyPacket(Object where, ItemStack item, String format, String ... args) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            if (where instanceof Vec3) {
                output.writeByte(1);
                Vec3 v = (Vec3)where;
                output.writeDouble(v.field_72450_a);
                output.writeDouble(v.field_72448_b);
                output.writeDouble(v.field_72449_c);
            } else if (where instanceof Coord) {
                output.writeByte(0);
                Coord c = (Coord)where;
                output.writeInt(c.x);
                output.writeInt(c.y);
                output.writeInt(c.z);
            } else if (where instanceof Entity) {
                output.writeByte(2);
                Entity ent = (Entity)where;
                output.writeInt(ent.field_70157_k);
            } else if (where instanceof TileEntity) {
                output.writeByte(3);
                TileEntity te = (TileEntity)where;
                output.writeInt(te.field_70329_l);
                output.writeInt(te.field_70330_m);
                output.writeInt(te.field_70327_n);
            } else {
                return null;
            }
            if (item == null) {
                item = EMPTY_ITEMSTACK;
            }
            NBTTagCompound tag = new NBTTagCompound();
            item.func_77955_b(tag);
            NBTBase.func_74731_a((NBTBase)tag, (DataOutput)output);
            output.writeUTF(format);
            output.writeInt(args.length);
            for (String a : args) {
                output.writeUTF(a);
            }
            output.flush();
            return PacketDispatcher.getTinyPacket((Object)Core.instance, (short)3, (byte[])outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void prefixEntityPacket(DataOutputStream output, Entity to, int messageType) throws IOException {
        output.writeInt(to.field_70157_k);
        output.writeShort(messageType);
    }

    public Packet entityPacket(ByteArrayOutputStream outputStream) throws IOException {
        outputStream.flush();
        return PacketDispatcher.getTinyPacket((Object)Core.instance, (short)4, (byte[])outputStream.toByteArray());
    }

    public Packet entityPacket(Entity to, int messageType, Object ... items) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            this.prefixEntityPacket(output, to, messageType);
            this.writeObjects(outputStream, output, items);
            return this.entityPacket(outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendCommand(EntityPlayer player, Command cmd, byte arg) {
        byte[] data = new byte[]{cmd.id, arg};
        Packet131MapData packet = PacketDispatcher.getTinyPacket((Object)Core.instance, (short)2, (byte[])data);
        this.addPacket(player, (Packet)packet);
    }

    public void broadcastMessage(EntityPlayer who, Coord src, int messageType, Object ... msg) {
        Packet toSend = this.TEmessagePacket(src, messageType, msg);
        if (who == null || !who.field_70170_p.field_72995_K) {
            this.broadcastPacket(who, src, toSend);
        } else {
            this.addPacket(who, toSend);
        }
    }

    public void broadcastPacket(EntityPlayer who, Coord src, Packet toSend) {
        if (src.w == null) {
            new NullPointerException("Coord is null").printStackTrace();
            return;
        }
        if (who == null) {
            Chunk srcChunk = src.getChunk();
            for (EntityPlayer player : src.w.field_73010_i) {
                double x = (double)src.x - player.field_70165_t;
                double z = (double)src.z - player.field_70161_v;
                if (x * x + z * z > this.maxBroadcastDistSq || !Core.proxy.playerListensToCoord(player, src)) continue;
                this.addPacket(player, toSend);
            }
        } else {
            this.addPacket(who, toSend);
        }
    }

    public void broadcastPacket(World world, int xCoord, int yCoord, int zCoord, Packet toSend) {
        if (toSend == null) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        WorldServer w = (WorldServer)world;
        PlayerInstance pi = w.func_73040_p().func_72690_a(xCoord >> 4, zCoord >> 4, false);
        if (pi == null) {
            return;
        }
        pi.func_73256_a(toSend);
    }

    public void broadcastPacketToLMPers(Entity servo, Packet toSend) {
        if (toSend == null) {
            return;
        }
        World world = servo.field_70170_p;
        int xCoord = (int)servo.field_70165_t;
        int zCoord = (int)servo.field_70161_v;
        if (world.field_72995_K) {
            return;
        }
        WorldServer w = (WorldServer)world;
        PlayerInstance pi = w.func_73040_p().func_72690_a(xCoord >> 4, zCoord >> 4, false);
        if (pi == null) {
            return;
        }
        for (int i = 0; i < pi.field_73263_b.size(); ++i) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)pi.field_73263_b.get(i);
            ItemStack held = entityplayermp.func_70694_bm();
            if (held == null || held.func_77973_b() != Core.registry.logicMatrixProgrammer || entityplayermp.field_71129_f.contains(pi.field_73264_c)) continue;
            entityplayermp.field_71135_a.func_72567_b(toSend);
        }
    }

    public EntityPlayer getCurrentPlayer() {
        EntityPlayer ret = currentPlayer.get();
        if (ret == null) {
            throw new NullPointerException("currentPlayer wasn't set");
        }
        return ret;
    }

    public void handle(NetHandler handler, Packet131MapData mapData) {
        this.handlePacketData(handler, mapData.field_73436_b, mapData.field_73437_c, handler.getPlayer());
    }

    void handlePacketData(NetHandler handler, int channel, byte[] data, EntityPlayer me) {
        currentPlayer.set(me);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        DataInputStream input = new DataInputStream(inputStream);
        switch (channel) {
            case 0: {
                this.handleTE(input);
                break;
            }
            case 2: {
                this.handleCmd(data);
                break;
            }
            case 3: {
                this.handleNtfy(input);
                break;
            }
            case 4: {
                this.handleEntity(input);
                break;
            }
            default: {
                Core.logWarning("Got packet with invalid channel %s with player = %s ", channel, me);
            }
        }
        currentPlayer.set(null);
    }

    void handleTE(DataInputStream input) {
        try {
            World world = this.getCurrentPlayer().field_70170_p;
            int x = input.readInt();
            int y = input.readInt();
            int z = input.readInt();
            int messageType = input.readShort();
            Coord here = new Coord(world, x, y, z);
            if (Core.debug_network) {
                Core.logFine("FactorNet: " + messageType + "      " + here, new Object[0]);
            }
            if (!here.blockExists() && world.field_72995_K) {
                return;
            }
            if (messageType == 2 && !world.field_72995_K) {
                TileEntityCommon tec = here.getTE(TileEntityCommon.class);
                if (tec != null) {
                    this.broadcastPacket(this.getCurrentPlayer(), here, tec.func_70319_e());
                }
                return;
            }
            if (messageType == 1 && world.field_72995_K) {
                FactoryType ft = FactoryType.fromMd(input.readInt());
                byte extraData = input.readByte();
                byte extraData2 = input.readByte();
                try {
                    messageType = input.readInt();
                }
                catch (IOException e) {
                    messageType = -1;
                }
                TileEntityCommon spawn = here.getTE(TileEntityCommon.class);
                if (spawn != null && spawn.getFactoryType() != ft) {
                    world.func_72932_q(x, y, z);
                    spawn = null;
                }
                if (spawn == null) {
                    spawn = ft.makeTileEntity();
                    spawn.field_70331_k = world;
                    world.func_72837_a(x, y, z, (TileEntity)spawn);
                }
                spawn.useExtraInfo(extraData);
                spawn.useExtraInfo2(extraData2);
            }
            if (messageType == -1) {
                return;
            }
            TileEntityCommon tec = here.getTE(TileEntityCommon.class);
            if (tec == null) {
                this.handleForeignMessage(world, x, y, z, tec, messageType, input);
                return;
            }
            boolean handled = here.w.field_72995_K ? tec.handleMessageFromServer(messageType, input) : tec.handleMessageFromClient(messageType, input);
            if (!handled) {
                this.handleForeignMessage(world, x, y, z, tec, messageType, input);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void handleForeignMessage(World world, int x, int y, int z, TileEntity ent, int messageType, DataInputStream input) throws IOException {
        if (world.field_72995_K) {
            Coord here = new Coord(world, x, y, z);
            switch (messageType) {
                case 11: {
                    Sound.receive(input);
                    break;
                }
                case 12: {
                    Block.field_71963_Z.func_71883_b(world, x, y, z, 0, input.readInt());
                    here.setId(0);
                    break;
                }
                default: {
                    if (here.blockExists() && here.getId() != 0) {
                        Core.logFine("Got unhandled message: " + messageType + " for " + here, new Object[0]);
                        break;
                    }
                    Core.logFine("Got message to unloaded chunk: " + messageType + " for " + here, new Object[0]);
                }
            }
        }
    }

    void handleCmd(byte[] data) {
        if (data == null || data.length < 2) {
            return;
        }
        byte s = data[0];
        byte arg = data[1];
        Command.fromNetwork(this.getCurrentPlayer(), s, arg);
    }

    void handleNtfy(DataInputStream input) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            EntityPlayer me = this.getCurrentPlayer();
            if (!me.field_70170_p.field_72995_K) {
                return;
            }
            try {
                Object target = null;
                switch (input.readByte()) {
                    case 0: {
                        int x = input.readInt();
                        int y = input.readInt();
                        int z = input.readInt();
                        target = new Coord(me.field_70170_p, x, y, z);
                        break;
                    }
                    case 2: {
                        int id = input.readInt();
                        if (id == me.field_70157_k) {
                            target = me;
                            break;
                        }
                        target = me.field_70170_p.func_73045_a(id);
                        break;
                    }
                    case 3: {
                        int x = input.readInt();
                        int y = input.readInt();
                        int z = input.readInt();
                        target = me.field_70170_p.func_72796_p(x, y, z);
                        break;
                    }
                    case 1: {
                        target = Vec3.func_72443_a((double)input.readDouble(), (double)input.readDouble(), (double)input.readDouble());
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (target == null) {
                    return;
                }
                NBTTagCompound tag = (NBTTagCompound)NBTBase.func_74739_b((DataInput)input);
                ItemStack item = ItemStack.func_77949_a((NBTTagCompound)tag);
                if (item != null && EMPTY_ITEMSTACK.func_77969_a(item)) {
                    item = null;
                }
                String msg = input.readUTF();
                int argCount = input.readInt();
                String[] args = new String[argCount];
                for (int i = 0; i < argCount; ++i) {
                    args[i] = input.readUTF();
                }
                NotifyImplementation.recieve(me, target, item, msg, args);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void handleEntity(DataInputStream input) {
        try {
            boolean handled;
            World world = this.getCurrentPlayer().field_70170_p;
            int entityId = input.readInt();
            short messageType = input.readShort();
            Entity to = world.func_73045_a(entityId);
            if (to == null) {
                if (Core.dev_environ) {
                    Core.logFine("Packet to unknown entity #%s: %s", entityId, messageType);
                }
                return;
            }
            if (!(to instanceof IEntityMessage)) {
                Core.logFine("Packet to inappropriate entity #%s: %s", entityId, messageType);
                return;
            }
            IEntityMessage iem = (IEntityMessage)to;
            if (Core.debug_network) {
                Core.logFine("EntityNet: " + messageType + "      " + to, new Object[0]);
            }
            if (!(handled = world.field_72995_K ? iem.handleMessageFromServer(messageType, input) : iem.handleMessageFromClient(messageType, input))) {
                Core.logFine("Got unhandled message: " + messageType + " for " + iem, new Object[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ItemStack nullItem(ItemStack is) {
        return is == null ? EMPTY_ITEMSTACK : is;
    }

    public static class NotifyMessageType {
        public static final byte COORD = 0;
        public static final byte VEC3 = 1;
        public static final byte ENTITY = 2;
        public static final byte TILEENTITY = 3;
    }

    public static class MessageType {
        public static final int ShareAll = -1;
        public static final int PlaySound = 11;
        public static final int PistonPush = 12;
        public static final int DrawActive = 0;
        public static final int FactoryType = 1;
        public static final int DescriptionRequest = 2;
        public static final int DataHelperEdit = 3;
        public static final int OpenDataHelperGui = 4;
        public static final int RouterSlot = 20;
        public static final int RouterTargetSide = 21;
        public static final int RouterMatch = 22;
        public static final int RouterIsInput = 23;
        public static final int RouterLastSeen = 24;
        public static final int RouterMatchToVisit = 25;
        public static final int RouterDowngrade = 26;
        public static final int RouterUpgradeState = 27;
        public static final int RouterEjectDirection = 28;
        public static final int BarrelDescription = 40;
        public static final int BarrelItem = 41;
        public static final int BarrelCount = 42;
        public static final int BatteryLevel = 50;
        public static final int LeydenjarLevel = 51;
        public static final int MirrorDescription = 60;
        public static final int TurbineWater = 70;
        public static final int TurbineSpeed = 71;
        public static final int HeaterHeat = 80;
        public static final int GrinderSpeed = 90;
        public static final int LaceratorSpeed = 91;
        public static final int MixerSpeed = 100;
        public static final int CrystallizerInfo = 110;
        public static final int WireFace = 121;
        public static final int SculptDescription = 130;
        public static final int SculptNew = 132;
        public static final int SculptMove = 133;
        public static final int SculptRemove = 134;
        public static final int SculptState = 135;
        public static final int ExtensionInfo = 150;
        public static final int RocketState = 151;
        public static final int ServoRailDecor = 161;
        public static final int ServoRailDecorUpdate = 162;
        public static final int ServoRailEditComment = 163;
        public static final int CompressionCrafter = 163;
        public static final int CompressionCrafterBeginCrafting = 164;
        public static final int CompressionCrafterBounds = 165;
        public static final int servo_brief = 174;
        public static final int servo_item = 175;
        public static final int servo_complete = 176;
        public static final int servo_stopped = 177;
    }
}

