/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import factorization.api.Coord;
import factorization.shared.Core;
import net.minecraft.block.Block;
import net.minecraftforge.common.MinecraftForge;

public enum BlockClass {
    Default(0, true, 0, 0, 1.0f),
    DarkIron(1, true, 0, 0, 3.25f),
    Barrel(2, true, 25, 0, 2.0f),
    Socket(3, false, 0, 0, 3.0f),
    Lamp(4, false, 0, 15, 6.0f),
    MachineDynamicLightable(6, true, 0, 0, 3.0f),
    Machine(7, true, 0, 0, 3.0f),
    MachineLightable(8, true, 0, 13, 3.0f),
    Wire(9, false, 0, 0, 0.25f),
    Ceramic(10, false, 0, 0, 0.75f);

    Block block;
    public final int md;
    final boolean normalCube;
    final int flamability;
    final boolean isFlamable;
    final int lightValue;
    final float hardness;
    boolean normal_cube = true;

    private BlockClass(Block block, int md, boolean normalCube, int flamability, int lightValue, float hardness) {
        this.block = block;
        this.md = md;
        this.normalCube = normalCube;
        this.flamability = flamability;
        this.isFlamable = flamability > 0;
        this.lightValue = lightValue;
        this.hardness = hardness;
        if (Md.map[this.md] != null) {
            throw new RuntimeException("Duplicate BlockProperty metadata ID");
        }
        Md.map[this.md] = this;
    }

    private BlockClass(int md, boolean normalCube, int flamability, int lightValue, float hardness) {
        this((Block)Core.registry.factory_block, md, normalCube, flamability, lightValue, hardness);
    }

    BlockClass setAbnormal() {
        this.normal_cube = false;
        return this;
    }

    static BlockClass get(int md) {
        BlockClass ret = Md.map[md];
        if (ret == null) {
            return Md.map[0];
        }
        return ret;
    }

    public void enforce(Coord c) {
        if (c.getBlock() != this.block || c.setMd(this.md, false)) {
            // empty if block
        }
    }

    void enforceQuiet(Coord c) {
        if (c.getBlock() == this.block) {
            c.setMd(this.md, false);
        }
    }

    public BlockClass harvest(String tool, int level) {
        MinecraftForge.setBlockHarvestLevel((Block)this.block, (int)this.md, (String)tool, (int)level);
        return this;
    }

    boolean isNormal() {
        return this.normal_cube;
    }

    static {
        Wire.setAbnormal();
        Machine.setAbnormal();
        Ceramic.setAbnormal();
    }

    static class Md {
        static BlockClass[] map = new BlockClass[16];

        Md() {
        }
    }
}

