/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class SetDirection
extends Instruction {
    ForgeDirection dir = ForgeDirection.UP;

    @Override
    public Icon getIcon(ForgeDirection side) {
        if (side == ForgeDirection.UNKNOWN) {
            return BlockIcons.servo$set_direction.side_W;
        }
        return BlockIcons.servo$set_direction.get(this.dir.getOpposite(), side);
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        if (SetDirection.playerHasProgrammer(player)) {
            int i = this.dir.ordinal();
            this.dir = ForgeDirection.getOrientation((int)((i + 1) % 6));
            return true;
        }
        return false;
    }

    @Override
    public void motorHit(ServoMotor motor) {
        ForgeDirection d;
        motor.nextDirection = d = this.dir.getOpposite();
        if (d == motor.orientation.facing.getOpposite()) {
            motor.changeOrientation(d);
        }
    }

    @Override
    public String getName() {
        return "fz.instruction.setdirection";
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.dir = data.as(Share.MUTABLE, "dir").putEnum(this.dir);
        return this;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return new ItemStack(Item.field_77704_l);
    }
}

