/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.common.BlockIcons;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class IntegerValue
extends Instruction {
    int val = 1;

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.val = data.asSameShare(prefix + "val").put(this.val);
        return this;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return new ItemStack(Block.field_72002_bp);
    }

    @Override
    public void motorHit(ServoMotor motor) {
        motor.getServoStack(4).push(this.val);
    }

    @Override
    public Icon getIcon(ForgeDirection side) {
        if (this.val == 1) {
            return BlockIcons.servo$one;
        }
        if (this.val == 0) {
            return BlockIcons.servo$zero;
        }
        return BlockIcons.servo$number;
    }

    @Override
    public String getName() {
        return "fz.instruction.integervalue";
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        if (IntegerValue.playerHasProgrammer(player)) {
            if (this.val == 0) {
                this.val = 1;
                return true;
            }
            if (this.val == 1) {
                this.val = 0;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getInfo() {
        return "" + this.val;
    }
}

