/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.common.BlockIcons;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import factorization.servo.TileEntityServoRail;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class EntryControl
extends Instruction {
    public boolean blocking = false;

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.blocking = data.asSameShare("block").putBoolean(this.blocking);
        return this;
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        if (!EntryControl.playerHasProgrammer(player)) {
            return false;
        }
        TileEntityServoRail sr = block.getTE(TileEntityServoRail.class);
        if (sr.priority >= 0) {
            sr.priority = (byte)-1;
            this.blocking = true;
        } else {
            sr.priority = 1;
            this.blocking = false;
        }
        return true;
    }

    @Override
    public void onPlacedOnRail(TileEntityServoRail sr) {
        sr.priority = 1;
        this.blocking = false;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return new ItemStack(Block.field_71993_bv);
    }

    @Override
    public void motorHit(ServoMotor motor) {
    }

    @Override
    public Icon getIcon(ForgeDirection side) {
        return this.blocking ? BlockIcons.servo$entry_forbid : BlockIcons.servo$entry_require;
    }

    @Override
    public String getName() {
        return "fz.instruction.entryControl";
    }
}

