/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.notify.Notify;
import factorization.servo.Decorator;
import factorization.servo.GuiCommentEditor;
import factorization.servo.Instruction;
import factorization.servo.ServoComponent;
import factorization.shared.BlockClass;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.TileEntityCommon;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.management.PlayerInstance;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityServoRail
extends TileEntityCommon
implements IChargeConductor {
    public static final float width = 0.4375f;
    Charge charge = new Charge(this);
    Decorator decoration = null;
    public byte priority = 0;
    String comment = "";
    private String decor_tag_key = "decor";

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SERVORAIL;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Wire;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        return null;
    }

    public void func_70316_g() {
        this.charge.update();
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.charge.writeToNBT(tag);
        tag.func_74774_a("priority", this.priority);
        if (this.decoration != null) {
            NBTTagCompound decor = new NBTTagCompound();
            this.decoration.save(decor);
            tag.func_74782_a(this.decor_tag_key, (NBTBase)decor);
        }
        tag.func_74778_a("rem", this.comment);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.charge.readFromNBT(tag);
        this.priority = tag.func_74771_c("priority");
        this.comment = tag.func_74779_i("rem");
        if (!tag.func_74764_b(this.decor_tag_key)) {
            return;
        }
        NBTTagCompound dtag = tag.func_74775_l(this.decor_tag_key);
        ServoComponent component = ServoComponent.load(dtag);
        if (component instanceof Decorator) {
            this.decoration = (Decorator)component;
        }
    }

    boolean has(ForgeDirection dir) {
        TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + dir.offsetX, this.field_70330_m + dir.offsetY, this.field_70327_n + dir.offsetZ);
        return te instanceof TileEntityServoRail;
    }

    public boolean fillSideInfo(boolean[] sides) {
        boolean any = false;
        for (int i = 0; i < 6; ++i) {
            boolean flag;
            sides[i] = flag = this.has(ForgeDirection.getOrientation((int)i));
            any |= flag;
        }
        return any;
    }

    private boolean getCollisionBoxes(AxisAlignedBB aabb, List list, Entity entity) {
        AxisAlignedBB a;
        float high;
        float low;
        boolean remote = entity != null && entity.field_70170_p != null ? entity.field_70170_p.field_72995_K : FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
        BlockRenderHelper block = remote ? Core.registry.clientTraceHelper : Core.registry.serverTraceHelper;
        boolean[] sides = new boolean[6];
        this.fillSideInfo(sides);
        int count = 0;
        float f = 0.4375f;
        if (sides[0] || sides[1]) {
            ++count;
            low = sides[0] ? 0.0f : f;
            high = sides[1] ? 1.0f : 1.0f - f;
            block.func_71905_a(f, low, f, 1.0f - f, high, 1.0f - f);
            a = block.func_71872_e(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            if (aabb == null || aabb.func_72326_a(a)) {
                list.add(a);
            }
        }
        if (sides[2] || sides[3]) {
            ++count;
            low = sides[2] ? 0.0f : f;
            high = sides[3] ? 1.0f : 1.0f - f;
            block.func_71905_a(f, f, low, 1.0f - f, 1.0f - f, high);
            a = block.func_71872_e(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            if (aabb == null || aabb.func_72326_a(a)) {
                list.add(a);
            }
        }
        if (sides[4] || sides[5]) {
            ++count;
            low = sides[4] ? 0.0f : f;
            high = sides[5] ? 1.0f : 1.0f - f;
            block.func_71905_a(low, f, f, high, 1.0f - f, 1.0f - f);
            a = block.func_71872_e(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            if (aabb == null || aabb.func_72326_a(a)) {
                list.add(a);
            }
        }
        if (count == 0) {
            block.func_71905_a(f, f, f, 1.0f - f, 1.0f - f, 1.0f - f);
            AxisAlignedBB a2 = block.func_71872_e(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            if (aabb == null || aabb.func_72326_a(a2)) {
                list.add(a2);
            }
        }
        return true;
    }

    @Override
    public boolean addCollisionBoxesToList(Block ignore, AxisAlignedBB aabb, List list, Entity entity) {
        if (this.decoration != null && !(this.decoration instanceof Instruction)) {
            float f = this.decoration.getSize();
            boolean remote = entity != null && entity.field_70170_p != null ? entity.field_70170_p.field_72995_K : FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
            BlockRenderHelper block = remote ? Core.registry.clientTraceHelper : Core.registry.serverTraceHelper;
            block.func_71905_a(f, f, f, 1.0f - f, 1.0f - f, 1.0f - f);
            AxisAlignedBB a = block.func_71872_e(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            if (aabb == null || aabb.func_72326_a(a)) {
                list.add(a);
                return true;
            }
        }
        return false;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return null;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(Vec3 startVec, Vec3 endVec) {
        ArrayList boxes = new ArrayList(4);
        this.getCollisionBoxes(null, boxes, null);
        BlockRenderHelper b = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? Core.registry.serverTraceHelper : Core.registry.clientTraceHelper;
        for (AxisAlignedBB ab : boxes) {
            ab = ab.func_72325_c((double)(-this.field_70329_l), (double)(-this.field_70330_m), (double)(-this.field_70327_n));
            float d = 0.0625f;
            b.func_71905_a((float)ab.field_72340_a - d, (float)ab.field_72338_b - d, (float)ab.field_72339_c - d, (float)ab.field_72336_d + d, (float)ab.field_72337_e + d, (float)ab.field_72334_f + d);
            MovingObjectPosition mop = b.func_71878_a(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, startVec, endVec);
            if (mop == null) continue;
            return mop;
        }
        return null;
    }

    @Override
    public void setBlockBounds(Block b) {
        float f = 0.4375f;
        b.func_71905_a(f, f, f, 1.0f - f, 1.0f - f, 1.0f - f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ForgeDirection dir) {
        return BlockIcons.servo$rail;
    }

    public void setDecoration(Decorator newDecor) {
        this.decoration = newDecor;
        if (this.decoration != null) {
            this.decoration.onPlacedOnRail(this);
        }
        this.func_70296_d();
    }

    public Decorator getDecoration() {
        return this.decoration;
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        WorldServer world;
        PlayerInstance playerInstance;
        Coord here = this.getCoord();
        if (this.field_70331_k.field_72995_K) {
            return false;
        }
        boolean ret = false;
        if (this.decoration != null) {
            ret = this.decoration.onClick(entityplayer, here, side);
        }
        if ((playerInstance = (world = (WorldServer)this.field_70331_k).func_73040_p().func_72690_a(this.field_70329_l >> 4, this.field_70327_n >> 4, false)) != null) {
            playerInstance.func_73256_a(this._getDescriptionPacket(true));
        }
        String info = "";
        if (this.decoration != null) {
            info = this.decoration.getInfo();
            String string = info = info == null ? "" : info;
            if (here.isWeaklyPowered()) {
                Notify.withItem(new ItemStack(Block.field_72035_aQ));
                Notify.withStyle(Notify.Style.DRAWITEM);
            }
        }
        if (this.comment.length() > 0) {
            if (info.length() > 0) {
                info = info + "\n";
            }
            info = info + EnumChatFormatting.ITALIC + this.comment;
        }
        if (info.length() > 0) {
            Notify.send(entityplayer, (Object)here, info, new String[0]);
        }
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 161 || messageType == 162) {
            if (messageType == 162) {
                this.getCoord().redraw();
            }
            DataInputStream dis = new DataInputStream(input);
            ServoComponent sc = ServoComponent.readFromPacket(input);
            if (!(sc instanceof Decorator)) {
                return false;
            }
            this.decoration = (Decorator)sc;
            return true;
        }
        if (messageType == 163) {
            this.comment = input.readUTF();
            FMLCommonHandler.instance().showGuiScreen((Object)new GuiCommentEditor(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMessageFromClient(int messageType, DataInputStream input) throws IOException {
        if (messageType == 163) {
            this.comment = input.readUTF();
            return true;
        }
        return super.handleMessageFromClient(messageType, input);
    }

    @Override
    public Packet func_70319_e() {
        return this._getDescriptionPacket(false);
    }

    public Packet _getDescriptionPacket(boolean with_update) {
        if (this.decoration == null) {
            return super.func_70319_e();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            this.decoration.writeToPacket(dos);
        }
        catch (Exception e) {
            Core.logWarning("Component packet error at %s %s:", this, this.getCoord());
            e.printStackTrace();
            this.decoration = null;
            Notify.withStyle(Notify.Style.FORCE, Notify.Style.LONG);
            Notify.send(null, (Object)this.getCoord(), "Component packet error!\nSee console log.", new String[0]);
            return super.func_70319_e();
        }
        return this.getDescriptionPacketWith(with_update ? 162 : 161, baos.toByteArray());
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return false;
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        if (this.decoration == null) {
            return;
        }
        if (!this.decoration.isFreeToPlace()) {
            this.getCoord().spawnItem(this.decoration.toItem());
        }
    }

    @Override
    public ItemStack getPickedBlock() {
        Decorator decoration = this.getDecoration();
        if (decoration != null) {
            return decoration.toItem();
        }
        return this.getDroppedBlock();
    }
}

