/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.ItemData;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.TileEntityFactorization;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;
import org.bouncycastle.util.Arrays;

public class TileEntityParaSieve
extends TileEntityFactorization
implements ISidedInventory {
    public ItemStack[] filters = new ItemStack[8];
    private boolean putting_nbt = false;
    private byte redstone_cache = (byte)-1;
    static short[] itemId2modIndex = new short[Item.field_77698_e.length];
    TileEntity cached_te = null;
    Entity cached_ent = null;
    static Coord hereCache = new Coord(null, 0, 0, 0);
    private byte self_recursion = 0;
    private static ThreadLocal<Integer> stack_recursion = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    AxisAlignedBB target_area = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);

    void dirtyCache() {
        this.cached_te = null;
        this.cached_ent = null;
    }

    public TileEntityParaSieve() {
        this.facing_direction = (byte)2;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.PARASIEVE;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.putting_nbt = true;
        this.writeSlotsToNBT(tag);
        this.putting_nbt = false;
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.putting_nbt = true;
        this.readSlotsFromNBT(tag);
        this.putting_nbt = false;
    }

    @Override
    public void dropContents() {
        this.putting_nbt = true;
        super.dropContents();
        this.putting_nbt = false;
    }

    public ForgeDirection getFacing() {
        return ForgeDirection.getOrientation((int)this.facing_direction).getOpposite();
    }

    @Override
    protected boolean canFaceVert() {
        return true;
    }

    private boolean isPowered() {
        if (this.redstone_cache == -1) {
            hereCache.set(this);
            this.redstone_cache = (byte)(hereCache.isPowered() ? 1 : 0);
        }
        return this.redstone_cache == 1;
    }

    @Override
    public void neighborChanged() {
        this.redstone_cache = (byte)-1;
        this.dirtyCache();
    }

    static boolean itemInRange(ItemStack a, ItemStack b, ItemStack stranger) {
        if (stranger == null) {
            return false;
        }
        if (a == null || b == null) {
            if (a != null) {
                return FzUtil.couldMerge(a, stranger);
            }
            if (b != null) {
                return FzUtil.couldMerge(b, stranger);
            }
            return false;
        }
        if (a.field_77993_c != b.field_77993_c) {
            short aId = itemId2modIndex[a.field_77993_c];
            short bId = itemId2modIndex[b.field_77993_c];
            if (aId == bId && aId != 0) {
                return itemId2modIndex[stranger.field_77993_c] == aId;
            }
            Class<?> ca = a.func_77973_b().getClass();
            Class<?> cb = b.func_77973_b().getClass();
            Class<?> c_stranger = stranger.func_77973_b().getClass();
            if (ca == cb) {
                return ca == c_stranger;
            }
            String na = ca.getName();
            String nb = cb.getName();
            String n_stranger = c_stranger.getName();
            int end = Math.min(na.length(), nb.length());
            int end_stranger = n_stranger.length();
            for (int i = 0; i < end; ++i) {
                char y;
                char x = na.charAt(i);
                if (x == (y = nb.charAt(i))) {
                    if (end_stranger > i && n_stranger.charAt(i) == x) continue;
                    return false;
                }
                return true;
            }
            return true;
        }
        if (a.field_77993_c != stranger.field_77993_c) {
            return false;
        }
        int mda = a.func_77960_j();
        int mdb = b.func_77960_j();
        int md_stranger = stranger.func_77960_j();
        if (a.func_77942_o() == b.func_77942_o() && (a.func_77942_o() ? !a.func_77978_p().equals((Object)stranger.func_77978_p()) : stranger.func_77942_o())) {
            return false;
        }
        if (mda < mdb) {
            return mda <= md_stranger && md_stranger <= mdb;
        }
        if (mda > mdb) {
            return mda >= md_stranger && md_stranger >= mdb;
        }
        return mda == md_stranger;
    }

    boolean itemPassesFilter(ItemStack stranger) {
        boolean empty = true;
        boolean p = this.isPowered();
        for (int i = 0; i < this.filters.length; i += 2) {
            ItemStack a = this.filters[i];
            ItemStack b = this.filters[i + 1];
            if (a == null && b == null) continue;
            empty = false;
            if (!TileEntityParaSieve.itemInRange(a, b, stranger)) continue;
            return true ^ p;
        }
        return empty ^ p;
    }

    protected boolean _beginRecursion() {
        int sr = stack_recursion.get() + 1;
        stack_recursion.set(sr);
        this.self_recursion = (byte)(this.self_recursion + 1);
        return this.self_recursion > 1 || sr > 6;
    }

    protected void endRecursion() {
        this.self_recursion = (byte)Math.max(0, this.self_recursion - 1);
        int sr = stack_recursion.get();
        stack_recursion.set(Math.max(0, sr - 1));
    }

    AxisAlignedBB getTargetArea() {
        ForgeDirection f = this.getFacing();
        this.target_area.field_72340_a = this.field_70329_l + f.offsetX;
        this.target_area.field_72338_b = this.field_70330_m + f.offsetY;
        this.target_area.field_72339_c = this.field_70327_n + f.offsetZ;
        this.target_area.field_72336_d = this.target_area.field_72340_a + 1.0;
        this.target_area.field_72337_e = this.target_area.field_72338_b + 1.0;
        this.target_area.field_72334_f = this.target_area.field_72339_c + 1.0;
        return this.target_area;
    }

    boolean isEntityInRange(Entity ent) {
        if (ent == null) {
            return false;
        }
        return ent.func_70046_E().func_72326_a(this.getTargetArea());
    }

    IInventory getRecursiveTarget() {
        if (this._beginRecursion() || this.putting_nbt || this.field_70331_k == null || this.field_70331_k.field_72995_K) {
            return null;
        }
        ForgeDirection facing = this.getFacing();
        if (facing == ForgeDirection.UNKNOWN) {
            return null;
        }
        if (this.cached_te != null) {
            if (!this.cached_te.func_70320_p()) {
                return FzUtil.openDoubleChest((IInventory)this.cached_te, true);
            }
            this.cached_te = null;
        } else if (this.cached_ent != null) {
            if (!this.cached_ent.field_70128_L && this.cached_ent.field_70121_D.func_72326_a(this.getTargetArea())) {
                return (IInventory)this.cached_ent;
            }
            this.cached_ent = null;
        }
        TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + facing.offsetX, this.field_70330_m + facing.offsetY, this.field_70327_n + facing.offsetZ);
        if (te instanceof IInventory) {
            this.cached_te = te;
            return FzUtil.openDoubleChest((IInventory)te, true);
        }
        for (Entity ent : this.field_70331_k.func_72872_a(IInventory.class, this.getTargetArea())) {
            if (!(ent instanceof IInventory)) continue;
            this.cached_ent = ent;
            return (IInventory)ent;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int func_70302_i_() {
        if (this.putting_nbt) {
            return this.filters.length;
        }
        try {
            IInventory target = this.getRecursiveTarget();
            if (target == null) {
                int n = this.filters.length;
                return n;
            }
            int n = this.filters.length + target.func_70302_i_();
            return n;
        }
        finally {
            this.endRecursion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70301_a(int i) {
        if (i < this.filters.length) {
            return this.filters[i];
        }
        try {
            IInventory target = this.getRecursiveTarget();
            if (target == null) {
                ItemStack itemStack = null;
                return itemStack;
            }
            ItemStack itemStack = target.func_70301_a(i - this.filters.length);
            return itemStack;
        }
        finally {
            this.endRecursion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70299_a(int i, ItemStack itemstack) {
        if (i < this.filters.length) {
            this.filters[i] = itemstack;
            return;
        }
        try {
            IInventory target = this.getRecursiveTarget();
            if (target == null) {
                return;
            }
            target.func_70299_a(i - this.filters.length, itemstack);
        }
        finally {
            this.endRecursion();
        }
    }

    public String func_70303_b() {
        return "Parasieve";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (i < this.filters.length) {
            return true;
        }
        try {
            IInventory target = this.getRecursiveTarget();
            if (target == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = target.func_94041_b(i - this.filters.length, itemstack) && this.itemPassesFilter(itemstack);
            return bl;
        }
        finally {
            this.endRecursion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] func_94128_d(int side) {
        try {
            IInventory target = this.getRecursiveTarget();
            if (target == null) {
                int[] nArray = new int[]{};
                return nArray;
            }
            side = this.facing_direction;
            if (target instanceof ISidedInventory) {
                int[] ret = Arrays.clone((int[])((ISidedInventory)target).func_94128_d(side));
                int i22 = 0;
                while (i22 < ret.length) {
                    int n = i22++;
                    ret[n] = ret[n] + this.filters.length;
                }
                int[] i22 = ret;
                return i22;
            }
            int len = target.func_70302_i_();
            int[] ret = new int[len];
            for (int i = 0; i < len; ++i) {
                ret[i] = i + this.filters.length;
            }
            int[] nArray = ret;
            return nArray;
        }
        finally {
            this.endRecursion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        if (slot < this.filters.length) {
            return true;
        }
        try {
            IInventory target = this.getRecursiveTarget();
            if (target == null) {
                boolean bl = true;
                return bl;
            }
            if (target instanceof ISidedInventory) {
                boolean bl = ((ISidedInventory)target).func_102007_a(slot - this.filters.length, itemstack, this.getFacing().getOpposite().ordinal()) && this.itemPassesFilter(itemstack);
                return bl;
            }
            boolean bl = this.itemPassesFilter(itemstack);
            return bl;
        }
        finally {
            this.endRecursion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        if (slot < this.filters.length) {
            return true;
        }
        try {
            IInventory target = this.getRecursiveTarget();
            if (target == null) {
                boolean bl = true;
                return bl;
            }
            if (target instanceof ISidedInventory) {
                boolean bl = ((ISidedInventory)target).func_102008_b(slot - this.filters.length, itemstack, (int)this.facing_direction) && this.itemPassesFilter(itemstack);
                return bl;
            }
            boolean bl = this.itemPassesFilter(itemstack);
            return bl;
        }
        finally {
            this.endRecursion();
        }
    }

    @Override
    protected void doLogic() {
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ForgeDirection dir) {
        ForgeDirection face = this.getFacing();
        if (dir == face) {
            return BlockIcons.parasieve_front;
        }
        if (dir == face.getOpposite()) {
            return BlockIcons.parasieve_back;
        }
        return BlockIcons.parasieve_side;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getComparatorValue(ForgeDirection side) {
        try {
            int n;
            int fidx;
            int fidx2;
            if (this._beginRecursion()) {
                int n2 = 11;
                return n2;
            }
            boolean empty = true;
            for (fidx2 = 0; fidx2 < this.filters.length; ++fidx2) {
                if (this.filters[fidx2] == null) continue;
                empty = false;
            }
            if (empty) {
                fidx2 = this.getCoord().add(this.getFacing()).getComparatorOverride(this.getFacing().getOpposite());
                return fidx2;
            }
            FzUtil.FzInv inv = FzUtil.openInventory(this.getCoord().add(this.getFacing()).getTE(IInventory.class), this.getFacing().getOpposite());
            if (inv == null) {
                int n3 = this.getCoord().add(this.getFacing()).getComparatorOverride(this.getFacing().getOpposite());
                return n3;
            }
            int custom_val = 0;
            for (fidx = 0; fidx < this.filters.length; fidx += 2) {
                ItemStack high;
                ItemStack low = this.filters[fidx];
                if (low == null || !FzUtil.identical(low, high = this.filters[fidx + 1])) continue;
                int min = Math.min(low.field_77994_a, high.field_77994_a);
                int max = Math.max(low.field_77994_a, high.field_77994_a);
                int count = 0;
                for (int i = 0; i < inv.size(); ++i) {
                    ItemStack is = inv.get(i);
                    if (!FzUtil.identical(low, is)) continue;
                    count += is.field_77994_a;
                }
                int res = count < min ? 0 : (count > max ? 15 : 1 + 14 * (count - min) / max);
                custom_val = Math.max(custom_val, res);
            }
            if (custom_val >= 15) {
                fidx = 15;
                return fidx;
            }
            int filledSlots = 0;
            float fullness = 0.0f;
            for (int i = 0; i < inv.size(); ++i) {
                ItemStack is = inv.get(i);
                if (is == null || !this.itemPassesFilter(is)) continue;
                ++filledSlots;
                fullness += (float)is.field_77994_a / (float)Math.min(inv.under.func_70297_j_(), is.func_77976_d());
            }
            if (filledSlots == 0) {
                n = custom_val;
                return n;
            }
            n = Math.max(custom_val, MathHelper.func_76141_d((float)((fullness /= (float)inv.size()) * 14.0f)) + 1);
            return n;
        }
        finally {
            this.endRecursion();
        }
    }

    @Override
    public ForgeDirection[] getValidRotations() {
        return full_rotation_array;
    }

    @Override
    public boolean rotate(ForgeDirection axis) {
        this.dirtyCache();
        byte ao = (byte)axis.ordinal();
        if (ao == this.facing_direction) {
            return false;
        }
        this.facing_direction = ao;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_70296_d() {
        super.func_70296_d();
        try {
            IInventory inv = this.getRecursiveTarget();
            if (inv == null) {
                return;
            }
            inv.func_70296_d();
        }
        finally {
            this.endRecursion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNeighborTileChanged(int tilex, int tiley, int tilez) {
        boolean isOurs;
        ForgeDirection facing = this.getFacing();
        boolean bl = isOurs = this.field_70329_l + facing.offsetX == tilex && this.field_70330_m + facing.offsetY == tiley && this.field_70327_n + facing.offsetZ == tilez;
        if (!isOurs) {
            return;
        }
        try {
            IInventory inv = this.getRecursiveTarget();
            if (inv == null) {
                return;
            }
            super.func_70296_d();
        }
        finally {
            this.endRecursion();
        }
    }

    @Override
    public void representYoSelf() {
        super.representYoSelf();
        Core.logFine("[parasieve] Classifying items", new Object[0]);
        HashMap<String, Short> modMap = new HashMap<String, Short>();
        short seen = 1;
        Map dataMap = null;
        try {
            dataMap = (Map)ReflectionHelper.getPrivateValue(GameData.class, null, (String[])new String[]{"idMap"});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Core.logFine("[parasieve] Reflection failed!", new Object[0]);
            return;
        }
        for (Item item : Item.field_77698_e) {
            Short val;
            if (item == null) continue;
            GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Item)item);
            String modName = null;
            if (ui != null) {
                modName = ui.modId;
            }
            if (modName == null && dataMap != null) {
                ItemData id = (ItemData)dataMap.get(item.field_77779_bT);
                modName = id.getModId();
            }
            if (modName == null) {
                modName = "vanilla?";
            }
            if ((val = (Short)modMap.get(modName)) == null) {
                modMap.put(modName, seen);
                val = seen;
                seen = (short)(seen + 1);
            }
            TileEntityParaSieve.itemId2modIndex[item.field_77779_bT] = val;
        }
        Core.logFine("[parasieve] Done", new Object[0]);
    }
}

