/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.servo.Decorator;
import factorization.servo.TileEntityServoRail;
import factorization.shared.BlockRenderHelper;
import factorization.shared.FactorizationBlockRender;
import java.util.Arrays;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class BlockRenderServoRail
extends FactorizationBlockRender {
    Icon[] central = new Icon[6];
    boolean[] sides = new boolean[6];
    BlockRenderHelper block;
    boolean[] extend = new boolean[6];

    void removeTextures(int i, int j) {
        if (!this.world_mode) {
            return;
        }
        if (this.sides[i]) {
            this.block.setTexture(i, null);
        }
        if (this.sides[j]) {
            this.block.setTexture(j, null);
        }
    }

    void restoreTextures(int a, int b) {
        Icon icon = BlockIcons.servo$rail;
        this.block.setTexture(a, icon);
        this.block.setTexture(b, icon);
    }

    @Override
    public void render(RenderBlocks rb) {
        TileEntityServoRail rail = null;
        if (this.world_mode) {
            if (this.te instanceof TileEntityServoRail) {
                rail = (TileEntityServoRail)this.te;
                Decorator dec = rail.decoration;
                if (dec != null) {
                    dec.renderStatic(rail.getCoord(), rb);
                }
            } else {
                return;
            }
        }
        if (rail != null) {
            rail.fillSideInfo(this.sides);
        } else {
            for (int i = 0; i < 6; ++i) {
                this.sides[i] = true;
            }
        }
        Icon icon = BlockIcons.servo$rail;
        this.block = BlockRenderHelper.instance;
        float fL = 0.4375f;
        float fH = 0.5625f;
        this.block.useTexture(null);
        for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
            int i = fd.ordinal();
            this.block.setTexture(i, icon);
            boolean any = false;
            for (ForgeDirection other : ForgeDirection.VALID_DIRECTIONS) {
                if (fd == other || fd == other.getOpposite()) continue;
                int ord = other.ordinal();
                this.extend[ord] = this.sides[ord];
                any |= this.extend[ord];
            }
            this.block.setTexture(i, (Icon)(this.sides[i] && !any ? null : icon));
            this.block.func_71905_a(this.extend[4] ? 0.0f : 0.4375f, this.extend[0] ? 0.0f : 0.4375f, this.extend[2] ? 0.0f : 0.4375f, this.extend[5] ? 1.0f : 0.5625f, this.extend[1] ? 1.0f : 0.5625f, this.extend[3] ? 1.0f : 0.5625f);
            if (this.world_mode) {
                this.block.begin();
                this.block.renderRotated(Tessellator.field_78398_a, this.x, this.y, this.z);
            } else {
                this.block.renderForInventory(rb);
            }
            Arrays.fill(this.extend, false);
            this.block.setTexture(i, null);
        }
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SERVORAIL;
    }
}

