/*
 * Decompiled with CFR 0.152.
 */
package factorization.oreprocessing;

import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.TileEntityFactorization;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileEntitySlagFurnace
extends TileEntityFactorization {
    ItemStack[] furnaceItemStacks = new ItemStack[4];
    public int furnaceBurnTime;
    public int currentFuelItemBurnTime;
    public int furnaceCookTime;
    static final int input = 0;
    static final int fuel = 1;
    static final int output = 2;
    private static final int[] INPUT_s = new int[]{0, 1};
    private static final int[] FUEL_s = new int[]{1};
    private static final int[] OUTPUT_s = new int[]{2, 3};
    boolean prevBurnState = false;

    public int func_70302_i_() {
        return 4;
    }

    @Override
    public Icon getIcon(ForgeDirection dir) {
        if (this.draw_active > 0 && this.facing_direction == dir.ordinal()) {
            return BlockIcons.machine$slag_furnace_face_on;
        }
        return BlockIcons.slag_furnace.get(this, dir);
    }

    public ItemStack func_70301_a(int i) {
        return this.furnaceItemStacks[i];
    }

    public void func_70299_a(int i, ItemStack is) {
        this.furnaceItemStacks[i] = is;
        this.func_70296_d();
    }

    public String func_70303_b() {
        return "Slag Furnace";
    }

    public int[] func_94128_d(int s) {
        ForgeDirection side = ForgeDirection.getOrientation((int)s);
        switch (side) {
            case DOWN: {
                return OUTPUT_s;
            }
            case UP: {
                return INPUT_s;
            }
        }
        return FUEL_s;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        if (slotIndex == 0) {
            return true;
        }
        if (slotIndex == 1) {
            return TileEntityFurnace.func_70401_b((ItemStack)itemstack);
        }
        return false;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SLAGFURNACE;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.MachineLightable;
    }

    @Override
    public void doLogic() {
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.readSlotsFromNBT(tag);
        this.furnaceBurnTime = tag.func_74762_e("burnTime");
        this.furnaceCookTime = tag.func_74762_e("cookTime");
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.writeSlotsToNBT(tag);
        tag.func_74768_a("burnTime", this.furnaceBurnTime);
        tag.func_74768_a("cookTime", this.furnaceCookTime);
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @Override
    public void func_70316_g() {
        boolean burning;
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        boolean invChanged = false;
        if (this.furnaceBurnTime <= 0 && this.canSmelt()) {
            this.currentFuelItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_70398_a((ItemStack)this.furnaceItemStacks[1]) / 2;
            if (this.furnaceBurnTime > 0) {
                invChanged = true;
                if (this.furnaceItemStacks[1] != null) {
                    --this.furnaceItemStacks[1].field_77994_a;
                    if (this.furnaceItemStacks[1].field_77994_a == 0) {
                        this.furnaceItemStacks[1] = this.furnaceItemStacks[1].func_77973_b().getContainerItemStack(this.furnaceItemStacks[1]);
                    }
                }
            }
        }
        if (this.isBurning() && this.canSmelt()) {
            ++this.furnaceCookTime;
            if (this.furnaceCookTime >= 200 || Core.cheat) {
                this.furnaceCookTime = 0;
                this.smeltItem();
                invChanged = true;
            }
        } else {
            this.furnaceCookTime = 0;
        }
        if (this.prevBurnState != (burning = this.isBurning())) {
            this.draw_active = (byte)(burning ? 0 : -1);
            this.drawActive(1);
            this.prevBurnState = burning;
        }
        if (invChanged) {
            this.func_70296_d();
        }
    }

    boolean checkFit(ItemStack output, ItemStack res, int resSize) {
        if (output == null) {
            return true;
        }
        if (!FzUtil.couldMerge(output, res)) {
            return false;
        }
        return output.field_77994_a + resSize <= output.func_77976_d();
    }

    public boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        SmeltingResult res = SlagRecipes.getSlaggingResult(this.furnaceItemStacks[0]);
        if (res == null) {
            return false;
        }
        return this.checkFit(this.furnaceItemStacks[2], res.output1, (int)res.prob1) && this.checkFit(this.furnaceItemStacks[3], res.output2, (int)res.prob2);
    }

    int getRandomSize(float f) {
        int i = (int)f;
        if (f - (float)i > rand.nextFloat()) {
            ++i;
        }
        return i;
    }

    void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        SmeltingResult res = SlagRecipes.getSlaggingResult(this.furnaceItemStacks[0]);
        if (this.furnaceItemStacks[2] == null) {
            this.furnaceItemStacks[2] = ItemStack.func_77944_b((ItemStack)res.output1);
            this.furnaceItemStacks[2].field_77994_a = 0;
        }
        if (this.furnaceItemStacks[3] == null) {
            this.furnaceItemStacks[3] = ItemStack.func_77944_b((ItemStack)res.output2);
            this.furnaceItemStacks[3].field_77994_a = 0;
        }
        ItemStack fo0 = this.furnaceItemStacks[2];
        ItemStack fo1 = this.furnaceItemStacks[3];
        fo0.field_77994_a += this.getRandomSize(res.prob1);
        fo1.field_77994_a += this.getRandomSize(res.prob2);
        if (fo0.field_77994_a > fo0.func_77976_d()) {
            fo0.field_77994_a = fo0.func_77976_d();
        }
        if (fo1.field_77994_a > fo1.func_77976_d()) {
            fo1.field_77994_a = fo1.func_77976_d();
        }
        if (fo0.field_77994_a <= 0) {
            this.furnaceItemStacks[2] = null;
        }
        if (fo1.field_77994_a <= 0) {
            this.furnaceItemStacks[3] = null;
        }
        --this.furnaceItemStacks[0].field_77994_a;
        if (this.furnaceItemStacks[0].field_77994_a == 0) {
            this.furnaceItemStacks[0] = null;
        }
    }

    public int getCookProgressScaled(int par1) {
        return this.furnaceCookTime * par1 / 200;
    }

    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentFuelItemBurnTime == 0) {
            this.currentFuelItemBurnTime = 200;
        }
        return this.furnaceBurnTime * par1 / this.currentFuelItemBurnTime;
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            if (messageType == 0) {
                this.getCoord().updateLight();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean rotate(ForgeDirection axis) {
        if (axis.offsetY != 0) {
            return false;
        }
        byte newd = (byte)axis.ordinal();
        if (newd != this.facing_direction) {
            this.facing_direction = newd;
            return true;
        }
        return false;
    }

    public static class SlagRecipes {
        public static ArrayList<SmeltingResult> smeltingResults = new ArrayList();

        public static void register(Object o_input, float prob1, Object o_output1, float prob2, Object o_output2) {
            ItemStack input = SlagRecipes.obj2is(o_input);
            ItemStack output1 = SlagRecipes.obj2is(o_output1);
            ItemStack output2 = SlagRecipes.obj2is(o_output2);
            input = ItemStack.func_77944_b((ItemStack)input);
            input.field_77994_a = 1;
            SmeltingResult value = new SmeltingResult(input, prob1, output1, prob2, output2);
            smeltingResults.add(value);
        }

        static ItemStack obj2is(Object o) {
            if (o instanceof ItemStack) {
                return (ItemStack)o;
            }
            if (o instanceof Block) {
                Block b = (Block)o;
                return new ItemStack(Item.field_77698_e[b.field_71990_ca]);
            }
            if (o instanceof Item) {
                return new ItemStack((Item)o);
            }
            return null;
        }

        static SmeltingResult getSlaggingResult(ItemStack input) {
            for (SmeltingResult res : smeltingResults) {
                if (!FzUtil.wildcardSimilar(res.input, input)) continue;
                return res;
            }
            return null;
        }
    }

    public static class SmeltingResult {
        public ItemStack input;
        public float prob1;
        public float prob2;
        public ItemStack output1;
        public ItemStack output2;

        SmeltingResult(ItemStack input, float prob1, ItemStack output1, float prob2, ItemStack output2) {
            this.input = input;
            this.prob1 = prob1;
            this.prob2 = prob2;
            this.output1 = output1;
            this.output2 = output2;
        }
    }
}

