/*
 * Decompiled with CFR 0.152.
 */
package factorization.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import factorization.crafting.GuiMixer;
import factorization.crafting.TileEntityMixer;
import factorization.shared.FzUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeMixer
extends TemplateRecipeHandler {
    private ArrayList<TileEntityMixer.RecipeMatchInfo> cache;

    public void loadCraftingRecipes(ItemStack result) {
        for (TileEntityMixer.RecipeMatchInfo mr : this.getCache()) {
            if (result == null) {
                this.arecipes.add(new CachedMixerRecipe(mr));
                continue;
            }
            if (!result.func_77969_a(mr.output)) continue;
            this.arecipes.add(new CachedMixerRecipe(mr));
        }
    }

    ArrayList<TileEntityMixer.RecipeMatchInfo> getCache() {
        if (this.cache == null) {
            this.cache = TileEntityMixer.getRecipes();
        }
        return this.cache;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("fz.mixing")) {
            this.loadCraftingRecipes(null);
            return;
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        block0: for (TileEntityMixer.RecipeMatchInfo mr : this.getCache()) {
            if (ingredient == null) {
                this.arecipes.add(new CachedMixerRecipe(mr));
                continue;
            }
            for (Object o : mr.inputs) {
                items.clear();
                if (o instanceof ItemStack) {
                    items.add((ItemStack)o);
                } else if (o instanceof String) {
                    items.addAll(OreDictionary.getOres((String)((String)o)));
                } else if (o instanceof List) {
                    items.addAll((Collection)o);
                }
                for (ItemStack item : items) {
                    if (!ingredient.func_77969_a(item)) continue;
                    this.arecipes.add(new CachedMixerRecipe(mr));
                    continue block0;
                }
            }
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "fz.mixing", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiMixer.class;
    }

    public String getRecipeName() {
        return "Mixer";
    }

    public String getGuiTexture() {
        return "factorization:textures/gui/mixer.png";
    }

    public String getOverlayIdentifier() {
        return "fz.mixing";
    }

    class CachedMixerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        TileEntityMixer.RecipeMatchInfo recipe;

        public CachedMixerRecipe(TileEntityMixer.RecipeMatchInfo recipe) {
            super((TemplateRecipeHandler)RecipeMixer.this);
            this.recipe = recipe;
        }

        public PositionedStack getResult() {
            return null;
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public ArrayList<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> ret = new ArrayList<PositionedStack>();
            int h = 14;
            int w = 33;
            try {
                switch (this.recipe.inputs.size()) {
                    default: {
                        ret.add(new PositionedStack(this.recipe.inputs.get(3), w + 18, h + 18));
                    }
                    case 3: {
                        ret.add(new PositionedStack(this.recipe.inputs.get(2), w, h + 18));
                    }
                    case 2: {
                        ret.add(new PositionedStack(this.recipe.inputs.get(1), w, h));
                    }
                    case 1: {
                        ret.add(new PositionedStack(this.recipe.inputs.get(0), w + 18, h));
                    }
                    case 0: 
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            w = 107;
            ArrayList<ItemStack> output = new ArrayList<ItemStack>();
            output.add(this.recipe.output);
            for (Object o : this.recipe.inputs) {
                ItemStack cnt;
                ItemStack is;
                if (!(o instanceof ItemStack) || !(is = (ItemStack)o).func_77973_b().func_77634_r() || (cnt = FzUtil.normalize(is.func_77973_b().getContainerItemStack(is))) == null) continue;
                output.add(cnt);
            }
            switch (output.size()) {
                default: {
                    ret.add(new PositionedStack(output.get(3), w + 18, h + 18));
                }
                case 3: {
                    ret.add(new PositionedStack(output.get(2), w, h + 18));
                }
                case 2: {
                    ret.add(new PositionedStack(output.get(1), w + 18, h));
                }
                case 1: {
                    ret.add(new PositionedStack(output.get(0), w, h));
                }
                case 0: 
            }
            return ret;
        }
    }
}

