/*
 * Decompiled with CFR 0.152.
 */
package factorization.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import factorization.oreprocessing.GuiGrinder;
import factorization.oreprocessing.TileEntityGrinder;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class RecipeGrinder
extends TemplateRecipeHandler {
    static final List<PositionedStack> socketBits = Arrays.asList(new PositionedStack((Object)Core.registry.socket_lacerator.func_77946_l(), 69, 24), new PositionedStack((Object)Core.registry.empty_socket_item, 87, 24));

    public void loadCraftingRecipes(ItemStack result) {
        for (TileEntityGrinder.GrinderRecipe gr : TileEntityGrinder.recipes) {
            if (result != null && !result.func_77969_a(gr.output)) continue;
            this.arecipes.add(new CachedGrinderRecipe(gr));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("fz.grinding")) {
            this.loadCraftingRecipes(null);
            return;
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (FzUtil.couldMerge(ingredient, Core.registry.socket_lacerator)) {
            ingredient = null;
        }
        if (FzUtil.couldMerge(ingredient, Core.registry.empty_socket_item)) {
            ingredient = null;
        }
        block0: for (TileEntityGrinder.GrinderRecipe gr : TileEntityGrinder.recipes) {
            if (ingredient == null) {
                this.arecipes.add(new CachedGrinderRecipe(gr));
                continue;
            }
            for (ItemStack is : gr.getInput()) {
                if (!FzUtil.wildcardSimilar(is, ingredient)) continue;
                this.arecipes.add(new CachedGrinderRecipe(gr));
                continue block0;
            }
        }
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        if (stack == null) {
            return currenttip;
        }
        TileEntityGrinder.GrinderRecipe gr = ((CachedGrinderRecipe)((Object)this.arecipes.get((int)recipe))).gr;
        float prob = 0.0f;
        if (gr.output != null && stack.func_77969_a(gr.output)) {
            prob = (float)((stack.field_77994_a - 1) * 100) + gr.probability * 100.0f;
        }
        if (prob != 0.0f) {
            currenttip.add((int)prob + "%");
        }
        for (ItemStack is : gr.getInput()) {
            if (!FzUtil.wildcardSimilar(is, stack)) continue;
            currenttip.add("In a barrel, or as a block");
            break;
        }
        return currenttip;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "fz.grinding", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiGrinder.class;
    }

    public String getRecipeName() {
        return "Lacerator";
    }

    public void drawForeground(int recipe) {
    }

    public void drawBackground(int recipe) {
    }

    public String getGuiTexture() {
        return "unused";
    }

    public String getOverlayIdentifier() {
        return "fz.grinding";
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        return currenttip;
    }

    class CachedGrinderRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        TileEntityGrinder.GrinderRecipe gr;

        CachedGrinderRecipe(TileEntityGrinder.GrinderRecipe gr) {
            super((TemplateRecipeHandler)RecipeGrinder.this);
            this.gr = gr;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.gr.output, 105, 24);
        }

        public PositionedStack getIngredient() {
            return new PositionedStack(this.gr.getInput(), 51, 24);
        }

        public List<PositionedStack> getOtherStacks() {
            return socketBits;
        }
    }
}

