/*
 * Decompiled with CFR 0.152.
 */
package factorization.misc;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.common.FzConfig;
import factorization.misc.LagssieWatchDog;
import factorization.misc.MiscClientCommands;
import factorization.misc.MiscProxy;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.NetLoginHandler;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet1Login;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatFileWriter;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;

public class MiscClientProxy
extends MiscProxy {
    static final Minecraft mc = Minecraft.func_71410_x();
    KeyBinding sprint = new KeyBinding("FZ vanilla sprint", 0);
    static LagssieWatchDog watch_dog = null;

    @Override
    void initializeClient() {
        StatFileWriter sfw = Minecraft.func_71410_x().field_71413_E;
        if (sfw != null && !sfw.func_77443_a(AchievementList.field_76004_f) && !FzConfig.add_branding) {
            sfw.func_77450_a((StatBase)AchievementList.field_76004_f, 1);
            Core.logInfo("Achievement Get! You've opened your inventory hundreds of times already! Yes! You're welcome!", new Object[0]);
        }
        Minecraft.field_71444_a = new byte[0];
        MinecraftForge.EVENT_BUS.register((Object)this);
        NetworkRegistry.instance().registerConnectionHandler(new IConnectionHandler(){

            public void playerLoggedIn(Player player, NetHandler netHandler, INetworkManager manager) {
                MiscClientProxy.this.fixNetherFog((World)MiscClientProxy.mc.field_71441_e);
            }

            public String connectionReceived(NetLoginHandler netHandler, INetworkManager manager) {
                return null;
            }

            public void connectionOpened(NetHandler netClientHandler, MinecraftServer server, INetworkManager manager) {
            }

            public void connectionOpened(NetHandler netClientHandler, String server, int port, INetworkManager manager) {
            }

            public void connectionClosed(INetworkManager manager) {
            }

            public void clientLoggedIn(NetHandler clientHandler, INetworkManager manager, Packet1Login login) {
            }
        });
        ClientCommandHandler.instance.func_71560_a((ICommand)new MiscClientCommands());
    }

    static boolean setFinalField(Field field, Object instance, Object newValue) {
        try {
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(instance, newValue);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    public void fixNetherFog(World world) {
        if (world == null || !world.field_72995_K) {
            return;
        }
        if (world.field_73011_w == null || world.field_73011_w.getClass() != WorldProviderHell.class) {
            return;
        }
        Field provider = ReflectionHelper.findField(World.class, (String[])new String[]{"field_73011_w", "provider"});
        if (provider == null) {
            return;
        }
        WorldProviderHell origProvider = (WorldProviderHell)world.field_73011_w;
        WorldProviderHell myProvider = new WorldProviderHell(){

            @SideOnly(value=Side.CLIENT)
            public boolean func_76568_b(int par1, int par2) {
                int renderDistance = MiscClientProxy.mc.field_71474_y.field_74339_e;
                return renderDistance < 2;
            }
        };
        if (!MiscClientProxy.setFinalField(provider, world, myProvider)) {
            Core.logWarning("[fixNetherFog] Unable to change world.worldProvider", new Object[0]);
        }
        for (Field f : WorldProviderHell.class.getFields()) {
            try {
                f.set(myProvider, f.get(origProvider));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    void registerLoadAlert() {
        Object th = new IScheduledTickHandler(){
            boolean hit = false;
            int count = 0;

            public EnumSet<TickType> ticks() {
                if (this.hit) {
                    return EnumSet.noneOf(TickType.class);
                }
                return EnumSet.of(TickType.CLIENT);
            }

            public void tickStart(EnumSet<TickType> type, Object ... tickData) {
                if (type.contains(TickType.CLIENT)) {
                    if (this.count == 40) {
                        if (MiscClientProxy.mc.field_71462_r instanceof GuiMainMenu) {
                            MiscClientProxy.mc.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
                        }
                        this.hit = true;
                        MiscClientProxy.startLagWatchDog();
                    }
                    ++this.count;
                }
            }

            public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
            }

            public int nextTickSpacing() {
                if (this.hit) {
                    return 100000;
                }
                return 1;
            }

            public String getLabel() {
                return "FZMisc waiting for Main Menu";
            }
        };
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)th, (Side)Side.CLIENT);
        th = new IScheduledTickHandler(){
            boolean wasClicked = false;
            private Minecraft mc = Minecraft.func_71410_x();

            public EnumSet<TickType> ticks() {
                return EnumSet.of(TickType.CLIENT);
            }

            public void tickStart(EnumSet<TickType> type, Object ... tickData) {
                MiscClientCommands.tick();
                if (!this.mc.field_71474_y.field_74322_I.field_74513_e) {
                    this.wasClicked = false;
                    return;
                }
                EntityClientPlayerMP player = this.mc.field_71439_g;
                if (player == null) {
                    return;
                }
                if (player.field_71075_bZ.field_75098_d) {
                    return;
                }
                if (this.mc.field_71462_r != null) {
                    return;
                }
                if (this.wasClicked) {
                    return;
                }
                this.wasClicked = true;
                MovingObjectPosition mop = this.mc.field_71476_x;
                if (mop == null || mop.field_72313_a != EnumMovingObjectType.TILE) {
                    return;
                }
                Coord here = new Coord(player.field_70170_p, mop);
                if (this.vanillaSatisfied(mop, here, (EntityPlayer)player)) {
                    return;
                }
                List<ItemStack> validItems = Arrays.asList(here.getPickBlock(mop), here.getBrokenBlock(), new ItemStack(here.getId(), 1, here.getMd()));
                int firstEmpty = -1;
                if (player.func_70694_bm() == null) {
                    firstEmpty = player.field_71071_by.field_70461_c;
                }
                for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                    for (ItemStack needle : validItems) {
                        if (needle == null) continue;
                        ItemStack is = player.field_71071_by.field_70462_a[i];
                        if (is == null && firstEmpty == -1 && i < 9) {
                            firstEmpty = i;
                        }
                        if (is == null || !FzUtil.couldMerge(needle, is)) continue;
                        if (i < 9) {
                            player.field_71071_by.field_70461_c = i;
                            return;
                        }
                        if (firstEmpty != -1) {
                            player.field_71071_by.field_70461_c = firstEmpty;
                        }
                        int targetSlot = player.field_71071_by.field_70461_c;
                        this.mc.field_71442_b.func_78753_a(player.field_71069_bz.field_75152_c, i, targetSlot, 2, (EntityPlayer)player);
                        return;
                    }
                }
            }

            public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
            }

            private boolean vanillaSatisfied(MovingObjectPosition mop, Coord here, EntityPlayer player) {
                ItemStack held = player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c);
                if (held == null) {
                    return false;
                }
                if (FzUtil.couldMerge(held, here.getPickBlock(mop))) {
                    return true;
                }
                return FzUtil.couldMerge(held, here.getBrokenBlock());
            }

            public String getLabel() {
                return "FZMisc PickBlock helper";
            }

            public int nextTickSpacing() {
                return 1;
            }
        };
        if (FzConfig.fix_middle_click) {
            TickRegistry.registerTickHandler((ITickHandler)th, (Side)Side.CLIENT);
        }
    }

    @Override
    void registerSprintKey() {
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new KeyBindingRegistry.KeyHandler(new KeyBinding[]{this.sprint}, new boolean[]{true}){

            public String getLabel() {
                return "FZ Sprint (vanilla)";
            }

            public EnumSet<TickType> ticks() {
                return EnumSet.of(TickType.CLIENT);
            }

            public void keyUp(EnumSet<TickType> types, KeyBinding kb, boolean tickEnd) {
                this.sprint(false);
            }

            public void keyDown(EnumSet<TickType> types, KeyBinding kb, boolean tickEnd, boolean isRepeat) {
                this.sprint(true);
            }

            void sprint(boolean state) {
                if (MiscClientProxy.mc.field_71462_r != null) {
                    return;
                }
                if (MiscClientProxy.mc.field_71439_g == null) {
                    return;
                }
                if (MiscClientProxy.this.sprint.field_74512_d == 0) {
                    return;
                }
                if (!MiscClientProxy.mc.field_71439_g.func_70093_af() && MiscClientProxy.mc.field_71439_g.func_70051_ag() != state) {
                    MiscClientProxy.mc.field_71439_g.func_70031_b(state);
                }
                MiscClientProxy.mc.field_71474_y.field_74351_w.field_74513_e = state;
            }
        });
    }

    @Override
    void handleTpsReport(float newTps) {
        if (Float.isInfinite(newTps) || Float.isNaN(newTps)) {
            return;
        }
        if (!FzConfig.use_tps_reports) {
            return;
        }
        MiscClientProxy.mc.field_71428_T.field_74278_d = newTps = Math.min(1.5f, Math.max(FzConfig.lowest_dilation, newTps));
    }

    static void startLagWatchDog() {
        if (FzConfig.lagssie_watcher) {
            watch_dog = new LagssieWatchDog(Thread.currentThread(), FzConfig.lagssie_interval);
            Thread dog = new Thread(watch_dog);
            dog.setDaemon(true);
            dog.start();
        }
    }
}

