/*
 * Decompiled with CFR 0.152.
 */
package factorization.misc;

import cpw.mods.fml.client.GuiModList;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.common.FzConfig;
import factorization.misc.ExporterTessellator;
import factorization.misc.MiscClientProxy;
import factorization.misc.WireframeTessellator;
import factorization.shared.Core;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.EnumChatFormatting;

public class MiscClientCommands
implements ICommand {
    static final Minecraft mc = Minecraft.func_71410_x();
    static int queued_action = 0;
    static int queue_delay = 0;
    static final int SHOW_MODS_LIST = 1;
    static final int CLEAR_CHAT = 2;

    public int compareTo(ICommand other) {
        return this.func_71517_b().compareTo(other.func_71517_b());
    }

    public int compareTo(Object obj) {
        return this.compareTo((ICommand)obj);
    }

    public String func_71517_b() {
        return "f";
    }

    public List func_71514_a() {
        return null;
    }

    public boolean func_71519_b(ICommandSender player) {
        return true;
    }

    public boolean func_82358_a(String[] astring, int i) {
        return false;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args == null || args.length == 0) {
            args = new String[]{"help"};
        }
        ArrayList<String> better = new ArrayList<String>();
        for (String arg : args) {
            if (arg == null || arg.length() == 0) continue;
            better.add(arg);
        }
        this.runCommand(better);
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/f <subcommand, such as 'help' or 'list'>";
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        try {
            if (args.length == 1) {
                String arg0 = args[0];
                ArrayList<String> availCommands = new ArrayList<String>(50);
                availCommands.addAll(Arrays.asList("0", "1", "2", "3", "4", "+", ""));
                for (Method method : miscCommands.class.getMethods()) {
                    if (method.getDeclaringClass() == Object.class || method.getParameterTypes().length != 0) continue;
                    availCommands.add(method.getName());
                    alias a = method.getAnnotation(alias.class);
                    if (a == null) continue;
                    for (String name2 : a.value()) {
                        availCommands.add(name2);
                    }
                }
                LinkedList<String> ret = new LinkedList<String>();
                for (String name3 : availCommands) {
                    if (!name3.startsWith(arg0)) continue;
                    ret.add(name3);
                }
                return ret;
            }
        }
        catch (Throwable e) {
            Core.logWarning("Wasn't able to do tab completion!", new Object[0]);
            e.printStackTrace();
            return Arrays.asList("tab_completion_failed");
        }
        return new LinkedList();
    }

    void runCommand(List<String> args) {
        try {
            String n;
            if (args == null) {
                args = new ArrayList<String>();
            }
            if (args.size() == 0) {
                args = Arrays.asList("help");
                n = "help";
            } else {
                n = args.get(0);
            }
            int i = MiscClientCommands.mc.field_71474_y.field_74339_e;
            boolean found_number = true;
            if (n.equalsIgnoreCase("+")) {
                ++i;
            } else if (n.equalsIgnoreCase("-")) {
                --i;
            } else {
                try {
                    i = Integer.parseInt(n);
                }
                catch (NumberFormatException e) {
                    found_number = false;
                }
            }
            if (found_number) {
                if (!(mc.func_71356_B() && FzConfig.enable_sketchy_client_commands || i >= 0)) {
                    i = 0;
                }
                if (i > 3) {
                    Minecraft.func_71410_x().field_71474_y.field_74347_j = false;
                }
                if (i > 8) {
                    i = 8;
                }
                MiscClientCommands.mc.field_71474_y.field_74339_e = i;
                return;
            }
            for (Method method : miscCommands.class.getMethods()) {
                if (method.getDeclaringClass() == Object.class || method.getParameterTypes().length != 0) continue;
                if (method.getName().equals(n)) {
                    this.tryCall(method, args);
                    return;
                }
                alias a = method.getAnnotation(alias.class);
                if (a == null) continue;
                for (String an : a.value()) {
                    if (!an.equals(n)) continue;
                    this.tryCall(method, args);
                    return;
                }
            }
            MiscClientCommands.mc.field_71439_g.func_71035_c("Unknown command. Try /f list.");
        }
        catch (Exception e) {
            MiscClientCommands.mc.field_71439_g.func_71035_c("Command failed; see console");
            e.printStackTrace();
        }
    }

    static boolean commandAllowed(Method method) {
        boolean canCheat;
        if (method.getDeclaringClass() == Object.class || method.getParameterTypes().length != 0) {
            return false;
        }
        boolean bl = canCheat = MiscClientCommands.mc.field_71439_g.field_71075_bZ.field_75098_d && mc.func_71356_B();
        if (canCheat) {
            return true;
        }
        if (method.getAnnotation(sketchy.class) != null && !FzConfig.enable_sketchy_client_commands) {
            return false;
        }
        return method.getAnnotation(cheaty.class) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryCall(Method method, List<String> args) {
        if (!MiscClientCommands.commandAllowed(method)) {
            MiscClientCommands.mc.field_71439_g.func_71035_c("That command is disabled");
            return;
        }
        try {
            miscCommands.player = MiscClientCommands.mc.field_71439_g;
            miscCommands.arg0 = args.get(0);
            if (args.size() >= 2) {
                miscCommands.arg1 = args.get(1);
            }
            miscCommands.args = args;
            Object ret = method.invoke(null, new Object[0]);
            if (ret != null) {
                MiscClientCommands.mc.field_71439_g.func_71035_c(ret.toString());
            }
        }
        catch (Exception e) {
            MiscClientCommands.mc.field_71439_g.func_71035_c("Caught an exception from command; see console");
            e.printStackTrace();
        }
        finally {
            miscCommands.player = null;
            miscCommands.arg1 = null;
            miscCommands.arg0 = null;
        }
    }

    static void tick() {
        if (queued_action == 0) {
            return;
        }
        if (queue_delay > 0) {
            --queue_delay;
            return;
        }
        switch (queued_action) {
            case 2: {
                ArrayList cp = new ArrayList();
                cp.addAll(MiscClientCommands.mc.field_71456_v.func_73827_b().func_73756_b());
                MiscClientCommands.mc.field_71456_v.func_73827_b().func_73761_a();
                MiscClientCommands.mc.field_71456_v.func_73827_b().func_73756_b().addAll(cp);
                break;
            }
            case 1: {
                mc.func_71373_a((GuiScreen)new GuiModList(null));
            }
        }
        queued_action = 0;
    }

    public static class miscCommands {
        static EntityClientPlayerMP player;
        static String arg0;
        static String arg1;
        static List<String> args;
        static Tessellator orig;
        static Map backup;
        static Map empty;

        @alias(value={"date", "time"})
        @help(value="Show the real-world time")
        public static String now() {
            return Calendar.getInstance().getTime().toString();
        }

        @alias(value={"help", "?"})
        public static void about() {
            player.func_71035_c("Miscellaneous Client Commands; from Factorization, by neptunepink");
            player.func_71035_c("Use /f list go see the sub-commands.");
        }

        @help(value="Lists available subcommands. Can also search the list.")
        public static void list() {
            String em = "" + EnumChatFormatting.GREEN;
            for (Method method : miscCommands.class.getMethods()) {
                help h;
                if (!MiscClientCommands.commandAllowed(method)) continue;
                String msg = em + method.getName() + EnumChatFormatting.RESET;
                alias a = method.getAnnotation(alias.class);
                if (a != null) {
                    for (String v : a.value()) {
                        msg = msg + ", " + em + v + EnumChatFormatting.RESET;
                    }
                }
                if ((h = method.getAnnotation(help.class)) != null) {
                    msg = msg + ": " + h.value();
                }
                if (method.getAnnotation(sketchy.class) != null) {
                    msg = msg + EnumChatFormatting.DARK_GRAY + " [SKETCHY]";
                }
                if (method.getAnnotation(cheaty.class) != null) {
                    msg = msg + EnumChatFormatting.RED + " [CHEATY]";
                }
                if (arg1 != null && arg1.length() != 0 && !msg.contains(arg1)) continue;
                player.func_71035_c(msg);
            }
            String msg = "";
            boolean first = true;
            for (String v : new String[]{"0", "1", "2", "3", "4", "+", "-"}) {
                if (!first) {
                    msg = msg + ", ";
                }
                first = false;
                msg = msg + em + v + EnumChatFormatting.RESET;
            }
            msg = msg + ": Changes the fog";
            if (arg1 == null || arg1.length() == 0 || msg.contains(arg1)) {
                player.func_71035_c(msg);
            }
        }

        @alias(value={"cl"})
        @help(value="Erases the chat window")
        public static void clear() {
            queued_action = 2;
        }

        @sketchy
        @help(value="Reveals your coordinates in-chat")
        public static void saycoords() {
            player.func_71165_d("/me is at " + (int)miscCommands.player.field_70165_t + ", " + (int)miscCommands.player.field_70163_u + ", " + (int)miscCommands.player.field_70161_v + " in dimension " + miscCommands.player.field_70170_p.field_73011_w.field_76574_g);
        }

        @alias(value={"ss"})
        @help(value="Saves game settings. (Vanilla seems to need help with this.)")
        public static String savesettings() {
            MiscClientCommands.mc.field_71474_y.func_74303_b();
            return "Saved settings";
        }

        @alias(value={"render_everything_lagfest"})
        @help(value="Render a ton of terrain at once (may lock your game up for a while)")
        public static void render_above() {
            Object wr_list = ReflectionHelper.getPrivateValue(RenderGlobal.class, (Object)MiscClientCommands.mc.field_71438_f, (String[])new String[]{"field_72768_k", "sortedWorldRenderers"});
            if (!(wr_list instanceof WorldRenderer[])) {
                MiscClientCommands.mc.field_71439_g.func_71035_c("Reflection failed");
                return;
            }
            WorldRenderer[] lizt = (WorldRenderer[])wr_list;
            int did = 0;
            int total = 0;
            boolean lagfest = arg0.contains("lagfest");
            for (WorldRenderer wr : lizt) {
                ++total;
                if (!wr.field_78939_q || !((double)(wr.field_78920_d - 48) > MiscClientCommands.mc.field_71439_g.field_70163_u && (double)wr.field_78920_d < MiscClientCommands.mc.field_71439_g.field_70163_u + 128.0) && !lagfest) continue;
                wr.func_78907_a();
                wr.field_78939_q = false;
                ++did;
            }
            player.func_71035_c("Rendered " + did + " chunks out of " + total);
        }

        @alias(value={"c"})
        @help(value="Switch between creative and survival mode")
        public static void creative() {
            player.func_71165_d("/gamemode " + (miscCommands.player.field_71075_bZ.field_75098_d ? 0 : 1));
        }

        @alias(value={"n", "makenice"})
        @help(value="Makes it a sunny morning")
        public static void nice() {
            double angle;
            if (miscCommands.player.field_70170_p.func_72896_J()) {
                player.func_71165_d("/weather clear");
            }
            if ((angle = (double)(miscCommands.player.field_70170_p.func_72826_c(0.0f) % 360.0f)) < 45.0 || angle > 135.0) {
                player.func_71165_d("/time set 1200");
            }
            miscCommands.clear();
            queue_delay = 10;
        }

        @help(value="Shows the mods screen")
        @SideOnly(value=Side.CLIENT)
        public static void mods() {
            queued_action = 1;
        }

        @cheaty
        @alias(value={"neo", "deneo", "deninja"})
        @help(value="Makes the world run slowly (single-player client-side only). Can specify custom timerSpeed.")
        public static String ninja() {
            if (mc.func_71356_B()) {
                float tps;
                if (arg0.startsWith("de")) {
                    tps = 1.0f;
                } else {
                    tps = 0.5f;
                    try {
                        tps = Float.parseFloat(arg1);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                tps = Math.max(0.1f, tps);
                MiscClientCommands.mc.field_71428_T.field_74278_d = tps = Math.min(1.0f, tps);
                if (arg0.contains("neo")) {
                    if (tps == 1.0f) {
                        return "Go back to sleep, Neo.";
                    }
                    return "Wake up, Neo.";
                }
            }
            return null;
        }

        @help(value="Sets the watchdog waitInterval")
        public static String watchdog() {
            if (MiscClientProxy.watch_dog == null) {
                return "Watchdog disabled. Enable in config, or use /f startwatchdog";
            }
            if (arg1 == null) {
                return "Usage: /f watchdog [waitInterval=" + MiscClientProxy.watch_dog.sleep_time + "]";
            }
            MiscClientProxy.watch_dog.sleep_time = Double.parseDouble(arg1);
            return "Set waitInterval to " + MiscClientProxy.watch_dog.sleep_time;
        }

        @help(value="Starts the watchdog")
        public static String startwatchdog() {
            if (MiscClientProxy.watch_dog == null) {
                FzConfig.lagssie_watcher = true;
                MiscClientProxy.startLagWatchDog();
                return "Started watchdog.";
            }
            return "Watchdog already running.";
        }

        @alias(value={"td"})
        @help(value="Sets the minimum time dilation (between 0.1 and 1), or disables it (0)")
        public static String timedilation() {
            if (arg1 == null) {
                String msg = "Current time dilation: " + MiscClientCommands.mc.field_71428_T.field_74278_d;
                if (!FzConfig.use_tps_reports) {
                    msg = msg + " ";
                    msg = msg + "(Disabled)";
                }
                return msg;
            }
            float dilation = Float.parseFloat(arg1);
            if (dilation <= 0.0f) {
                FzConfig.use_tps_reports = false;
                return "Time dilation disabled";
            }
            dilation = Math.max(0.1f, dilation);
            FzConfig.lowest_dilation = dilation = Math.min(1.0f, dilation);
            if (!FzConfig.use_tps_reports) {
                FzConfig.use_tps_reports = true;
                return "Enabled time dilation at " + dilation;
            }
            return "Set minimum time dilation to " + dilation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @cheaty
        @SideOnly(value=Side.CLIENT)
        @help(value="Dump chunk to .obj")
        public static String exportChunk() {
            Object wr_list = ReflectionHelper.getPrivateValue(RenderGlobal.class, (Object)MiscClientCommands.mc.field_71438_f, (String[])new String[]{"sortedWorldRenderers", "sortedWorldRenderers"});
            if (!(wr_list instanceof WorldRenderer[])) {
                return "Reflection failed";
            }
            WorldRenderer[] lizt = (WorldRenderer[])wr_list;
            double px = MiscClientCommands.mc.field_71439_g.field_70165_t;
            double py = MiscClientCommands.mc.field_71439_g.field_70163_u;
            double pz = MiscClientCommands.mc.field_71439_g.field_70161_v;
            for (WorldRenderer wr : lizt) {
                if (!((double)wr.field_78918_f < px) || !(px < (double)wr.field_78925_n) || !((double)wr.field_78919_g < py) || !(py < (double)wr.field_78926_o) || !((double)wr.field_78931_h < pz) || !(pz < (double)wr.field_78940_p)) continue;
                Tessellator real_tess = Tessellator.field_78398_a;
                File output = new File("./chunkExport.obj");
                try {
                    ExporterTessellator ex = new ExporterTessellator(output);
                    Tessellator.field_78398_a = ex;
                    wr.func_78914_f();
                    wr.func_78907_a();
                    ex.doneDumping();
                }
                finally {
                    Tessellator.field_78398_a = real_tess;
                }
                return "Written to " + output;
            }
            return "You aren't in a rendering chunk. Remarkable.";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @cheaty
        @help(value="Dump all terrain to a .obj. This can take a while! Watch the console.")
        public static String exportWorld() {
            Object wr_list = ReflectionHelper.getPrivateValue(RenderGlobal.class, (Object)MiscClientCommands.mc.field_71438_f, (String[])new String[]{"sortedWorldRenderers", "sortedWorldRenderers"});
            if (!(wr_list instanceof WorldRenderer[])) {
                return "Reflection failed";
            }
            double maxDist = 256.0;
            if (arg1 != null && arg1 != "") {
                maxDist = Double.parseDouble(arg1);
            }
            WorldRenderer[] lizt = (WorldRenderer[])wr_list;
            Tessellator real_tess = Tessellator.field_78398_a;
            File output = new File("./worldExport.obj");
            try {
                ExporterTessellator ex = new ExporterTessellator(output);
                Tessellator.field_78398_a = ex;
                int total = lizt.length;
                double px = MiscClientCommands.mc.field_71439_g.field_70165_t;
                double py = MiscClientCommands.mc.field_71439_g.field_70163_u;
                double pz = MiscClientCommands.mc.field_71439_g.field_70161_v;
                int skipped = 0;
                for (int i = 0; i < lizt.length; ++i) {
                    WorldRenderer wr = lizt[i];
                    double dx = (double)wr.field_78923_c - px;
                    double dy = (double)wr.field_78920_d - py;
                    double dz = (double)wr.field_78921_e - pz;
                    double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    if (dist > maxDist) {
                        ++skipped;
                        continue;
                    }
                    System.out.println("Writing chunk " + i + "/" + total + " at " + wr.field_78923_c + " " + wr.field_78920_d + " " + wr.field_78921_e);
                    wr.func_78914_f();
                    wr.func_78907_a();
                }
                System.out.println("Skipped " + skipped + " chunks");
                ex.doneDumping();
            }
            finally {
                Tessellator.field_78398_a = real_tess;
            }
            return "Done!";
        }

        @cheaty
        @help(value="Re-renders the chunk as a wireframe")
        public static String wireframe() {
            Object wr_list = ReflectionHelper.getPrivateValue(RenderGlobal.class, (Object)MiscClientCommands.mc.field_71438_f, (String[])new String[]{"sortedWorldRenderers", "sortedWorldRenderers"});
            if (!(wr_list instanceof WorldRenderer[])) {
                return "Reflection failed";
            }
            WorldRenderer[] lizt = (WorldRenderer[])wr_list;
            double px = MiscClientCommands.mc.field_71439_g.field_70165_t;
            double py = MiscClientCommands.mc.field_71439_g.field_70163_u;
            double pz = MiscClientCommands.mc.field_71439_g.field_70161_v;
            for (WorldRenderer wr : lizt) {
                if (!((double)wr.field_78918_f < px) || !(px < (double)wr.field_78925_n) || !((double)wr.field_78919_g < py) || !(py < (double)wr.field_78926_o) || !((double)wr.field_78931_h < pz) || !(pz < (double)wr.field_78940_p)) continue;
                Tessellator real_tess = Tessellator.field_78398_a;
                Tessellator.field_78398_a = new WireframeTessellator();
                wr.func_78914_f();
                wr.func_78907_a();
                Tessellator.field_78398_a = real_tess;
                return null;
            }
            return "You aren't in a rendering chunk. Remarkable.";
        }

        @cheaty
        @help(value="Render all the things with a wireframe")
        public static String wireframeGlobal() {
            if (orig == null) {
                orig = Tessellator.field_78398_a;
                Tessellator.field_78398_a = new WireframeTessellator();
                return "Run the command again to disable. Note that some effects may persist until MC is restarted.";
            }
            Tessellator.field_78398_a = orig;
            orig = null;
            return "Restored normal Tessellator";
        }

        @help(value="Disable or enable TileEntity special renderers")
        public static String tesrtoggle() {
            if (backup == null) {
                if (TileEntityRenderer.field_76963_a.field_76966_m == null) {
                    return "no TESRs!";
                }
                backup = TileEntityRenderer.field_76963_a.field_76966_m;
                TileEntityRenderer.field_76963_a.field_76966_m = empty;
                return "TESRs disabled";
            }
            empty.clear();
            TileEntityRenderer.field_76963_a.field_76966_m = backup;
            backup = null;
            return "TESRs enabled; requires chunk update to restart drawing";
        }

        @help(value="Change how large servo instructions are rendered. (This also has a config option.)")
        public static String servoInstructionSize() {
            FzConfig.large_servo_instructions = !FzConfig.large_servo_instructions;
            return "Servo instruction size toggled; requires a chunk update to redraw.";
        }

        @help(value="Sets doDaylightCycle, doMobSpawning, weather, time")
        public static void setupSterileTestWorld() {
            player.func_71165_d("/gamerule doDaylightCycle false");
            player.func_71165_d("/gamerule doMobSpawning false");
            player.func_71165_d("/weather clear 999999");
            player.func_71165_d("/time set 1200");
        }

        @help(value="Pass an /f command to the server (for Factions)")
        @alias(value={"/f"})
        public static void factions() {
            String cmd = "";
            boolean first = true;
            for (String c : args) {
                if (first) {
                    first = false;
                    cmd = c;
                    continue;
                }
                cmd = cmd + " " + c;
            }
            player.func_71165_d(cmd);
        }

        static {
            orig = null;
            backup = null;
            empty = new HashMap();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface help {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface cheaty {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface sketchy {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface alias {
        public String[] value();
    }
}

