/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;

class Range {
    double lower;
    double upper;
    boolean initialized = false;

    Range() {
    }

    Range(double lower, double upper) {
        this.lower = lower;
        this.upper = upper;
        this.initialized = true;
    }

    boolean intersects(Range other) {
        return !(this.upper < other.lower) && !(other.upper < this.lower);
    }

    void include(Vec3 point, ForgeDirection axis) {
        switch (axis) {
            case EAST: 
            case WEST: {
                this.include(point.field_72450_a);
                break;
            }
            case UP: 
            case DOWN: {
                this.include(point.field_72448_b);
                break;
            }
            case NORTH: 
            case SOUTH: {
                this.include(point.field_72449_c);
                break;
            }
        }
    }

    void include(double point) {
        if (!this.initialized) {
            this.initialized = true;
            this.lower = this.upper = point;
            return;
        }
        this.lower = Math.min(point, this.lower);
        this.upper = Math.max(point, this.upper);
    }

    void reset() {
        this.initialized = false;
        this.lower = 0.0;
        this.upper = 0.0;
    }
}

