/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import factorization.common.FzConfig;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.DseCollider;
import factorization.fzds.DseRayTarget;
import factorization.fzds.FZDSCommand;
import factorization.fzds.HammerInfo;
import factorization.fzds.HammerNet;
import factorization.fzds.HammerProxy;
import factorization.fzds.HammerWorldProvider;
import factorization.fzds.Packet220FzdsWrap;
import factorization.fzds.ShadowWorldAccess;
import factorization.fzds.WeakSet;
import factorization.fzds.api.IDeltaChunk;
import factorization.shared.Core;
import java.io.File;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.NetLoginHandler;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet1Login;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.util.Vec3;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="factorization.dimensionalSlice", name="Factorization Dimensional Slices", version="0.8.29", dependencies="required-after: factorization")
@NetworkMod(clientSideRequired=true, tinyPacketHandler=HammerNet.class)
public class Hammer {
    final String[] Lore = new String[]{"At twilight's end, the shadow's crossed,", "A new world birthed, the elder lost.", "Yet on the morn we wake to find", "That mem'ry left so far behind.", "To deafened ears we ask, unseen,", "\u201cWhich is life and which the dream?\u201d"};
    public static final String modId = "factorization.dimensionalSlice";
    public static final String name = "Factorization Dimensional Slices";
    public static Hammer instance;
    @SidedProxy(clientSide="factorization.fzds.HammerClientProxy", serverSide="factorization.fzds.HammerProxy")
    public static HammerProxy proxy;
    public static boolean enabled;
    public static int dimensionID;
    public static World worldClient;
    public static double DSE_ChunkUpdateRangeSquared;
    public static int fzds_command_channel;
    public static int max_fzds_grab_area;
    static Set<IDeltaChunk> serverSlices;
    static Set<IDeltaChunk> clientSlices;
    private static final EnumSet<TickType> serverTicks;
    static final HammerInfo hammerInfo;
    static final int channelWidth = 800;

    public Hammer() {
        instance = this;
    }

    @Mod.EventHandler
    public void setup(FMLPreInitializationEvent event) {
        event.getModMetadata().parent = "factorization";
        enabled = FzConfig.enable_dimension_slice;
        if (!enabled) {
            return;
        }
        EntityRegistry.registerModEntity(DimensionSliceEntity.class, (String)"fzds", (int)1, (Object)this, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(DseCollider.class, (String)"fzdsC", (int)2, (Object)this, (int)64, (int)80000, (boolean)false);
        dimensionID = FzConfig.dimension_slice_dimid;
        DimensionManager.registerProviderType((int)dimensionID, HammerWorldProvider.class, (boolean)true);
        DimensionManager.registerDimension((int)dimensionID, (int)dimensionID);
        File base = event.getSuggestedConfigurationFile().getParentFile();
        hammerInfo.setConfigFile(new File(base, "hammerChannels.cfg"));
        fzds_command_channel = hammerInfo.makeChannelFor(this, "cmd", fzds_command_channel, -1, "This channel is used for Slices created using the /fzds command");
        Packet.func_73285_a((int)220, (boolean)true, (boolean)true, Packet220FzdsWrap.class);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            proxy.clientInit();
            NetworkRegistry.instance().registerConnectionHandler(new IConnectionHandler(){

                public void playerLoggedIn(Player player, NetHandler netHandler, INetworkManager manager) {
                }

                public String connectionReceived(NetLoginHandler netHandler, INetworkManager manager) {
                    return null;
                }

                public void connectionOpened(NetHandler netClientHandler, MinecraftServer server, INetworkManager manager) {
                }

                public void connectionOpened(NetHandler netClientHandler, String server, int port, INetworkManager manager) {
                }

                public void connectionClosed(INetworkManager manager) {
                    proxy.clientLogout(manager);
                }

                public void clientLoggedIn(NetHandler clientHandler, INetworkManager manager, Packet1Login login) {
                    proxy.clientLogin(clientHandler, manager, login);
                }
            });
            TickRegistry.registerTickHandler((ITickHandler)new ITickHandler(){
                EnumSet<TickType> clientTick = EnumSet.of(TickType.WORLD);

                public EnumSet<TickType> ticks() {
                    return this.clientTick;
                }

                public void tickStart(EnumSet<TickType> type, Object ... tickData) {
                    proxy.checkForWorldChange();
                }

                public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
                    proxy.runShadowTick();
                }

                public String getLabel() {
                    return "FZ Hammer client tick";
                }
            }, (Side)Side.CLIENT);
        }
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new IScheduledTickHandler(){

            public EnumSet<TickType> ticks() {
                return serverTicks;
            }

            public String getLabel() {
                return "FZDS save info";
            }

            public int nextTickSpacing() {
                return 100;
            }

            public void tickStart(EnumSet<TickType> type, Object ... tickData) {
            }

            public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
                hammerInfo.saveCellAllocations();
            }
        }, (Side)Side.SERVER);
        MinecraftForge.EVENT_BUS.register((Object)hammerInfo);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new DseRayTarget.ClickHandler());
        }
    }

    @Mod.EventHandler
    public void serverStartup(FMLServerStartingEvent event) {
        if (!enabled) {
            return;
        }
        event.registerServerCommand((ICommand)new FZDSCommand());
        DimensionManager.initDimension((int)dimensionID);
        assert (DimensionManager.shouldLoadSpawn((int)dimensionID));
        WorldServer hammerWorld = DimensionManager.getWorld((int)dimensionID);
        hammerWorld.func_72954_a((IWorldAccess)new ShadowWorldAccess());
        int view_distance = MinecraftServer.func_71276_C().func_71203_ab().func_72395_o();
        DSE_ChunkUpdateRangeSquared = Math.pow(PlayerManager.func_72686_a((int)view_distance) + 32, 2.0);
    }

    @Mod.EventHandler
    public void saveInfo(FMLServerStoppingEvent event) {
        hammerInfo.saveCellAllocations();
        serverSlices.clear();
        clientSlices.clear();
    }

    public static Vec3 ent2vec(Entity ent) {
        return ent.field_70170_p.func_82732_R().func_72345_a(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        double desired_radius = 8.0;
        if (FzConfig.force_max_entity_radius >= 0 && (double)FzConfig.force_max_entity_radius < desired_radius) {
            desired_radius = FzConfig.force_max_entity_radius;
            Core.logFine("Using %f as FZDS's maximum entity radius; this could cause failure to collide with FZDS entities", new Object[0]);
        }
        if (World.MAX_ENTITY_RADIUS < desired_radius) {
            Core.logFine("Enlarging World.MAX_ENTITY_RADIUS from %f to %f", World.MAX_ENTITY_RADIUS, desired_radius);
            Core.logFine("Please let the author know if this causes problems.", new Object[0]);
            World.MAX_ENTITY_RADIUS = desired_radius;
        } else {
            Core.logFine("World.MAX_ENTITY_RADIUS was already set to %f, which is large enough for our purposes (%f)", World.MAX_ENTITY_RADIUS, desired_radius);
        }
    }

    static {
        worldClient = null;
        DSE_ChunkUpdateRangeSquared = Math.pow(128.0, 2.0);
        fzds_command_channel = 0;
        max_fzds_grab_area = 81920;
        serverSlices = new WeakSet<IDeltaChunk>();
        clientSlices = new WeakSet<IDeltaChunk>();
        serverTicks = EnumSet.of(TickType.SERVER);
        hammerInfo = new HammerInfo();
    }
}

