/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.Quaternion;
import factorization.fzds.DSTeleporter;
import factorization.fzds.DeltaChunk;
import factorization.fzds.DseCollider;
import factorization.fzds.DseRayTarget;
import factorization.fzds.Hammer;
import factorization.fzds.HammerNet;
import factorization.fzds.MetaAxisAlignedBB;
import factorization.fzds.PacketProxyingPlayer;
import factorization.fzds.api.DeltaCapability;
import factorization.fzds.api.IDeltaChunk;
import factorization.fzds.api.IFzdsCustomTeleport;
import factorization.fzds.api.IFzdsEntryControl;
import factorization.shared.Core;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet131MapData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class DimensionSliceEntity
extends IDeltaChunk
implements IFzdsEntryControl,
IEntityAdditionalSpawnData {
    private Coord hammerCell;
    private Coord farCorner;
    Vec3 centerOffset;
    private long capabilities = DeltaCapability.of(DeltaCapability.MOVE, DeltaCapability.COLLIDE, DeltaCapability.DRAG, DeltaCapability.REMOVE_ITEM_ENTITIES);
    AxisAlignedBB realArea = null;
    MetaAxisAlignedBB metaAABB = null;
    private AxisAlignedBB shadowArea = null;
    private AxisAlignedBB shadowCollisionArea = null;
    private AxisAlignedBB realCollisionArea = null;
    private AxisAlignedBB realDragArea = null;
    private boolean needAreaUpdate = true;
    ArrayList<DseCollider> children = null;
    private double last_motion_hash = Double.NaN;
    private Quaternion rotation = new Quaternion();
    private Quaternion rotationalVelocity = new Quaternion();
    private Quaternion last_shared_rotation = new Quaternion();
    private Quaternion last_shared_rotational_velocity = new Quaternion();
    Quaternion prevTickRotation = new Quaternion();
    float scale = 1.0f;
    float opacity = 1.0f;
    Object renderInfo = null;
    PacketProxyingPlayer proxy = null;
    private static final IEntitySelector excludeDseRelatedEntities = new IEntitySelector(){

        public boolean func_82704_a(Entity entity) {
            return entity.getClass() != DseCollider.class && entity.field_70121_D != null;
        }
    };
    private DseRayTarget rayTarget = null;
    private Entity[] raypart = null;
    private boolean rayOutOfDate = true;

    public DimensionSliceEntity(World world) {
        super(world);
        if (world == DeltaChunk.getWorld(world)) {
            this.func_70106_y();
        }
        this.field_70158_ak = true;
        this.field_70121_D.func_72324_b(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public DimensionSliceEntity(World world, Coord lowerCorner, Coord upperCorner) {
        this(world);
        this.setCorners(lowerCorner, upperCorner);
    }

    private void setCorners(Coord lowerCorner, Coord upperCorner) {
        if (lowerCorner.w != DeltaChunk.getWorld(this.field_70170_p)) {
            throw new IllegalArgumentException("My corners are not shadow!");
        }
        Coord.sort(lowerCorner, upperCorner);
        this.hammerCell = lowerCorner;
        this.farCorner = upperCorner;
        DeltaCoord dc = upperCorner.difference(lowerCorner);
        this.centerOffset = Vec3.func_72443_a((double)(dc.x / 2), (double)(dc.y / 2), (double)(dc.z / 2));
    }

    public String toString() {
        return super.toString() + " - from " + this.hammerCell + "  to  " + this.farCorner + "   center at " + this.centerOffset;
    }

    @Override
    public Vec3 real2shadow(Vec3 realVector) {
        Vec3 buffer = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        double diffX = realVector.field_72450_a + this.centerOffset.field_72450_a - this.field_70165_t;
        double diffY = realVector.field_72448_b + this.centerOffset.field_72448_b - this.field_70163_u;
        double diffZ = realVector.field_72449_c + this.centerOffset.field_72449_c - this.field_70161_v;
        buffer.field_72450_a = (double)this.hammerCell.x + diffX;
        buffer.field_72448_b = (double)this.hammerCell.y + diffY;
        buffer.field_72449_c = (double)this.hammerCell.z + diffZ;
        return buffer;
    }

    @Override
    public Vec3 shadow2real(Vec3 shadowVector) {
        Vec3 buffer = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        double diffX = shadowVector.field_72450_a - (double)this.hammerCell.x;
        double diffY = shadowVector.field_72448_b - (double)this.hammerCell.y;
        double diffZ = shadowVector.field_72449_c - (double)this.hammerCell.z;
        buffer.field_72450_a = diffX - this.centerOffset.field_72450_a;
        buffer.field_72448_b = diffY - this.centerOffset.field_72448_b;
        buffer.field_72449_c = diffZ - this.centerOffset.field_72449_c;
        this.rotation.applyRotation(buffer);
        buffer.field_72450_a += this.field_70165_t;
        buffer.field_72448_b += this.field_70163_u;
        buffer.field_72449_c += this.field_70161_v;
        return buffer;
    }

    @Override
    public void shadow2real(Coord c) {
        c.set(this.shadow2real(c.createVector()));
        c.w = this.field_70170_p;
    }

    @Override
    public void real2shadow(Coord c) {
        c.set(this.real2shadow(c.createVector()));
        c.w = DeltaChunk.getWorld(this.field_70170_p);
    }

    @Override
    public Coord getCorner() {
        return this.hammerCell;
    }

    @Override
    public Coord getCenter() {
        return this.hammerCell.center(this.farCorner);
    }

    @Override
    public Coord getFarCorner() {
        return this.farCorner;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public void func_70100_b_(EntityPlayer player) {
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.hammerCell = new Coord(DeltaChunk.getWorld(this.field_70170_p), 0, 0, 0);
        this.farCorner = this.hammerCell.copy();
        this.capabilities = tag.func_74763_f("cap");
        this.rotation = Quaternion.loadFromTag(tag, "r");
        this.rotationalVelocity = Quaternion.loadFromTag(tag, "w");
        this.centerOffset = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        this.centerOffset.field_72450_a = tag.func_74760_g("cox");
        this.centerOffset.field_72448_b = tag.func_74760_g("coy");
        this.centerOffset.field_72449_c = tag.func_74760_g("coz");
        this.hammerCell.readFromNBT("min", tag);
        this.farCorner.readFromNBT("max", tag);
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74772_a("cap", this.capabilities);
        this.rotation.writeToTag(tag, "r");
        this.rotationalVelocity.writeToTag(tag, "w");
        tag.func_74776_a("cox", (float)this.centerOffset.field_72450_a);
        tag.func_74776_a("coy", (float)this.centerOffset.field_72448_b);
        tag.func_74776_a("coz", (float)this.centerOffset.field_72449_c);
        this.hammerCell.writeToNBT("min", tag);
        this.farCorner.writeToNBT("max", tag);
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    private AxisAlignedBB cloneAABB(AxisAlignedBB orig) {
        AxisAlignedBB ret = this.makeAABB();
        ret.func_72328_c(orig);
        return ret;
    }

    private AxisAlignedBB makeAABB() {
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    private AxisAlignedBB offsetAABB(AxisAlignedBB orig, double dx, double dy, double dz) {
        return AxisAlignedBB.func_72330_a((double)(orig.field_72340_a + dx), (double)(orig.field_72338_b + dy), (double)(orig.field_72339_c + dz), (double)(orig.field_72336_d + dx), (double)(orig.field_72337_e + dy), (double)(orig.field_72334_f + dz));
    }

    private void updateRealArea() {
        Coord c = this.hammerCell;
        double odx = this.field_70165_t - (double)c.x - this.centerOffset.field_72450_a;
        double ody = this.field_70163_u - (double)c.y - this.centerOffset.field_72448_b;
        double odz = this.field_70161_v - (double)c.z - this.centerOffset.field_72449_c;
        this.realArea = this.offsetAABB(this.shadowArea, odx, ody, odz);
        this.realCollisionArea = this.offsetAABB(this.shadowCollisionArea, odx, ody, odz);
        this.needAreaUpdate = false;
        if (this.children == null && this.field_70170_p.field_72995_K) {
            this.children = new ArrayList();
        } else if (this.children == null && !this.field_70170_p.field_72995_K) {
            this.children = new ArrayList();
            DeltaCoord size = this.getFarCorner().difference(this.getCorner());
            DeltaCoord half = size.scale(0.5);
            for (int dx = 0; dx <= size.x; dx += 16) {
                for (int dy = 0; dy <= size.y; dy += 16) {
                    for (int dz = 0; dz <= size.z; dz += 16) {
                        DseCollider e = new DseCollider(this, Vec3.func_72443_a((double)(dx - half.x), (double)(dy - half.y), (double)(dz - half.z)));
                        e.func_70030_z();
                        this.field_70170_p.func_72838_d((Entity)e);
                    }
                }
            }
        }
        this.metaAABB = new MetaAxisAlignedBB(this.hammerCell.w, this.shadowArea, Vec3.func_72443_a((double)odx, (double)ody, (double)odz), this.rotation, this.real2shadow(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v)));
        this.metaAABB.setUnderlying(this.realArea);
    }

    private void updateShadowArea() {
        Coord c = this.getCorner();
        Coord d = this.getFarCorner();
        AxisAlignedBB start = null;
        for (int x = c.x; x <= d.x; ++x) {
            for (int y = c.y; y <= d.y; ++y) {
                for (int z = c.z; z <= d.z; ++z) {
                    AxisAlignedBB b;
                    Block block = Block.field_71973_m[c.w.func_72798_a(x, y, z)];
                    if (block == null || (b = block.func_71872_e(c.w, x, y, z)) == null) continue;
                    if (start == null) {
                        start = b;
                        continue;
                    }
                    start.field_72340_a = Math.min(start.field_72340_a, b.field_72340_a);
                    start.field_72338_b = Math.min(start.field_72338_b, b.field_72338_b);
                    start.field_72339_c = Math.min(start.field_72339_c, b.field_72339_c);
                    start.field_72336_d = Math.max(start.field_72336_d, b.field_72336_d);
                    start.field_72337_e = Math.max(start.field_72337_e, b.field_72337_e);
                    start.field_72334_f = Math.max(start.field_72334_f, b.field_72334_f);
                }
            }
        }
        if (start == null) {
            if (this.field_70170_p.field_72995_K) {
                return;
            }
            this.shadowArea = this.makeAABB();
            this.shadowCollisionArea = this.makeAABB();
            this.realArea = this.makeAABB();
            this.realCollisionArea = this.makeAABB();
            return;
        }
        this.shadowArea = this.cloneAABB(start);
        this.shadowCollisionArea = this.shadowArea.func_72314_b(2.0, 2.0, 2.0);
        this.updateRealArea();
    }

    public void blocksChanged(int x, int y, int z) {
        if (this.shadowArea == null) {
            this.needAreaUpdate = true;
            return;
        }
        this.needAreaUpdate |= (double)x < this.shadowArea.field_72340_a || (double)y < this.shadowArea.field_72338_b || (double)z < this.shadowArea.field_72339_c || (double)x > this.shadowArea.field_72336_d || (double)y > this.shadowArea.field_72337_e || (double)z > this.shadowArea.field_72334_f;
    }

    public void func_70107_b(double par1, double par3, double par5) {
        super.func_70107_b(par1, par3, par5);
        this.needAreaUpdate = true;
    }

    boolean updateHashMotion() {
        double hash = this.field_70159_w * 10.0 + this.field_70181_x * 1010.0 + this.field_70179_y * 101010.0;
        if (hash == this.last_motion_hash) {
            return false;
        }
        this.last_motion_hash = hash;
        return true;
    }

    void updateMotion() {
        if (this.field_70159_w == 0.0 && this.field_70181_x == 0.0 && this.field_70179_y == 0.0 && this.rotationalVelocity.isZero()) {
            return;
        }
        if (this.realArea == null || this.metaAABB == null) {
            return;
        }
        if (this.realDragArea == null || this.updateHashMotion() || !this.rotationalVelocity.isZero()) {
            this.realDragArea = this.realArea.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        Quaternion rotation_copy = new Quaternion(this.rotation);
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.rotation.incrMultiply(this.rotationalVelocity);
        this.last_shared_rotation.incrMultiply(this.last_shared_rotational_velocity);
        boolean moved = true;
        if (!this.field_70145_X && this.can(DeltaCapability.COLLIDE)) {
            List collisions = this.field_70170_p.func_72945_a((Entity)this, this.realArea);
            AxisAlignedBB collision = null;
            for (int i = 0; i < collisions.size(); ++i) {
                AxisAlignedBB solid = (AxisAlignedBB)collisions.get(i);
                if (solid == this.metaAABB || !this.metaAABB.func_72326_a(solid)) continue;
                collision = solid;
                break;
            }
            if (collision != null) {
                this.field_70165_t -= this.field_70159_w;
                this.field_70163_u -= this.field_70181_x;
                this.field_70161_v -= this.field_70179_y;
                moved = false;
                this.func_70016_h(0.0, 0.0, 0.0);
                this.rotationalVelocity.update(0.0, 0.0, 0.0, 0.0);
                this.rotation = rotation_copy;
            }
        }
        if (moved && this.can(DeltaCapability.DRAG)) {
            List ents = this.field_70170_p.func_94576_a((Entity)this, (AxisAlignedBB)this.metaAABB, excludeDseRelatedEntities);
            for (int i = 0; i < ents.size(); ++i) {
                Entity e = (Entity)ents.get(i);
                double friction_expansion = -0.01;
                AxisAlignedBB ebb = e.field_70121_D;
                if (ebb == null) continue;
                if (this.field_70181_x > 0.0) {
                    ebb = ebb.func_72314_b(-this.field_70159_w, -this.field_70181_x, -this.field_70179_y);
                }
                if (this.field_70159_w != 0.0 || this.field_70179_y != 0.0) {
                    ebb = ebb.func_72331_e(friction_expansion, friction_expansion, friction_expansion);
                }
                if (!this.metaAABB.func_72326_a(ebb)) continue;
                e.func_70107_b(e.field_70165_t + this.field_70159_w, e.field_70163_u + this.field_70181_x, e.field_70161_v + this.field_70179_y);
                e.field_70169_q += this.field_70159_w;
                e.field_70167_r += this.field_70181_x;
                e.field_70166_s += this.field_70179_y;
                if (this.field_70181_x > 0.0 && e.field_70181_x < this.field_70181_x) {
                    e.field_70181_x = this.field_70181_x;
                    e.field_70143_R += (float)Math.abs(this.field_70181_x - e.field_70181_x);
                }
                e.field_70122_E = true;
            }
            this.updateRealArea();
        }
    }

    void shareRotationInfo() {
        boolean d0 = !this.rotation.isEqual(this.last_shared_rotation);
        boolean d1 = !this.rotationalVelocity.isEqual(this.last_shared_rotational_velocity);
        Packet131MapData toSend = null;
        if (d0 && d1) {
            toSend = HammerNet.makePacket((short)2, this.field_70157_k, this.rotation, this.rotationalVelocity);
            this.last_shared_rotation.update(this.rotation);
            this.last_shared_rotational_velocity.update(this.rotationalVelocity);
        } else if (d0) {
            toSend = HammerNet.makePacket((short)0, this.field_70157_k, this.rotation);
            this.last_shared_rotation.update(this.rotation);
        } else if (d1) {
            toSend = HammerNet.makePacket((short)1, this.field_70157_k, this.rotationalVelocity);
            this.last_shared_rotational_velocity.update(this.rotationalVelocity);
        }
        if (toSend != null) {
            PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)64.0, (int)this.field_71093_bK, toSend);
        }
    }

    void doUpdate() {
        Core.profileStart("init");
        if (this.field_70170_p.field_72995_K) {
            this.prevTickRotation.update(this.rotation);
            this.rayOutOfDate = true;
            if (this.field_70173_aa == 1) {
                DeltaChunk.getSlices(this.field_70170_p).add(this);
            }
        } else if (this.proxy == null && !this.field_70128_L) {
            DeltaChunk.getSlices(this.field_70170_p).add(this);
            this.proxy = new PacketProxyingPlayer(this, DeltaChunk.getServerShadowWorld());
            this.proxy.field_70170_p.func_72838_d((Entity)this.proxy);
            return;
        }
        Core.profileEnd();
        Core.profileStart("updateMotion");
        this.updateMotion();
        Core.profileEnd();
        if (!this.field_70170_p.field_72995_K && this.can(DeltaCapability.ROTATE)) {
            this.shareRotationInfo();
        }
        if (this.needAreaUpdate) {
            Core.profileStart("updateArea");
            this.updateShadowArea();
            Core.profileEnd();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.shadowArea == null) {
                this.updateShadowArea();
            }
            if (this.shadowArea == null) {
                if (this.hammerCell.blockExists() && !this.can(DeltaCapability.EMPTY)) {
                    this.func_70106_y();
                    Core.logFine("%s dying due to empty area", this.toString());
                } else {
                    this.needAreaUpdate = true;
                }
            } else {
                if (this.can(DeltaCapability.TAKE_INTERIOR_ENTITIES)) {
                    this.takeInteriorEntities();
                }
                if (this.can(DeltaCapability.REMOVE_EXTERIOR_ENTITIES)) {
                    this.removeExteriorEntities();
                }
                if (this.can(DeltaCapability.REMOVE_ITEM_ENTITIES)) {
                    this.removeItemEntities();
                }
            }
            if (this.field_70128_L) {
                this.endSlice();
                return;
            }
        }
    }

    public void func_70030_z() {
        Core.profileStart("FZDSEntityTick");
        this.doUpdate();
        Core.profileEnd();
    }

    private void takeInteriorEntities() {
        List realEntities = this.field_70170_p.func_72872_a(Entity.class, this.realArea);
        for (int i = 0; i < realEntities.size(); ++i) {
            Entity ent = (Entity)realEntities.get(i);
            if (ent == this) continue;
            this.takeEntity(ent);
        }
    }

    private void removeExteriorEntities() {
        for (int x = this.hammerCell.x; x <= this.farCorner.x; x += 16) {
            for (int z = this.hammerCell.z; z <= this.farCorner.z; z += 16) {
                if (!this.field_70170_p.func_72899_e(x, 64, z)) continue;
                Chunk chunk = this.field_70170_p.func_72938_d(x, z);
                for (int j = 0; j < chunk.field_76645_j.length; ++j) {
                    List l = chunk.field_76645_j[j];
                    for (int k = 0; k < l.size(); ++k) {
                        AxisAlignedBB bb;
                        Entity ent = (Entity)l.get(k);
                        if (ent.field_70163_u < 0.0 || ent.field_70163_u > (double)this.field_70170_p.func_72940_L() || ent == this || (bb = ent.field_70121_D) == null || this.shadowArea.func_72326_a(bb)) continue;
                        this.ejectEntity(ent);
                    }
                }
            }
        }
    }

    private void removeItemEntities() {
        for (int x = this.hammerCell.x; x <= this.farCorner.x; x += 16) {
            for (int z = this.hammerCell.z; z <= this.farCorner.z; z += 16) {
                if (!this.field_70170_p.func_72899_e(x, 64, z)) continue;
                Chunk chunk = this.field_70170_p.func_72938_d(x, z);
                for (int j = 0; j < chunk.field_76645_j.length; ++j) {
                    List l = chunk.field_76645_j[j];
                    for (int k = 0; k < l.size(); ++k) {
                        Entity ent = (Entity)l.get(k);
                        if (ent.field_70163_u < 0.0 || ent.field_70163_u > (double)this.field_70170_p.func_72940_L() || ent == this || !(ent instanceof EntityItem)) continue;
                        this.ejectEntity(ent);
                    }
                }
            }
        }
    }

    boolean forbidEntityTransfer(Entity ent) {
        return ent.field_71088_bW > 0;
    }

    void takeEntity(Entity ent) {
        if (this.forbidEntityTransfer(ent)) {
            return;
        }
        IFzdsEntryControl ifec = null;
        if (ent instanceof IFzdsEntryControl && !(ifec = (IFzdsEntryControl)ent).canEnter(this)) {
            return;
        }
        World shadowWorld = DeltaChunk.getServerShadowWorld();
        Vec3 newLocation = this.real2shadow(Hammer.ent2vec(ent));
        this.transferEntity(ent, shadowWorld, newLocation);
        if (ifec != null) {
            ifec.onEnter(this);
        }
    }

    void ejectEntity(Entity ent) {
        if (this.forbidEntityTransfer(ent)) {
            return;
        }
        IFzdsEntryControl ifec = null;
        if (ent instanceof IFzdsEntryControl && !(ifec = (IFzdsEntryControl)ent).canExit(this)) {
            return;
        }
        Vec3 newLocation = this.shadow2real(Hammer.ent2vec(ent));
        this.transferEntity(ent, this.field_70170_p, newLocation);
        if (ifec != null) {
            ifec.onExit(this);
        }
    }

    void transferEntity(Entity ent, World newWorld, Vec3 newPosition) {
        if (ent instanceof IFzdsCustomTeleport) {
            ((IFzdsCustomTeleport)ent).transferEntity(this.field_70170_p, newPosition);
            return;
        }
        if (ent instanceof EntityPlayerMP) {
            if (!this.can(DeltaCapability.TRANSFER_PLAYERS)) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)ent;
            MinecraftServer ms = MinecraftServer.func_71276_C();
            ServerConfigurationManager manager = ms.func_71203_ab();
            DSTeleporter tp = new DSTeleporter((WorldServer)newWorld);
            tp.preciseDestination = newPosition;
            manager.transferPlayerToDimension(player, newWorld.field_73011_w.field_76574_g, (Teleporter)tp);
        } else {
            ent.field_70170_p.func_72900_e(ent);
            ent.field_70128_L = false;
            Entity phoenix = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)ent), (World)newWorld);
            if (phoenix == null) {
                return;
            }
            phoenix.func_82141_a(ent, true);
            phoenix.field_71088_bW = phoenix.func_82147_ab();
            ent.field_70128_L = true;
            phoenix.func_70107_b(newPosition.field_72450_a, newPosition.field_72448_b, newPosition.field_72449_c);
            newWorld.func_72838_d(phoenix);
        }
    }

    void endSlice() {
        DeltaChunk.getSlices(this.field_70170_p).remove(this);
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.endSlice();
    }

    public boolean func_70112_a(double distSquared) {
        int s = 128;
        return distSquared < (double)(s * s);
    }

    @Override
    public boolean canEnter(IDeltaChunk dse) {
        return false;
    }

    @Override
    public boolean canExit(IDeltaChunk dse) {
        return true;
    }

    @Override
    public void onEnter(IDeltaChunk dse) {
    }

    @Override
    public void onExit(IDeltaChunk dse) {
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeLong(this.capabilities);
        this.rotation.write(data);
        this.rotationalVelocity.write(data);
        data.writeFloat((float)this.centerOffset.field_72450_a);
        data.writeFloat((float)this.centerOffset.field_72448_b);
        data.writeFloat((float)this.centerOffset.field_72449_c);
        this.hammerCell.writeToStream(data);
        this.farCorner.writeToStream(data);
        if (this.can(DeltaCapability.SCALE)) {
            data.writeFloat(this.scale);
        }
        if (this.can(DeltaCapability.TRANSPARENT)) {
            data.writeFloat(this.opacity);
        }
    }

    public void readSpawnData(ByteArrayDataInput data) {
        try {
            this.capabilities = data.readLong();
            this.rotation = Quaternion.read((DataInput)data);
            this.rotationalVelocity = Quaternion.read((DataInput)data);
            this.centerOffset = Vec3.func_72443_a((double)data.readFloat(), (double)data.readFloat(), (double)data.readFloat());
            this.hammerCell = this.can(DeltaCapability.ORACLE) ? new Coord(this.field_70170_p, 0, 0, 0) : new Coord(DeltaChunk.getClientShadowWorld(), 0, 0, 0);
            this.hammerCell.readFromStream(data);
            this.farCorner = this.hammerCell.copy();
            this.farCorner.readFromStream(data);
            if (this.can(DeltaCapability.SCALE)) {
                this.scale = data.readFloat();
            }
            if (this.can(DeltaCapability.TRANSPARENT)) {
                this.opacity = data.readFloat();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int the_number_three) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public void func_70024_g(double par1, double par3, double par5) {
        super.func_70024_g(par1, par3, par5);
        this.field_70160_al = false;
    }

    @Override
    public boolean can(DeltaCapability cap) {
        return cap.in(this.capabilities);
    }

    @Override
    public DimensionSliceEntity permit(DeltaCapability cap) {
        this.capabilities |= cap.bit;
        if (cap == DeltaCapability.ORACLE) {
            this.forbid(DeltaCapability.COLLIDE);
            this.forbid(DeltaCapability.DRAG);
            this.forbid(DeltaCapability.TAKE_INTERIOR_ENTITIES);
            this.forbid(DeltaCapability.REMOVE_EXTERIOR_ENTITIES);
            this.forbid(DeltaCapability.TRANSFER_PLAYERS);
            this.forbid(DeltaCapability.INTERACT);
            this.forbid(DeltaCapability.BLOCK_PLACE);
            this.forbid(DeltaCapability.BLOCK_MINE);
            this.forbid(DeltaCapability.REMOVE_ITEM_ENTITIES);
            this.forbid(DeltaCapability.REMOVE_ALL_ENTITIES);
            this.permit(DeltaCapability.SCALE);
            this.permit(DeltaCapability.TRANSPARENT);
        }
        return this;
    }

    @Override
    public DimensionSliceEntity forbid(DeltaCapability cap) {
        this.capabilities &= cap.bit ^ 0xFFFFFFFFFFFFFFFFL;
        return this;
    }

    @Override
    public Quaternion getRotation() {
        return this.rotation;
    }

    @Override
    public Quaternion getRotationalVelocity() {
        return this.rotationalVelocity;
    }

    @Override
    public void setRotation(Quaternion r) {
        this.rotation = r;
    }

    @Override
    public void setRotationalVelocity(Quaternion w) {
        this.rotationalVelocity = w;
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public Entity[] func_70021_al() {
        if (!this.field_70170_p.field_72995_K) {
            return null;
        }
        if (!this.can(DeltaCapability.INTERACT)) {
            return null;
        }
        if (this.rayOutOfDate) {
            if (this.raypart == null) {
                this.raypart = new Entity[1];
                this.rayTarget = new DseRayTarget(this);
                this.raypart[0] = this.rayTarget;
            }
            this.rayOutOfDate = false;
            Hammer.proxy.updateRayPosition(this.rayTarget);
        }
        return this.raypart;
    }
}

