/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.Hammer;
import factorization.fzds.TransferLib;
import factorization.fzds.api.IDeltaChunk;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class DeltaChunk {
    private static Vec3 buffer = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private static Coord shadow = new Coord(null, 0, 0, 0);

    static Set<IDeltaChunk> getSlices(World w) {
        if (w == null) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return Hammer.clientSlices;
            }
            return Hammer.serverSlices;
        }
        return w.field_72995_K ? Hammer.clientSlices : Hammer.serverSlices;
    }

    public static World getClientShadowWorld() {
        return Hammer.worldClient;
    }

    public static World getServerShadowWorld() {
        return DimensionManager.getWorld((int)Hammer.dimensionID);
    }

    public static World getClientRealWorld() {
        return Hammer.proxy.getClientRealWorld();
    }

    public static World getWorld(World realWorld) {
        boolean remote = realWorld == null ? FMLCommonHandler.instance().getEffectiveSide().isClient() : realWorld.field_72995_K;
        return remote ? DeltaChunk.getClientShadowWorld() : DeltaChunk.getServerShadowWorld();
    }

    public static IDeltaChunk allocateSlice(World spawnWorld, int channel, DeltaCoord size) {
        Coord base = Hammer.hammerInfo.takeCell(channel, size);
        return new DimensionSliceEntity(spawnWorld, base, base.add(size));
    }

    public static IDeltaChunk findClosest(Entity target, Coord pos) {
        if (target == null) {
            return null;
        }
        IDeltaChunk closest = null;
        double dist = Double.POSITIVE_INFINITY;
        World real_world = DeltaChunk.getClientRealWorld();
        for (IDeltaChunk here : DeltaChunk.getSlices(target.field_70170_p)) {
            if (here.field_70170_p != real_world && !pos.inside(here.getCorner(), here.getFarCorner())) continue;
            if (closest == null) {
                closest = here;
                continue;
            }
            double here_dist = target.func_70068_e((Entity)here);
            if (!(here_dist < dist)) continue;
            dist = here_dist;
            closest = here;
        }
        return closest;
    }

    public static Vec3 shadow2nearestReal(Entity player, double x, double y, double z) {
        IDeltaChunk closest = DeltaChunk.findClosest(player, new Coord(player.field_70170_p, x, y, z));
        if (closest == null) {
            return null;
        }
        DeltaChunk.buffer.field_72450_a = x;
        DeltaChunk.buffer.field_72448_b = y;
        DeltaChunk.buffer.field_72449_c = z;
        Vec3 ret = closest.shadow2real(buffer);
        return ret;
    }

    public static IDeltaChunk makeSlice(int channel, Coord min, Coord max, AreaMap mapper2, final boolean wipeSrc) {
        DeltaCoord size = max.difference(min);
        final IDeltaChunk dse = DeltaChunk.allocateSlice(min.w, channel, size);
        Vec3 vrm = min.centerVec(max);
        dse.field_70165_t = (int)vrm.field_72450_a;
        dse.field_70163_u = (int)vrm.field_72448_b;
        dse.field_70161_v = (int)vrm.field_72449_c;
        mapper2.fillDse(new DseDestination(){

            @Override
            public void include(Coord real) {
                shadow.set(real);
                dse.real2shadow(shadow);
                TransferLib.move(real, shadow, false, true);
            }
        });
        mapper2.fillDse(new DseDestination(){

            @Override
            public void include(Coord real) {
                if (wipeSrc) {
                    TransferLib.rawErase(real);
                }
                shadow.set(real);
                dse.real2shadow(shadow);
                shadow.markBlockForUpdate();
            }
        });
        return dse;
    }

    public static IDeltaChunk construct(Coord min, Coord max) {
        return new DimensionSliceEntity(DeltaChunk.getServerShadowWorld(), min, max);
    }

    public static void paste(IDeltaChunk selected, boolean overwriteDestination) {
        Coord a = new Coord(DeltaChunk.getServerShadowWorld(), 0, 0, 0);
        Coord b = a.copy();
        Vec3 vShadowMin = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Vec3 vShadowMax = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        selected.getCorner().setAsVector(vShadowMin);
        selected.getFarCorner().setAsVector(vShadowMax);
        a.set(vShadowMin);
        b.set(vShadowMax);
        DeltaCoord dc = b.difference(a);
        Coord dest = new Coord(selected);
        Coord c = new Coord(a.w, 0, 0, 0);
        int minX = 0;
        int minY = 0;
        int minZ = 0;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        boolean first = true;
        for (int x = a.x; x <= b.x; ++x) {
            for (int y = a.y; y <= b.y; ++y) {
                for (int z = a.z; z <= b.z; ++z) {
                    c.set(a.w, x, y, z);
                    dest.set(c);
                    selected.shadow2real(dest);
                    TransferLib.move(c, dest, false, overwriteDestination);
                    if (first) {
                        minX = maxX = x;
                        minY = maxY = y;
                        minZ = maxZ = z;
                        first = false;
                        continue;
                    }
                    minX = Math.min(minX, x);
                    minY = Math.min(minY, y);
                    minZ = Math.min(minZ, z);
                    maxX = Math.max(maxX, x);
                    maxY = Math.max(maxY, y);
                    maxZ = Math.max(maxZ, z);
                }
            }
        }
        dest.w.func_72909_d(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static void clear(IDeltaChunk selected) {
        Coord a = new Coord(DeltaChunk.getServerShadowWorld(), 0, 0, 0);
        Coord b = a.copy();
        Vec3 vShadowMin = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Vec3 vShadowMax = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        selected.getCorner().setAsVector(vShadowMin);
        selected.getFarCorner().setAsVector(vShadowMax);
        a.set(vShadowMin);
        b.set(vShadowMax);
        Coord c = new Coord(a.w, 0, 0, 0);
        for (int x = a.x; x < b.x; ++x) {
            for (int y = a.y; y < b.y; ++y) {
                for (int z = a.z; z < b.z; ++z) {
                    c.set(a.w, x, y, z);
                    selected.shadow2real(c);
                    c.markBlockForUpdate();
                }
            }
        }
    }

    public static interface DseDestination {
        public void include(Coord var1);
    }

    public static interface AreaMap {
        public void fillDse(DseDestination var1);
    }
}

