/*
 * Decompiled with CFR 0.152.
 */
package factorization.crafting;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.crafting.CompressionState;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.TileEntityCommon;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityCompressionCrafter
extends TileEntityCommon {
    static ThreadLocal<CompressionState> states = new ThreadLocal();
    ArrayList<ItemStack> buffer = new ArrayList();
    byte progress = 0;
    byte b_facing = (byte)ForgeDirection.UP.ordinal();
    boolean isCrafterRoot = false;
    boolean powered = false;
    public Coord upperCorner;
    public Coord lowerCorner;
    public ForgeDirection craftingAxis = ForgeDirection.UP;

    CompressionState getStateHelper() {
        CompressionState cs = states.get();
        if (cs == null) {
            cs = new CompressionState();
            states.set(cs);
        }
        return cs;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.COMPRESSIONCRAFTER;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.DarkIron;
    }

    public ForgeDirection getFacing() {
        return ForgeDirection.getOrientation((int)this.b_facing);
    }

    public float getProgressPerc() {
        if (this.progress == 0) {
            return 0.0f;
        }
        if (this.progress > 0) {
            return (float)Math.sqrt((float)this.progress / 20.0f);
        }
        return Math.min(1.0f, (float)this.progress * 1.0f / -10.0f);
    }

    public boolean isPrimaryCrafter() {
        return this.isCrafterRoot && this.progress > 0;
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74774_a("prog", this.progress);
        tag.func_74774_a("dir", this.b_facing);
        tag.func_74757_a("root", this.isCrafterRoot);
        tag.func_74757_a("rs", this.powered);
        this.writeBuffer("buff", tag, this.buffer);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.progress = tag.func_74771_c("prog");
        this.b_facing = tag.func_74771_c("dir");
        this.isCrafterRoot = tag.func_74767_n("root");
        this.powered = tag.func_74767_n("rs");
        this.readBuffer("buff", tag, this.buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ForgeDirection dir) {
        ForgeDirection f = this.getFacing();
        if (dir == f) {
            return BlockIcons.compactFace;
        }
        if (dir == f.getOpposite()) {
            return BlockIcons.compactBack;
        }
        return BlockIcons.compactSide;
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side) {
        super.onPlacedBy(player, is, side);
        this.b_facing = (byte)FzUtil.determineOrientation(player);
        this.b_facing = (byte)ForgeDirection.getOrientation((int)this.b_facing).getOpposite().ordinal();
    }

    public void func_70316_g() {
        if (this.progress != 0) {
            byte by = this.progress;
            this.progress = (byte)(by + 1);
            if (by == 20) {
                if (!this.field_70331_k.field_72995_K && this.getFacing() != ForgeDirection.UNKNOWN && this.isCrafterRoot) {
                    boolean signal;
                    this.getStateHelper().craft(false, this);
                    this.isCrafterRoot = false;
                    boolean bl = signal = this.field_70331_k.func_94577_B(this.field_70329_l, this.field_70330_m, this.field_70327_n) > 0;
                    if (!signal) {
                        this.powered = false;
                    }
                } else {
                    this.lowerCorner = null;
                    this.upperCorner = null;
                }
                this.progress = (byte)-10;
            }
        }
        this.dumpBuffer();
    }

    void dumpBuffer() {
        if (this.buffer.isEmpty()) {
            return;
        }
        block0: for (FzUtil.FzInv fz : this.getAdjacentInventories()) {
            if (fz == null) break;
            while (!this.buffer.isEmpty()) {
                ItemStack is = FzUtil.normalize(this.buffer.get(0));
                if (is != null) {
                    is = FzUtil.normalize(fz.push(is));
                }
                if (is != null) continue block0;
                this.buffer.remove(0);
            }
        }
    }

    FzUtil.FzInv[] getAdjacentInventories() {
        FzUtil.FzInv[] ret = new FzUtil.FzInv[30];
        int i = 0;
        Coord me = this.getCoord();
        ForgeDirection facing = this.getFacing();
        ForgeDirection behind = facing.getOpposite();
        for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
            TileEntityCompressionCrafter neighbor;
            if (fd == facing) continue;
            ForgeDirection back = fd.getOpposite();
            Coord sc = me.add(fd);
            IInventory inv = sc.getTE(IInventory.class);
            if (inv != null) {
                ret[i++] = FzUtil.openInventory(inv, back);
                continue;
            }
            if (fd == behind || (neighbor = sc.getTE(TileEntityCompressionCrafter.class)) == null || neighbor.getFacing() != facing) continue;
            for (ForgeDirection nfd : ForgeDirection.VALID_DIRECTIONS) {
                if (nfd == facing || nfd == back) continue;
                Coord sd = sc.add(nfd);
                ForgeDirection newBack = nfd.getOpposite();
                IInventory newInv = sd.getTE(IInventory.class);
                if (newInv == null) continue;
                ret[i++] = FzUtil.openInventory(newInv, newBack);
            }
        }
        return ret;
    }

    @Override
    public void neighborChanged() {
        boolean signal;
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        boolean bl = signal = this.field_70331_k.func_94577_B(this.field_70329_l, this.field_70330_m, this.field_70327_n) > 0;
        if (signal != this.powered && signal && this.progress == 0) {
            this.getStateHelper().craft(true, this);
            this.isCrafterRoot = true;
        }
        this.powered = signal;
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 163) {
            this.b_facing = input.readByte();
            this.progress = input.readByte();
            return true;
        }
        if (messageType == 164) {
            this.progress = 1;
            return true;
        }
        if (messageType == 165) {
            this.upperCorner = new Coord(this.field_70331_k, input.readInt(), input.readInt(), input.readInt());
            this.lowerCorner = new Coord(this.field_70331_k, input.readInt(), input.readInt(), input.readInt());
            this.craftingAxis = ForgeDirection.getOrientation((int)input.readByte());
            Coord.sort(this.lowerCorner, this.upperCorner);
            if (this.lowerCorner.distanceSq(this.upperCorner) > 25) {
                Core.logFine("Server wanted us to render a large area!", new Object[0]);
                this.upperCorner = null;
                this.lowerCorner = null;
            } else {
                this.isCrafterRoot = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public Packet func_70319_e() {
        return this.getDescriptionPacketWith(163, this.b_facing, this.progress);
    }

    void informClient() {
        this.broadcastMessage(null, 164, new Object[0]);
        this.progress = 1;
        this.powered = true;
    }

    TileEntityCompressionCrafter look(ForgeDirection d) {
        TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + d.offsetX, this.field_70330_m + d.offsetY, this.field_70327_n + d.offsetZ);
        if (te instanceof TileEntityCompressionCrafter) {
            return (TileEntityCompressionCrafter)te;
        }
        return null;
    }

    @Override
    public boolean rotate(ForgeDirection axis) {
        byte new_b = (byte)axis.ordinal();
        if (new_b == this.b_facing) {
            return false;
        }
        this.b_facing = new_b;
        return true;
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        Coord here = this.getCoord();
        while (!this.buffer.isEmpty()) {
            here.spawnItem(this.buffer.remove(0));
        }
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        if (this.field_70331_k.field_72995_K) {
            return false;
        }
        if (entityplayer.func_70093_af()) {
            return false;
        }
        Coord c = this.getCoord();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (Math.abs(dx) + Math.abs(dy) + Math.abs(dz) == 3) continue;
                    c.set(this.field_70331_k, this.field_70329_l + dx, this.field_70330_m + dy, this.field_70327_n + dz);
                    TileEntity te = c.getTE(TileEntityCompressionCrafter.class);
                    if (te == this || te == null) continue;
                    return false;
                }
            }
        }
        this.getStateHelper().showTutorial(entityplayer, this);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isPrimaryCrafter()) {
            AxisAlignedBB ab = super.getRenderBoundingBox();
            int d = 7;
            ab.field_72336_d += (double)d;
            ab.field_72337_e += (double)d;
            ab.field_72334_f += (double)d;
            ab.field_72340_a -= (double)d;
            ab.field_72338_b -= (double)d;
            ab.field_72339_c -= (double)d;
            return ab;
        }
        return super.getRenderBoundingBox();
    }
}

