/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import factorization.common.FzConfig;
import factorization.shared.Core;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkDataEvent;

public class WorldgenManager {
    IWorldGenerator silverGen;
    IWorldGenerator darkIronGen;
    private static ArrayList<Chunk> retrogenQueue = new ArrayList();

    public WorldgenManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setupWorldGenerators();
    }

    void setupWorldGenerators() {
        if (FzConfig.gen_silver_ore) {
            this.silverGen = new IWorldGenerator(){
                WorldGenMinable gen;
                {
                    this.gen = new WorldGenMinable(Core.registry.resource_block.field_71990_ca, FzConfig.silver_ore_node_new_size);
                }

                public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
                    if (!FzConfig.gen_silver_ore) {
                        return;
                    }
                    if (!world.field_73011_w.func_76569_d()) {
                        return;
                    }
                    int count = 1 + (rand.nextBoolean() && rand.nextBoolean() && rand.nextBoolean() ? 1 : 0);
                    for (int i = 0; i < count; ++i) {
                        int x = chunkX * 16 + rand.nextInt(16);
                        int z = chunkZ * 16 + rand.nextInt(16);
                        int y = 4 + rand.nextInt(42);
                        this.gen.func_76484_a(world, rand, x, y, z);
                    }
                }
            };
            GameRegistry.registerWorldGenerator((IWorldGenerator)this.silverGen);
        }
        if (FzConfig.gen_dark_iron_ore) {
            this.darkIronGen = new IWorldGenerator(){
                int x;
                int z;
                int stoneId;
                int stoneMd;
                int setBlockFlags = 0;

                void set(World world, int dx, int y, int dz) {
                    world.func_72832_d(this.x + dx, y, this.z + dz, Core.registry.dark_iron_ore.field_71990_ca, 0, this.setBlockFlags);
                }

                void clear(World world, int dx, int y, int dz) {
                    if (world.func_72798_a(this.x + dx, y, this.z + dz) == Block.field_71986_z.field_71990_ca) {
                        world.func_72832_d(this.x + dx, y, this.z + dz, this.stoneId, this.stoneMd, this.setBlockFlags);
                    }
                }

                void fracture(World world, int dx, int y, int dz) {
                    if (world.func_72798_a(this.x + dx, y, this.z + dz) == Block.field_71986_z.field_71990_ca) {
                        world.func_72832_d(this.x + dx, y, this.z + dz, Core.registry.fractured_bedrock_block.field_71990_ca, 0, this.setBlockFlags);
                    }
                }

                public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
                    this.doGeneration(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                    world = null;
                }

                private void dob(Random random, World world, int dx, int y, int dz) {
                    this.set(world, dx, y, dz);
                    block6: for (int i = 0; i < 4; ++i) {
                        switch (random.nextInt(3)) {
                            case 0: {
                                this.set(world, dx + 1, y, dz);
                                continue block6;
                            }
                            case 1: {
                                this.set(world, dx - 1, y, dz);
                                continue block6;
                            }
                            case 3: {
                                this.set(world, dx, y, dz + 1);
                                continue block6;
                            }
                            case 4: {
                                this.set(world, dx, y, dz - 1);
                                continue block6;
                            }
                        }
                    }
                    if (random.nextBoolean()) {
                        this.set(world, dx, y + 1, dz);
                    }
                }

                private void doGeneration(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
                    if (!FzConfig.gen_dark_iron_ore) {
                        return;
                    }
                    if (!world.field_73011_w.func_76569_d()) {
                        return;
                    }
                    if (chunkX == 0 && chunkZ == 0) {
                        this.z = 0;
                        this.x = 0;
                    } else {
                        if (random.nextInt(10) < 2) {
                            return;
                        }
                        this.x = chunkX * 16 + random.nextInt(16);
                        this.z = chunkZ * 16 + random.nextInt(16);
                    }
                    if (world.func_72798_a(this.x, 0, this.z) != Block.field_71986_z.field_71990_ca) {
                        return;
                    }
                    Block stoneBlock = Block.field_71973_m[world.func_72798_a(this.x, 1, this.z)];
                    if (stoneBlock == null) {
                        return;
                    }
                    if (!stoneBlock.isGenMineableReplaceable(world, this.x, 1, this.z, Block.field_71981_t.field_71990_ca)) {
                        return;
                    }
                    this.stoneId = stoneBlock.field_71990_ca;
                    this.stoneMd = world.func_72805_g(this.x, 1, this.z);
                    int height = 4 + random.nextInt(3);
                    for (int y = 1; y < height + 1; ++y) {
                        this.set(world, 0, y, 0);
                    }
                    int trailHeight = height + 2 + random.nextInt(3);
                    for (int y = height + 1; y < trailHeight; ++y) {
                        if (!random.nextBoolean()) continue;
                        this.set(world, 0, y, 0);
                    }
                    int roundCount = 3 + (random.nextBoolean() ? 1 : 0);
                    block8: for (int i = 0; i < roundCount; ++i) {
                        switch (random.nextInt(4)) {
                            case 0: {
                                this.dob(random, world, -1, 1, 0);
                                continue block8;
                            }
                            case 1: {
                                this.dob(random, world, 1, 1, 0);
                                continue block8;
                            }
                            case 2: {
                                this.dob(random, world, 0, 1, -1);
                                continue block8;
                            }
                            case 3: {
                                this.dob(random, world, 0, 1, 1);
                                continue block8;
                            }
                        }
                    }
                    int radius = 3 + random.nextInt(3);
                    for (int y = 0; y < 7; ++y) {
                        int rSq = radius * radius;
                        for (int dx = -radius; dx <= radius; ++dx) {
                            for (int dz = -radius; dz <= radius; ++dz) {
                                int rdist = rSq - (dx * dx + dz * dz);
                                if (rdist < 0 || rdist < 2 && random.nextInt(3) != 0) continue;
                                if (y == 0) {
                                    this.fracture(world, dx, y, dz);
                                    continue;
                                }
                                this.clear(world, dx, y, dz);
                            }
                        }
                        if (y == 0) continue;
                        ++radius;
                        if (y <= 3) continue;
                        radius += random.nextInt(2);
                    }
                }
            };
            GameRegistry.registerWorldGenerator((IWorldGenerator)this.darkIronGen);
        }
    }

    @ForgeSubscribe
    public void enqueueRetrogen(ChunkDataEvent.Load event) {
        if (!FzConfig.enable_retrogen) {
            return;
        }
        NBTTagCompound data = event.getData();
        String oldKey = data.func_74779_i("fzRetro");
        if (FzConfig.retrogen_key.equals(oldKey)) {
            return;
        }
        if (FzConfig.retrogen_silver || FzConfig.retrogen_dark_iron) {
            retrogenQueue.add(event.getChunk());
        }
    }

    @ForgeSubscribe
    public void saveRetroKey(ChunkDataEvent.Save event) {
        NBTTagCompound data = event.getData();
        data.func_74778_a("fzRetro", FzConfig.retrogen_key);
    }

    void doRetrogen(boolean test, Chunk chunk, String genType, IWorldGenerator gen) {
        if (!test) {
            return;
        }
        int chunkX = chunk.field_76635_g;
        int chunkZ = chunk.field_76647_h;
        World world = chunk.field_76637_e;
        long worldSeed = world.func_72905_C();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
        fmlRandom.setSeed(chunkSeed);
        IChunkProvider chunkProvider = world.func_72863_F();
        gen.generate(fmlRandom, chunkX, chunkZ, world, chunkProvider, chunkProvider);
    }

    public void tickRetrogenQueue() {
        if (retrogenQueue.isEmpty()) {
            return;
        }
        WorldgenManager.log("Starting %s chunks", retrogenQueue.size());
        for (int i = 0; i < retrogenQueue.size(); ++i) {
            Chunk chunk = retrogenQueue.get(i);
            this.doRetrogen(FzConfig.retrogen_silver, chunk, "Silver", this.silverGen);
            this.doRetrogen(FzConfig.retrogen_dark_iron, chunk, "Dark Iron", this.darkIronGen);
        }
        retrogenQueue.clear();
        WorldgenManager.log("Done", new Object[0]);
    }

    public static void log(String format, Object ... formatParameters) {
        Core.logWarning("Retrogen> " + format, formatParameters);
    }
}

