/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.api.IFactoryType;
import factorization.astro.BlockRenderRocketEngine;
import factorization.ceramics.BlockRenderGreenware;
import factorization.ceramics.ItemRenderGlazeBucket;
import factorization.ceramics.TileEntityGreenware;
import factorization.ceramics.TileEntityGreenwareRender;
import factorization.charge.BatteryItemRender;
import factorization.charge.BlockRenderBattery;
import factorization.charge.BlockRenderHeater;
import factorization.charge.BlockRenderLeydenJar;
import factorization.charge.BlockRenderMirrorStand;
import factorization.charge.BlockRenderSteamTurbine;
import factorization.charge.BlockRenderWire;
import factorization.charge.TileEntityHeater;
import factorization.charge.TileEntityHeaterRenderer;
import factorization.charge.TileEntityLeydenJar;
import factorization.charge.TileEntityLeydenJarRender;
import factorization.charge.TileEntitySteamTurbine;
import factorization.charge.TileEntitySteamTurbineRender;
import factorization.common.Command;
import factorization.common.ContainerFactorization;
import factorization.common.FactorizationProxy;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.crafting.BlockRenderCompressionCrafter;
import factorization.crafting.BlockRenderMixer;
import factorization.crafting.ContainerMixer;
import factorization.crafting.GuiMixer;
import factorization.crafting.GuiStamper;
import factorization.crafting.TileEntityCompressionCrafter;
import factorization.crafting.TileEntityCompressionCrafterRenderer;
import factorization.crafting.TileEntityMixer;
import factorization.crafting.TileEntityMixerRenderer;
import factorization.darkiron.BlockDarkIronOre;
import factorization.darkiron.GlintRenderer;
import factorization.oreprocessing.BlockRenderCrystallizer;
import factorization.oreprocessing.BlockRenderGrinder;
import factorization.oreprocessing.ContainerCrystallizer;
import factorization.oreprocessing.ContainerGrinder;
import factorization.oreprocessing.ContainerSlagFurnace;
import factorization.oreprocessing.GuiCrystallizer;
import factorization.oreprocessing.GuiGrinder;
import factorization.oreprocessing.GuiSlag;
import factorization.oreprocessing.TileEntityCrystallizer;
import factorization.oreprocessing.TileEntityCrystallizerRender;
import factorization.oreprocessing.TileEntityGrinder;
import factorization.oreprocessing.TileEntityGrinderRender;
import factorization.oreprocessing.TileEntitySlagFurnace;
import factorization.servo.BlockRenderServoRail;
import factorization.servo.GuiParasieve;
import factorization.servo.RenderServoMotor;
import factorization.servo.ServoMotor;
import factorization.shared.BlockRenderDefault;
import factorization.shared.BlockRenderEmpty;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.EmptyRender;
import factorization.shared.FactorizationBlockRender;
import factorization.shared.FactorizationRender;
import factorization.shared.ItemRenderCapture;
import factorization.shared.TileEntityFactorization;
import factorization.sockets.BlockRenderSocketBase;
import factorization.sockets.SocketLacerator;
import factorization.sockets.TileEntitySocketRenderer;
import factorization.weird.BlockRenderDayBarrel;
import factorization.weird.ContainerPocket;
import factorization.weird.DayBarrelItemRenderer;
import factorization.weird.GuiPocketTable;
import factorization.weird.TileEntityBarrel;
import factorization.weird.TileEntityBarrelRenderer;
import factorization.weird.TileEntityDayBarrel;
import factorization.weird.TileEntityDayBarrelRenderer;
import factorization.wrath.BlockRenderLamp;
import factorization.wrath.EntityWrathFlameFX;
import factorization.wrath.GuiRouter;
import factorization.wrath.TileEntityWrathLamp;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.input.Keyboard;

public class FactorizationClientProxy
extends FactorizationProxy {
    int fireParticlesSpawned = 0;
    int fireParticlesMax = 5;
    public static KeyBinding bag_swap_key = new KeyBinding("FZ Bag of Holding", 41);
    public static KeyBinding pocket_key = new KeyBinding("FZ Pocket Crafting Table", 46);

    public FactorizationClientProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public Profiler getProfiler() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return Minecraft.func_71410_x().field_71424_I;
        }
        return super.getProfiler();
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == FactoryType.POCKETCRAFTGUI.gui) {
            return new GuiPocketTable(new ContainerPocket(player));
        }
        TileEntity te = world.func_72796_p(x, y, z);
        if (!(te instanceof TileEntityFactorization)) {
            return null;
        }
        TileEntityFactorization fac = (TileEntityFactorization)te;
        ContainerFactorization cont = ID == FactoryType.SLAGFURNACE.gui ? new ContainerSlagFurnace(player, fac) : (ID == FactoryType.GRINDER.gui ? new ContainerGrinder(player, fac) : (ID == FactoryType.MIXER.gui ? new ContainerMixer(player, fac) : (ID == FactoryType.CRYSTALLIZER.gui ? new ContainerCrystallizer(player, fac) : new ContainerFactorization(player, fac))));
        GuiContainer gui = null;
        if (ID == FactoryType.ROUTER.gui) {
            gui = new GuiRouter(cont);
        }
        if (ID == FactoryType.STAMPER.gui) {
            gui = new GuiStamper(cont);
        }
        if (ID == FactoryType.SLAGFURNACE.gui) {
            gui = new GuiSlag(cont);
        }
        if (ID == FactoryType.GRINDER.gui) {
            gui = new GuiGrinder(cont);
        }
        if (ID == FactoryType.MIXER.gui) {
            gui = new GuiMixer((ContainerMixer)cont);
        }
        if (ID == FactoryType.CRYSTALLIZER.gui) {
            gui = new GuiCrystallizer(cont);
        }
        if (ID == FactoryType.PARASIEVE.gui) {
            gui = new GuiParasieve(cont);
        }
        cont.addSlotsForGui(fac, player.field_71071_by);
        return gui;
    }

    @Override
    public String translateItemStack(ItemStack is) {
        if (is == null) {
            return "null";
        }
        return is.func_77973_b().func_77628_j(is);
    }

    @Override
    public void pokePocketCrafting() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r instanceof GuiPocketTable) {
            GuiPocketTable gui = (GuiPocketTable)minecraft.field_71462_r;
            gui.containerPocket.updateCraft();
        }
    }

    @Override
    public void randomDisplayTickFor(World w, int x, int y, int z, Random rand) {
        Coord here = new Coord(w, x, y, z);
        int id = w.func_72798_a(x, y, z);
        int md = w.func_72805_g(x, y, z);
        if (id == Core.registry.factory_block.field_71990_ca) {
            TileEntity te = w.func_72796_p(x, y, z);
            if (!(te instanceof IFactoryType)) {
                return;
            }
            FactoryType ft = ((IFactoryType)te).getFactoryType();
            if (ft == FactoryType.LAMP) {
                for (int i = 0; i < 3; ++i) {
                    double X = (double)x + 0.4 + (double)rand.nextFloat() * 0.2;
                    double Z = (double)z + 0.4 + (double)rand.nextFloat() * 0.2;
                    EntityWrathFlameFX flame = new EntityWrathFlameFX(w, X, (double)y + 0.2 + (double)rand.nextFloat() * 0.1, Z, 0.001 - (double)rand.nextFloat() * 0.002, 0.01, 0.001 - (double)rand.nextFloat() * 0.002);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)flame);
                }
            }
            if (ft == FactoryType.SLAGFURNACE) {
                TileEntitySlagFurnace slag = (TileEntitySlagFurnace)te;
                if (slag.draw_active <= 0) {
                    return;
                }
                byte var6 = slag.facing_direction;
                float var7 = (float)x + 0.5f;
                float var8 = (float)y + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
                float var9 = (float)z + 0.5f;
                float var10 = 0.52f;
                float var11 = rand.nextFloat() * 0.6f - 0.3f;
                if (var6 == 4) {
                    w.func_72869_a("smoke", (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                    w.func_72869_a("flame", (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                } else if (var6 == 5) {
                    w.func_72869_a("smoke", (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                    w.func_72869_a("flame", (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                } else if (var6 == 2) {
                    w.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0);
                    w.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0);
                } else if (var6 == 3) {
                    w.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0);
                    w.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0);
                }
            }
        }
        if (id == Core.registry.lightair_block.field_71990_ca && md == 1) {
            int to_spawn = 1;
            EntityPlayer player = Core.proxy.getClientPlayer();
            boolean force = false;
            boolean big = true;
            if (player != null) {
                int dx = (int)player.field_70165_t - x;
                int dy = (int)player.field_70163_u - y;
                int dz = (int)player.field_70161_v - z;
                int dist = Math.abs(dx) + Math.abs(dy) + Math.abs(dz);
                if (dist < 4) {
                    to_spawn = 8;
                    force = true;
                    big = false;
                } else if (dist <= 12) {
                    to_spawn = 4;
                    force = true;
                } else if (dist <= 16) {
                    to_spawn = 1;
                }
            }
            if (this.fireParticlesSpawned >= this.fireParticlesMax) {
                if (!force) {
                    return;
                }
                to_spawn /= 4;
            }
            if (!force) {
                this.fireParticlesSpawned += to_spawn;
            }
            for (int i = 0; i < to_spawn; ++i) {
                double X = (double)x + 0.05 + (double)rand.nextFloat() * 0.95;
                double Z = (double)z + 0.05 + (double)rand.nextFloat() * 0.95;
                EntityWrathFlameFX flame = new EntityWrathFlameFX(w, X, (double)y + (double)rand.nextFloat() * 0.25, Z, ((double)rand.nextFloat() - 0.5) * 0.02, 0.05 + (double)rand.nextFloat() * 0.04, ((double)rand.nextFloat() - 0.5) * 0.02);
                if (big) {
                    flame.setScale(4);
                }
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)flame);
            }
        }
    }

    @Override
    public void playSoundFX(String src, float volume, float pitch) {
        Minecraft.func_71410_x().field_71416_A.func_77366_a(src, volume, pitch);
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void registerKeys() {
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)CommandKeySet.create(new Object[]{bag_swap_key, Command.bagShuffle, pocket_key, Command.craftOpen}));
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new IScheduledTickHandler(){

            public void tickStart(EnumSet<TickType> type, Object ... tickData) {
            }

            public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
                TileEntityDayBarrel.iterateForFinalizedBarrels();
            }

            public EnumSet<TickType> ticks() {
                return EnumSet.of(TickType.CLIENT);
            }

            public String getLabel() {
                return "fz.barrel_display_list_finalizer";
            }

            public int nextTickSpacing() {
                return 600;
            }
        }, (Side)Side.CLIENT);
    }

    private void setTileEntityRenderer(Class clazz, TileEntitySpecialRenderer r) {
        ClientRegistry.bindTileEntitySpecialRenderer((Class)clazz, (TileEntitySpecialRenderer)r);
    }

    @Override
    public void registerRenderers() {
        if (FzConfig.render_barrel_item || FzConfig.render_barrel_text) {
            this.setTileEntityRenderer(TileEntityBarrel.class, new TileEntityBarrelRenderer(FzConfig.render_barrel_item, FzConfig.render_barrel_text));
        }
        this.setTileEntityRenderer(TileEntityDayBarrel.class, new TileEntityDayBarrelRenderer());
        this.setTileEntityRenderer(TileEntityGreenware.class, new TileEntityGreenwareRender());
        if (FzConfig.renderTEs) {
            this.setTileEntityRenderer(TileEntityHeater.class, new TileEntityHeaterRenderer());
            this.setTileEntityRenderer(TileEntityGrinder.class, new TileEntityGrinderRender());
            this.setTileEntityRenderer(TileEntityMixer.class, new TileEntityMixerRenderer());
            this.setTileEntityRenderer(TileEntityCrystallizer.class, new TileEntityCrystallizerRender());
            this.setTileEntityRenderer(TileEntitySteamTurbine.class, new TileEntitySteamTurbineRender());
            this.setTileEntityRenderer(TileEntityLeydenJar.class, new TileEntityLeydenJarRender());
            this.setTileEntityRenderer(TileEntityCompressionCrafter.class, new TileEntityCompressionCrafterRenderer());
            this.setTileEntityRenderer(SocketLacerator.class, new TileEntitySocketRenderer());
        }
        RenderingRegistry.registerEntityRenderingHandler(TileEntityWrathLamp.RelightTask.class, (Render)new EmptyRender());
        RenderingRegistry.registerEntityRenderingHandler(ServoMotor.class, (Render)new RenderServoMotor());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new FactorizationRender());
        BlockRenderBattery renderBattery = new BlockRenderBattery();
        BlockRenderDayBarrel renderBarrel = new BlockRenderDayBarrel();
        new BlockRenderLeydenJar();
        new BlockRenderDefault();
        new BlockRenderHeater();
        new BlockRenderLamp();
        new BlockRenderMirrorStand();
        new BlockRenderSteamTurbine();
        new BlockRenderWire();
        new BlockRenderGrinder();
        new BlockRenderMixer();
        new BlockRenderCrystallizer();
        new BlockRenderCompressionCrafter();
        new BlockRenderGreenware().setup();
        new BlockRenderRocketEngine();
        new BlockRenderServoRail();
        for (FactoryType ft : new FactoryType[]{FactoryType.SOCKET_EMPTY, FactoryType.SOCKET_LACERATOR, FactoryType.SOCKET_ROBOTHAND, FactoryType.SOCKET_SHIFTER}) {
            new BlockRenderSocketBase(ft);
        }
        for (FactoryType ft : new FactoryType[]{FactoryType.ROUTER, FactoryType.STAMPER, FactoryType.BARREL, FactoryType.PACKAGER, FactoryType.SLAGFURNACE, FactoryType.SOLARBOILER, FactoryType.PARASIEVE, FactoryType.CALIOMETRIC_BURNER}) {
            FactorizationBlockRender.setDefaultRender(ft);
        }
        new BlockRenderEmpty(FactoryType.EXTENDED);
        ItemRenderCapture capture = new ItemRenderCapture();
        MinecraftForgeClient.registerItemRenderer((int)Core.registry.factory_block.field_71990_ca, (IItemRenderer)capture);
        MinecraftForgeClient.registerItemRenderer((int)Core.registry.battery.field_77779_bT, (IItemRenderer)new BatteryItemRender(renderBattery));
        MinecraftForgeClient.registerItemRenderer((int)Core.registry.glaze_bucket.field_77779_bT, (IItemRenderer)new ItemRenderGlazeBucket());
        MinecraftForgeClient.registerItemRenderer((int)Core.registry.daybarrel.field_77779_bT, (IItemRenderer)new DayBarrelItemRenderer(renderBarrel));
        this.setTileEntityRenderer(BlockDarkIronOre.Glint.class, new GlintRenderer());
        if (Minecraft.func_71410_x().func_110432_I().func_111285_a().equals("neptunepink")) {
            Core.FZLogger.setLevel(Level.FINE);
        }
    }

    @Override
    public void texturepackChanged() {
        TileEntityGrinderRender.remakeModel();
    }

    @Override
    public boolean BlockRenderHelper_has_texture(BlockRenderHelper block, int f) {
        if (block.textures == null) {
            return true;
        }
        return block.textures[f] != null;
    }

    @Override
    public void BlockRenderHelper_clear_texture(BlockRenderHelper block) {
        block.textures = null;
    }

    @Override
    public String getPocketCraftingTableKey() {
        return GameSettings.func_74298_c((int)FactorizationClientProxy.pocket_key.field_74512_d);
    }

    @Override
    public boolean isClientHoldingShift() {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        return Keyboard.isKeyDown((int)42);
    }

    @ForgeSubscribe
    public void onStitch(TextureStitchEvent.Post event) {
        int t = event.map.field_94255_a;
        if (t == 0) {
            Core.blockMissingIcon = event.map.func_110572_b("this code for getting the missing Icon brought to you by LexManos");
        } else if (t == 1) {
            Core.itemMissingIcon = event.map.func_110572_b("this code for getting the missing Icon brought to you by Tahg");
        }
    }

    private static class CommandKeySet
    extends KeyBindingRegistry.KeyHandler {
        Map<KeyBinding, Command> map;

        static CommandKeySet create(Object ... args) {
            KeyBinding[] bindings = new KeyBinding[args.length / 2];
            boolean[] repeatings = new boolean[args.length / 2];
            HashMap<KeyBinding, Command> map = new HashMap<KeyBinding, Command>();
            for (int i = 0; i < args.length; i += 2) {
                KeyBinding key = (KeyBinding)args[i];
                Command cmd = (Command)((Object)args[i + 1]);
                map.put(key, cmd);
                bindings[i / 2] = key;
                repeatings[i / 2] = false;
            }
            CommandKeySet ret = new CommandKeySet(bindings, repeatings);
            ret.map = map;
            return ret;
        }

        private CommandKeySet(KeyBinding[] keyBindings, boolean[] repeatings) {
            super(keyBindings, repeatings);
        }

        public EnumSet<TickType> ticks() {
            return EnumSet.of(TickType.CLIENT);
        }

        public String getLabel() {
            return "CommandKeys";
        }

        public void keyDown(EnumSet<TickType> types, KeyBinding kb, boolean tickEnd, boolean isRepeat) {
            if (tickEnd) {
                return;
            }
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui != null) {
                return;
            }
            Command command = this.map.get(kb);
            EntityPlayer player = Core.proxy.getClientPlayer();
            if (player == null) {
                return;
            }
            if (player.func_70093_af()) {
                command = command.reverse;
            }
            command.call(Core.proxy.getClientPlayer());
        }

        public void keyUp(EnumSet<TickType> types, KeyBinding kb, boolean tickEnd) {
        }
    }
}

