/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import factorization.api.VectorUV;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.util.Icon;

public class WireRenderingCube {
    Icon icon;
    public VectorUV corner;
    public VectorUV origin;
    public VectorUV axis;
    public double ul;
    public double vl;
    public float theta;

    public WireRenderingCube(Icon icon, VectorUV corner, VectorUV origin) {
        if (origin == null) {
            origin = new VectorUV(0.0, 0.0, 0.0, 0.0, 0.0);
        }
        this.corner = corner;
        this.origin = origin;
        this.axis = new VectorUV(0.0, 0.0, 0.0);
        this.theta = 0.0f;
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.setIcon(icon);
        }
    }

    static float takeFloat(ArrayList<Object> args) {
        return ((Float)args.remove(0)).floatValue();
    }

    public boolean equals(WireRenderingCube other) {
        return this.corner.equals(other.corner) && this.origin.equals(other.origin) && this.icon == other.icon;
    }

    public WireRenderingCube copy() {
        WireRenderingCube ret = new WireRenderingCube(this.icon, this.corner.copy(), this.origin.copy());
        ret.ul = this.ul;
        ret.vl = this.vl;
        ret.axis = this.axis.copy();
        ret.theta = this.theta;
        return ret;
    }

    public WireRenderingCube normalize() {
        VectorUV newCorner = this.corner.copy();
        VectorUV newOrigin = this.origin.copy();
        newCorner.rotate(this.axis.x, this.axis.y, this.axis.z, this.theta);
        newOrigin.rotate(this.axis.x, this.axis.y, this.axis.z, this.theta);
        newCorner.x = Math.abs(newCorner.x);
        newCorner.y = Math.abs(newCorner.y);
        newCorner.z = Math.abs(newCorner.z);
        return new WireRenderingCube(this.icon, newCorner, newOrigin);
    }

    public void toBlockBounds(Block b) {
        WireRenderingCube cube = this.normalize();
        VectorUV c = cube.corner;
        VectorUV o = cube.origin;
        c.scale(0.0625);
        o = o.add(8, 8, 8);
        o.scale(0.0625);
        b.func_71905_a((float)(o.x - c.x), (float)(o.y - c.y), (float)(o.z - c.z), (float)(o.x + c.x), (float)(o.y + c.y), (float)(o.z + c.z));
    }

    public WireRenderingCube rotate(double ax, double ay, double az, int theta) {
        return this.rotate((float)ax, (float)ay, (float)az, theta);
    }

    public WireRenderingCube rotate(float ax, float ay, float az, int theta) {
        if (theta == 0) {
            this.axis = new VectorUV(0.0, 0.0, 0.0);
            this.theta = 0.0f;
            return this;
        }
        this.axis = new VectorUV(ax, ay, az);
        this.theta = theta;
        return this;
    }

    public void setIcon(Icon newIcon) {
        this.icon = newIcon;
        this.ul = newIcon.func_94209_e();
        this.vl = newIcon.func_94206_g();
    }

    public VectorUV[] faceVerts(int face) {
        VectorUV[] ret = new VectorUV[4];
        VectorUV v = this.corner;
        int c = 8;
        switch (face) {
            case 0: {
                ret[0] = new VectorUV(v.x, -v.y, v.z);
                ret[1] = new VectorUV(-v.x, -v.y, v.z);
                ret[2] = new VectorUV(-v.x, -v.y, -v.z);
                ret[3] = new VectorUV(v.x, -v.y, -v.z);
                break;
            }
            case 1: {
                ret[0] = new VectorUV(v.x, v.y, -v.z);
                ret[1] = new VectorUV(-v.x, v.y, -v.z);
                ret[2] = new VectorUV(-v.x, v.y, v.z);
                ret[3] = new VectorUV(v.x, v.y, v.z);
                break;
            }
            case 2: {
                ret[0] = new VectorUV(v.x, v.y, -v.z);
                ret[1] = new VectorUV(v.x, -v.y, -v.z);
                ret[2] = new VectorUV(-v.x, -v.y, -v.z);
                ret[3] = new VectorUV(-v.x, v.y, -v.z);
                break;
            }
            case 3: {
                ret[0] = new VectorUV(v.x, v.y, v.z);
                ret[1] = new VectorUV(-v.x, v.y, v.z);
                ret[2] = new VectorUV(-v.x, -v.y, v.z);
                ret[3] = new VectorUV(v.x, -v.y, v.z);
                break;
            }
            case 4: {
                ret[0] = new VectorUV(-v.x, v.y, v.z);
                ret[1] = new VectorUV(-v.x, v.y, -v.z);
                ret[2] = new VectorUV(-v.x, -v.y, -v.z);
                ret[3] = new VectorUV(-v.x, -v.y, v.z);
                break;
            }
            case 5: {
                ret[0] = new VectorUV(v.x, v.y, v.z);
                ret[1] = new VectorUV(v.x, -v.y, v.z);
                ret[2] = new VectorUV(v.x, -v.y, -v.z);
                ret[3] = new VectorUV(v.x, v.y, -v.z);
            }
        }
        for (VectorUV vert : ret) {
            vert.incr(this.origin);
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            switch (face) {
                case 0: 
                case 1: {
                    for (VectorUV vert : ret) {
                        vert.u = vert.x + 8.0;
                        vert.v = vert.z + 8.0;
                    }
                    break;
                }
                case 2: {
                    for (VectorUV vert : ret) {
                        vert.u = 16.0 - (vert.x + 8.0);
                        vert.v = 16.0 - (vert.y + 8.0);
                    }
                    break;
                }
                case 3: {
                    for (VectorUV vert : ret) {
                        vert.u = vert.x + 8.0;
                        vert.v = 16.0 - (vert.y + 8.0);
                    }
                    break;
                }
                case 4: {
                    for (VectorUV vert : ret) {
                        vert.u = 16.0 - (vert.y + 8.0);
                        vert.v = vert.z + 8.0;
                    }
                    break;
                }
                case 5: {
                    for (VectorUV vert : ret) {
                        vert.u = 16.0 - (vert.y + 8.0);
                        vert.v = 16.0 - (vert.z + 8.0);
                    }
                    break;
                }
            }
            for (VectorUV main : ret) {
                double udelta = 0.0;
                double vdelta = 0.0;
                int nada = 0;
                if (main.u > 16.0) {
                    udelta = main.u - 16.0;
                } else if (main.u < 0.0) {
                    udelta = main.u;
                } else {
                    ++nada;
                }
                if (main.v > 16.0) {
                    vdelta = main.v - 16.0;
                } else if (main.v < 0.0) {
                    vdelta = main.v;
                } else {
                    ++nada;
                }
                if (nada == 2) continue;
                for (VectorUV other : ret) {
                    other.u -= udelta;
                    other.v -= vdelta;
                }
            }
        }
        if (this.theta != 0.0f) {
            for (VectorUV vert : ret) {
                vert.rotate(this.axis.x, this.axis.y, this.axis.z, this.theta);
            }
        }
        return ret;
    }
}

