/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import factorization.api.IActOnCraft;
import factorization.charge.TileEntityBattery;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.ItemBlockProxy;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemBattery
extends ItemBlockProxy
implements IActOnCraft {
    int magnet_cost = 2560;

    public ItemBattery(int id) {
        super(id, Core.registry.battery_item_hidden, "charge_battery", Core.TabType.CHARGE);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.setNoRepair();
    }

    public int getStorage(ItemStack is) {
        NBTTagCompound tag = FzUtil.getTag(is);
        if (tag.func_74764_b("storage")) {
            return tag.func_74762_e("storage");
        }
        return 6400;
    }

    public void setStorage(ItemStack is, int new_charge) {
        NBTTagCompound tag = FzUtil.getTag(is);
        tag.func_74768_a("storage", new_charge);
        this.normalizeDamage(is);
    }

    public void normalizeDamage(ItemStack is) {
        is.func_77964_b(this.getStorage(is) / this.magnet_cost);
    }

    @Override
    public void addExtraInformation(ItemStack is, EntityPlayer player, List list, boolean verbose) {
        String pre = "item.factorization:charge_battery.";
        if (is.func_77978_p() != null && is.func_77978_p().func_74764_b("storage")) {
            float fullness = TileEntityBattery.getFullness(this.getStorage(is));
            String n = StatCollector.func_74837_a((String)"item.factorization:charge_battery.perc", (Object[])new Object[]{(int)(fullness * 100.0f)});
            list.add(n);
        } else {
            switch (is.func_77960_j()) {
                case 0: {
                    list.add("item.factorization:charge_battery.low");
                    break;
                }
                case 1: {
                    list.add("item.factorization:charge_battery.mid");
                    break;
                }
                case 2: {
                    list.add("item.factorization:charge_battery.full");
                }
            }
        }
    }

    public boolean func_77634_r() {
        return true;
    }

    public boolean func_77630_h(ItemStack par1ItemStack) {
        return false;
    }

    public ItemStack getContainerItemStack(ItemStack is) {
        is = is.func_77946_l();
        this.normalizeDamage(is);
        int d = is.func_77960_j();
        if (d > 0) {
            int stor = this.getStorage(is);
            this.setStorage(is, stor -= this.magnet_cost);
            this.normalizeDamage(is);
        }
        return is;
    }

    @Override
    public void onCraft(ItemStack is, IInventory craftMatrix, int craftSlot, ItemStack result, EntityPlayer player) {
        this.normalizeDamage(is);
        if (result.func_77973_b() == Core.registry.battery) {
            --is.field_77994_a;
            result.field_77993_c = is.field_77993_c;
            result.field_77994_a = is.field_77994_a;
            result.func_77982_d(is.func_77978_p());
        }
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            ItemStack wire = craftMatrix.func_70301_a(i);
            if (wire == null || !wire.func_77969_a(Core.registry.leadwire_item)) continue;
            ++wire.field_77994_a;
        }
    }

    public boolean func_77645_m() {
        return false;
    }

    public void func_77622_d(ItemStack is, World w, EntityPlayer player) {
        if (is.func_77978_p() == null) {
            NBTTagCompound tag = FzUtil.getTag(is);
            tag.func_74768_a("storage", this.getStorage(is));
        }
    }

    @Override
    public boolean func_77651_p() {
        return true;
    }
}

