/*
 * Decompiled with CFR 0.152.
 */
package factorization.ceramics;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.ceramics.BasicGlazes;
import factorization.ceramics.TileEntityGreenware;
import factorization.common.BlockIcons;
import factorization.notify.Notify;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.ItemFactorization;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ItemGlazeBucket
extends ItemFactorization {
    public static final int MAX_CHARGES = 32;
    private ArrayList<ItemStack> subItems = new ArrayList();
    private boolean done;
    int md_for_nei = 0;

    public ItemGlazeBucket(int itemId) {
        super(itemId, "ceramics/glaze_bucket", Core.TabType.ART);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.setNoRepair();
        Core.tab(this, Core.TabType.ART);
    }

    public Icon getIcon(ItemStack is, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (renderPass == 0) {
            return this.func_77617_a(0);
        }
        short id = this.getBlockId(is);
        Block block = Block.field_71973_m[id];
        if (block == null) {
            return BlockIcons.uv_test;
        }
        return block.func_71858_a((int)this.getBlockSide(is), (int)this.getBlockMd(is));
    }

    public String func_77667_c(ItemStack is) {
        String base = super.func_77667_c(is);
        NBTTagCompound tag = FzUtil.getTag(is);
        if (tag.func_74764_b("gid")) {
            String key = tag.func_74779_i("gid");
            return base + "." + key;
        }
        return base;
    }

    public String func_77628_j(ItemStack is) {
        ItemStack hint;
        String base = super.func_77628_j(is);
        if (this.isMimic(is) && (hint = this.getSource(is)) != null) {
            return Core.translate(this.func_77658_a() + ".mimicry_prefix") + " " + hint.func_82833_r();
        }
        return base;
    }

    public float getFullness(ItemStack is) {
        int c = this.getCharges(is);
        if (c >= 32) {
            return 1.0f;
        }
        if (c <= 0) {
            return 0.0f;
        }
        return (float)c / 32.0f;
    }

    public int getCharges(ItemStack is) {
        NBTTagCompound tag = FzUtil.getTag(is);
        return tag.func_74762_e("remaining");
    }

    public boolean useCharge(ItemStack is) {
        NBTTagCompound tag = FzUtil.getTag(is);
        int remaining = tag.func_74762_e("remaining");
        if (remaining <= 0) {
            return false;
        }
        tag.func_74768_a("remaining", --remaining);
        return remaining > 0;
    }

    private short getBlockId(ItemStack is) {
        return FzUtil.getTag(is).func_74765_d("bid");
    }

    private byte getBlockMd(ItemStack is) {
        return FzUtil.getTag(is).func_74771_c("bmd");
    }

    private byte getBlockSide(ItemStack is) {
        return FzUtil.getTag(is).func_74771_c("bsd");
    }

    private boolean isMimic(ItemStack is) {
        return FzUtil.getTag(is).func_74767_n("mimic");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int itemId, CreativeTabs tab, List list) {
        list.addAll(this.subItems);
    }

    public void doneMakingStandardGlazes() {
        this.done = true;
    }

    public void notDoneMakingStandardGlazes() {
        this.done = false;
    }

    public void addGlaze(ItemStack is) {
        if (!this.done) {
            this.subItems.add(is);
        }
    }

    void setGid(ItemStack is, String unique_id) {
        FzUtil.getTag(is).func_74778_a("gid", unique_id);
    }

    public ItemStack makeCraftingGlaze(String unique_id) {
        ItemStack is = new ItemStack((Item)this);
        NBTTagCompound tag = FzUtil.getTag(is);
        tag.func_74757_a("fake", true);
        this.setGid(is, unique_id);
        is.func_77964_b(this.md_for_nei++);
        return is;
    }

    private ItemStack makeGlazeWith(int id, int md, int side) {
        ItemStack is = new ItemStack((Item)this);
        NBTTagCompound tag = FzUtil.getTag(is);
        tag.func_74777_a("bid", (short)id);
        tag.func_74774_a("bmd", (byte)md);
        tag.func_74774_a("bsd", (byte)side);
        tag.func_74768_a("remaining", 32);
        this.addGlaze(is);
        return is;
    }

    public ItemStack makeMimicingGlaze(int id, int md, int side) {
        ItemStack is = this.makeGlazeWith(id, md, side);
        this.setMimicry(is);
        return is;
    }

    public ItemStack make(BasicGlazes glaze) {
        ItemStack is = this.makeGlazeWith(Core.registry.resource_block.field_71990_ca, glaze.metadata, 0);
        this.setGid(is, glaze.name());
        is.func_77964_b(this.md_for_nei++);
        return is;
    }

    public void setMimicry(ItemStack is) {
        NBTTagCompound tag = FzUtil.getTag(is);
        tag.func_74757_a("mimic", true);
    }

    public boolean isUsable(ItemStack is) {
        if (FzUtil.getTag(is).func_74767_n("fake")) {
            return false;
        }
        return Block.field_71973_m[this.getBlockId(is)] != null;
    }

    ItemStack getSource(ItemStack is) {
        Block b = Block.field_71973_m[this.getBlockId(is)];
        if (b == null) {
            return null;
        }
        return new ItemStack(b, 1, (int)this.getBlockMd(is));
    }

    public ItemStack func_77659_a(ItemStack is, World w, EntityPlayer player) {
        if (w.field_72995_K) {
            return is;
        }
        MovingObjectPosition mop = this.func_77621_a(w, player, true);
        if (!this.isUsable(is)) {
            return is;
        }
        if (mop == null) {
            return is;
        }
        if (mop.field_72313_a != EnumMovingObjectType.TILE || mop.subHit == -1) {
            return is;
        }
        TileEntityGreenware clay = new Coord(w, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d).getTE(TileEntityGreenware.class);
        if (clay == null) {
            return is;
        }
        TileEntityGreenware.ClayState state = clay.getState();
        if (player.field_71075_bZ.field_75098_d) {
            if (state != TileEntityGreenware.ClayState.HIGHFIRED) {
                clay.totalHeat = TileEntityGreenware.highfireHeat + 1;
            }
        } else {
            switch (state) {
                case WET: 
                case DRY: {
                    Notify.withItem(Core.registry.heater_item);
                    Notify.send(player, (Object)clay.getCoord(), "Use a {ITEM_NAME} to bisque", new String[0]);
                    return is;
                }
                case HIGHFIRED: {
                    Notify.send(player, (Object)clay.getCoord(), "Already high-fired", new String[0]);
                    return is;
                }
            }
        }
        TileEntityGreenware.ClayLump part = clay.parts.get(mop.subHit);
        short id = this.getBlockId(is);
        byte md = this.getBlockMd(is);
        byte sd = this.getBlockSide(is);
        if (part.icon_id == id && part.icon_md == md && part.icon_side == sd) {
            return is;
        }
        if (player.field_71075_bZ.field_75098_d || this.useCharge(is)) {
            part.icon_id = id;
            part.icon_md = md;
            part.icon_side = sd;
            clay.changeLump(mop.subHit, part);
            clay.glazesApplied = true;
            return is;
        }
        return new ItemStack((Item)this);
    }
}

