/*
 * Decompiled with CFR 0.152.
 */
package factorization.astro;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.fzds.DeltaChunk;
import factorization.fzds.TransferLib;
import factorization.fzds.api.DeltaCapability;
import factorization.fzds.api.IDeltaChunk;
import factorization.notify.Notify;
import factorization.shared.BlockClass;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.TileEntityCommon;
import factorization.shared.TileEntityExtension;
import factorization.weird.TileEntityDayBarrel;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityRocketEngine
extends TileEntityCommon {
    boolean inSlice = false;
    boolean isLeaderEngine = false;
    public boolean isFiring = false;
    int availableFuel = -1;
    int nonfuelMass = 0;
    public boolean lastValidationStatus = false;
    private boolean ignitionRequest = false;
    private static int[][] perimDeltas = new int[][]{{-1, 0, -1}, {-1, 0, 0}, {-1, 0, 1}, {-1, 0, 2}, {0, 0, -1}, {0, 0, 2}, {1, 0, -1}, {1, 0, 2}, {2, 0, -1}, {2, 0, 0}, {2, 0, 1}, {2, 0, 2}};
    long next_free_time = 0L;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.ROCKETENGINE;
    }

    @Override
    public Icon getIcon(ForgeDirection dir) {
        return this.lastValidationStatus ? BlockIcons.rocket_engine_valid : BlockIcons.rocket_engine_invalid;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.DarkIron;
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74757_a("inSlice", this.inSlice);
        tag.func_74757_a("isLeaderEngine", this.isLeaderEngine);
        tag.func_74757_a("isFiring", this.isFiring);
        tag.func_74768_a("availableFuel", this.availableFuel);
        tag.func_74768_a("nonfuelMass", this.nonfuelMass);
        tag.func_74757_a("lastValidationStatus", this.lastValidationStatus);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.inSlice = tag.func_74767_n("inSlice");
        this.isLeaderEngine = tag.func_74767_n("isLeaderEngine");
        this.isFiring = tag.func_74767_n("isFiring");
        this.availableFuel = tag.func_74762_e("availableFuel");
        this.nonfuelMass = tag.func_74762_e("nonfuelMass");
        this.lastValidationStatus = tag.func_74767_n("lastValidationStatus");
    }

    List<Coord> getArea() {
        return this.getArea(this.getCoord(), new DeltaCoord(1, 1, 1));
    }

    List<Coord> getArea(Coord c, DeltaCoord dc) {
        ArrayList<Coord> ret = new ArrayList<Coord>(12);
        for (int dyc = 0; dyc < 3; ++dyc) {
            int dy = dyc * dc.y;
            for (int dxc = 0; dxc < 2; ++dxc) {
                int dx = dxc * dc.x;
                for (int dzc = 0; dzc < 2; ++dzc) {
                    int dz = dzc * dc.z;
                    ret.add(c.add(dx, dy, dz));
                }
            }
        }
        return ret;
    }

    DeltaCoord getCornerDirection(EntityPlayer player, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        DeltaCoord dc = FzUtil.getFlatDiagonalFacing(player);
        if (dc.isZero()) {
            return null;
        }
        ForgeDirection fside = ForgeDirection.getOrientation((int)side);
        if (fside.offsetY == 0) {
            dc.x = dc.x * (fside.offsetX != 0 ? -1 : 1);
            dc.z = dc.z * (fside.offsetZ != 0 ? -1 : 1);
        }
        dc.y = fside == ForgeDirection.DOWN ? -1 : 1;
        for (int i = 0; i < 3; ++i) {
            if (dc.get(i) != 0) continue;
            dc.set(i, 1);
        }
        return dc;
    }

    @Override
    public boolean canPlaceAgainst(EntityPlayer player, Coord c, int side) {
        DeltaCoord dc;
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        if (!c.isReplacable()) {
            c = c.towardSide(side);
        }
        if ((dc = this.getCornerDirection(player, side)) == null) {
            Notify.send(player, (Object)c, "Place it differently", new String[0]);
            return false;
        }
        boolean fail = false;
        for (Coord spot : this.getArea(c, dc)) {
            if (spot.isReplacable()) continue;
            if (!fail) {
                Notify.clear(player);
                fail = true;
            }
            if (spot.equals(c)) continue;
            Notify.withStyle(Notify.Style.FORCE);
            Notify.send(player, (Object)spot, "X", new String[0]);
        }
        if (fail) {
            Notify.withStyle(Notify.Style.FORCE);
            Notify.send(player, (Object)c, "Obstructed", new String[0]);
            return false;
        }
        AxisAlignedBB area = AxisAlignedBB.func_72330_a((double)c.x, (double)c.y, (double)c.z, (double)c.x, (double)c.y, (double)c.z);
        Iterator i$ = c.w.func_72839_b(null, area = area.func_72321_a((double)(2 * dc.x), (double)(3 * dc.y), (double)(2 * dc.z))).iterator();
        if (i$.hasNext()) {
            Object o = i$.next();
            Entity e = (Entity)o;
            if (e.func_70067_L() || !(e instanceof EntityLiving)) {
                // empty if block
            }
            Notify.withStyle(Notify.Style.FORCE);
            if (e == player) {
                Notify.send(player, (Object)c, "You are in the way", new String[0]);
                return false;
            }
            Notify.send(player, (Object)c, "Obstructed by entity", new String[0]);
            Coord ec = new Coord(e);
            if (!ec.equals(c)) {
                String it = "(this guy)";
                if (e instanceof EntityPlayer) {
                    it = "(this player)";
                }
                if (e instanceof EntityCreeper) {
                    it = "(thissss guy)";
                }
                Notify.withStyle(Notify.Style.FORCE);
                Notify.send(player, (Object)e, it, new String[0]);
            }
            return false;
        }
        return true;
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side) {
        DeltaCoord dc = this.getCornerDirection(player, side);
        List<Coord> area = this.getArea(this.getCoord(), dc);
        Coord myDestination = area.get(0);
        for (Coord c : area) {
            if (!c.isSubmissiveTo(myDestination)) continue;
            myDestination = c;
        }
        myDestination.setId((Block)Core.registry.factory_block);
        this.getBlockClass().enforce(myDestination);
        myDestination.setTE(this);
        for (Coord spot : area) {
            if (!spot.equals(myDestination)) {
                spot.setId(FzConfig.factory_block_id);
                TileEntityExtension tex = new TileEntityExtension(this);
                spot.setTE(tex);
                tex.getBlockClass().enforce(spot);
            }
            spot.redraw();
        }
        this.ignitionRequest = true;
    }

    @Override
    protected void onRemove() {
        Coord here = this.getCoord();
        for (int dx = -5; dx <= 5; ++dx) {
            for (int dy = -5; dy <= 5; ++dy) {
                for (int dz = -5; dz <= 5; ++dz) {
                    Coord c = here.add(dx, dy, dz);
                    TileEntityExtension tex = c.getTE(TileEntityExtension.class);
                    if (tex == null || tex.getParent() != this) continue;
                    c.setId(0);
                }
            }
        }
        here.setId(0);
    }

    @Override
    public void setBlockBounds(Block b) {
        b.func_71905_a(0.0f, 0.0f, 0.0f, 2.0f, 3.0f, 2.0f);
    }

    Coord[] getIgnitionArea() {
        int i;
        Coord[] ret = new Coord[perimDeltas.length + 4];
        Coord here = this.getCoord();
        for (i = 0; i < perimDeltas.length; ++i) {
            ret[i] = here.add(perimDeltas[i][0], 0, perimDeltas[i][1]);
        }
        i = 0;
        for (int dx = 0; dx <= 1; ++dx) {
            for (int dz = 0; dz <= 1; ++dz) {
                ret[TileEntityRocketEngine.perimDeltas.length + i] = here.add(dx, -1, dz);
                ++i;
            }
        }
        return ret;
    }

    @Override
    public void neighborChanged() {
        this.ignitionRequest = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ContiguitySolver canIgnite(EntityPlayer player) {
        if (this.isFiring) {
            return null;
        }
        int fireCount = 0;
        for (Coord n : this.getIgnitionArea()) {
            fireCount += n.isBlockBurning() ? 1 : 0;
        }
        if (fireCount < 4) {
            return null;
        }
        ContiguitySolver solver = new ContiguitySolver(this);
        try {
            solver.solve();
        }
        catch (RocketValidationException e) {
            e.notify(this, player);
            for (TileEntityRocketEngine engine : solver.engines) {
                engine.setValid(false);
            }
            return null;
        }
        for (TileEntityRocketEngine engine : solver.engines) {
            engine.setValid(true);
            if (engine == this) continue;
            for (Coord n : engine.getIgnitionArea()) {
                fireCount += n.isBlockBurning() ? 1 : 0;
            }
        }
        double perfect = solver.engines.size() * 12;
        double score = (double)fireCount / perfect;
        if (score >= 0.5) {
            if (solver.entireRocket.size() != 0) return solver;
            Notify.send(this.getCoord(), "No body?", new String[0]);
            return null;
        } else {
            Notify.send(this.getCoord(), "Nope!", new String[0]);
        }
        return null;
    }

    void ignite(ContiguitySolver solver) {
        Coord min;
        Notify.send(this.getCoord(), "Ignition", new String[0]);
        this.isLeaderEngine = true;
        this.availableFuel = solver.fuel;
        for (TileEntityRocketEngine engine : solver.engines) {
            engine.isFiring = true;
            engine.inSlice = true;
        }
        Coord max = min = TileEntityRocketEngine.choose(solver.entireRocket);
        for (Coord c : solver.entireRocket) {
            if (c.isSubmissiveTo(min)) {
                min = c;
            }
            if (!max.isSubmissiveTo(c)) continue;
            max = c;
        }
        DeltaCoord size = max.difference(min);
        DeltaCoord half = size.scale(0.5);
        Coord center = min.add(half);
        IDeltaChunk dse = DeltaChunk.allocateSlice(this.field_70331_k, -1, new DeltaCoord(0, 0, 0));
        center.setAsEntityLocation(dse);
        dse.field_70165_t += 0.5;
        dse.field_70163_u -= 5.0;
        dse.field_70161_v += 0.5;
        Vec3 real = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Coord dest = new Coord(DeltaChunk.getServerShadowWorld(), 0, 0, 0);
        for (Coord c : solver.entireRocket) {
            c.setAsVector(real);
            dest.set(dse.real2shadow(real));
            TransferLib.move(c, dest, true, true);
        }
        dse.permit(DeltaCapability.DRAG);
        dse.permit(DeltaCapability.INTERACT);
        dse.permit(DeltaCapability.MOVE);
        this.field_70331_k.func_72838_d((Entity)dse);
    }

    void broadcastState(EntityPlayer who) {
        this.broadcastMessage(null, 151, this.lastValidationStatus, this.isFiring);
    }

    void setValid(boolean nv) {
        if (nv != this.lastValidationStatus) {
            this.lastValidationStatus = nv;
            this.broadcastState(null);
        }
    }

    boolean isValid(EntityPlayer player) {
        this.setValid(this.calculateValidation(player));
        this.broadcastState(null);
        return this.lastValidationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean calculateValidation(EntityPlayer player) {
        long now = System.currentTimeMillis();
        if (now < this.next_free_time) {
            return this.lastValidationStatus;
        }
        long start = System.currentTimeMillis();
        try {
            new ContiguitySolver(this).solve();
        }
        catch (RocketValidationException e) {
            e.notify(this, player);
            boolean bl = false;
            return bl;
        }
        finally {
            long end = System.currentTimeMillis();
            long delay = Math.max((end - start) * 100L, 2000L);
            this.next_free_time = end + delay;
        }
        return true;
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        if (this.field_70331_k.field_72995_K) {
            return true;
        }
        if (this.isFiring) {
            return true;
        }
        if (this.isValid(entityplayer)) {
            Notify.withStyle(Notify.Style.EXACTPOSITION);
            Notify.send(entityplayer, (Object)this.getCoord(), "Rocket is valid!\nSuround the nozzles with fire to launch", new String[0]);
        }
        return true;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(Vec3 startVec, Vec3 endVec) {
        BlockRenderHelper block = this.field_70331_k.field_72995_K ? Core.registry.clientTraceHelper : Core.registry.serverTraceHelper;
        block.func_71905_a(0.0f, 0.0f, 0.0f, 2.0f, 3.0f, 2.0f);
        return block.func_71878_a(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, startVec, endVec);
    }

    @Override
    public Packet getAuxillaryInfoPacket() {
        return this.getDescriptionPacketWith(151, this.lastValidationStatus, this.isFiring);
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 151) {
            boolean v = input.readBoolean();
            boolean f = input.readBoolean();
            if (v != this.lastValidationStatus || this.isFiring != f) {
                this.lastValidationStatus = v;
                this.isFiring = f;
                this.getCoord().redraw();
            }
            return true;
        }
        return false;
    }

    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (!(this.inSlice && this.isFiring || !this.ignitionRequest)) {
            this.ignitionRequest = false;
            ContiguitySolver solver = this.canIgnite(null);
            if (solver != null) {
                this.ignite(solver);
            }
        }
    }

    public void notifyArea(EntityPlayer player) {
        ContiguitySolver solver = this.canIgnite(player);
        for (Coord c : solver.entireRocket) {
            Notify.withStyle(Notify.Style.FORCE);
            Notify.send(player, (Object)c, "" + c.y, new String[0]);
        }
    }

    static <E> E choose(HashSet<E> src) {
        Iterator<E> it = src.iterator();
        E ret = it.next();
        it.remove();
        return ret;
    }

    static HashSet<Coord> fillPlane(Iterable<Coord> seeds, int planeNormal, Criteria<Coord> criteria) throws RocketValidationException {
        HashSet<Coord> ret = new HashSet<Coord>(81);
        HashSet<Coord> frontier = new HashSet<Coord>();
        for (Coord seed : seeds) {
            if (!criteria.fits(seed)) continue;
            frontier.add(seed);
        }
        while (frontier.size() > 0) {
            if (ret.size() == FzConfig.max_rocket_base_size) {
                throw new RocketValidationException("Rocket is too wide");
            }
            Coord me = (Coord)TileEntityRocketEngine.choose(frontier);
            ret.add(me);
            Coord[] neighbors = me.getNeighborsInPlane(planeNormal);
            for (int i = 0; i < neighbors.length; ++i) {
                Coord n = neighbors[i];
                if (ret.contains(n) || frontier.contains(n) || !criteria.fits(n)) continue;
                frontier.add(n);
            }
        }
        return ret;
    }

    static void movePlane(ArrayList<Coord> coordSet, DeltaCoord dc) {
        for (Coord c : coordSet) {
            c.adjust(dc);
        }
    }

    static int expandPlane(ArrayList<Coord> coordSet, ForgeDirection normal, Criteria<Coord> crit) {
        int ord = normal.ordinal();
        HashSet<Coord> toAdd = new HashSet<Coord>();
        for (Coord me : coordSet) {
            Coord[] neighbors = me.getNeighborsInPlane(ord);
            for (int i = 0; i < neighbors.length; ++i) {
                Coord n = neighbors[i];
                if (coordSet.contains(n) || !crit.fits(n)) continue;
                toAdd.add(n);
            }
        }
        int ret = toAdd.size();
        coordSet.addAll(toAdd);
        return ret;
    }

    static void collapsePlane(ArrayList<Coord> plane, Criteria<Coord> crit) {
        Iterator<Coord> it = plane.iterator();
        while (it.hasNext()) {
            Coord here = it.next();
            if (crit.fits(here)) continue;
            it.remove();
        }
    }

    static HashSet<Coord> cloneSet(Collection<Coord> src) {
        HashSet<Coord> ret = new HashSet<Coord>(src.size());
        for (Coord c : src) {
            ret.add(c.copy());
        }
        return ret;
    }

    static ArrayList<Coord> cloneArray(Collection<Coord> src) {
        ArrayList<Coord> ret = new ArrayList<Coord>(src.size());
        for (Coord c : src) {
            ret.add(c.copy());
        }
        return ret;
    }

    @Override
    public ItemStack getDroppedBlock() {
        return new ItemStack((Item)Core.registry.rocket_engine);
    }

    static class ContiguitySolver {
        TileEntityRocketEngine seed;
        HashSet<TileEntityRocketEngine> engines = new HashSet();
        HashSet<Coord> entireRocket = new HashSet();
        ArrayList<Coord> mountingPlane = new ArrayList();
        int fuel = 0;

        public ContiguitySolver(TileEntityRocketEngine seed) {
            this.seed = seed;
        }

        void addEngine(TileEntityCommon engine) {
            if (engine instanceof TileEntityExtension) {
                engine = ((TileEntityExtension)engine).getParent();
            }
            if (engine instanceof TileEntityRocketEngine) {
                this.engines.add((TileEntityRocketEngine)engine);
            }
        }

        public void solve() throws RocketValidationException {
            Coord mounting = this.seed.getCoord().add(0, 3, 0);
            Criteria<Coord> isSolid = new Criteria<Coord>(){

                @Override
                public boolean fits(Coord coord) {
                    return coord.getHardness() > 0.0f;
                }
            };
            List<Coord> seeds = Arrays.asList(mounting, mounting.add(1, 0, 0), mounting.add(1, 0, 1), mounting.add(0, 0, 1));
            this.mountingPlane.addAll(TileEntityRocketEngine.fillPlane(seeds, 0, isSolid));
            if (this.mountingPlane.size() == 0) {
                throw new RocketValidationException("Rocket engine is attatched to nothing");
            }
            TileEntityRocketEngine.movePlane(this.mountingPlane, new DeltaCoord(0, -3, 0));
            for (Coord c : this.mountingPlane) {
                this.addEngine(c.getTE(TileEntityCommon.class));
            }
            for (TileEntityRocketEngine engine : this.engines) {
                this.entireRocket.addAll(engine.getArea());
            }
            TileEntityRocketEngine.movePlane(this.mountingPlane, new DeltaCoord(0, 3, 0));
            ArrayList<Coord> heightScan = TileEntityRocketEngine.cloneArray(this.mountingPlane);
            int y = 0;
            DeltaCoord upwards = new DeltaCoord(0, 1, 0);
            this.entireRocket.addAll(TileEntityRocketEngine.cloneArray(this.mountingPlane));
            block2: while (true) {
                if (++y > FzConfig.max_rocket_height) {
                    throw new RocketValidationException("Rocket is too tall");
                }
                TileEntityRocketEngine.movePlane(heightScan, upwards);
                TileEntityRocketEngine.collapsePlane(heightScan, isSolid);
                int last_size = heightScan.size();
                while (true) {
                    TileEntityRocketEngine.expandPlane(heightScan, ForgeDirection.UP, isSolid);
                    int new_size = heightScan.size();
                    if (new_size >= FzConfig.max_rocket_base_size) {
                        throw new RocketValidationException("Rocket is too wide");
                    }
                    if (new_size == last_size) break;
                    last_size = new_size;
                }
                if (heightScan.size() >= FzConfig.max_rocket_base_size) {
                    throw new RocketValidationException("Rocket is too wide");
                }
                if (heightScan.size() == 0) {
                    --y;
                    break;
                }
                this.entireRocket.addAll(TileEntityRocketEngine.cloneArray(heightScan));
                Iterator<Coord> i$ = this.mountingPlane.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block2;
                    Coord c = i$.next();
                    this.entireRocket.add(c.add(0, y, 0));
                }
                break;
            }
            if (this.entireRocket.size() == 0) {
                throw new RocketValidationException("Rocket is made of nothing!?");
            }
            if (this.engines.size() == 0) {
                throw new RocketValidationException("Rocket has no engines!?");
            }
            Coord below = this.seed.getCoord();
            for (Coord c : this.entireRocket) {
                TileEntity te = c.getTE();
                if (te instanceof TileEntityExtension) {
                    te = ((TileEntityExtension)te).getParent();
                }
                if (te instanceof TileEntityRocketEngine && this.engines.contains(te)) continue;
                below.set(c);
                --below.y;
                if (!isSolid.fits(below) || this.entireRocket.contains(below)) continue;
                throw new RocketValidationException("Can't drag", below);
            }
            ItemStack rocket_fuel = new ItemStack((Item)Core.registry.rocket_fuel);
            for (TileEntityRocketEngine engine : this.engines) {
                mounting = engine.getCoord();
                mounting.y += 3;
                for (Coord c : new Coord[]{mounting, mounting.add(1, 0, 0), mounting.add(1, 0, 1), mounting.add(0, 0, 1)}) {
                    TileEntityDayBarrel b = c.getTE(TileEntityDayBarrel.class);
                    if (b == null || !b.itemMatch(rocket_fuel)) continue;
                    this.fuel += b.getItemCount();
                }
            }
            if (this.fuel <= 0) {
                throw new RocketValidationException("No barrel of {ITEM_NAME}\nHere's a good spot.", mounting).with(Notify.Style.EXACTPOSITION, rocket_fuel);
            }
        }
    }

    static interface Criteria<E> {
        public boolean fits(E var1);
    }

    static class RocketValidationException
    extends Exception {
        String msg;
        Coord mark = null;
        Notify.Style style = null;
        ItemStack item = null;

        public RocketValidationException(String msg) {
            this.msg = msg;
        }

        public RocketValidationException(String msg, Coord mark) {
            this.msg = msg;
            this.mark = mark;
        }

        public RocketValidationException with(Notify.Style style, ItemStack item) {
            this.style = style;
            this.item = item;
            return this;
        }

        public void notify(TileEntityRocketEngine where, EntityPlayer who) {
            if (who != null) {
                if (this.mark != null) {
                    Coord xtra = where.getCoord();
                    if (xtra.distance(this.mark) > 2.0) {
                        Notify.withStyle(Notify.Style.EXACTPOSITION);
                        Notify.send(who, (Object)where.getCoord(), "Validation failed", new String[0]);
                    }
                } else {
                    this.mark = where.getCoord();
                }
                if (this.style != null) {
                    Notify.withStyle(this.style);
                }
                if (this.item != null) {
                    Notify.withItem(this.item);
                }
                Notify.send(who, (Object)this.mark, this.msg, new String[0]);
            }
        }
    }
}

