/*
 * Decompiled with CFR 0.152.
 */
package factorization.api;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.DeltaCoord;
import factorization.api.ICoordFunction;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.shared.BlockHelper;
import factorization.shared.FzUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeDirection;

public class Coord
implements IDataSerializable {
    public World w;
    public int x;
    public int y;
    public int z;
    private static Random rand = new Random();
    private static ThreadLocal<Coord> staticCoord = new ThreadLocal();
    public static final int NOTIFY_NEIGHBORS = 1;
    public static final int UPDATE = 2;
    public static final int ONLY_UPDATE_SERVERSIDE = 4;
    private static Vec3 nullVec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private static boolean spam = false;

    public Coord(World w, int x, int y, int z) {
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coord(TileEntity te) {
        this(te.field_70331_k, te.field_70329_l, te.field_70330_m, te.field_70327_n);
    }

    public Coord(Entity ent) {
        this(ent.field_70170_p, Math.floor(ent.field_70165_t), ent.field_70163_u + (double)ent.field_70129_M, Math.floor(ent.field_70161_v));
    }

    public Coord(World w, double x, double y, double z) {
        this(w, (int)x, (int)y, (int)z);
    }

    public Coord(World w, MovingObjectPosition mop) {
        this(w, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
    }

    public static Coord tryLoad(World world, Object o) {
        if (o instanceof Coord) {
            return (Coord)o;
        }
        if (o instanceof Vec3) {
            Vec3 vec = (Vec3)o;
            return new Coord(world, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        }
        if (o instanceof Entity) {
            Entity e = (Entity)o;
            return new Coord(e);
        }
        if (o instanceof TileEntity) {
            TileEntity te = (TileEntity)o;
            return new Coord(te);
        }
        return null;
    }

    public static Coord of(int x, int y, int z) {
        return Coord.of(null, x, y, z);
    }

    public static Coord of(double x, double y, double z) {
        return Coord.of(null, (int)x, (int)y, (int)z);
    }

    public static Coord of(World w, int x, int y, int z) {
        Coord ret = staticCoord.get();
        if (ret == null) {
            ret = new Coord(w, x, y, z);
            staticCoord.set(ret);
            return ret;
        }
        ret.set(w, x, y, z);
        return ret;
    }

    public String toString() {
        String ret = "(" + this.x + ", " + this.y + ", " + this.z + ")";
        if (this.w == null) {
            ret = ret + " null world";
        } else if (!this.blockExists()) {
            ret = ret + " not loaded";
        } else if (this.w != null) {
            Block b = this.getBlock();
            if (b != null) {
                ret = ret + " " + this.getBlock().getClass().getSimpleName();
                ret = ret + " " + b.func_71917_a();
            } else {
                ret = ret + " null";
            }
            TileEntity te = this.getTE();
            if (te != null) {
                ret = ret + " " + te.getClass().getSimpleName();
            }
        }
        return ret;
    }

    public void set(World w, int x, int y, int z) {
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(ChunkCoordinates cc) {
        this.set(this.w, cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
    }

    public void set(Coord c) {
        this.set(c.w, c.x, c.y, c.z);
    }

    public void set(Vec3 v) {
        this.set(this.w, (int)v.field_72450_a, (int)v.field_72448_b, (int)v.field_72449_c);
    }

    public void set(DeltaCoord dc) {
        this.set(this.w, dc.x, dc.y, dc.z);
    }

    public void set(TileEntity te) {
        this.set(te.field_70331_k, te.field_70329_l, te.field_70330_m, te.field_70327_n);
    }

    public int hashCode() {
        return (this.x * 11 % 71 << 7) + this.z * 7 % 479 + this.y;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Coord) {
            Coord other = (Coord)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z && this.w == other.w;
        }
        return false;
    }

    public Coord copy() {
        return new Coord(this.w, this.x, this.y, this.z);
    }

    public int get(int axis) {
        switch (axis) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new RuntimeException("Invalid argument");
    }

    public void set(int axis, int value) {
        switch (axis) {
            case 0: {
                this.x = value;
                return;
            }
            case 1: {
                this.y = value;
                return;
            }
            case 2: {
                this.z = value;
                return;
            }
        }
        throw new RuntimeException("Invalid argument");
    }

    public Vec3 createVector() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    public MovingObjectPosition createMop(ForgeDirection side, Vec3 hitVec) {
        return new MovingObjectPosition(this.x, this.y, this.z, side.ordinal(), hitVec);
    }

    public boolean parity() {
        return (this.x + this.y + this.z & 1) == 0;
    }

    public int seed() {
        return (this.x << 4 + this.z << 8) + this.y;
    }

    public DeltaCoord difference(Coord b) {
        return new DeltaCoord(this.x - b.x, this.y - b.y, this.z - b.z);
    }

    public DeltaCoord asDeltaCoord() {
        return new DeltaCoord(this.x, this.y, this.z);
    }

    public double distance(Coord o) {
        return Math.sqrt(this.distanceSq(o));
    }

    public int distanceSq(Coord o) {
        if (o == null) {
            return 0;
        }
        int dx = this.x - o.x;
        int dy = this.y - o.y;
        int dz = this.z - o.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public int distanceManhatten(Coord o) {
        if (o == null) {
            return 0;
        }
        int dx = this.x - o.x;
        int dy = this.y - o.y;
        int dz = this.z - o.z;
        return Math.abs(dx) + Math.abs(dy) + Math.abs(dz);
    }

    public ArrayList<Coord> getNeighborsAdjacent() {
        ArrayList<Coord> ret = new ArrayList<Coord>(6);
        for (DeltaCoord d : DeltaCoord.directNeighbors) {
            ret.add(this.add(d));
        }
        return ret;
    }

    public <T> Iterable<T> getAdjacentTEs(Class<T> clazz) {
        ArrayList<T> ret = new ArrayList<T>(6);
        for (Coord n : this.getNeighborsAdjacent()) {
            T toAdd = n.getTE(clazz);
            if (toAdd == null) continue;
            ret.add(toAdd);
        }
        return ret;
    }

    public ArrayList<Coord> getNeighborsDiagonal() {
        ArrayList<Coord> ret = new ArrayList<Coord>(26);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    ret.add(this.add(dx, dy, dz));
                }
            }
        }
        return ret;
    }

    public ArrayList<Coord> getRandomNeighborsAdjacent() {
        ArrayList<Coord> ret = this.getNeighborsAdjacent();
        Collections.shuffle(ret);
        return ret;
    }

    public ArrayList<Coord> getRandomNeighborsDiagonal() {
        ArrayList<Coord> ret = this.getNeighborsDiagonal();
        Collections.shuffle(ret);
        return ret;
    }

    public Coord getSingleRandomNeighborAdjacent() {
        int r = rand.nextInt(DeltaCoord.directNeighbors.length);
        return this.add(DeltaCoord.directNeighbors[r]);
    }

    public Coord[] getNeighborsInPlane(int side) {
        switch (side) {
            case 0: 
            case 1: {
                return new Coord[]{this.add(-1, 0, 0), this.add(1, 0, 0), this.add(0, 0, -1), this.add(0, 0, 1)};
            }
            case 2: 
            case 3: {
                return new Coord[]{this.add(-1, 0, 0), this.add(1, 0, 0), this.add(0, -1, 0), this.add(0, 1, 0)};
            }
            case 4: 
            case 5: {
                return new Coord[]{this.add(0, 0, -1), this.add(0, 0, 1), this.add(0, -1, 0), this.add(0, 1, 0)};
            }
        }
        return null;
    }

    public Coord[] getNeighborsOutOfPlane(int side) {
        switch (side) {
            case 0: 
            case 1: {
                return new Coord[]{this.add(0, -1, 0), this.add(0, 1, 0)};
            }
            case 2: 
            case 3: {
                return new Coord[]{this.add(0, 0, -1), this.add(0, 0, 1)};
            }
            case 4: 
            case 5: {
                return new Coord[]{this.add(-1, 0, 0), this.add(1, 0, 0)};
            }
        }
        return null;
    }

    public boolean isSubmissiveTo(Coord o) {
        return this.y < o.y || this.x < o.x || this.z < o.z;
    }

    public boolean isCompletelySubmissiveTo(Coord o) {
        return this.x < o.x && this.y < o.y && this.z < o.z;
    }

    public boolean inside(Coord lower, Coord upper) {
        return lower.lesserOrEqual(this) && this.lesserOrEqual(upper);
    }

    public boolean lesserOrEqual(Coord o) {
        return this.x <= o.x && this.y <= o.y && this.z <= o.z;
    }

    public void setWorld(World newWorld) {
        this.w = newWorld;
    }

    public Coord add(DeltaCoord d) {
        return this.add(d.x, d.y, d.z);
    }

    public Coord add(ForgeDirection d) {
        return this.add(d.offsetX, d.offsetY, d.offsetZ);
    }

    public Coord add(int x, int y, int z) {
        return new Coord(this.w, this.x + x, this.y + y, this.z + z);
    }

    public Coord center(Coord o) {
        return new Coord(this.w, (this.x + o.x) / 2, (this.y + o.y) / 2, (this.z + o.z) / 2);
    }

    public Vec3 centerVec(Coord o) {
        return Vec3.func_72443_a((double)((double)(this.x + o.x) / 2.0), (double)((double)(this.y + o.y) / 2.0), (double)((double)(this.z + o.z) / 2.0));
    }

    public Coord towardSide(int side) {
        switch (side) {
            case 0: {
                --this.y;
                break;
            }
            case 1: {
                ++this.y;
                break;
            }
            case 2: {
                --this.z;
                break;
            }
            case 3: {
                ++this.z;
                break;
            }
            case 4: {
                --this.x;
                break;
            }
            case 5: {
                ++this.x;
            }
        }
        return this;
    }

    public void adjust(DeltaCoord dc) {
        this.x += dc.x;
        this.y += dc.y;
        this.z += dc.z;
    }

    public void adjust(ForgeDirection dc) {
        this.x += dc.offsetX;
        this.y += dc.offsetY;
        this.z += dc.offsetZ;
    }

    public void markBlockForUpdate() {
        this.w.func_72845_h(this.x, this.y, this.z);
    }

    public void redraw() {
        if (this.w.field_72995_K) {
            this.w.func_72902_n(this.x, this.y, this.z);
        }
    }

    public void notifyNeighbors() {
        this.w.func_72898_h(this.x, this.y, this.z, this.getId());
    }

    public void updateLight() {
        this.w.func_72969_x(this.x, this.y, this.z);
    }

    public void updateBlockLight() {
        this.w.func_72936_c(EnumSkyBlock.Block, this.x, this.y, this.z);
    }

    public void setTE(TileEntity te) {
        this.w.func_72837_a(this.x, this.y, this.z, te);
    }

    public TileEntity getTE() {
        if (this.w == null) {
            return null;
        }
        if (!this.blockExists()) {
            return null;
        }
        return this.w.func_72796_p(this.x, this.y, this.z);
    }

    public <T> T getTE(Class<T> clazz) {
        TileEntity te = this.getTE();
        if (clazz.isInstance(te)) {
            return (T)te;
        }
        return null;
    }

    public void rmTE() {
        this.w.func_72932_q(this.x, this.y, this.z);
    }

    public Chunk getChunk() {
        return this.w.func_72938_d(this.x, this.z);
    }

    public Block getBlock() {
        return Block.field_71973_m[this.getId()];
    }

    @Deprecated
    public int getId() {
        return this.w.func_72798_a(this.x, this.y, this.z);
    }

    public int getMd() {
        return this.w.func_72805_g(this.x, this.y, this.z);
    }

    public int getRawId() {
        return this.w.func_72798_a(this.x, this.y, this.z);
    }

    public boolean isAir() {
        return this.w.func_72799_c(this.x, this.y, this.z);
    }

    public boolean isSolid() {
        Block b = this.getBlock();
        if (b == null) {
            return false;
        }
        return b.isBlockNormalCube(this.w, this.x, this.y, this.z);
    }

    public float getHardness() {
        Block b = this.getBlock();
        if (b == null) {
            return 0.0f;
        }
        return b.func_71934_m(this.w, this.x, this.y, this.z);
    }

    public boolean isSolidOnSide(int side) {
        return this.w.isBlockSolidOnSide(this.x, this.y, this.z, ForgeDirection.getOrientation((int)side));
    }

    public boolean isSolidOnSide(ForgeDirection side) {
        return this.w.isBlockSolidOnSide(this.x, this.y, this.z, side);
    }

    public boolean isBlockBurning() {
        Block b = this.getBlock();
        if (b == null) {
            return false;
        }
        return b == Block.field_72067_ar || b.isBlockBurning(this.w, this.x, this.y, this.z);
    }

    public boolean blockExists() {
        if (this.w == null) {
            return false;
        }
        return this.w.func_72899_e(this.x, this.y, this.z);
    }

    public boolean isReplacable() {
        Block b = this.getBlock();
        if (b == null) {
            return true;
        }
        if (b.field_72018_cp.func_76222_j()) {
            return true;
        }
        return b.isBlockReplaceable(this.w, this.x, this.y, this.z);
    }

    public boolean isTop() {
        return this.w.func_72976_f(this.x, this.z) == this.y;
    }

    public boolean canBeSeenThrough() {
        if (this.w.func_72799_c(this.x, this.y, this.z)) {
            return true;
        }
        return Block.field_71971_o[this.getId()] == 0;
    }

    public boolean canSeeSky() {
        Coord skyLook = this.copy();
        int i = this.y + 1;
        while (i < this.w.func_72800_K()) {
            skyLook.y = i++;
            if (skyLook.canBeSeenThrough()) continue;
            return false;
        }
        return true;
    }

    public boolean is(Block b) {
        return this.getId() == b.field_71990_ca;
    }

    public boolean is(Block b, int md) {
        return this.getId() == b.field_71990_ca && this.getMd() == md;
    }

    @Deprecated
    public boolean setId(int id, boolean notify) {
        int notifyFlag = notify ? 3 : 0;
        return this.w.func_72832_d(this.x, this.y, this.z, id, 0, notifyFlag);
    }

    public boolean setId(Block block, boolean notify) {
        int notifyFlag = notify ? 3 : 0;
        return this.w.func_72832_d(this.x, this.y, this.z, block.field_71990_ca, 0, notifyFlag);
    }

    public boolean setMd(int md, boolean notify) {
        int notifyFlag = notify ? 3 : 0;
        return this.w.func_72921_c(this.x, this.y, this.z, md, notifyFlag);
    }

    @Deprecated
    public boolean setIdMd(int id, int md, boolean notify) {
        int notifyFlag = notify ? 3 : 0;
        return this.w.func_72832_d(this.x, this.y, this.z, id, md, notifyFlag);
    }

    public boolean setIdMd(Block block, int md, boolean notify) {
        int notifyFlag = notify ? 3 : 0;
        return this.w.func_72832_d(this.x, this.y, this.z, block.field_71990_ca, md, notifyFlag);
    }

    @Deprecated
    public boolean setId(int id) {
        return this.setId(id, true);
    }

    public boolean setMd(int md) {
        return this.setMd(md, true);
    }

    @Deprecated
    public boolean setIdMd(int id, int md) {
        return this.setIdMd(id, md, true);
    }

    public boolean setId(Block block) {
        return this.setId(block.field_71990_ca);
    }

    public void notifyBlockChange() {
        this.w.func_72851_f(this.x, this.y, this.z, this.getId());
    }

    public void writeToNBT(String prefix, NBTTagCompound tag) {
        tag.func_74768_a(prefix + "x", this.x);
        tag.func_74768_a(prefix + "y", this.y);
        tag.func_74768_a(prefix + "z", this.z);
    }

    public void readFromNBT(String prefix, NBTTagCompound tag) {
        this.x = tag.func_74762_e(prefix + "x");
        this.y = tag.func_74762_e(prefix + "y");
        this.z = tag.func_74762_e(prefix + "z");
    }

    public void writeToStream(ByteArrayDataOutput dos) {
        dos.writeInt(this.x);
        dos.writeInt(this.y);
        dos.writeInt(this.z);
    }

    public void readFromStream(ByteArrayDataInput dis) {
        this.x = dis.readInt();
        this.y = dis.readInt();
        this.z = dis.readInt();
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.x = data.asSameShare(prefix + "x").put(this.x);
        this.y = data.asSameShare(prefix + "y").put(this.y);
        this.z = data.asSameShare(prefix + "z").put(this.z);
        return this;
    }

    public void mark() {
        World use_world = this.w;
        use_world.func_72869_a("reddust", (double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, 0.0, 0.0, 0.0);
    }

    public boolean remote() {
        return this.w.field_72995_K;
    }

    public boolean local() {
        return !this.w.field_72995_K;
    }

    public EntityItem spawnItem(ItemStack is) {
        EntityItem ent = new EntityItem(this.w, (double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, is);
        this.w.func_72838_d((Entity)ent);
        return ent;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        Block b = this.getBlock();
        if (b == null) {
            return null;
        }
        return b.func_71872_e(this.w, this.x, this.y, this.z);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        Block b = this.getBlock();
        if (b == null) {
            return null;
        }
        return b.func_71911_a_(this.w, this.x, this.y, this.z);
    }

    public void notifyOfNeighborChange(int neighborId) {
        this.w.func_72898_h(this.x, this.y, this.z, neighborId);
    }

    public void scheduleUpdate(int delay) {
        this.w.func_72836_a(this.x, this.y, this.z, this.getId(), delay);
    }

    public void setAsEntityLocation(Entity ent) {
        ent.field_70170_p = this.w;
        ent.func_70012_b((double)this.x + 0.5, (double)this.y, (double)this.z + 0.5, ent.field_70177_z, ent.field_70125_A);
    }

    public void setAsEntityLocationUnsafe(Entity ent) {
        ent.field_70170_p = this.w;
        ent.field_70165_t = (double)this.x + 0.5;
        ent.field_70163_u = this.y;
        ent.field_70161_v = (double)this.z + 0.5;
    }

    public void setAsTileEntityLocation(TileEntity te) {
        te.field_70331_k = this.w;
        te.field_70329_l = this.x;
        te.field_70330_m = this.y;
        te.field_70327_n = this.z;
    }

    public void setAsVector(Vec3 vec) {
        vec.field_72450_a = this.x;
        vec.field_72448_b = this.y;
        vec.field_72449_c = this.z;
    }

    public static void sort(Coord lower, Coord upper) {
        Coord a = lower.copy();
        Coord b = upper.copy();
        lower.x = Math.min(a.x, b.x);
        lower.y = Math.min(a.y, b.y);
        lower.z = Math.min(a.z, b.z);
        upper.x = Math.max(a.x, b.x);
        upper.y = Math.max(a.y, b.y);
        upper.z = Math.max(a.z, b.z);
    }

    public void moveToTopBlock() {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                this.y = Math.max(this.y, this.w.func_72825_h(this.x + dx, this.z + dz));
            }
        }
    }

    public void removeTE() {
        this.w.func_72932_q(this.x, this.y, this.z);
    }

    public boolean isPowered() {
        return this.w.func_94577_B(this.x, this.y, this.z) > 0;
    }

    public boolean isWeaklyPowered() {
        return this.w.func_72864_z(this.x, this.y, this.z);
    }

    public static void iterateCube(Coord a, Coord b, ICoordFunction func) {
        a = a.copy();
        b = b.copy();
        Coord.sort(a, b);
        Coord here = a.copy();
        for (int x = a.x; x <= b.x; ++x) {
            for (int y = a.y; y <= b.y; ++y) {
                for (int z = a.z; z <= b.z; ++z) {
                    here.set(here.w, x, y, z);
                    func.handle(here);
                }
            }
        }
    }

    public boolean hasSimilarCoordinate(Coord other) {
        return this.x == other.x || this.y == other.y || this.z == other.z;
    }

    public int getComparatorOverride(ForgeDirection side) {
        Block b = this.getBlock();
        if (b == null || !b.func_96468_q_()) {
            return 0;
        }
        return b.func_94328_b_(this.w, this.x, this.y, this.z, side.ordinal());
    }

    public ItemStack getPickBlock(ForgeDirection dir) {
        Block b = this.getBlock();
        if (b == null) {
            return null;
        }
        MovingObjectPosition mop = this.createMop(dir, nullVec);
        try {
            return b.getPickBlock(mop, this.w, this.x, this.y, this.z);
        }
        catch (NoSuchMethodError t) {
            if (!spam) {
                spam = true;
            }
            return BlockHelper.getPlacingItem(b, mop, this.w, this.x, this.y, this.z);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition mop) {
        Block b = this.getBlock();
        if (b == null) {
            return null;
        }
        return b.getPickBlock(mop, this.w, this.x, this.y, this.z);
    }

    public ItemStack getBrokenBlock() {
        Block b = this.getBlock();
        if (b == null) {
            return null;
        }
        ArrayList dropped = b.getBlockDropped(this.w, this.x, this.y, this.z, this.getMd(), 0);
        if (dropped == null || dropped.isEmpty()) {
            return null;
        }
        ItemStack main = (ItemStack)dropped.remove(0);
        for (int i = 0; i < dropped.size(); ++i) {
            ItemStack other = (ItemStack)dropped.get(i);
            if (!FzUtil.couldMerge(main, other)) {
                return null;
            }
            main.field_77994_a += other.field_77994_a;
        }
        return main;
    }
}

