/*
 * Decompiled with CFR 0.152.
 */
package appeng.world;

import appeng.api.WorldCoord;
import appeng.common.AppEng;
import appeng.world.BlockMatrixFrame;
import appeng.world.CachedPlane;
import appeng.world.ISpatialVisitor;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class StorageHelper {
    private static StorageHelper instance;

    public static StorageHelper getInstance() {
        if (instance == null) {
            instance = new StorageHelper();
        }
        return instance;
    }

    public Entity teleportEntity(Entity entity, TelDestination link) {
        boolean difDest;
        EntityPlayerMP player;
        WorldServer newWorld;
        WorldServer oldWorld;
        try {
            oldWorld = (WorldServer)entity.field_70170_p;
            newWorld = (WorldServer)link.dim;
            player = entity instanceof EntityPlayerMP ? (EntityPlayerMP)entity : null;
        }
        catch (Throwable e) {
            return entity;
        }
        if (oldWorld == null) {
            return entity;
        }
        if (newWorld == null) {
            return entity;
        }
        if (entity.field_70153_n != null) {
            return this.teleportEntity(entity.field_70153_n, link);
        }
        Entity cart = entity.field_70154_o;
        if (cart != null) {
            entity.func_70078_a(null);
            cart = this.teleportEntity(cart, link);
        }
        boolean bl = difDest = newWorld != oldWorld;
        if (difDest) {
            if (player != null) {
                player.field_71133_b.func_71203_ab().transferPlayerToDimension(player, link.dim.field_73011_w.field_76574_g, (Teleporter)new METeleporter(newWorld, link));
            } else {
                int entX = entity.field_70176_ah;
                int entZ = entity.field_70164_aj;
                if (entity.field_70175_ag && oldWorld.func_72863_F().func_73149_a(entX, entZ)) {
                    oldWorld.func_72964_e(entX, entZ).func_76622_b(entity);
                    oldWorld.func_72964_e((int)entX, (int)entZ).field_76643_l = true;
                }
                oldWorld.func_72847_b(entity);
                if (player == null) {
                    NBTTagCompound entityNBT = new NBTTagCompound();
                    entity.field_70165_t = link.x;
                    entity.field_70163_u = link.y;
                    entity.field_70161_v = link.z;
                    entity.field_70169_q = link.x;
                    entity.field_70167_r = link.y;
                    entity.field_70166_s = link.z;
                    entity.field_70128_L = false;
                    entity.func_70039_c(entityNBT);
                    entity.field_70128_L = true;
                    entity = EntityList.func_75615_a((NBTTagCompound)entityNBT, (World)newWorld);
                }
                if (entity == null) {
                    return entity;
                }
                newWorld.func_72838_d(entity);
                entity.func_70029_a((World)newWorld);
            }
        }
        entity.field_70170_p.func_72866_a(entity, false);
        if (cart != null) {
            if (player != null) {
                entity.field_70170_p.func_72866_a(entity, true);
            }
            entity.func_70078_a(cart);
        }
        if (player != null) {
            ((WorldServer)WorldServer.class.cast(newWorld)).func_72863_F().func_73158_c(MathHelper.func_76128_c((double)entity.field_70165_t) >> 4, MathHelper.func_76128_c((double)entity.field_70161_v) >> 4);
        }
        return entity;
    }

    public void transverseEdges(int minx, int miny, int minz, int maxx, int maxy, int maxz, ISpatialVisitor obj) {
        int x;
        int z;
        for (int y = miny; y < maxy; ++y) {
            for (z = minz; z < maxz; ++z) {
                obj.visit(minx, y, z);
                obj.visit(maxx, y, z);
            }
        }
        for (x = minx; x < maxx; ++x) {
            for (z = minz; z < maxz; ++z) {
                obj.visit(x, miny, z);
                obj.visit(x, maxy, z);
            }
        }
        for (x = minx; x < maxx; ++x) {
            for (int y = miny; y < maxy; ++y) {
                obj.visit(x, y, minz);
                obj.visit(x, y, maxz);
            }
        }
    }

    public void swapRegions(World src, World dst, int x, int y, int z, int i, int j, int k, int scaleX, int scaleY, int scaleZ) {
        BlockMatrixFrame blkMF = AppEng.getInstance().registration.blkMatrixFrame;
        this.transverseEdges(i - 1, j - 1, k - 1, i + scaleX + 1, j + scaleY + 1, k + scaleZ + 1, new WrapInMatrixFrame(blkMF.getBlockID(), blkMF.getMetaData(), dst));
        AxisAlignedBB srcBox = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + scaleX + 1), (double)(y + scaleY + 1), (double)(z + scaleZ + 1));
        AxisAlignedBB dstBox = AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + scaleX + 1), (double)(j + scaleY + 1), (double)(k + scaleZ + 1));
        CachedPlane cDst = new CachedPlane(dst, i, j, k, i + scaleX, j + scaleY, k + scaleZ);
        CachedPlane cSrc = new CachedPlane(src, x, y, z, x + scaleX, y + scaleY, z + scaleZ);
        cSrc.Swap(cDst);
        List srcE = src.func_72872_a(Entity.class, srcBox);
        List dstE = dst.func_72872_a(Entity.class, dstBox);
        for (Entity e : dstE) {
            this.teleportEntity(e, new TelDestination(src, srcBox, e.field_70165_t - (double)i + (double)x, e.field_70163_u - (double)j + (double)y, e.field_70161_v - (double)k + (double)z));
        }
        for (Entity e : srcE) {
            this.teleportEntity(e, new TelDestination(dst, dstBox, e.field_70165_t - (double)x + (double)i, e.field_70163_u - (double)y + (double)j, e.field_70161_v - (double)z + (double)k));
        }
        for (WorldCoord wc : cDst.updates) {
            cDst.wrld.func_72821_m(wc.x, wc.y, wc.z, 0);
        }
        for (WorldCoord wc : cSrc.updates) {
            cSrc.wrld.func_72821_m(wc.x, wc.y, wc.z, 0);
        }
        this.transverseEdges(x - 1, y - 1, z - 1, x + scaleX + 1, y + scaleY + 1, z + scaleZ + 1, new triggerUpdates(src));
        this.transverseEdges(i - 1, j - 1, k - 1, i + scaleX + 1, j + scaleY + 1, k + scaleZ + 1, new triggerUpdates(dst));
        this.transverseEdges(x, y, z, x + scaleX, y + scaleY, z + scaleZ, new triggerUpdates(src));
        this.transverseEdges(i, j, k, i + scaleX, j + scaleY, k + scaleZ, new triggerUpdates(dst));
    }

    class METeleporter
    extends Teleporter {
        TelDestination dest;

        public METeleporter(WorldServer par1WorldServer, TelDestination d) {
            super(par1WorldServer);
            this.dest = d;
        }

        public void func_77185_a(Entity par1Entity, double par2, double par4, double par6, float par8) {
            par1Entity.func_70012_b(this.dest.x, this.dest.y, this.dest.z, par1Entity.field_70177_z, 0.0f);
            par1Entity.field_70179_y = 0.0;
            par1Entity.field_70181_x = 0.0;
            par1Entity.field_70159_w = 0.0;
        }

        public boolean func_85188_a(Entity par1Entity) {
            return false;
        }

        public boolean func_77184_b(Entity par1Entity, double par2, double par4, double par6, float par8) {
            return false;
        }

        public void func_85189_a(long par1) {
        }
    }

    class TelDestination {
        final World dim;
        final double x;
        final double y;
        final double z;

        TelDestination(World _dim, AxisAlignedBB srcBox, double _x, double _y, double _z) {
            this.dim = _dim;
            this.x = Math.min(srcBox.field_72336_d - 0.5, Math.max(srcBox.field_72340_a + 0.5, _x));
            this.y = Math.min(srcBox.field_72337_e - 0.5, Math.max(srcBox.field_72338_b + 0.5, _y));
            this.z = Math.min(srcBox.field_72334_f - 0.5, Math.max(srcBox.field_72339_c + 0.5, _z));
        }
    }

    class WrapInMatrixFrame
    implements ISpatialVisitor {
        World dst;
        int blkID;
        int Meta;

        public WrapInMatrixFrame(int blockID, int metaData, World dst2) {
            this.dst = dst2;
            this.blkID = blockID;
            this.Meta = metaData;
        }

        @Override
        public void visit(int x, int y, int z) {
            this.dst.func_72832_d(x, y, z, this.blkID, this.Meta, 3);
        }
    }

    class triggerUpdates
    implements ISpatialVisitor {
        World dst;

        public triggerUpdates(World dst2) {
            this.dst = dst2;
        }

        @Override
        public void visit(int x, int y, int z) {
            int blk = this.dst.func_72798_a(x, y, z);
            if (blk > 0) {
                Block.field_71973_m[blk].func_71863_a(this.dst, x, y, z, 0);
            }
        }
    }
}

